<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Arr;
class Administration extends Controller
{
    

    public function index()
    {
        //return redirect()->route('dashboard-administration');
        return redirect()->route('dashboard-administration');
    }
    public function liste_driver(Request $request)
    {
        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;

        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

        // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $option2 = $request->input('option2');
        
        $sqls = ""; 
        
        if ($startDate > 0 && $endDate > 0) {
            if ($option2 == 'externe') {
                $sqls = "register_driver.iCompanyId != 37 
                    AND (register_driver.vName NOT LIKE 'L-%' 
                    AND register_driver.vLastName NOT LIKE 'L-%' 
                    AND register_driver.vName NOT LIKE 'LEX-%' 
                    AND register_driver.vLastName NOT LIKE 'LEX-%')
                    ";
            } elseif ($option2 == 'interne') {
                $sqls = "register_driver.iCompanyId = 37";
            }
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        
        $drivers= DB::connection('mysql2')
        ->table('trips')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=', 'vehicle_type.iVehicleTypeId')
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->select('register_driver.iDriverId as DriverId','register_driver.vPhone as vPhone','register_driver.vEmail as vEmail',
            DB::raw('MAX(trips.tEndDate) as lastdate'),
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as Driver"),
            DB::raw('COUNT(trips.iTripId) as TotalCourse'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN 1 ELSE 0 END) as Completed'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" THEN 1 ELSE 0 END) as Annulation'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "Driver" THEN 1 ELSE 0 END) as DeDriver'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "Passenger" THEN 1 ELSE 0 END) as DeClient'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "" THEN 1 ELSE 0 END) as DeAdmin'),
            DB::raw('ROUND(SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN trips.fTripGenerateFare ELSE 0 END),0) as MontantCourse'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" THEN trips.fCancellationFare ELSE 0 END) as MontantAnnulation'),
            // Sous-requête pour compter les jours de travail distincts
            DB::raw('COUNT(DISTINCT DATE(trips.tTripRequestDate)) as WorkDaysCount')
                  
        )
        ->where('trips.eSystem', 'General')
        ->whereIn('trips.eHailTrip', ['No', 'Yes'])
        ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T','Taxi Jaune']) 
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
        ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
        //->setBindings(['startDate' => $startDate, 'endDate' => $endDate]);
        if (!empty($sqls)) {
            $drivers->whereRaw($sqls);
        }
        $drivers = $drivers->groupBy('register_driver.iDriverId', 'register_driver.vName')->paginate($itemsPerPage);
        $drivers2 = DB::connection('mysql2')
            ->table('trips AS tr')
            ->join('vehicle_type', 'tr.iVehicleTypeId', '=', 'vehicle_type.iVehicleTypeId')
            ->join('register_driver', 'tr.iDriverId', '=', 'register_driver.iDriverId')
            ->select(
                'register_driver.iDriverId as DriverId',
                'register_driver.vPhone as vPhone',
                'register_driver.vEmail as vEmail',
                DB::raw('MAX(tr.tEndDate) as lastdate'),
                DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as Driver"),
                DB::raw('COUNT(tr.iTripId) as TotalCourse'),
                DB::raw('SUM(CASE WHEN tr.iActive = "Finished" AND tr.eCancelled = "No" THEN 1 ELSE 0 END) as Completed'),
                DB::raw('SUM(CASE WHEN tr.iActive = "Canceled" AND tr.eCancelled = "Yes" THEN 1 ELSE 0 END) as Annulation'),
                DB::raw('SUM(CASE WHEN tr.iActive = "Canceled" AND tr.eCancelled = "Yes" AND tr.eCancelledBy = "Driver" THEN 1 ELSE 0 END) as DeDriver'),
                DB::raw('SUM(CASE WHEN tr.iActive = "Canceled" AND tr.eCancelled = "Yes" AND tr.eCancelledBy = "Passenger" THEN 1 ELSE 0 END) as DeClient'),
                DB::raw('SUM(CASE WHEN tr.iActive = "Canceled" AND tr.eCancelled = "Yes" AND tr.eCancelledBy = "" THEN 1 ELSE 0 END) as DeAdmin'),
                DB::raw('ROUND(SUM(CASE WHEN tr.iActive = "Finished" AND tr.eCancelled = "No" THEN tr.fTripGenerateFare ELSE 0 END), 0) as MontantCourse'),
                DB::raw('SUM(CASE WHEN tr.iActive = "Canceled" AND tr.eCancelled = "Yes" THEN tr.fCancellationFare ELSE 0 END) as MontantAnnulation'),
                DB::raw('COUNT(DISTINCT DATE(tr.tTripRequestDate)) as WorkDaysCount')
            )
            ->where('tr.eSystem', 'General')
            ->whereIn('tr.eHailTrip', ['No', 'Yes'])
            ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T', 'Taxi Jaune'])
            ->whereNotIn('tr.eType', ['Deliver', 'Multi-Delivery'])
            ->whereBetween('tr.tTripRequestDate', [$startDate, $endDate]);
            if (!empty($sqls)) {
                $drivers2->whereRaw($sqls);
            }
            
            $drivers2->groupBy('register_driver.iDriverId', 'register_driver.vName');
            $drivers2 = $drivers2->get();
        
         $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_driver', compact('drivers','drivers2','startDate', 'endDate','option2'));
    }
    
    
    /*public function liste_driver(Request $request)
    {
    $itemsPerPage = 6;

    // Dates du mois en cours par défaut
    $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
    $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

    if ($request->has('startDate') && $request->has('endDate')) {
        $startDate = $request->input('startDate');
        $endDate = $request->input('endDate');
    }

    $option2 = $request->input('option2');
    $sqls = "";

    if ($option2 == 'externe') {
        $sqls = "register_driver.iCompanyId != 37 
            AND (register_driver.vName NOT LIKE 'L-%' 
            AND register_driver.vLastName NOT LIKE 'L-%' 
            AND register_driver.vName NOT LIKE 'LEX-%' 
            AND register_driver.vLastName NOT LIKE 'LEX-%')";
    } elseif ($option2 == 'interne') {
        $sqls = "register_driver.iCompanyId = 37";
    }

    // Étape 1 : récupérer les chauffeurs (avec pagination)
    $driverIds = DB::connection('mysql2')
        ->table('trips')
        ->select('iDriverId')
        ->where('eSystem', 'General')
        ->whereIn('eHailTrip', ['No', 'Yes'])
        ->whereNotIn('eType', ['Deliver', 'Multi-Delivery'])
        ->whereBetween('tTripRequestDate', [$startDate, $endDate])
        ->groupBy('iDriverId')
        ->when(!empty($sqls), function($q) use ($sqls) {
            $q->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
              ->whereRaw($sqls);
        })
        ->paginate($itemsPerPage);

    // Étape 2 : calculer les stats uniquement pour ces drivers
    $drivers = DB::connection('mysql2')
        ->table('trips as tr')
        ->join('vehicle_type as vt', 'tr.iVehicleTypeId', '=', 'vt.iVehicleTypeId')
        ->join('register_driver as rd', 'tr.iDriverId', '=', 'rd.iDriverId')
        ->select(
            'rd.iDriverId as DriverId',
            'rd.vPhone as vPhone',
            'rd.vEmail as vEmail',
            DB::raw('MAX(tr.tEndDate) as lastdate'),
            DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) as Driver"),
            DB::raw('COUNT(tr.iTripId) as TotalCourse'),
            DB::raw('SUM(CASE WHEN tr.iActive = "Finished" AND tr.eCancelled = "No" THEN 1 ELSE 0 END) as Completed'),
            DB::raw('SUM(CASE WHEN tr.iActive = "Canceled" AND tr.eCancelled = "Yes" THEN 1 ELSE 0 END) as Annulation'),
            DB::raw('SUM(CASE WHEN tr.iActive = "Canceled" AND tr.eCancelled = "Yes" AND tr.eCancelledBy = "Driver" THEN 1 ELSE 0 END) as DeDriver'),
            DB::raw('SUM(CASE WHEN tr.iActive = "Canceled" AND tr.eCancelled = "Yes" AND tr.eCancelledBy = "Passenger" THEN 1 ELSE 0 END) as DeClient'),
            DB::raw('SUM(CASE WHEN tr.iActive = "Canceled" AND tr.eCancelled = "Yes" AND tr.eCancelledBy = "" THEN 1 ELSE 0 END) as DeAdmin'),
            DB::raw('ROUND(SUM(CASE WHEN tr.iActive = "Finished" AND tr.eCancelled = "No" THEN tr.fTripGenerateFare ELSE 0 END),0) as MontantCourse'),
            DB::raw('SUM(CASE WHEN tr.iActive = "Canceled" AND tr.eCancelled = "Yes" THEN tr.fCancellationFare ELSE 0 END) as MontantAnnulation'),
            DB::raw('COUNT(DISTINCT DATE(tr.tTripRequestDate)) as WorkDaysCount')
        )
        ->where('tr.eSystem', 'General')
        ->whereIn('tr.eHailTrip', ['No', 'Yes'])
        ->whereNotIn('vt.vVehicleType_FR', ['Confort T', 'Eco T','Taxi Jaune'])
        ->whereNotIn('tr.eType', ['Deliver', 'Multi-Delivery'])
        ->whereBetween('tr.tTripRequestDate', [$startDate, $endDate])
        ->whereIn('rd.iDriverId', $driverIds->pluck('iDriverId')) // <-- uniquement les drivers paginés
        ->when(!empty($sqls), function($q) use ($sqls) {
            $q->whereRaw($sqls);
        })
        ->groupBy('rd.iDriverId', 'rd.vName', 'rd.vLastName', 'rd.vPhone', 'rd.vEmail')
        ->get();

     return view('layouts.administration.liste_driver', [
        'drivers'   => $drivers,
        'startDate' => $startDate,
        'endDate'   => $endDate,
        'option2'   => $option2,
        'driverIds' => $driverIds // garde la pagination
    ]);
  }*/


    public function liste_users_conver()
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // Récupération des utilisateurs paginés
        $stores = DB::connection('mysql2')->table('company')->paginate($itemsPerPage);
        //return view('users.index', compact('users'));
        return view('layouts.administration.liste_store', compact('stores'));
    }

    public function liste_users_non_conver()
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // Récupération des utilisateurs paginés
        $stores = DB::connection('mysql2')->table('company')->paginate($itemsPerPage);
        //return view('users.index', compact('users'));
        return view('layouts.administration.liste_store', compact('stores'));
    }

    public function liste_user(Request $request)
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = '';//$request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = '';//$request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $option1 = $request->input('option1');
        $option11 = $request->input('option11');

        if( $option1=='all'){
            $startDate = '';
            $endDate = '';
        }

        $sqls11='';
       
        if($option11 == 'ios'){
            $sqls11="register_user.eDeviceType LIKE 'Ios'";
        }

        if($option11 == 'android'){
            $sqls11="register_user.eDeviceType LIKE 'Android'";
        }
        
         $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
         
        $users= DB::connection('mysql2')
        ->table('trips')
        ->join('register_user', 'trips.iUserId', '=', 'register_user.iUserId')
        ->select('register_user.iUserId as UserId','register_user.vPhone as vPhone','register_user.vEmail as vEmail',
            DB::raw('MAX(trips.tTripRequestDate) as lastdate'),
            DB::raw("CONCAT(register_user.vName, ' ', register_user.vLastName) as Client"),
            DB::raw('COUNT(trips.iTripId) as TotalCourse'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN 1 ELSE 0 END) as Completed'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" THEN 1 ELSE 0 END) as Annulation'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "Driver" THEN 1 ELSE 0 END) as DeDriver'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "Passenger" THEN 1 ELSE 0 END) as DeClient'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "" THEN 1 ELSE 0 END) as DeAdmin'),
            DB::raw('ROUND(SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN trips.fTripGenerateFare ELSE 0 END),0) as MontantCourse'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" THEN trips.fCancellationFare ELSE 0 END) as MontantAnnulation')
        )
        ->where('trips.eSystem', 'General')
        ->whereIn('trips.eHailTrip', ['No', 'Yes'])
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
        ->whereNotIn('register_user.vPhone', ['72210808', '78805461','58072647']);
        if($startDate>0 && $endDate>0){
            $users->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
        }else{
           
        }
        if(!empty($sqls11)) {
            $users->whereRaw($sqls11);
        }

        $users =  $users->groupBy('register_user.iUserId', 'register_user.vName')->get();

        //->get();
        // Ajoutez des conditions pour filtrer les résultats par date
        
        //$users = $users->get();
        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_user', compact('users','startDate', 'endDate','option1','option11'));
    }


    public function liste_drive(Request $request)
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 5000;
        
        $request->validate([
            'startDate' => 'nullable|date',
            'endDate' => 'nullable|date',
        ]);
        
        $startDate = $request->input('startDate') ?? Carbon::now()->startOfMonth()->format('Y-m-d');
        $endDate = $request->input('endDate') ?? Carbon::now()->endOfMonth()->format('Y-m-d');

        //$endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        //$endDate= Carbon::parse($endDate)->addDay()->format('Y-m-d');

        $drives = DB::connection('mysql2')
        ->table('trips')
        ->join('register_user', 'trips.iUserId', '=','register_user.iUserId' )
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=','vehicle_type.iVehicleTypeId')
        ->join('company', 'company.iCompanyId', '=','register_driver.iCompanyId')
        ->select(
            'trips.iTripId as iTripId',
            'trips.vRideNo as vRideNo',
            'trips.fCommision as fcommision',
            'trips.fTva as ftva',
            DB::raw("CONCAT(register_user.vName, ' ', register_user.vLastName) as passenger"),
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as driver"),
            'company.vCompany as vCompanyName',
            'register_user.vPhone as vPhone',
            'register_driver.vPhone as vPhone_rd',
            'trips.tStartDate as startDate',
            'trips.tEndDate as endDate',
            'trips.tSaddress as source',
            'trips.tDaddress as destination',
            'vehicle_type.vVehicleType_FR as categorie',
            'trips.fTripGenerateFare as total'
            )
            ->where('trips.iActive', '=', 'Finished')
            ->where('trips.eSystem', '=', 'General')
            ->where('trips.eType', '=', 'Ride')
            ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T','Taxi Jaune']) 
            ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
            ->paginate($itemsPerPage);
            //->get();
            
        // $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_drive', compact('drives','startDate', 'endDate'));
    }
    public function liste_drive_group(){
        
        // Nombre d'éléments à afficher par page
        $itemsPerPage = 5000;
        
        $request->validate([
            'startDate' => 'nullable|date',
            'endDate' => 'nullable|date',
        ]);
        
        $startDate = $request->input('startDate') ?? Carbon::now()->startOfMonth()->format('Y-m-d');
        $endDate = $request->input('endDate') ?? Carbon::now()->endOfMonth()->format('Y-m-d');

        $drives = DB::connection('mysql2')
        ->table('trips')
        ->join('register_user', 'trips.iUserId', '=','register_user.iUserId' )
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=','vehicle_type.iVehicleTypeId')
        ->join('company', 'company.iCompanyId', '=','register_driver.iCompanyId')
        ->select(
            'company.vCompany as vCompanyName',
            'register_user.vPhone as vPhone',
            'register_driver.vPhone as vPhone_rd',
            DB::raw('SUM(trips.fCommision) as fcommision'),
            DB::raw('SUM(trips.fTva) as ftva'),
            DB::raw("CONCAT(register_user.vName, ' ', register_user.vLastName) as passenger"),
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as driver"),
            DB::raw('SUM(trips.fTripGenerateFare) as total'),
            DB::raw('MAX(trips.tEndDate) as lastEndDate'),
            DB::raw('MAX(trips.tDestination) as lastDestination')
            )
            ->where('trips.iActive', '=', 'Finished')
            ->where('trips.eSystem', '=', 'General')
            ->where('trips.eType', '=', 'Ride')
            ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T','Taxi Jaune']) 
            ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
            ->groupBy('register_driver.iDriverId', 'register_driver.vName', 'register_driver.vLastName', 'company.vCompany', 'register_driver.vPhone')
            ->orderByDesc('total')
            //->paginate($itemsPerPage);
            ->get();
            
        // $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_drive_group', compact('drives','startDate', 'endDate'));
    
    }

    public function parcour_drive(Request $request)
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        $parcours = DB::connection('mysql2')
        ->table('trips')
        ->join('register_user', 'trips.iUserId', '=','register_user.iUserId' )
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=','vehicle_type.iVehicleTypeId')
        //->join('trip_times', 'trips.iTripId', '=','trip_times.iTripId')
        ->leftJoin('trip_times', 'trips.iTripId', '=', 'trip_times.iTripId')
        ->join('company', 'company.iCompanyId', '=','register_driver.iCompanyId')
        ->select(
            'trips.iTripId as iTripId',
            'trips.vRideNo as vRideNo',
            DB::raw("CONCAT(register_user.vName, ' ', register_user.vLastName) as passenger"),
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as driver"),
            'company.vCompany as vCompanyName',
            'register_user.vPhone as vPhone',
            'register_driver.vPhone as vPhone_rd',
            'trips.tTripRequestDate as tDate',
            'trips.tDriverArrivedDate as arrivedDate',
            'trips.tStartDate as startDate',
            'trips.tEndDate as endDate',
            'trips.tSaddress as source',
            'trips.tDaddress as destination',
            'vehicle_type.vVehicleType_FR as categorie',
            'trips.fDuration as duree',
            'trips.fDistance as distance',
            'trips.fTripGenerateFare as total',
            'trips.fCommision as comission',
            'trips.vTripPaymentMode as paiement',
            'trips.iActive as status',
            'trips.eHailTrip as ehail',
            'trips.fWaitingFees as waitingfees',
            'trips.fTripHoldPrice as transitfee',
            'trip_times.dResumeTime as startp',
            'trip_times.dPauseTime as endp'
            )
          
            ->where('trips.iActive', '=', 'Finished')
            ->where('trips.eSystem', '=', 'General')
            ->where('trips.eType', '=', 'Ride')
            ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T','Taxi Jaune']) 
            ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
            ->get();
            
         $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_parcour', compact('parcours','startDate', 'endDate'));
    }

    public function liste_store(Request $request)
    {


        // Nombre d'éléments à afficher par page
       $itemsPerPage = 6;
       // utilisez les dates du mois en cours
       $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
       $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

           // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
       if ($request->has('startDate') && $request->has('endDate')) {
           $startDate = $request->input('startDate');
           $endDate = $request->input('endDate');
       }

    $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
       $stores_d = DB::connection('mysql2')
       ->table('trips')
       //->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
       ->join('company', 'company.iCompanyId', '=', 'trips.iCompanyId')
       ->select(
           'company.iCompanyId as vIdentifiant',
           'company.vCompany as vCompanyName',
           'company.vPhone as vPhone',
           'company.tRegistrationDate as vDate',
           DB::raw('COUNT(trips.iTripId) as nbCommande'),
           DB::raw('ROUND(SUM(trips.fTripGenerateFare), 0) as montant')
           //DB::raw('(SELECT COUNT(register_driver.iDriverId) FROM register_driver WHERE register_driver.iCompanyId = company.iCompanyId AND register_driver.eStatus = "Active") as nbvehicule')

       )
       ->where('trips.iActive', '=', 'Finished')
       ->where('trips.eSystem', '=', 'DeliverAll')
       ->where('trips.eType', '=', 'Ride')
       ->where('trips.iOrderId', '>', 0)
       ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
       ->groupBy(
           'company.iCompanyId',
           'company.vCompany',
           'company.vPhone',
           'company.tRegistrationDate'
       )
       ->get();
       


        $stores_d = DB::connection('mysql2')->table('company')->paginate($itemsPerPage);
        //return view('users.index', compact('users'));


     $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_store', compact('stores_d','startDate','endDate'));
    }

    public function liste_course()
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // Récupération des utilisateurs paginés
        $stores = DB::connection('mysql2')->table('company')->paginate($itemsPerPage);
        //return view('users.index', compact('users'));
        return view('layouts.administration.liste_store', compact('stores'));
    }

    
    public function liste_partner_store(Request $request)
    {

       // Nombre d'éléments à afficher par page
       $itemsPerPage = 6;
       // utilisez les dates du mois en cours
       $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
       $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

           // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
       if ($request->has('startDate') && $request->has('endDate')) {
           $startDate = $request->input('startDate');
           $endDate = $request->input('endDate');
       }
       
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        
       $stores = DB::connection('mysql2')
       ->table('trips')
       //->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
       ->join('company', 'company.iCompanyId', '=', 'trips.iCompanyId')
       ->select(
           'company.iCompanyId as vIdentifiant',
           'company.vCompany as vCompanyName',
           'company.vPhone as vPhone',
           'company.tRegistrationDate as vDate',
           DB::raw('COUNT(trips.iTripId) as nbCommande'),
           DB::raw('ROUND(SUM(trips.fTripGenerateFare), 0) as montant')
           //DB::raw('(SELECT COUNT(register_driver.iDriverId) FROM register_driver WHERE register_driver.iCompanyId = company.iCompanyId AND register_driver.eStatus = "Active") as nbvehicule')

       )
       ->where('trips.iActive', '=', 'Finished')
       ->where('trips.eSystem', '=', 'DeliverAll')
       ->where('trips.eType', '=', 'Ride')
       ->where('trips.iOrderId', '>', 0)
       ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
       ->groupBy(
           'company.iCompanyId',
           'company.vCompany',
           'company.vPhone',
           'company.tRegistrationDate'
       )
       ->get();

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        
        return view('layouts.administration.liste_partners_store', compact('stores','startDate', 'endDate'));
    }
    public function liste_partner_taxi(Request $request)
    {
       // Nombre d'éléments à afficher par page
       $itemsPerPage = 6;
       // utilisez les dates du mois en cours
       $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
       $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
           // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
       if ($request->has('startDate') && $request->has('endDate')) {
           $startDate = $request->input('startDate');
           $endDate = $request->input('endDate');
       }
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        $taxis = DB::connection('mysql2')
            ->table('trips')
            ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
            ->join('company', 'company.iCompanyId', '=', 'register_driver.iCompanyId')
            ->select(
                'company.iCompanyId as vIdentifiant',
                'company.vCompany as vCompanyName',
                'company.vPhone as vPhone',
                'company.tRegistrationDate as vDate',
                DB::raw('COUNT(trips.iTripId) as nbCourse'),
                DB::raw('ROUND(SUM(trips.fTripGenerateFare), 0) as montant'),
                DB::raw('(SELECT COUNT(register_driver.iDriverId) FROM register_driver WHERE register_driver.iCompanyId = company.iCompanyId AND register_driver.eStatus = "Active") as nbvehicule')
    
            )
            ->where('trips.iActive', '=', 'Finished')
            ->where('trips.eSystem', '=', 'General')
            ->where('trips.eType', '=', 'Ride')
            ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
            ->groupBy(
                'company.iCompanyId',
                'company.vCompany',
                'company.vPhone',
                'company.tRegistrationDate'
        )
        ->get();
         $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));

        return view('layouts.administration.liste_partners_taxi', compact('taxis','startDate', 'endDate'));
    }

    /* +===+**************Administration******************** +===+*/

    public function logistique()
    {
        $us = DB::connection('mysql2')->table('order_request')->count();

        // Utilisez var_dump() pour déboguer, commentez-le une fois que vous avez terminé le débogage
        //var_dump($us);

        return view('layouts.dashboard.logistique', compact('us'));
    }

    public function comptabilite()
    {
        $us = DB::connection('mysql2')->table('order_request')->count();

        // Utilisez var_dump() pour déboguer, commentez-le une fois que vous avez terminé le débogage
        //var_dump($us);

        return view('layouts.dashboard.comptabilite', compact('us'));
    }

   

    /* +===============================Déposit==============================+ */
    public function liste_deposit(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $option22 = $request->input('option22');
        $option33 = $request->input('option33');

        if($option22=='today'){
            $startDate = Carbon::now()->format('Y-m-d');
            $endDate = Carbon::now()->format('Y-m-d');
        }
        if($option22=='week'){
            $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));
        }
        if($option22=='month'){
            $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
        }
        if($option22=='other'){
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $sqls='';
        
        /*if ($startDate > 0 && $endDate > 0) {
            if ($option2 == 'externe') {
                $sqls = "register_driver.iCompanyId != 37";
            } elseif ($option2 == 'interne') {
                $sqls = "register_driver.iCompanyId = 37";
            }
        }*/
        
        if ($startDate > 0 && $endDate > 0) {
            if($option33 == 'driver'){
                $sqls="user_wallet.eUserType LIKE 'Driver' 
                    AND user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_USER#' 
                    AND (register_driver.vName NOT LIKE 'L-%' 
                    AND register_driver.vLastName NOT LIKE 'L-%' 
                    AND register_driver.vName NOT LIKE 'LEX-%' 
                    AND register_driver.vLastName NOT LIKE 'LEX-%')
                    ";
            }
            
    
            if($option33 == 'user'){
                $sqls="user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_USER#' 
                AND user_wallet.eUserType LIKE 'Rider'";
            }
            
            if($option33 == 'olog'){
                $sqls="user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_USER#' 
                AND user_wallet.eUserType LIKE 'Rider'
                AND (register_user.vName LIKE 'D-%'
                OR register_driver.vLastName LIKE 'D-%'
                OR register_user.vName LIKE 'D%-%'
                OR register_user.vLastName LIKE 'D%-%') ";
            }
            //SELECT * FROM `register_user` WHERE vName like 'D-%' or vLastName like 'D-%';
    
            if($option33 == 'admin'){
                $sqls="user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_ADMIN%'";
            }
    
            if($option33 == 'deliver'){
                $sqls="user_wallet.eUserType LIKE 'Driver'
                AND user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_USER#' 
                AND (register_driver.vName LIKE 'L-%'
                OR register_driver.vLastName LIKE 'L-%'
                OR register_driver.vName LIKE 'LEX-%'
                OR register_driver.vLastName LIKE 'LEX-%') ";
            }
            
             if($option33 == 'om'){
                 $sqls="user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_USER#'"; 
              //OR user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_ADMIN%'";
             }
            
            
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        
        $deposits = DB::connection('mysql2')
        ->table('user_wallet')
        ->select(
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.iUserId, register_driver.iDriverId) as iUserId'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vName, register_driver.vName) as name'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vLastName, register_driver.vLastName) as lastname'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vPhone, register_driver.vPhone) as vPhone'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vEmail, register_driver.vEmail) as vEmail'),
            'user_wallet.eType as type',
            'user_wallet.eUserType as eusertype',
            DB::raw('ROUND(user_wallet.ibalance)  as montant'),
            'user_wallet.eFor as raison',
            'user_wallet.tDescription as description',
            'user_wallet.dDate as date'
        )
        ->where('user_wallet.eType', 'Credit')
        ->where('user_wallet.eFor', 'Deposit');
        if(!empty($sqls)) {
            $deposits->whereRaw($sqls);
        }
        $deposits->whereBetween('user_wallet.dDate', [$startDate, $endDate]);
       

        $deposits->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId');
            //->where('user_wallet.eUserType', '=', 'Rider');
        });
        $deposits->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId');
            //->where('user_wallet.eUserType', '=', 'Driver');
        });
        
        $deposits=$deposits->get();
        
        /*$deposits=$deposits->toSql();
        dd($deposits);*/

        $total= DB::connection('mysql2')
        ->table('user_wallet')
        //->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Credit')
        ->where('user_wallet.eFor', 'Deposit');
        if(!empty($sqls)) {
            $total->whereRaw($sqls);
        }

        $total->whereBetween('user_wallet.dDate', [$startDate, $endDate]);
        
        $total->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId');
            //->where('user_wallet.eUserType', '=', 'Rider');
        });
        $total->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId');
            //->where('user_wallet.eUserType', '=', 'Driver');
        });
        $total= $total->value('montant');

        //$total=$this->formatNombreAvecEspaces($total);

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_deposit', compact('deposits','total','startDate','endDate','option22','option33'));
    }
    
    /* +==============================Balance===============================+ */
    
     public function calculateBalance($userId, $type, $sdate)
    {
        $walletData = DB::table('user_wallet')
            ->select('eType', DB::raw('SUM(iBalance) as totBalance'))
            ->where('iUserId', $userId)
            ->where('eUserType', $type)
            ->where('dDate','<' , $sdate)
            ->groupBy('eType')
            ->get();

        $debitBalance = $creditBalance = 0;
        foreach ($walletData as $data) {
            if ($data->eType == 'Credit') {
                $creditBalance += $data->totBalance;
            } elseif ($data->eType == 'Debit') {
                $debitBalance += $data->totBalance;
            }
        }

        $balance = $creditBalance - $debitBalance;
       $roundedBalance = round($balance, 0); // Arrondir le solde à 2 décimales

    return $roundedBalance;
    }
    
public function liste_balance(Request $request)
{
 
    $soldeDate = $request->input('soldeDate', Carbon::now()->format('Y-m-d'));
    if ($request->has('soldeDate')) {
        $soldeDate = $request->input('soldeDate');
    }

    $ligne='';
    $option33 = $request->input('option33');
    $numero = $request->input('numero');
    $ligne = $request->input('ligne');
    $ligne = $request->input('ligne', 10);
    
    //if($ligne==''){
    //  $ligne=10;
    // }

    $sqls='';
    if($soldeDate>0){
        if($option33 == 'driver'){
            $sqls="user_wallet.eUserType LIKE 'Driver'
            AND (register_driver.vName NOT LIKE 'L-%' 
            AND register_driver.vLastName NOT LIKE 'L-%' 
            AND register_driver.vName NOT LIKE 'LEX-%' 
            AND register_driver.vLastName NOT LIKE 'LEX-%')";
        }

        if($option33 == 'user'){
            $sqls="user_wallet.eUserType LIKE 'Rider'";
        }
    
        if($option33 == 'deliver'){
            $sqls="user_wallet.eUserType LIKE 'Driver' AND (register_driver.vName LIKE 'L-%' OR register_driver.vLastName LIKE 'L-%' OR register_driver.vName LIKE 'LEX-%' OR register_driver.vLastName LIKE 'LEX-%') AND register_driver.eStatus='active' ";
        }
    }

    if($numero) {
        if($sqls != '')
            $sqls .= " AND (register_driver.vPhone = '$numero' OR register_user.vPhone = '$numero')";
        else{
             $sqls= "register_driver.vPhone ='$numero' OR register_user.vPhone = '$numero'";
        }
    }
    
  
    //dd($sqls);
    $soldeDate = date('Y-m-d', strtotime($soldeDate . ' + 1 day'));
        
    $balances = DB::connection('mysql2')
    ->table('user_wallet')
    ->select(
    DB::raw('IF(user_wallet.eUserType = "Rider", register_user.iUserId, register_driver.iDriverId) as iUserId'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vName, register_driver.vName) as name'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vLastName, register_driver.vLastName) as lastname'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vPhone, register_driver.vPhone) as vPhone'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vEmail, register_driver.vEmail) as vEmail'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.nRegistrationDate, register_driver.nRegistrationDate) as vDate'),
            'user_wallet.eUserType as eusertype'
    )
   ->groupBy('iUserId', 'eusertype', 'name', 'lastname', 'vPhone', 'vEmail','vDate');
   
    if(!empty($sqls)) {
            $balances->whereRaw($sqls);
    }
        
    $balances->where('user_wallet.dDate','<' , $soldeDate);
       
    $balances->leftJoin('register_user', function($join) {
        $join->on('user_wallet.iUserId', '=', 'register_user.iUserId');
       // ->where('user_wallet.eUserType', '=', 'Rider');
    });
    $balances->leftJoin('register_driver', function($join) {
    $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId');
    //->where('user_wallet.eUserType', '=', 'Driver');
    });
    //$balances=$balances->toSql();
    //dd($balances);
    $balances=$balances->paginate($ligne);
    
    // +===================Calcul de balance=====================+ 
    
    // Calculer le solde pour chaque utilisateur ou chauffeur
        foreach ($balances as $balance) {
                $balance->balance = $this->calculateBalance($balance->iUserId, $balance->eusertype, $soldeDate);
        }

// +=====================Credit=============================+ 
    $totalc= DB::connection('mysql2')
    ->table('user_wallet')
    ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
    ->where('user_wallet.eType', 'Credit');
    
    if($sqls != '') {
        $totalc->whereRaw($sqls);
    }
    
    $totalc->where('dDate','<',$soldeDate);
   
    
    $totalc->leftJoin('register_user', function($join) {
    $join->on('user_wallet.iUserId', '=', 'register_user.iUserId');
    //->where('user_wallet.eUserType', '=', 'Rider');
    });
    $totalc->leftJoin('register_driver', function($join) {
    $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId');
   // ->where('user_wallet.eUserType', '=', 'Driver');
    });
   
    $totalc= $totalc->value('montant');
    
   // +===================Debit===================================+

    $totald= DB::connection('mysql2')
    ->table('user_wallet')
    ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
    ->where('user_wallet.eType', 'Debit');
    if($sqls != '') {
        $totald->whereRaw($sqls);
    }
    $totald->where('dDate','<',$soldeDate);
        
    $totald->leftJoin('register_user', function($join) {
    $join->on('user_wallet.iUserId', '=', 'register_user.iUserId');
    //->where('user_wallet.eUserType', '=', 'Rider');
    });
    $totald->leftJoin('register_driver', function($join) {
    $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId');
    //->where('user_wallet.eUserType', '=', 'Driver');
    });
    $totald= $totald->value('montant');
    
    // +=================End======================+ 
    $total=$totalc - $totald;
    //$total=$this->formatNombreAvecEspaces($total);

    $soldeDate = date('Y-m-d', strtotime($soldeDate . ' - 1 day'));
    return view('layouts.administration.liste_balance', compact('balances','total','numero','soldeDate','option33','ligne'));
}

/* +===============================================================================================================+ */

/*public function liste_balance(Request $request)
{
    $soldeDate = $request->input('soldeDate', Carbon::now()->format('Y-m-d'));
    $ligne = $request->input('ligne', 10);
    $option33 = $request->input('option33');
    $numero = $request->input('numero');
    
    $soldeDatee = date('Y-m-d', strtotime($soldeDate . ' + 1 day'));
    $conditions = [];

    if ($option33 == 'driver') {
        $conditions[] = "user_wallet.eUserType LIKE 'Driver' AND (register_driver.vName LIKE 'D-%' OR register_driver.vLastName LIKE 'D-%' OR register_driver.vName LIKE 'DEX-%' OR register_driver.vLastName LIKE 'DEX-%')";
    } elseif ($option33 == 'user') {
        $conditions[] = "user_wallet.eUserType LIKE 'Rider'";
    } elseif ($option33 == 'deliver') {
        $conditions[] = "user_wallet.eUserType LIKE 'Driver' AND (register_driver.vName LIKE 'L-%' OR register_driver.vLastName LIKE 'L-%' OR register_driver.vName LIKE 'LEX-%' OR register_driver.vLastName LIKE 'LEX-%')";
    }

    if ($numero) {
        $conditions[] = "(register_driver.vPhone = '$numero' OR register_user.vPhone = '$numero')";
    }

    $soldeDatePlusOne = date('Y-m-d', strtotime($soldeDate . ' + 1 day'));

    $balances = DB::connection('mysql2')
        ->table('user_wallet')
        ->select(
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.iUserId, register_driver.iDriverId) as iUserId'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vName, register_driver.vName) as name'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vLastName, register_driver.vLastName) as lastname'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vPhone, register_driver.vPhone) as vPhone'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vEmail, register_driver.vEmail) as vEmail'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.nRegistrationDate, register_driver.nRegistrationDate) as vDate'),
            'user_wallet.eUserType as eusertype'
        )
        ->groupBy('iUserId', 'eusertype', 'name', 'lastname', 'vPhone', 'vEmail', 'vDate');

    if (!empty($conditions)) {
        $balances->whereRaw(implode(' AND ', $conditions));
    }

    $balances->where('user_wallet.dDate', '<', $soldeDatePlusOne)
        ->leftJoin('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->leftJoin('register_driver', 'user_wallet.iUserId', '=', 'register_driver.iDriverId');

    $balances = $balances->paginate($ligne);

    $balances->getCollection()->transform(function ($balance) use ($soldeDate) {
        $balance->balance = $this->calculateBalance($balance->iUserId, $balance->eusertype, $soldeDate);
        return $balance;
    });

    $totalCredit = DB::connection('mysql2')
        ->table('user_wallet')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Credit')
        ->where('dDate', '<', $soldeDatePlusOne);

    if (!empty($conditions)) {
        $totalCredit->whereRaw(implode(' AND ', $conditions));
    }

    $totalCredit->leftJoin('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->leftJoin('register_driver', 'user_wallet.iUserId', '=', 'register_driver.iDriverId');

    $totalCredit = $totalCredit->value('montant');

    $totalDebit = DB::connection('mysql2')
        ->table('user_wallet')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Debit')
        ->where('dDate', '<', $soldeDatePlusOne);

    if (!empty($conditions)) {
        $totalDebit->whereRaw(implode(' AND ', $conditions));
    }

    $totalDebit->leftJoin('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->leftJoin('register_driver', 'user_wallet.iUserId', '=', 'register_driver.iDriverId');

    $totalDebit = $totalDebit->value('montant');

    $total = $totalCredit - $totalDebit;
    
     $soldeDatee = date('Y-m-d', strtotime($soldeDate . ' - 1 day'));

    return view('layouts.administration.liste_balance', compact('balances', 'total', 'numero', 'soldeDate', 'option33', 'ligne'));
}*/

/* +=========Update balance=========+ */
public function soustract_balance(Request $request){
       $today = Carbon::now();
       $currentdate = $today->format('Y-m-d H:i');
    
       $iDriverId = $request->input('iDriverId');
       $eUserType = $request->input('eUserType');
       $Montant = $request->input('montant');
       
       
      DB::connection('mysql2')->table('user_wallet')->insert([
            'iUserId' =>$iDriverId,
            'vName' =>'',
            'vLastName' =>'',
            'vPhone' =>'',
            'eUserType' => $eUserType,
            'iBalance' => $Montant,
            'eType' => 'Debit',
            'iTripId' => 0,
            'eFor' => 'Withdrawl',
            'tDescription' => '#LBL_AMOUNT_DEBIT#',
            'ePaymentStatus' => 'Unsettelled',
            'dDate' => $currentdate,
            'fRatio_USD' => 0.0017000,
            'fRatio_XOF' => 1.0000000,
            'iOrderId'=>0,
            'iTransactionId'=>'',
            'fromUserId'=>0,
            'fromUserType'=>'Driver',
            'fromAdminId'=>'',
            'service'=>'',
            'serviceType'=>'',
            'iBiddingPostId'=>0,
            'iRentItemPostId'=>0,
            'iTmpRentItemPostId'=>0,
            'iBookingId'=>0,
        ]);
     
     // Réponse de succès
        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
}
public function additional_balance(Request $request){
     $today = Carbon::now();
       $currentdate = $today->format('Y-m-d H:i');
    
        $iDriverId = $request->input('iDriverId');
       $eUserType = $request->input('eUserType');
       $Montant = $request->input('montant');
       
       
        DB::connection('mysql2')->table('user_wallet')->insert([
            'iUserId' =>$iDriverId,
            'vName' =>'',
            'vLastName' =>'',
            'vPhone' =>'',
            'eUserType' => $eUserType,
            'iBalance' => $Montant,
            'eType' => 'Credit',
            'iTripId' => 0,
            'eFor' => 'Deposit',
            'tDescription' => '#LBL_AMOUNT_CREDIT_BY_ADMIN#',
            'ePaymentStatus' => 'Unsettelled',
            'dDate' => $currentdate,
            'fRatio_USD' => 0.0017000,
            'fRatio_XOF' => 1.0000000,
            'iOrderId'=>0,
            'iTransactionId'=>'',
            'fromUserId'=>0,
            'fromUserType'=>'Driver',
            'fromAdminId'=>'',
            'service'=>'',
            'serviceType'=>'',
            'iBiddingPostId'=>0,
            'iRentItemPostId'=>0,
            'iTmpRentItemPostId'=>0,
            'iBookingId'=>0,
        ]);
     
     // Réponse de succès
        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
}

/* =======================================Remboursement===================*/
public function remboursement_balance(Request $request){
       $today = Carbon::now();
       $currentdate = $today->format('Y-m-d H:i');
    
        $iTripId = $request->input('iTripId');
        $iDriverId = $request->input('iDriverId');
        $eUserType = 'Driver';
        $created_by = session('user_id');
        
        //var_dump($iDriverId.' '. $iTripId);
       
        DB::connection('mysql2')->table('user_wallet')->insert([
            'iUserId' =>$iDriverId,
            'vName' =>'',
            'vLastName' =>'',
            'vPhone' =>'',
            'eUserType' => $eUserType,
            'iBalance' => 250,
            'eType' => 'Credit',
            'iTripId' =>  $iTripId,
            'eFor' => 'Deposit',
            'tDescription' => '#LBL_AMOUNT_REMBOURSEMENT_250_BY_ADMIN#',
            'ePaymentStatus' => 'Unsettelled',
            'dDate' => $currentdate,
            'fRatio_USD' => 0.0017000,
            'fRatio_XOF' => 1.0000000,
            'iOrderId'=>0,
            'iTransactionId'=>'',
            'fromUserId'=>0,
            'fromUserType'=>'Driver',
            'fromAdminId'=>$created_by,
            'service'=>'',
            'serviceType'=>'',
            'iBiddingPostId'=>0,
            'iRentItemPostId'=>0,
            'iTmpRentItemPostId'=>0,
            'iBookingId'=>0,
        ]);
        
        DB::table('trips')
        ->where('iTripId', $iTripId)
        ->update([
            'eAmountCancelledByDriver' => 1,
            'iRemFromAdminId'=>$created_by,
        ]);

     // Réponse de succès
        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
}
    
    /* +=============================Transaction===========================+ */

    public function liste_transaction(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

       $option1 = $request->input('option1');
       $option2 = $request->input('option2');


        if($option1=='today'){
            $startDate = Carbon::now()->format('Y-m-d');
            $endDate = Carbon::now()->format('Y-m-d');
        }
        
        if($option1=='week'){
            $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));
        }
        if($option1=='month'){
            $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
        }
        if($option1=='other'){
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        
        if($startDate>0 && $endDate>0){

            if($option2 == 'driver'){
                $sqls="user_wallet.eUserType LIKE 'Driver' 
                AND (register_driver.vName NOT LIKE 'L-%' 
                AND register_driver.vLastName NOT LIKE 'L-%' 
                AND register_driver.vName NOT LIKE 'LEX-%' 
                AND register_driver.vLastName NOT LIKE 'LEX-%')";
            }

            if($option2 == 'user'){
                $sqls="user_wallet.eUserType LIKE 'Rider'";
            }

            if($option2 == 'deliver'){
                $sqls="user_wallet.eUserType LIKE 'Driver' AND (register_driver.vName LIKE 'L-%' OR register_driver.vLastName LIKE 'L-%' OR register_driver.vName LIKE 'LEX-%' OR register_driver.vLastName LIKE 'LEX-%')";
            }
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        /*if($option2 == 'interne' && $startDate>0 && $endDate>0){
            $sqls="register_driver.vName LIKE 'D-%' OR register_driver.vLastName LIKE 'D-%'";
        }*/


        $transactions = DB::connection('mysql2')
        ->table('user_wallet')
        ->select(
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.iUserId, register_driver.iDriverId) as iUserId'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vName, register_driver.vName) as name'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vLastName, register_driver.vLastName) as lastname'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vPhone, register_driver.vPhone) as vPhone'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vEmail, register_driver.vEmail) as vEmail'),
            'user_wallet.eType as type',
            'user_wallet.eUserType as eusertype',
            DB::raw('ROUND(user_wallet.ibalance)  as montant'),
            'user_wallet.eFor as raison',
            'user_wallet.tDescription as description',
            'user_wallet.dDate as date'
        );
        if(!empty($sqls)) {
            $transactions->whereRaw($sqls);
        }
        $transactions->whereBetween('user_wallet.dDate', [$startDate, $endDate]);

        $transactions->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId');
                //->where('user_wallet.eUserType', '=', 'Rider');
        });
        $transactions->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId');
                //->where('user_wallet.eUserType', '=', 'Driver');
        });

        $transactions=$transactions->get();


        $credits= DB::connection('mysql2')
        ->table('user_wallet')
        //->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Credit');
        if(!empty($sqls)) {
            $credits->whereRaw($sqls);
        }
        $credits->whereBetween('user_wallet.dDate', [$startDate, $endDate]);
        

        $credits->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
            ->where('user_wallet.eUserType', '=', 'Rider');
        });
        $credits->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
            ->where('user_wallet.eUserType', '=', 'Driver');
        });
        $credits= $credits->value('montant');

        $debits= DB::connection('mysql2')
        ->table('user_wallet')
        //->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Debit');
        if(!empty($sqls)) {
            $debits->whereRaw($sqls);
        }
        $debits->whereBetween('user_wallet.dDate', [$startDate, $endDate]);

    
        $debits->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
            ->where('user_wallet.eUserType', '=', 'Rider');
        });
        $debits->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
            ->where('user_wallet.eUserType', '=', 'Driver');
        });

        $debits= $debits->value('montant');

        $balance=$credits-$debits;
        //$debits=$this->formatNombreAvecEspaces($debits);
        //$credits=$this->formatNombreAvecEspaces($credits);
        //$balance=$this->formatNombreAvecEspaces($balance);

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_transaction', compact('transactions','debits','credits','balance','startDate','endDate','option1','option2'));
    }


    public function liste_wallet_statistic(){

        return view('layouts.administration.liste_wallet_statistic');

    }
    
    
    
    /*********+===+**********Commandes******+===+*************/
 public function liste_livreur(Request $request)
    {
        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;

        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

        // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $sqls='';
        $option2 = $request->input('option2');
       
        if ($startDate > 0 && $endDate > 0) {
            if ($option2 == 'externe') {
                $sqls = "register_driver.iCompanyId != 37 AND (register_driver.vName NOT LIKE 'L-%' 
                AND register_driver.vLastName NOT LIKE 'L-%' 
                AND register_driver.vName NOT LIKE 'LEX-%' 
                AND register_driver.vLastName NOT LIKE 'LEX-%')"
                ;
            } elseif ($option2 == 'interne') {
                $sqls = "register_driver.iCompanyId = 37";
            }
        }

        /*  */
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        
        $livreurs= DB::connection('mysql2')
        ->table('orders')
        ->join('register_driver', 'orders.iDriverId', '=', 'register_driver.iDriverId')
        ->select('register_driver.iDriverId as DriverId','register_driver.vPhone as vPhone','register_driver.vEmail as vEmail',
            DB::raw('MAX(orders.tOrderRequestDate) as lastdate'),
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as Driver"),
            DB::raw('COUNT(orders.iOrderId) as totalCommande'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 6 THEN 1 ELSE 0 END) as Completed'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 8 THEN 1 ELSE 0 END) as Annulation'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 8 AND orders.eCancelledBy = "Driver" THEN 1 ELSE 0 END) as DeDriver'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 8 AND orders.eCancelledBy = "Passenger" THEN 1 ELSE 0 END) as DeClient'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 8 AND orders.eCancelledBy = "Admin" THEN 1 ELSE 0 END) as DeAdmin'),
            DB::raw('ROUND(SUM(CASE WHEN orders.iStatusCode = 6 THEN orders.fTotalGenerateFare ELSE 0 END),0) as MontantCommande')
        )
        ->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
        
       
        if(!empty($sqls)) {
            $livreurs->whereRaw($sqls);
        }
       
        $livreurs = $livreurs->groupBy('register_driver.iDriverId', 'register_driver.vName')->get();
        
         $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_livreur', compact('livreurs','startDate', 'endDate','option2'));
    }
    
    
    public function liste_user_commande(Request $request)
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = '';//$request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = '';//$request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $option1 = $request->input('option1');
        $option11 = $request->input('option11');

        if( $option1=='all'){
            $startDate = '';
            $endDate = '';
        }

        $sqls11='';
       
        if($option11 == 'ios'){
            $sqls11="register_user.eDeviceType LIKE 'Ios'";
        }

        if($option11 == 'android'){
            $sqls11="register_user.eDeviceType LIKE 'Android'";
        }
        
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        $usercoms= DB::connection('mysql2')
        ->table('orders')
        ->join('register_user', 'orders.iUserId', '=', 'register_user.iUserId')
        ->select('register_user.iUserId as UserId','register_user.vPhone as vPhone','register_user.vEmail as vEmail',
            DB::raw('MAX(orders.tOrderRequestDate) as lastdate'),
            DB::raw("CONCAT(register_user.vName, ' ', register_user.vLastName) as Client"),
            DB::raw('COUNT(orders.iOrderId) as TotalCommande'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 6 THEN 1 ELSE 0 END) as Completed'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 8 THEN 1 ELSE 0 END) as Annulation'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 8 AND orders.eCancelledBy = "Driver" THEN 1 ELSE 0 END) as DeDriver'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 8 AND orders.eCancelledBy = "Passenger" THEN 1 ELSE 0 END) as DeClient'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 8 AND orders.eCancelledBy = "Admin" THEN 1 ELSE 0 END) as DeAdmin'),
            DB::raw('ROUND(SUM(CASE WHEN orders.iStatusCode = 6 THEN orders.fTotalGenerateFare ELSE 0 END),0) as MontantCommande'),
            DB::raw('SUM(CASE WHEN orders.iStatusCode = 8 THEN orders.fCancellationCharge ELSE 0 END) as MontantAnnulation')
        )
        /*->where('trips.eSystem', 'General')
        ->whereIn('trips.eHailTrip', ['No', 'Yes'])
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])*/
        ->whereNotIn('register_user.vPhone', ['72210808', '78805461']);
        if($startDate>0 && $endDate>0){
            $users->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
        }else{
           
        }
        if(!empty($sqls11)) {
            $users->whereRaw($sqls11);
        }

        $usercoms =  $usercoms->groupBy('register_user.iUserId', 'register_user.vName')->get();

        //->get();
        // Ajoutez des conditions pour filtrer les résultats par date
        
        //$users = $users->get();
        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_user_commande', compact('usercoms','startDate', 'endDate','option1','option11'));
    }
    
    
   public function liste_commande(Request $request)
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        $commandes = DB::connection('mysql2')
        ->table('trips')
        ->join('orders', 'trips.iOrderId', '=','orders.iOrderId' )
        ->join('register_user', 'trips.iUserId', '=','register_user.iUserId' )
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        //->join('vehicle_type', 'orders.iVehicleTypeId', '=','vehicle_type.iVehicleTypeId')
        ->join('company', 'company.iCompanyId', '=','orders.iCompanyId')
        ->select(
            'orders.iOrderId as iOrderId',
            'orders.vOrderNo as vOrderNo',
            DB::raw("CONCAT(register_user.vName, ' ', register_user.vLastName) as passenger"),
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as driver"),
            'company.vCompany as vCompanyName',
            'register_user.vPhone as vPhone',
            'register_driver.vPhone as vPhone_rd',
            'orders.tOrderRequestDate as tDate',
            'trips.tDriverArrivedDate as arrivedDate',
            'trips.tStartDate as startDate',
            'trips.tEndDate as endDate',
             'orders.dDeliveryDate as deliveryDate',
            'trips.tSaddress as source',
            'trips.tDaddress as destination',
            'trips.fDuration as duree',
            'trips.fDistance as distance',
            'trips.fDeliveryCharge as paie',
            'orders.fSubTotal as montant',
            'orders.fDeliveryCharge as frais',
            'orders.fTotalGenerateFare as total',
            'orders.fWalletDebit as wallet',
            'orders.fNetTotal as cash',
            'orders.fCommision as comission',
            'trips.vTripPaymentMode as paiement',
            'trips.iActive as status'
            )
          ->where('orders.iStatusCode', '=', 6)
          ->where('trips.iActive', '=', 'Finished')
           /* ->where('trips.eSystem', '=', 'General')
            ->where('trips.eType', '=', 'Ride')*/
            ->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate])
            ->get();
            
        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_commande', compact('commandes','startDate', 'endDate'));
    }
    
    
    
    /* +======================================================= Recharge unite ===========================================================+ */
    
    public function view_unite()
    {
        return view('layouts.administration.view_unite');
    }
    
    public function send_unite(Request $request)
    {
           // Valider les données
        $validated = $request->validate([
            'sentTo' => 'required|array',
            'sentTo.*' => 'required|string',
            'amount' => 'required|numeric',
            'ref' => 'required|string',
            'countryStringCode' => 'required|string',
            'countryNumberCode' => 'required|string',
            'campaignName' => 'required|string',
        ]);
    
        // Appel API POST vers iKoddi
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
            'x-api-key' => 'CxhQAwCRf8PoGtglNJ9BB9qV8aFCkXZR',
        ])->post('https://api.staging.ikoddi.com/api/v1/groups/10519078/airtimes', $validated);
    
        if ($response->successful()) {
            return back()->with('success', 'Recharge envoyée avec succès.');
        } else {
            $error = $response->json();
            return back()->with('error', 'Échec de l\'envoi : ' . json_encode($error));
        }
    }
    
    public function liste_forfait()
    {
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
            'x-api-key' => 'CxhQAwCRf8PoGtglNJ9BB9qV8aFCkXZR',
        ])->get('https://api.staging.ikoddi.com/api/v1/groups/10519078/airtimes/internet-plans');

        if ($response->successful()) {
            $forfaits = Arr::get($response->json(), null, []); // réponse = tableau directement, pas ['data']
            return view('layouts.administration.liste_forfait', compact('forfaits'));
        } else {
            return back()->with('error', 'Impossible de récupérer les forfaits Internet.');
        }
            
       
    }
    //
    public function subscribe_forfait(Request $request)
    {
        
         //$balance->balance = $this->calculateBalance($balance->iUserId, $balance->eusertype, $soldeDate);
        
        
        
        $response = Http::withHeaders([
        'Content-Type' => 'application/json',
        'x-api-key' => 'CxhQAwCRf8PoGtglNJ9BB9qV8aFCkXZR',
        ])->post('https://api.staging.ikoddi.com/api/v1/groups/10519078/airtimes', [
        "sentTo" => [$request->sentTo],
        "ref" => $request->ref,
        "amount" => $request->amount,
        "countryStringCode" => $request->countryStringCode,
        "countryNumberCode" => $request->countryNumberCode,
        "campaignName" => $request->campaignName,
    ]);

    if ($response->successful()) {
        return back()->with('success', 'Souscription envoyée avec succès !');
    } else {
        return back()->with('error', 'Erreur lors de l’envoi : ' . $response->body());
    }
    }
    //
    public function liste_historique(Request $request)
    {
             $response = Http::withHeaders([
             'Content-Type' => 'application/json',
                'x-api-key' => 'CxhQAwCRf8PoGtglNJ9BB9qV8aFCkXZR',
            ])->get('https://api.staging.ikoddi.com/api/v1/groups/10519078/airtimes');
        
            if (!$response->successful()) {
                return back()->with('error', 'Impossible de récupérer les données');
            }
        
            $data = $response->json()['data'];
        
            $dateDebut = $request->input('date_debut');
            $dateFin = $request->input('date_fin');
            
            
            $response2 = Http::withHeaders([
                'Content-Type' => 'application/json',
                'x-api-key' => 'CxhQAwCRf8PoGtglNJ9BB9qV8aFCkXZR',
            ])->get('https://api.staging.ikoddi.com/api/v1/groups/10519078/airtime/accounts/current/balance');
            //return redirect()->back()->with('success', 'Souscription effectuée avec succès.');

            if ($response2->successful()) {
                $solde = $response2->json()['balance']; // ou adapte selon structure exacte de la réponse
            } else {
                $solde = 0;
            }
            
       
            if ($dateDebut && $dateFin) {
                $data = collect($data)->filter(function ($item) use ($dateDebut, $dateFin) {
                    $createdAt = \Carbon\Carbon::parse($item['createdAt'])->format('Y-m-d');
                    return $createdAt >= $dateDebut && $createdAt <= $dateFin;
                })->values()->all(); // Re-indexe les résultats
            }
            return view('layouts.administration.liste_historique', compact('data', 'solde'));
    }
    

    /* +===============================+============================End===================================+===================+ */
    public static function calculateMinutesDifference($startDate, $endDate) {
        // Convertir les chaînes de dates en instances de Carbon
        $start = Carbon::parse($startDate);
        $end = Carbon::parse($endDate);

        // Calculer la différence totale en secondes
        $secondsDifference = $start->diffInSeconds($end);

        // Convertir la différence en minutes avec des décimales
        $minutesDifference = $secondsDifference / 60;

        return number_format($minutesDifference, 2); // Formater avec 2 chiffres après la virgule
   
    }


    function formatNombreAvecEspaces($nombre) {
        // Utilise number_format avec un espace comme séparateur des milliers
        return number_format($nombre, 0, ',', ' ');
    }


    function login(){
        return view('layouts.login');
    }
}
