<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;


class Comptabilite extends Controller
{
    
    //Depense

    public function index()
    {
        //return redirect()->route('dashboard-administration');
        return redirect()->route('dashboard-administration');
    }
    
     
    public function liste_depense(Request $request)
    {
        
        $sqls="register_user.vName LIKE 'D- %' OR register_user.vLastName LIKE 'D- %'";
         $sqlsl="register_driver.vName LIKE 'L-%' 
                    OR register_driver.vLastName LIKE 'L-%' 
                    OR register_driver.vLastName LIKE 'LEX-%' 
                    OR register_driver.vLastName LIKE 'LEX-%' ";
         
        $sqlsd = "(register_driver.vName NOT LIKE 'L-%' 
                    AND register_driver.vLastName NOT LIKE 'L-%' 
                    AND register_driver.vName NOT LIKE 'LEX-%' 
                    AND register_driver.vLastName NOT LIKE 'LEX-%')
                    ";
        
        //Select option
        $driveurs = DB::connection('mysql2')
        ->table('register_driver')
        ->select('iDriverId as iUserId','vPhone',DB::raw("CONCAT(vName, ' ', vLastName) as name"))
        ->where('eStatus','=','active')
        ->whereRaw($sqlsd)
        ->get();
        
       $users = DB::connection('mysql2')
        ->table('register_user')
        ->select('iUserId','vPhone',DB::raw("CONCAT(vName, ' ', vLastName) as name"))
        ->where('eStatus','=','active')
        //->whereRaw($sqls)
        ->get();
        
        $livreurs = DB::connection('mysql2')
        ->table('register_driver')
        ->select('iDriverId as iUserId','vPhone',DB::raw("CONCAT(vName, ' ', vLastName) as name"))
        ->where('eStatus','=','active')
        ->whereRaw($sqlsl)
        ->get();
        
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        /*$depense_driver = DB::connection('mysql2')
        ->table('allexpense as de')
        ->leftJoin('register_user as rd', 'rd.iUserId', '=', 'de.iDriverId')
        ->select(
            'de.expenseId',
            'de.contenu as titre',
            'de.description',
            'de.montant',
            'de.date_created as date_c',
            'de.aexpense_date as edate',
            'de.iUserId as iDriverId',
            'rd.vName',
            'rd.vLastName',
            'rd.vPhone',
            DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) as driveur")
        )
        ->whereBetween('de.expense_date', [$startDate, $endDate])
        ->get();*/
        
        
        $depense_driver = DB::connection('mysql2')
    ->table('allexpense as de')
    ->leftJoin('administrators as ad', 'ad.iAdminId', '=', 'de.created_by')
    // Jointure avec register_user si user_type = 'user'
    ->leftJoin('register_user as ru', function($join) {
        $join->on('ru.iUserId', '=', 'de.iUserId')
             ->where('de.user_type', '=', 'user');
    })
    // Jointure avec register_driver si user_type = 'driver'
    ->leftJoin('register_driver as rd', function($join) {
        $join->on('rd.iDriverId', '=', 'de.iUserId')
             ->where('de.user_type', '=', 'driver');
    })
    ->select(
        'de.aexpenseId',
        'de.contenu as titre',
        'de.description',
        'de.montant',
        'de.date_created as date_c',
        'de.aexpense_date as edate',
        'de.iUserId',
       // 'de.iDriverId',
        'de.user_type',
        DB::raw("CONCAT(ad.vFirstName, ' ', ad.vLastName) as nom_creation"),
        // Récupérer les informations en fonction du type d'utilisateur
        DB::raw("
            CASE 
                WHEN de.user_type = 'user' THEN CONCAT(ru.vName, ' ', ru.vLastName)
                WHEN de.user_type = 'driver' THEN CONCAT(rd.vName, ' ', rd.vLastName)
                ELSE 'Inconnu'
            END as nom_personne
        "),
        DB::raw("
            CASE 
                WHEN de.user_type = 'user' THEN ru.vPhone
                WHEN de.user_type = 'driver' THEN rd.vPhone
                ELSE 'Inconnu'
            END as telephone
        ")
    )
    ->whereBetween('de.aexpense_date', [$startDate, $endDate])
    ->orderBy('aexpenseId', 'desc')
    ->get();

        
        /*
        
        $depense_driver = DB::connection('mysql2')
        ->table('expense as de')
        ->leftJoin('register_user as rd', 'rd.iUserId', '=', 'de.iDriverId')
        ->select(
            'de.expenseId',
            'de.titre',
            'de.description',
            'de.montant',
            'de.date_created as date_c',
            'de.expense_date as edate',
            'de.iDriverId',
            'rd.vName',
            'rd.vLastName',
            'rd.vPhone',
            DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) as driveur")
        )
        ->whereBetween('de.expense_date', [$startDate, $endDate])
        ->get();
        
        */
       
        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.comptabilite.liste_depense', compact('depense_driver','driveurs','users','livreurs','startDate','endDate'));
    }
    

/*public function saveDepense(Request $request)
{
    // Validation des données d'entrée
    $validator = Validator::make($request->all(), [
        'montant' => 'required|numeric|min:0',
        'titre' => 'required|string|max:255',
        'description' => 'nullable|string|max:500',
        'edate' => 'required|date',
        'usertype' => 'required|in:user,driver,deliver',
        'numero' => 'required|string|max:15', 
        //'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048' // Taille max 2 Mo
    ]);

    // Gestion des erreurs de validation
    if ($validator->fails()) {
        return redirect()->back()
            ->withErrors($validator)
            ->withInput();
    }

    // Récupération des données du formulaire
    $date_day = Carbon::now()->format('Y-m-d H:i:s');
    $montant = $request->input('montant');
    $titre = $request->input('titre');
    $description = $request->input('description');
    $edate = $request->input('edate');
    $usertype = $request->input('usertype');
    $numero = $request->input('numero');
    $created_by = session('user_id');
    
    // Vérification du type d'utilisateur et récupération des informations correspondantes
    if($usertype == "user") {
        $userOK = DB::connection('mysql2')
            ->table('register_user')
            ->select('iUserId as iUserId', 'vPhone', DB::raw("CONCAT(vName, ' ', vLastName) as name"))
            ->where('eStatus', 'active')
            ->where('vPhone', $numero)
            ->first();
        
        if ($userOK) {
            $iUserId = $userOK->iUserId;
            $type="Rider";
        } else {
            return redirect()->back()->with('error', 'Le numéro de l\'utilisateur doit être valide! Veuillez changer de numéro.');
        }
    }elseif ($usertype == "driver" || $usertype == "deliver") {
        $driverOK = DB::connection('mysql2')
            ->table('register_driver')
            ->select('iDriverId as iUserId', 'vPhone', DB::raw("CONCAT(vName, ' ', vLastName) as name"))
            ->where('eStatus', 'active')
            ->where('vPhone', $numero)
            ->first();
        
        if($driverOK){
            $iUserId = $driverOK->iUserId;
              $type="Driver";
        }else{
            return redirect()->back()->with('error', 'Le numéro du chauffeur doit être valide! Veuillez changer de numéro.');
        }
    }



             DB::connection('mysql2')->table('user_wallet')->insert([
                    'iUserId' =>  $iUserId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => $type,
                    'iBalance' => $montant,
                    'eType' => 'Credit',
                    'iTripId' => 0,
                    'eFor' => 'Deposit',
                    'tDescription' => '#ADMIN_RECHARGE_DEPENSE#',
                    'ePaymentStatus' => 'Unsettelled',
                    'dDate' => $date_day,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>$created_by,
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                        
            ]);
            // Préparation des données pour insertion dans la base de données
            $data = [
                'montant' => $montant,
                'contenu' => $titre,
                'description' => $description,
                'aexpense_date' => $edate,
                'iUserId' => $iUserId,
                'user_type' => $usertype,
                'files' => "null",//$imagePath,
                'created_by' => $created_by
            ];
        
            // Insertion des données dans la table allexpense
            DB::connection('mysql2')->table('allexpense')->insert($data);

    // Redirection avec un message de succès
    return redirect()->back()->with('success', 'Dépense ajoutée avec succès!');
}*/


public function saveDepense(Request $request)
{
    // Validation des données d'entrée
    $validator = Validator::make($request->all(), [
        'montant' => 'required|numeric|min:0',
        'titre' => 'required|string|max:255',
        'description' => 'nullable|string|max:500',
        'edate' => 'required|date',
        'usertype' => 'required|in:user,driver,deliver',
        'numero' => 'required|string|max:15'
    ]);

    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }

    $date_day = Carbon::now()->format('Y-m-d H:i:s');
    $montant = $request->input('montant');
    $titre = $request->input('titre');
    $description = $request->input('description');
    $edate = $request->input('edate');
    $usertype = $request->input('usertype');
    $numero = $request->input('numero');
    $created_by = session('user_id');

    try {
        // Début de la transaction
        DB::connection('mysql2')->beginTransaction();

        // Vérification du type d'utilisateur
        if ($usertype == "user") {
            $userOK = DB::connection('mysql2')->table('register_user')
                ->select('iUserId as iUserId', 'vPhone', DB::raw("CONCAT(vName, ' ', vLastName) as name"))
                ->where('eStatus', 'active')
                ->where('vPhone', $numero)
                ->first();

            if (!$userOK) {
                throw new \Exception("Le numéro de l'utilisateur est invalide.");
            }

            $iUserId = $userOK->iUserId;
            $type = "Rider";

        } elseif (in_array($usertype, ["driver", "deliver"])) {
            $driverOK = DB::connection('mysql2')->table('register_driver')
                ->select('iDriverId as iUserId', 'vPhone', DB::raw("CONCAT(vName, ' ', vLastName) as name"))
                ->where('eStatus', 'active')
                ->where('vPhone', $numero)
                ->first();

            if (!$driverOK) {
                throw new \Exception("Le numéro du chauffeur est invalide.");
            }

            $iUserId = $driverOK->iUserId;
            $type = "Driver";
        }

        // Insertion dans la table user_wallet
        DB::connection('mysql2')->table('user_wallet')->insert([
            'iUserId' => $iUserId,
            'vName' => '',
            'vLastName' => '',
            'vPhone' => '',
            'eUserType' => $type,
            'iBalance' => $montant,
            'eType' => 'Credit',
            'iTripId' => 0,
            'eFor' => 'Deposit',
            'tDescription' => '#ADMIN_RECHARGE_DEPENSE#',
            'ePaymentStatus' => 'Unsettelled',
            'dDate' => $date_day,
            'fRatio_USD' => 0.0017000,
            'fRatio_XOF' => 1.0000000,
            'iOrderId' => 0,
            'iTransactionId' => '',
            'fromUserId' => 0,
            'fromUserType' => 'Driver',
            'fromAdminId' => $created_by,
            'service' => '',
            'serviceType' => '',
            'iBiddingPostId' => 0,
            'iRentItemPostId' => 0,
            'iTmpRentItemPostId' => 0,
            'iBookingId' => 0,
        ]);

        // Insertion dans la table allexpense
        DB::connection('mysql2')->table('allexpense')->insert([
            'montant' => $montant,
            'contenu' => $titre,
            'description' => $description,
            'aexpense_date' => $edate,
            'iUserId' => $iUserId,
            'user_type' => $usertype,
            'files' => null, // utilise null et non "null"
            'created_by' => $created_by
        ]);

        // Validation de la transaction
        DB::connection('mysql2')->commit();

        return redirect()->back()->with('success', 'Dépense ajoutée avec succès !');

    } catch (\Exception $e) {
        DB::connection('mysql2')->rollBack();
        return redirect()->back()->with('error', 'Erreur : ' . $e->getMessage());
    }
}


//Facture

    public function liste_facture(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        $invoices = DB::connection('mysql2')
        ->table('invoice_internal as ii')
        ->leftJoin('administrators as ad', 'ad.iAdminId', '=', 'ii.created_by')
        ->select(
            'ii.*',
            DB::raw("CONCAT(ad.vFirstName, ' ', ad.vLastName) as nom_creation")
        )
        ->whereBetween('ii.date_invoice', [$startDate, $endDate])
        ->orderBy('invoice_internalId', 'desc')
        ->get();

       
        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.comptabilite.liste_facture', compact('invoices','startDate','endDate'));
    }
    

    public function saveFacture(Request $request)
    {
       //var_dump($request);
        // Validation des données d'entrée
        $validator = Validator::make($request->all(), [
            'client' => 'required|numeric|min:0',
            'numero' => 'required|string|max:255',
            'numerof' => 'nullable|string|max:500',
            'edate' => 'required|date',
            'montant'=>'required|numeric',
            'service' => 'required|string',
            'status' => 'required|string', 
            ///'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048' // Taille max 2 Mo
        ]);
    
        // Gestion des erreurs de validation
        /*if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }*/
    
        // Récupération des données du formulaire
        //$date_day = Carbon::now()->format('Y-m-d H:i:s');
        $montant = $request->input('montant');
        $service = $request->input('service');
        $client=$request->input('client');
        $numero = $request->input('numero');
        $date_invoice = $request->input('edate');
        $status = $request->input('status');
        $numero_fact = $request->input('numerof');
        $created_by = session('user_id');
        
        // Préparation des données pour insertion dans la base de données
        $data = [
                'montant' => $montant,
                'numero_facture' => $numero_fact,
                'client' => $client,
                'date_invoice' => $date_invoice,
                'service' => $service,
                'status' => $status,
                'numero_client'=>$numero,
                'file' => "null",
                'created_by' => $created_by,
            ];
            
                // Insertion des données dans la table allexpense
        DB::connection('mysql2')->table('invoice_internal')->insert($data);
    
        // Redirection avec un message de succès
        return redirect()->back()->with('success', 'Facture ajoutée avec succès!');
    }
    
    public function updateStatus(Request $request, $id)
    {
        $invoice = DB::connection('mysql2')
            ->table('invoice_internal')
            ->where('invoice_internalId', $id)
            ->first();
    
        if (!$invoice) {
            abort(404, 'Invoice not found');
        }
    
        DB::connection('mysql2')
            ->table('invoice_internal')
            ->where('invoice_internalId', $id)
            ->update(['status' => $request->status]);
    
        return redirect()->back()->with('success', 'Statut mis à jour avec succès');
    }


    
    public function liste_partner_taxi(Request $request)
    {
       // Nombre d'éléments à afficher par page
       $itemsPerPage = 6;
       // utilisez les dates du mois en cours
       $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
       $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
           // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
       if ($request->has('startDate') && $request->has('endDate')) {
           $startDate = $request->input('startDate');
           $endDate = $request->input('endDate');
       }
       
        $taxis = DB::connection('mysql2')
            ->table('trips')
            ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
            ->join('company', 'company.iCompanyId', '=', 'register_driver.iCompanyId')
            ->select(
                'company.iCompanyId as vIdentifiant',
                'company.vCompany as vCompanyName',
                'company.vPhone as vPhone',
                'company.tRegistrationDate as vDate',
                DB::raw('COUNT(trips.iTripId) as nbCourse'),
                DB::raw('ROUND(SUM(trips.fTripGenerateFare), 0) as montant'),
                DB::raw('(SELECT COUNT(register_driver.iDriverId) FROM register_driver WHERE register_driver.iCompanyId = company.iCompanyId AND register_driver.eStatus = "Active") as nbvehicule')
    
            )
            ->where('trips.iActive', '=', 'Finished')
            ->where('trips.eSystem', '=', 'General')
            ->where('trips.eType', '=', 'Ride')
            ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
            ->groupBy(
                'company.iCompanyId',
                'company.vCompany',
                'company.vPhone',
                'company.tRegistrationDate'
        )
        ->get();

        return view('layouts.administration.liste_partners_taxi', compact('taxis','startDate', 'endDate'));
    }

    /* ******************************** */
    public function liste_wallet_statistic(){

        return view('layouts.administration.liste_wallet_statistic');

    }
    
    /* ========================Paiement=============================+ */
    public function liste_paiement_resto(Request $request)
    {
        $startDate = '';
        $endDate = '';

        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        
        $option2=$request->input('option2');

        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        /** +==============================sql esquest================================+* */
         $paiement_restos = DB::connection('mysql2')->table('company')
            ->select([
                'company.iCompanyId',
                'orders.eRestaurantPaymentStatus',
                'company.iMoney as money',
                'company.iMoneyResponsable as moneyResp',
                //DB::raw("service_categories.vServiceName_FR as vServiceName"), //Comment by Basile 02/04/2024
                'company.vCompany','company.vPhone as vPhone',
                DB::raw('ROUND(SUM(orders.fTotalGenerateFare),0) as totalFare'),
                DB::raw('ROUND(SUM(orders.fCommision),0) as totalCommision'),
                DB::raw('ROUND(SUM(orders.fDeliveryCharge),0) as totalDeliveryCharge'),
                DB::raw('ROUND(SUM(orders.fOffersDiscount),0) as totalOffersDiscount'),
                DB::raw('ROUND(SUM(orders.fOutStandingAmount),0) as totalOutStandingAmount'),
            ])
            ->leftJoin('store_pay_timing', 'store_pay_timing.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('orders', 'orders.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('service_categories', 'service_categories.iServiceid', '=', 'orders.iServiceid')
            //->where('orders.eRestaurantPaymentStatus', 'Unsettled')
            ->where('eRestaurantPayByAdmin','No')
            //->where('eRestaurantPaymentStatus','Settled')
            ->where('orders.iStatusCode', '6')
            //->where('company.eStatus', 'Active')
            ->whereNotIn('company.iCompanyId', [40,554])
            ->where(function ($query) {
                $query->where('orders.iStatusCode', '6')
                      ->orWhere('orders.fRestaurantPayAmount', '>', 0);
            })
            ->where('orders.eBuyAnyService', 'No');
            if($startDate>0 && $endDate>0){
                $paiement_restos->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            }else{
               
            }
            //->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            
            if($option2 !='All') {
               $paiement_restos->where('store_pay_timing.iPeriode', $option2);
            }
            //->where('store_pay_timing.iPeriode', $option2)
            //$paiement_restos->groupBy('company.iCompanyId', 'orders.eRestaurantPaymentStatus', 'vServiceName', 'company.vCompany'); //Comment by Basile 02/04/2024
            $paiement_restos->groupBy('company.iCompanyId', 'orders.eRestaurantPaymentStatus', 'company.vCompany');
            
            $paiement_restos=$paiement_restos->get();
            
        if($endDate>0){
          $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_paiement_resto', compact('paiement_restos','startDate','endDate','option2'));
    }
    
    public function upStorePaymentStatus(Request $request){
        
        $today = Carbon::now();
        $currentdate = $today->format('Y-m-d H:i'); // Format YYYY-MM-DD HH:MM
     
        //var_dump($request);
        
        // Récupérer les données du formulaire
        $iCompanyId = $request->input('iCompanyId');
        $resto = $request->input('resto');
        $startDate = $request->input('dated');
        $endDate = $request->input('datef');
        $montant = $request->input('montant');
       
        
    // Début de la transaction
    
        DB::beginTransaction();
        
        try {
            // Vérifier si les dates sont valides
            if ($startDate > 0 && $endDate > 0) {
               
                $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
                
                // Mettre à jour les commandes dans la plage de dates spécifiée
              
                DB::connection('mysql2')->table('orders')
                    ->where('iCompanyId', $iCompanyId)
                    ->whereBetween('dDate', [$startDate, $endDate])
                    ->update(['eRestaurantPayByAdmin' => 'Yes','eRestaurantPaymentStatus'=>'Settled']);
            } else {
                // Si les dates ne sont pas spécifiées, mettre à jour toutes les commandes du pilote
              
                DB::connection('mysql2')->table('orders')
                    ->where('iCompanyId', $iCompanyId)
                    ->update(['eRestaurantPayByAdmin' => 'Yes','eRestaurantPaymentStatus'=>'Settled']);
            }
            
            // Commit de la transaction
            
            DB::commit();
            
        } catch (\Exception $e) {
        
            // En cas d'erreur, annuler la transaction
            
            DB::rollback();
            // Gérer l'exception
        }

        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    /* +======================Paiement resto details===================================+ */
    public function liste_paiement_resto_detail(Request $request,$id)
    {
        $startDate = '';
        $endDate = '';
        
       if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
       
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }
        
        /* +===========resto name==================*/
        
         $companies = DB::connection('mysql2')
        ->table('company')
        ->select('*')
        ->where('iCompanyId','=',$id)
        ->get();
        
        /*+=========================+*/
        
         $paiement_resto_details = DB::connection('mysql2')->table('company')
            ->select([
                'company.iCompanyId',
                'orders.vOrderNo',
                'orders.eRestaurantPaymentStatus',
                'service_categories.vServiceName_FR as vServiceName',
                'company.vCompany','company.vPhone as vPhone',
                'company.iMoney as money',
                'orders.fTotalGenerateFare as totalFare',
                'orders.fSubTotal as subTotal',
                'orders.fPackingCharge as fPackingCharge',
                'orders.fOffersDiscount as fodiscount',
                'orders.fCommision as totalCommision',
                'orders.fDeliveryCharge as totalDeliveryCharge',
                'orders.fOffersDiscount as totalOffersDiscount',
                'orders.fOutStandingAmount as totalOutStandingAmount',
                'orders.tOrderRequestDate as oDate'
            ])
            ->leftJoin('store_pay_timing', 'store_pay_timing.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('orders', 'orders.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('service_categories', 'service_categories.iServiceid', '=', 'orders.iServiceid')
            //->where('orders.eRestaurantPaymentStatus', 'Unsettled')
            ->where('eRestaurantPayByAdmin','No')
            ->where('orders.iStatusCode', '6')
            ->where(function ($query) {
                $query->where('orders.iStatusCode', '6')
                      ->orWhere('orders.fRestaurantPayAmount', '>', 0);
            })
            ->where('orders.eBuyAnyService', 'No')
             ->where('company.iCompanyId', $id);
            
            if($startDate>0 && $endDate>0){
                $paiement_resto_details->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            }else{}
           
            $paiement_resto_details=$paiement_resto_details->get();
        
            if($endDate>0){
              $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
            }
            
            return view('layouts.comptabilite.liste_paiement_resto_detail', compact('paiement_resto_details','companies','startDate','endDate','id'));
    }
    
    public function upStoreDetailPaymentStatus(Request $request){
        
        $today = Carbon::now();
        $currentdate = $today->format('Y-m-d H:i'); // Format YYYY-MM-DD HH:MM
     
        //var_dump($request);
        
        // Récupérer les données du formulaire
        $iCompanyId = $request->input('iCompanyId');
        $resto = $request->input('resto');
        $startDate = $request->input('dated');
        $endDate = $request->input('datef');
       // $montant = $request->input('montant');
       
       dd($iCompanyId.' '.$resto.' '.$startDate);
       var_dump($iCompanyId.' '.$resto.' '.$startDate);
       
        
    // Début de la transaction
    
        /*DB::beginTransaction();
        
        try {
            // Vérifier si les dates sont valides
            if ($startDate > 0 && $endDate > 0) {
               
                $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
                
                // Mettre à jour les commandes dans la plage de dates spécifiée
              
                DB::connection('mysql2')->table('orders')
                    ->where('iCompanyId', $iCompanyId)
                    ->whereBetween('dDate', [$startDate, $endDate])
                    ->update(['eRestaurantPayByAdmin' => 'Yes','eRestaurantPaymentStatus'=>'Settled']);
            } else {
                // Si les dates ne sont pas spécifiées, mettre à jour toutes les commandes du pilote
              
                DB::connection('mysql2')->table('orders')
                    ->where('iCompanyId', $iCompanyId)
                    ->update(['eRestaurantPayByAdmin' => 'Yes','eRestaurantPaymentStatus'=>'Settled']);
            }
            
            // Commit de la transaction
            
            DB::commit();
            
        } catch (\Exception $e) {
        
            // En cas d'erreur, annuler la transaction
            
            DB::rollback();
            // Gérer l'exception
        }*/

        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    
    public function liste_store_gain(Request $request)
    {
        $startDate = '';
        $endDate = '';

        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
      
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        
        $sgains = DB::connection('mysql2')->table('company')
            ->select([
                'company.iCompanyId',
                'orders.eRestaurantPaymentStatus',
                //'company.iMoney as money',
                //'company.iMoneyResponsable as moneyResp',
                DB::raw("service_categories.vServiceName_FR as vServiceName"),
                'company.vCompany','company.vPhone as vPhone',
                DB::raw('ROUND(SUM(orders.fTotalGenerateFare),0) as totalFare'),
                DB::raw('ROUND(SUM(orders.fCommision),0) as totalCommision'),
                DB::raw('ROUND(SUM(orders.fDeliveryCharge),0) as totalDeliveryCharge'),
                DB::raw('ROUND(SUM(orders.fDeliveryCharge),0) as totalDeliveryCharge'),
                DB::raw('ROUND(SUM(trips.fDeliveryCharge),0) as totalDeliveryChargeTrips'),
                DB::raw('SUM(orders.fOffersDiscount) as totalOffersDiscount'),
                DB::raw('SUM(orders.fOutStandingAmount) as totalOutStandingAmount'),
            ])
            /*->leftJoin('store_pay_timing', 'store_pay_timing.iCompanyId', '=', 'company.iCompanyId')*/
            ->leftJoin('orders', 'orders.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('service_categories', 'service_categories.iServiceid', '=', 'orders.iServiceid')
            ->leftJoin('register_driver', 'register_driver.iDriverId', '=', 'orders.iDriverId')
            ->leftJoin('trips', 'trips.iOrderId', '=', 'orders.iOrderId')
            //->where('orders.eRestaurantPaymentStatus', 'Unsettled')
            ->where('orders.iStatusCode', '6')
            ->where(function ($query) {
                $query->where('orders.iStatusCode', '6')
                      ->orWhere('orders.fRestaurantPayAmount', '>', 0);
            })
            ->where('orders.eBuyAnyService', 'No');
            if($startDate>0 && $endDate>0){
                $sgains->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            }else{
               
            }
           
            
            $sgains->groupBy('company.iCompanyId', 'orders.eRestaurantPaymentStatus', 'vServiceName', 'company.vCompany');
            
            $sgains=$sgains->get();
           
            if($endDate>0){
              $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
            }
            
            return view('layouts.comptabilite.liste_store_gain', compact('sgains','startDate','endDate'));
    }
    
    public function liste_historique_paiement(Request $request)
    {
        $startDate = '';
        $endDate = '';

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        $option2=$request->input('option2');

        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        /***/
         $pay_historiques = DB::connection('mysql2')->table('company')
            ->select([
                'company.iCompanyId',
                'orders.eRestaurantPaymentStatus',
                DB::raw("service_categories.vServiceName_FR as vServiceName"),
                'company.vCompany','company.vPhone as vPhone',
                DB::raw('SUM(orders.fTotalGenerateFare) as totalFare'),
                DB::raw('SUM(orders.fSubTotal) as subTotal'),
                DB::raw('SUM(orders.fCommision) as totalCommision'),
                DB::raw('SUM(orders.fDeliveryCharge) as totalDeliveryCharge'),
                DB::raw('SUM(orders.fOffersDiscount) as totalOffersDiscount'),
                DB::raw('SUM(orders.fOutStandingAmount) as totalOutStandingAmount'),
            ])
            ->leftJoin('store_pay_timing', 'store_pay_timing.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('orders', 'orders.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('service_categories', 'service_categories.iServiceid', '=', 'orders.iServiceid')
            ->where('orders.eRestaurantPaymentStatus', 'Settled')
            ->where('orders.iStatusCode', '6')
            ->where(function ($query) {
                $query->where('orders.iStatusCode', '6')
                      ->orWhere('orders.fRestaurantPayAmount', '>', 0);
            })
            ->where('orders.eBuyAnyService', 'No');
            if($startDate>0 && $endDate>0){
                $pay_historiques->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            }else{
               
            }
            //->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            
            if($option2 !='All') {
               $pay_historiques->where('store_pay_timing.iPeriode', $option2);
            }
            //->where('store_pay_timing.iPeriode', $option2)
            $pay_historiques->groupBy('company.iCompanyId', 'orders.eRestaurantPaymentStatus', 'vServiceName', 'company.vCompany');
            
            $pay_historiques=$pay_historiques->get();
        
       
        //$point_store_driver= $point_store_driver->get();
        if($endDate>0){
          $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_historique_paiement', compact('pay_historiques','startDate','endDate','option2'));
    }
    
    public function liste_historique_paiement_detail(Request $request,$id)
    {
        $startDate = '';
        $endDate = '';

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
       // $option2=$request->input('option2');

        if($endDate>0){
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        ////
         $pay_historique_details = DB::connection('mysql2')->table('company')
            ->select([
                'company.iCompanyId',
                'orders.iOrderId',
                'orders.vOrderNo',
                'orders.eRestaurantPaymentStatus',
                'service_categories.vServiceName_FR as vServiceName',
                'company.vCompany','company.vPhone as vPhone',
                'orders.fTotalGenerateFare as totalFare',
                'orders.fSubTotal as subTotal',
                'orders.fCommision as totalCommision',
                'orders.fDeliveryCharge as totalDeliveryCharge',
                'orders.fOffersDiscount as totalOffersDiscount',
                'orders.fOutStandingAmount as totalOutStandingAmount',
                'orders.tOrderRequestDate as oDate'
            ])
            ->leftJoin('store_pay_timing', 'store_pay_timing.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('orders', 'orders.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('service_categories', 'service_categories.iServiceid', '=', 'orders.iServiceid')
            ->where('orders.eRestaurantPaymentStatus', 'Settled')
            ->where('orders.iStatusCode', '6')
            ->where(function ($query) {
                $query->where('orders.iStatusCode', '6')
                      ->orWhere('orders.fRestaurantPayAmount', '>', 0);
            })
            ->where('orders.eBuyAnyService', 'No')
             ->where('company.iCompanyId', $id);
            
            if($startDate>0 && $endDate>0){
                 $pay_historique_details->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            }else{
               
            }
           
             $pay_historique_details= $pay_historique_details->get();
        
            if($endDate>0){
              $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
            }
            
            return view('layouts.comptabilite.liste_historique_paiement_detail', compact('pay_historique_details','startDate','endDate','id'));
    }
    
    /* +==================================Point store comptable==================================================+ */
    public function liste_point_store_comptable(Request $request)
    {
        $endDate = '';
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        $option2=$request->input('option2');

        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        /***/
         $pay_historiques = DB::connection('mysql2')->table('company')
            ->select([
                'company.iCompanyId',
                'orders.eRestaurantPaymentStatus',
                //DB::raw("service_categories.vServiceName_FR as vServi),
                'company.vCompany','company.vPhone as vPhone',
                DB::raw('SUM(orders.fTotalGenerateFare) as totalFare'),
                DB::raw('SUM(orders.fSubTotal) as subTotal'),
                DB::raw('SUM(orders.fCommision) as totalCommision'),
                DB::raw('SUM(orders.fDeliveryCharge) as totalDeliveryCharge'),
                DB::raw('SUM(orders.fOffersDiscount) as totalOffersDiscount'),
                DB::raw('SUM(orders.fOutStandingAmount) as totalOutStandingAmount'),
            ])
            //->leftJoin('trips as tr', 'company.iCompanyId', '=', 'tr.iCompanyId')
            ->leftJoin('store_pay_timing', 'store_pay_timing.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('orders', 'orders.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('trips as tr', 'orders.iOrderId', '=', 'tr.iOrderId')
            //->leftJoin('service_categories', 'service_categories.iServiceid', '=', 'orders.iServiceid')
            //->where('orders.eRestaurantPaymentStatus', 'Settled')
            //->where('tr.eSystem', 'DeliverAll')
            ->where('tr.iActive', 'Finished')
            ->where('orders.iStatusCode', '6')
            ->where(function ($query) {
                $query->where('orders.iStatusCode', '6')
                      ->orWhere('orders.fRestaurantPayAmount', '>', 0);
            });
            //->where('orders.eBuyAnyService', 'No');
            if($startDate>0 && $endDate>0){
                $pay_historiques->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            }else{
               
            }
            //->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            
            if($option2 !='All') {
               $pay_historiques->where('store_pay_timing.iPeriode', $option2);
            }
            //->where('store_pay_timing.iPeriode', $option2)
            $pay_historiques->groupBy('company.iCompanyId', 'orders.eRestaurantPaymentStatus', 'company.vCompany');
            
            $pay_historiques=$pay_historiques->get();
        
       
        //$point_store_driver= $point_store_driver->get();
        if($endDate>0){
          $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_point_store_comptable', compact('pay_historiques','startDate','endDate','option2'));
    }
    /*** +==============+====END======+==========+=========*/
    
    
    public function liste_pay_store(Request $request)
    {
        $startDate = '';
        $endDate = '';

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        $option2=$request->input('option2');

        if($endDate>0){
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        /***/
         $pay_stores = DB::connection('mysql2')->table('company')
            ->select([
                'company.iCompanyId',
                'orders.eRestaurantPaymentStatus',
                DB::raw("service_categories.vServiceName_FR as vServiceName"),
                'company.vCompany','company.vPhone as vPhone',
                DB::raw('SUM(orders.fTotalGenerateFare) as totalFare'),
                DB::raw('SUM(orders.fSubTotal) as subTotal'),
                DB::raw('SUM(orders.fCommision) as totalCommision'),
                DB::raw('SUM(orders.fDeliveryCharge) as totalDeliveryCharge'),
                DB::raw('SUM(orders.fOffersDiscount) as totalOffersDiscount'),
                DB::raw('SUM(orders.fOutStandingAmount) as totalOutStandingAmount'),
            ])
            ->leftJoin('store_pay_timing', 'store_pay_timing.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('orders', 'orders.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('service_categories', 'service_categories.iServiceid', '=', 'orders.iServiceid')
            ->where('orders.eRestaurantPaymentStatus', 'Unsettled')
            ->where('orders.iStatusCode', '6')
            ->where(function ($query) {
                $query->where('orders.iStatusCode', '6')
                      ->orWhere('orders.fRestaurantPayAmount', '>', 0);
            })
            ->where('orders.eBuyAnyService', 'No');
            if($startDate>0 && $endDate>0){
                $pay_stores->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            }else{
               
            }
            
            if($option2 !='All') {
               $pay_stores->where('store_pay_timing.iPeriode', $option2);
            }
            
            $pay_stores->groupBy('company.iCompanyId', 'orders.eRestaurantPaymentStatus', 'vServiceName', 'company.vCompany');
            $pay_stores=$pay_stores->get();
        
        if($endDate>0){
          $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_pay_store', compact('pay_stores','startDate','endDate','option2'));
    }
    
    public function liste_pay_store_detail(Request $request,$id)
    {
        $startDate = '';
        $endDate = '';

        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        if($endDate>0){
          $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        $pay_store_details = DB::connection('mysql2')->table('company')
            ->select([
                'company.iCompanyId',
                'company.fCommission as commissionR',
                'company.vCommissionPercentage as commissionP',
                'orders.iOrderId',
                'orders.vOrderNo',
                'orders.eRestaurantPaymentStatus',
                'service_categories.vServiceName_FR as vServiceName',
                'company.vCompany','company.vPhone as vPhone',
                'orders.fTotalGenerateFare as totalFare',
                'orders.fSubTotal as subTotal',
                'orders.fCommision as totalCommision',
                'orders.fDeliveryCharge as totalDeliveryCharge',
                'orders.fOffersDiscount as totalOffersDiscount',
                'orders.fOutStandingAmount as totalOutStandingAmount',
                'orders.tOrderRequestDate as oDate'
            ])
            ->leftJoin('store_pay_timing', 'store_pay_timing.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('orders', 'orders.iCompanyId', '=', 'company.iCompanyId')
            ->leftJoin('service_categories', 'service_categories.iServiceid', '=', 'orders.iServiceid')
            ->where('orders.eRestaurantPaymentStatus', 'Unsettled')
            ->where('orders.iStatusCode', '6')
            ->where(function ($query) {
                $query->where('orders.iStatusCode', '6')
                      ->orWhere('orders.fRestaurantPayAmount', '>', 0);
            })
            ->where('orders.eBuyAnyService', 'No')
             ->where('company.iCompanyId', $id);
            
            if($startDate>0 && $endDate>0){
                $pay_store_details->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
            }else{
               
            }
           
            $pay_store_details=$pay_store_details->get();
        
            if($endDate>0){
              $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
            }
            
            return view('layouts.comptabilite.liste_pay_store_detail', compact('pay_store_details','startDate','endDate','id'));
    }
    
    
    public function update_store_commission(Request $request, $id){
        
           $company = $request->input('iCompanyId');
            $commission = $request->input('commission');
            $subtotal = $request->input('subtotal');
            
        
            $data = [
                //'iCompanyId' => $company,
                'fCommission' => $commission,
                //'subtotal' =>$subtotal,
                'iServiceId'=>11,
            ];
            $date1 = [
                'iServiceId'=>11,
                ];

        DB::connection('mysql2')->table('orders')->where('iOrderId', $id)->update($data);
        
         DB::connection('mysql2')->table('trips')->where('iOrderId', $id)->update($data1);
        
        
         // Redirect to HomeController@index
        //return view('layouts.comptabilite.liste_pay_store_detail');
        //return redirect()->action([Comptabilite::class, //'liste_pay_store_detail']);
        
         return redirect()->action([Comptabilite::class, 'liste_pay_store']);
            
            
    }
    
    /* +==========================paie livreur===================================+ */
    public function liste_pay_livreur(Request $request)
    {
        $startDate='';
        $endDate = '';
           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
    
        $sqls='';
        $option2 = $request->input('option2');

        if(($option2 == 'Externe' && $startDate>0 && $endDate>0) || ($option2 == 'Externe' && $startDate=='' && $endDate=='')){
            $sqls="rd.vName LIKE 'LEX%' OR rd.vLastName LIKE 'LEX%'";
        }

        if(($option2 == 'Interne' && $startDate>0 && $endDate>0) || ($option2 == 'Interne' && $startDate=='' && $endDate=='')){
            $sqls="rd.vName LIKE 'L-%' OR rd.vLastName LIKE 'L-%'";
        }
        
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        //
        $pay_deliveries = DB::connection('mysql2')
            ->table('register_driver as rd')
            ->leftJoin('trips as tr', 'rd.iDriverId', '=', 'tr.iDriverId')
            ->leftJoin('orders as o', 'tr.iOrderId', '=', 'o.iOrderId')
            ->select(
                'rd.iDriverId',
                'rd.vPhone',
                'tr.eDriverPaymentStatus',
                DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) AS dname"),
                DB::raw("SUM(o.fTotalGenerateFare) AS totalAmount"),
                 DB::raw("SUM(o.fDeliveryCharge) AS totalDeliverie"),
                DB::raw("SUM(tr.fDeliveryCharge) AS totalPaie"),
                DB::raw("SUM(o.fTipAmount) AS totaltip")
            )
            ->where('tr.eDriverPaymentStatus', 'Unsettelled')
            ->where('tr.eSystem', 'DeliverAll')
            ->where('tr.iActive', 'Finished')
            ->where('o.iStatusCode', 6);
            if($startDate>0 && $endDate>0){
                $pay_deliveries->whereBetween('tr.tTripRequestDate', [$startDate, $endDate]);
            }else{}
            
            if (!empty($sqls)) {
               $pay_deliveries->whereRaw($sqls);
            }
            $pay_deliveries->groupBy('rd.iDriverId', 'tr.eDriverPaymentStatus', 'dname');
            $pay_deliveries=$pay_deliveries->get();
        
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_pay_livreur', compact('pay_deliveries','startDate','endDate','option2'));
    }
    public function liste_pay_livreur_detail(Request $request, $id)
    {
        $startDate='';
        $endDate = '';
           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        //
        $pay_deliverie_details = DB::connection('mysql2')
            ->table('register_driver as rd')
            ->leftJoin('trips as tr', 'rd.iDriverId', '=', 'tr.iDriverId')
            ->leftJoin('orders as o', 'tr.iOrderId', '=', 'o.iOrderId')
            ->select(
                'rd.iDriverId',
                'rd.vPhone',
                'tr.eDriverPaymentStatus',
                DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) AS dname"),
                'o.fTotalGenerateFare AS totalAmount',
                'o.fDeliveryCharge AS totalDeliverie',
                'tr.fDeliveryCharge AS totalPaie',
                'o.fTipAmount AS totaltip',
                'o.vOrderNo',
                'tr.tTripRequestDate as tDate'
            )
            ->where('tr.eDriverPaymentStatus', 'Unsettelled')
            ->where('tr.eSystem', 'DeliverAll')
            ->where('tr.iActive', 'Finished')
            ->where('o.iStatusCode', 6)
            ->where('rd.iDriverId', $id);
            if($startDate>0 && $endDate>0){
                $pay_deliverie_details->whereBetween('tr.tTripRequestDate', [$startDate, $endDate]);
            }else{
               
            }
           
            $pay_deliverie_details=$pay_deliverie_details->get();
        
            if($endDate>0){
                $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
            }
        
        return view('layouts.comptabilite.liste_pay_livreur_detail', compact('pay_deliverie_details','startDate','endDate','id'));
    }
    /* +===========================Point pay livreur ============================+ */
    
    
    public function calculateDriverBalance($iDriverId)
    {
        $walletData = DB::table('user_wallet')
            ->select('eType', DB::raw('SUM(iBalance) as totBalance'))
            ->where('iUserId', $iDriverId)
            ->where('eUserType', 'Driver')
                //->where('dDate','<' , $sdate)
            ->groupBy('eType')
            ->get();
    
            $debitBalance = $creditBalance = 0;
            foreach ($walletData as $data) {
                if ($data->eType == 'Credit') {
                    $creditBalance += $data->totBalance;
                } elseif ($data->eType == 'Debit') {
                    $debitBalance += $data->totBalance;
                }
            }
    
            $balance = $creditBalance - $debitBalance;
           $roundedBalance = round($balance, 0); // Arrondir le solde à 2 décimales
    
        return $roundedBalance;
    }
    
    public function list_colis_by_livreur($iDriverId, $start, $end) {
        
        if($end>0){
            $end = date('Y-m-d', strtotime($end . ' + 1 day'));
        }
        
        $resultats = DB::connection('mysql2')->table('trips')
            ->where('iDriverId', $iDriverId)
            ->where('iActive', 'Finished')
            ->where('eSystem', 'General')
            ->where('eCancelled', 'No')
            ->whereIn('eType', ['Deliver', 'Multi-Delivery'])
            ->where('eDriverPointWithAdmin', 'No');
    
        if ($start > 0 && $end > 0) {
            $resultats->whereBetween('tTripRequestDate', [$start, $end]);
        }
    
        $resultats = $resultats->select(DB::raw('count(*) as nbliv, SUM(iFare) as m_col'))
            ->groupBy('iDriverId')
            ->get();
    
        //return $resultats;
        
        /* +==================================+*/
        
         $walletData = DB::table('user_wallet')
            ->select('eType', DB::raw('SUM(iBalance) as totBalance'))
            ->where('iUserId', $iDriverId)
            ->where('eUserType', 'Driver')
                //->where('dDate','<' , $sdate)
            ->groupBy('eType')
            ->get();
    
            $debitBalance = $creditBalance = 0;
            foreach ($walletData as $data) {
                if ($data->eType == 'Credit') {
                    $creditBalance += $data->totBalance;
                } elseif ($data->eType == 'Debit') {
                    $debitBalance += $data->totBalance;
                }
            }
    
            $balance = $creditBalance - $debitBalance;
           $roundedBalance = round($balance, 0); 
          
        /* +=======================================+ */
        
        return ['resultat' =>$resultats, 'balance' => $roundedBalance];

    }
    public function list_recharge_by_livreur($iDriverId, $start, $end) {
        
        /* +==================================+*/
        
        if($end>0){
            $end = date('Y-m-d', strtotime($end . ' + 1 day'));
        }
        
         $walletData = DB::table('user_wallet')
            ->select('eType', DB::raw('SUM(iBalance) as totBalance'))
            ->where('iUserId', $iDriverId)
            ->where('eUserType', 'Driver')
            ->where('eType', 'Credit')
            ->where('eFor', 'Deposit')
            //->where('tDescription','Unsettelled')
            ->where('ePaymentStatus','Unsettelled')
            ->where('iDriverCreditPoint', 'No');
            
            if ($start > 0 && $end > 0) {
                $walletData->whereBetween('dDate', [$start, $end]);
            }
    
         $walletData = $walletData->select(DB::raw('SUM(iBalance) as mCredit'))
           ->get();
           
           foreach ($walletData as $data) {
                $creditBalance = $data->mCredit;
            }
    
         $roundedBalance = round($creditBalance, 0); 
           
        /* +=======================================+ */
        
        return ['credit' => $roundedBalance];

    }
    /* +===================================================================+ */
   
    public function liste_point_pay_livreur(Request $request)
    {
        //$startDate='';
        //$endDate = '';
        
         // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));
           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
    
        $sqls='';
        $option2 = $request->input('option2');

        if(($option2 == 'Externe' && $startDate>0 && $endDate>0) || ($option2 == 'Externe' && $startDate=='' && $endDate=='')){
            $sqls="rd.vName LIKE 'LEX%' OR rd.vLastName LIKE 'LEX%'";
        }

        if(($option2 == 'Interne' && $startDate>0 && $endDate>0) || ($option2 == 'Interne' && $startDate=='' && $endDate=='')){
            $sqls="rd.vName LIKE 'L-%' OR rd.vLastName LIKE 'L-%'";
        }
        
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        $point_deliveries = DB::connection('mysql2')
            ->table('register_driver as rd')
            ->leftJoin('trips as tr', 'rd.iDriverId', '=', 'tr.iDriverId')
            ->leftJoin('orders as o', 'tr.iOrderId', '=', 'o.iOrderId')
            ->select(
                'rd.iDriverId',
                'rd.vPhone',
                DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) AS dname"),
                DB::raw("SUM(o.fNetTotal) AS totalCash"),
                DB::raw("COUNT(o.iOrderId) AS nbCommande")
            )
            ->where('o.eDriverPointWithAdmin', 'No')
            ->where('tr.eSystem', 'DeliverAll')
            ->where('tr.iActive', 'Finished')
            ->where('o.iStatusCode', 6);
            if($startDate>0 && $endDate>0){
                 $point_deliveries->whereBetween('tr.tTripRequestDate', [$startDate, $endDate]);
            }else{}
            
            if (!empty($sqls)) {
                $point_deliveries->whereRaw($sqls);
            }
            $point_deliveries->groupBy('rd.iDriverId','dname');
            $point_deliveries=$point_deliveries->get();
            
            
            /*$point_deliveries = DB::connection('mysql2')
                        ->table('register_driver as rd')
                        ->leftJoin('trips as tr', 'rd.iDriverId', '=', 'tr.iDriverId')
                        ->select(
                            'rd.iDriverId',
                            'rd.vPhone',
                            DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) AS dname"),
                            DB::raw("SUM(CASE WHEN tr.eSystem = 'DeliverAll' THEN tr.fTripGenerateFare ELSE 0 END) AS totalCash"),
                            DB::raw("COUNT(CASE WHEN tr.eSystem = 'DeliverAll' THEN tr.iTripId ELSE 0 END) AS nbCommande"),
                            DB::raw("SUM(CASE WHEN tr.eSystem = 'General' AND tr.eCancelled = 'No' AND tr.eType IN ('Deliver', 'Multi-Delivery') THEN tr.iFare ELSE 0 END) AS m_col"),
                            DB::raw("COUNT(CASE WHEN tr.eSystem = 'General' AND tr.eCancelled = 'No' AND tr.eType IN ('Deliver', 'Multi-Delivery') THEN tr.iTripId  ELSE 0 END) AS nbliv")
                        )
                        ->where('tr.eDriverPointWithAdmin', 'No')
                        ->where('tr.iActive', 'Finished')
                        ->groupBy('rd.iDriverId', 'dname');
                    if($startDate > 0 && $endDate > 0){
                        $point_deliveries->whereBetween('tr.tTripRequestDate', [$startDate, $endDate]);
                    }
                    
                    if (!empty($sqls)) {
                        $point_deliveries->whereRaw($sqls);
                    }
                $point_deliveries = $point_deliveries->get();
            */
            
            
        /* +==========Add colis option if command is zero==========+ */
            
           /*$point_colis = DB::connection('mysql2')
            ->table('register_driver as rd')
            ->leftJoin('trips as tr', 'rd.iDriverId', '=', 'tr.iDriverId')
            //->leftJoin('orders as o', 'tr.iOrderId', '=', 'o.iOrderId')
            ->select(
                'rd.iDriverId',
                'rd.vPhone',
                //'tr.eDriverPaymentStatus',
                DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) AS dname")
                //DB::raw("SUM(o.fNetTotal) AS totalCash"),
                //DB::raw("COUNT(o.iOrderId) AS nbCommande")
            )
            ->where('tr.iActive', 'Finished')
            ->where('tr.eSystem', 'General')
            ->where('eCancelled', 'No')
            ->whereIn('tr.eType', ['Deliver', 'Multi-Delivery'])
            ->where('tr.eDriverPointWithAdmin', 'No');
            
            
            if($startDate>0 && $endDate>0){
                 $point_colis->whereBetween('tr.tTripRequestDate', [$startDate, $endDate]);
            }else{}
            
            if (!empty($sqls)) {
                $point_colis->whereRaw($sqls);
            }
            $point_colis->groupBy('rd.iDriverId','dname');
            $point_colis=$point_colis->get();*/
      
            
            
            
        //$point_store_driver= $point_store_driver->get();
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_point_pay_livreur', compact('point_deliveries','startDate','endDate','option2'));
    }
    
    public function updateStatusLivreurPoint(Request $request){
        
        $today = Carbon::now();
        $currentdate = $today->format('Y-m-d H:i'); // Format YYYY-MM-DD HH:MM
     
        // Récupérer les données du formulaire
        $iDriverId = $request->input('iDriverId');
        $livreur = $request->input('livreur');
        $startDate = $request->input('dated');
        $endDate = $request->input('datef');
        $balance = $request->input('balance');
        
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }
        
       //var_dump($balance);
        
        if($balance < 0){
            
           $tDescript='#LBL_AMOUNT_DEBIT#';
           $eFor='Withdrawl';
           $eType='Debit';
           $balance=-$balance;
        }else{
            $tDescript='#LBL_AMOUNT_CREDIT_BY_ADMIN#';
            $eFor='Deposit';
            $eType='Credit';
        }
        
        //var_dump($balance);
      
       
    
        // Début de la transaction
        DB::beginTransaction();
        
        try {
            // Vérifier si les dates sont valides
            if ($startDate > 0 && $endDate > 0) {
                $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
                
                // Mettre à jour les commandes dans la plage de dates spécifiée
                DB::connection('mysql2')->table('orders')
                    ->where('iDriverId', $iDriverId)
                    ->whereBetween('dDate', [$startDate, $endDate])
                    ->update(['eDriverPointWithAdmin' => 'Yes']);
        
                // Mettre à jour les voyages dans la plage de dates spécifiée
               DB::connection('mysql2')->table('trips')
                    ->where('iDriverId', $iDriverId)
                    ->whereBetween('tEndDate', [$startDate, $endDate])
                    ->update(['eDriverPointWithAdmin' => 'Yes']);
                    
                DB::connection('mysql2')->table('user_wallet')
                    ->where('iDriverId', $iDriverId)
                    ->where('eUserType', 'Driver')
                    ->where('eType', 'Credit')
                    ->where('eFor', 'Deposit')
                    ->whereBetween('dDate', [$startDate, $endDate])
                    ->update(['iDriverCreditPoint' => 'Yes']);
                    
                    
            } else {
                // Si les dates ne sont pas spécifiées, mettre à jour toutes les commandes du pilote
                DB::connection('mysql2')->table('orders')
                    ->where('iDriverId', $iDriverId)
                    ->update(['eDriverPointWithAdmin' => 'Yes']);
                    
                // Si les dates ne sont pas spécifiées, mettre à jour tous les voyages du pilote
                 DB::connection('mysql2')->table('trips')
                    ->where('iDriverId', $iDriverId)
                    ->update(['eDriverPointWithAdmin' => 'Yes']);
                    
                 DB::connection('mysql2')->table('user_wallet')
                    ->where('iDriverId', $iDriverId)
                    ->where('eUserType', 'Driver')
                    ->where('eType', 'Credit')
                    ->where('eFor', 'Deposit')
                    //->whereBetween('dDate', [$startDate, $endDate])
                    ->update(['iDriverCreditPoint' => 'Yes']);
                            
            }
        
            // Commit de la transaction
            DB::commit();
        } catch (\Exception $e) {
            // En cas d'erreur, annuler la transaction
            DB::rollback();
            // Gérer l'exception
        }

        DB::connection('mysql2')->table('user_wallet')->insert([
            'iUserId' => $iDriverId,
            'vName' => '',
            'vLastName' => '',
            'vPhone' => '',
            'eUserType' => 'Driver',
            'iBalance' => $balance,
            'eType' => $eType,
            'iTripId'=>0,
            'eFor'=>$eFor,
            'tDescription' => $tDescript,//#LBL_AMOUNT_CREDIT_BY_ADMIN#',
            'ePaymentStatus' => 'Unsettelled',
            'dDate' => $currentdate,
            'fRatio_USD' => '1.0000000',
            'fRatio_XOF' => '1.0000000',
            'iOrderId'=>0,
            'iTransactionId'=>'',
            'fromUserId'=>0,
            'fromUserType'=>'Driver',
            'fromAdminId'=>'',
            'service'=>'',
            'serviceType'=>'',
            'iBiddingPostId'=>0,
            'iRentItemPostId'=>0,
            'iTmpRentItemPostId'=>0,
            'iBookingId'=>0,
        ]);
            
        
        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    
    /* +==============================LIvreur================================================+ */
    public function liste_point_store_livreur(Request $request)
    {
         // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));
           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
    
        $sqls='';
        $option2 = $request->input('option2');

        if(($option2 == 'Externe' && $startDate>0 && $endDate>0) || ($option2 == 'Externe' && $startDate=='' && $endDate=='')){
            $sqls="rd.vName LIKE 'LEX%' OR rd.vLastName LIKE 'LEX%'";
        }

        if(($option2 == 'Interne' && $startDate>0 && $endDate>0) || ($option2 == 'Interne' && $startDate=='' && $endDate=='')){
            $sqls="rd.vName LIKE 'L-%' OR rd.vLastName LIKE 'L-%'";
        }
        
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        $point_deliveries = DB::connection('mysql2')
            ->table('register_driver as rd')
            ->leftJoin('trips as tr', 'rd.iDriverId', '=', 'tr.iDriverId')
            ->leftJoin('orders as o', 'tr.iOrderId', '=', 'o.iOrderId')
            ->select(
                'rd.iDriverId',
                'rd.vPhone',
                'rd.vName',
                'rd.vLastName',
                DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) AS dname"),
                DB::raw("ROUND(SUM(o.fNetTotal), 0) AS totalCash"),
                DB::raw("COUNT(o.iOrderId) AS nbCommande"),
                DB::raw("ROUND(SUM(o.fTotalGenerateFare), 0) AS totalAmount"),
                DB::raw("ROUND(SUM(o.fDeliveryCharge), 0) AS totalDeliverie"),
                DB::raw("ROUND(SUM(tr.fDeliveryCharge), 0) AS totalPaie")
            )
            ->where('tr.eSystem', 'DeliverAll')
            ->where('tr.iActive', 'Finished')
            ->where('o.iStatusCode', 6);
            if($startDate>0 && $endDate>0){
                 $point_deliveries->whereBetween('tr.tTripRequestDate', [$startDate, $endDate]);
            }else{}
            
            if (!empty($sqls)) {
                $point_deliveries->whereRaw($sqls);
            }
            $point_deliveries->groupBy('rd.iDriverId','dname');
            $point_deliveries=$point_deliveries->get();
            
        //$point_store_driver= $point_store_driver->get();
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_point_store_livreur', compact('point_deliveries','startDate','endDate','option2'));
    }
    
     public function liste_point_colis_livreur(Request $request)
    {
       
        $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));
           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
    
        $sqls='';
        $option2 = $request->input('option2');

        if(($option2 == 'Externe' && $startDate>0 && $endDate>0) || ($option2 == 'Externe' && $startDate=='' && $endDate=='')){
            $sqls="rd.vName LIKE 'LEX%' OR rd.vLastName LIKE 'LEX%'";
        }

        if(($option2 == 'Interne' && $startDate>0 && $endDate>0) || ($option2 == 'Interne' && $startDate=='' && $endDate=='')){
            $sqls="rd.vName LIKE 'L-%' OR rd.vLastName LIKE 'L-%'";
        }
        
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

           $point_colis = DB::connection('mysql2')
            ->table('register_driver as rd')
            ->leftJoin('trips as tr', 'rd.iDriverId', '=', 'tr.iDriverId')
            //->leftJoin('orders as o', 'tr.iOrderId', '=', 'o.iOrderId')
            ->select(
                'rd.iDriverId',
                'rd.vPhone',
                'rd.vName',
                'rd.vLastName',
                DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) AS dname"),
                 DB::raw("ROUND(SUM(tr.fTripGenerateFare), 0) AS totalAmount"),
                DB::raw("ROUND(SUM(tr.fCommision), 0) AS totalCommision"),
                DB::raw("COUNT(tr.iTripId) AS nbColis")
            )
            ->where('tr.iActive', 'Finished')
            ->where('tr.eSystem', 'General')
            ->where('eCancelled', 'No')
            ->whereIn('tr.eType', ['Deliver', 'Multi-Delivery']);
            //->where('tr.eDriverPointWithAdmin', 'No');
            
            
            if($startDate>0 && $endDate>0){
                 $point_colis->whereBetween('tr.tTripRequestDate', [$startDate, $endDate]);
            }else{}
            
            if (!empty($sqls)) {
                $point_colis->whereRaw($sqls);
            }
            $point_colis->groupBy('rd.iDriverId','dname');
            $point_colis=$point_colis->get();
            
            
            
            
        //$point_store_driver= $point_store_driver->get();
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_point_colis_livreur', compact('point_colis','startDate','endDate','option2'));
    }
    
    
    public function liste_point_drive(Request $request)
    {
       // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
        
        // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        $sqls='';
        $option2 = $request->input('option2');

        if($option2 == 'Externe' && $startDate>0 && $endDate>0){
            $sqls="register_driver.vName LIKE 'DEX%' OR register_driver.vLastName LIKE 'DEX%'";
        }

        if($option2 == 'Interne' && $startDate>0 && $endDate>0){
            $sqls="register_driver.vName LIKE 'D-%' OR register_driver.vLastName LIKE 'D-%'";
        }
        
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        $drivers= DB::connection('mysql2')
        ->table('trips')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=', 'vehicle_type.iVehicleTypeId')
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->select('register_driver.iDriverId as DriverId','register_driver.vPhone as vPhone','register_driver.vEmail as vEmail',
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as driver"),
            DB::raw('COUNT(trips.iTripId) as TotalCourse'),
            DB::raw('ROUND(SUM(trips.fCommision),0) as CommisionCourse'),
            DB::raw('ROUND(SUM(trips.iFare),0) as FareCourse'),
            DB::raw('ROUND(SUM(trips.fTripGenerateFare),0) as MontantCourse')
        )
        ->where('trips.iActive', 'Finished')
        ->where('trips.eSystem', 'General')
        ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T','Taxi Jaune']) 
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
        ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
        
        if (!empty($sqls)) {
            $drivers->whereRaw($sqls);
        }
        
        $drivers = $drivers->groupBy('register_driver.iDriverId', 'register_driver.vName');
        $drivers=$drivers->get();//->paginate($itemsPerPage);

        //$point_store_driver= $point_store_driver->get();
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_point_drive', compact('drivers','startDate','endDate','option2'));
    }
    
    public function liste_point_drive_orga(Request $request)
    {
       // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
        // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if($request->has('startDate') && $request->has('endDate')){
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        $organizations= DB::connection('mysql2')
        ->table('trips')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=', 'vehicle_type.iVehicleTypeId')
        ->join('organization', 'trips.iOrganizationId', '=', 'organization.iOrganizationId')
        ->select('organization.iOrganizationId as organizationId','organization.vCompany as vCompany','organization.vPhone as vPhone','organization.vEmail as vEmail',
            DB::raw('COUNT(trips.iTripId) as TotalCourse'),
            DB::raw('ROUND(SUM(trips.fCommision),0) as CommisionCourse'),
            DB::raw('ROUND(SUM(trips.iFare),0) as FareCourse'),
            DB::raw('ROUND(SUM(trips.fTripGenerateFare),0) as MontantCourse'),
            DB::raw('ROUND(SUM(trips.fTva),0) as MontantTva')
        )
        ->where('trips.iActive', 'Finished')
        ->where('trips.eSystem', 'General')
        ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T','Taxi Jaune']) 
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
        ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
        $organizations = $organizations->groupBy('organization.iOrganizationId', 'organization.vCompany');
        $organizations=$organizations->get();

        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_point_drive_orga', compact('organizations','startDate','endDate'));
    }
    
    public function liste_point_drive_orga_detail(Request $request, $id)
    {
       // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
        // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if($request->has('startDate') && $request->has('endDate')){
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        
        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        }

        $organizations= DB::connection('mysql2')
        ->table('trips')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=', 'vehicle_type.iVehicleTypeId')
        ->join('organization', 'trips.iOrganizationId', '=', 'organization.iOrganizationId')
        ->join('register_user', 'trips.iUserId', '=', 'register_user.iUserId')
        ->select('organization.iOrganizationId as organizationId','organization.vCompany as vCompany','organization.vPhone as vPhone','organization.vEmail as vEmail',
           DB::raw("CONCAT(register_user.vName, ' ', register_user.vLastName) as user"),
            'trips.fCommision as CommisionCourse',
            'trips.iFare as FareCourse',
            'trips.fTripGenerateFare as MontantCourse',
            'trips.fTva as MontantTva',
            'trips.vRideNo as rideNo'
        )
        ->where('trips.iActive', 'Finished')
        ->where('trips.eSystem', 'General')
        ->where('organization.iOrganizationId', $id)
        ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T','Taxi Jaune']) 
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
        ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
        ->get();

        if($endDate>0){
            $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }
        
        return view('layouts.comptabilite.liste_point_drive_orga_detail', compact('organizations','startDate','endDate'));
    }
    /* +=====================Configuration periode pay resto========================+ */
    
    public function liste_store_planning(Request $request)
    {
        
        //Select option
       $companies = DB::connection('mysql2')
        ->table('company')
        ->select('*')
        ->where('eSystem', '=', 'DeliverAll')
        ->where('eStatus', '=', 'Active')
        ->get();

       // Nombre d'éléments à afficher par page
       $itemsPerPage = 6;

       $storeplans = DB::connection('mysql2')
            ->table('store_pay_timing')
            ->join('company', 'store_pay_timing.iCompanyId', '=', 'company.iCompanyId')
            ->select(
                'store_pay_timing.iStoreTimingId',
                'store_pay_timing.iPeriode',
                'store_pay_timing.iCommission',
                'store_pay_timing.iMoney',
                'store_pay_timing.iMoneyResponsable',
                 'store_pay_timing.iStatus',
                'store_pay_timing.iPeriode as vPeriode',
                'store_pay_timing.iCommission as vCommission',
                 'store_pay_timing.iMoney as vMoney',
                  'store_pay_timing.iMoneyResponsable as vMoneyResp',
                 'store_pay_timing.iStatus as vStatus',
                 'company.iCompanyId',
                'company.vCompany as vCompanyName',
                'company.vPhone as vPhone',
                'company.tRegistrationDate as tDate',
                 'company.eStatus as eStatus'
            )
            ->get();
            

        return view('layouts.comptabilite.liste_store_pay_planning', compact('storeplans','companies'));
    }
    
    public function getLoadCompanyCommission($id){
         $companies = DB::connection('mysql2')
        ->table('company')
        ->select('fCommission','vCommissionPercentage')
        ->where('eSystem', '=', 'DeliverAll')
        ->where('eStatus', '=', 'Active')
        ->where('iCompanyId', $id)
        ->get();
        
        
        return response()->json($companies);

    }
    
    public function save_store_planning(Request $request){
        
            $company = $request->input('iCompanyId');
            $periode = $request->input('iPeriode');
            $commission = $request->input('iCommission');
            $money = $request->input('iMoney');
            $moneyresp = $request->input('iMoneyResponsable');
        
            $data = [
                'iCompanyId' => $company,
                'iPeriode' => $periode,
                'iCommission' => $commission,
                'iMoney' => $money,
                 'iMoneyResponsable' => $moneyresp,
            ];
        
            // Utilisation de updateOrInsert
            DB::connection('mysql2')->table('store_pay_timing')->updateOrInsert(
                ['iCompanyId' => $company],
                $data
            );
            
            $companies = DB::connection('mysql2')
                ->table('company')
                ->select('fCommission', 'vCommissionPercentage')
                ->where('eSystem', '=', 'DeliverAll')
                ->where('eStatus', '=', 'Active')
                ->where('iCompanyId', $company)
                ->get();
            
            if (empty($companies[0]->fCommission) && $companies[0]->vCommissionPercentage != $commission) {
                DB::connection('mysql2')->table('company')
                    ->where('iCompanyId', $company)
                    ->update([
                        'vCommissionPercentage' => $commission,
                        'fCommission' => $commission,
                        'iMoney' => $money,
                        'iMoneyResponsable' => $moneyresp,
                    ]);
            }else{

                 DB::connection('mysql2')->table('company')
                 ->where('iCompanyId', $company)
                 ->update([
                     'iMoney'=>$money,
                     'iMoneyResponsable' => $moneyresp,
                 ]);
                    
            }

        
         // Redirect to HomeController@index
        return redirect()->action([Comptabilite::class, 'liste_store_planning']);
            
    }
    
    public function update_store_planning(Request $request, $id){
        
           $company = $request->input('iCompanyId');
            $periode = $request->input('iPeriode');
            $commission = $request->input('iCommission');
            $money = $request->input('iMoney');
            $moneyresp = $request->input('iMoneyResponsable');
        
            $data = [
                'iCompanyId' => $company,
                'iPeriode' => $periode,
                'iCommission' => $commission,
                'iMoney' => $money,
                 'iMoneyResponsable' => $moneyresp,
            ];

        DB::connection('mysql2')->table('store_pay_timing')->where('iStoreTimingId', $id)->update($data);
        
        
        
        $companies = DB::connection('mysql2')
                ->table('company')
                ->select('fCommission', 'vCommissionPercentage')
                ->where('eSystem', '=', 'DeliverAll')
                ->where('eStatus', '=', 'Active')
                ->where('iCompanyId', $company)
                ->get();
            
            if (empty($companies[0]->fCommission) && $companies[0]->vCommissionPercentage != $commission) {
                DB::connection('mysql2')->table('company')
                    ->where('iCompanyId', $company)
                    ->update([
                        'vCommissionPercentage' => $commission,
                        'fCommission' => $commission,
                        'iMoney' => $money,
                        'iMoneyResponsable' => $moneyresp,
                    ]);
            }else{

                 DB::connection('mysql2')->table('company')
                 ->where('iCompanyId', $company)
                 ->update([
                     'iMoney'=>$money,
                     'iMoneyResponsable' => $moneyresp,
                 ]);
                    
            }
        
         /*DB::connection('mysql2')->table('company')->where('iCompanyId', $company)->update(['iMoney'=>$money, 'iMoneyResponsable' => $moneyresp,]);*/

        
         // Redirect to HomeController@index
        return redirect()->action([Comptabilite::class, 'liste_store_planning']);
            
    }

    function formatNombreAvecEspaces($nombre) {
        // Utilise number_format avec un espace comme séparateur des milliers
        return number_format($nombre, 0, ',', ' ');
    }


    function login(){
        return view('layouts.login');
    }
}
