<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
class Logistique extends Controller
{
    
    public function index()
    {
        //return redirect()->route('dashboard-administration');
        return redirect()->route('dashboard-administration');
    }
    
    public function liste_partner_taxi(Request $request)
    {
       // Nombre d'éléments à afficher par page
       $itemsPerPage = 6;
       // utilisez les dates du mois en cours
       $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
       $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
           // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
       if ($request->has('startDate') && $request->has('endDate')) {
           $startDate = $request->input('startDate');
           $endDate = $request->input('endDate');
       }
       
        $taxis = DB::connection('mysql2')
            ->table('trips')
            ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
            ->join('company', 'company.iCompanyId', '=', 'register_driver.iCompanyId')
            ->select(
                'company.iCompanyId as vIdentifiant',
                'company.vCompany as vCompanyName',
                'company.vPhone as vPhone',
                'company.tRegistrationDate as vDate',
                DB::raw('COUNT(trips.iTripId) as nbCourse'),
                DB::raw('ROUND(SUM(trips.fTripGenerateFare), 0) as montant'),
                DB::raw('(SELECT COUNT(register_driver.iDriverId) FROM register_driver WHERE register_driver.iCompanyId = company.iCompanyId AND register_driver.eStatus = "Active") as nbvehicule')
    
            )
            ->where('trips.iActive', '=', 'Finished')
            ->where('trips.eSystem', '=', 'General')
            ->where('trips.eType', '=', 'Ride')
            ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
            ->groupBy(
                'company.iCompanyId',
                'company.vCompany',
                'company.vPhone',
                'company.tRegistrationDate'
        )
        ->get();

        return view('layouts.administration.liste_partners_taxi', compact('taxis','startDate', 'endDate'));
    }

    /* +===+**************Administration******************** +===+*/

    public function logistique()
    {
        $us = DB::connection('mysql2')->table('order_request')->count();

        // Utilisez var_dump() pour déboguer, commentez-le une fois que vous avez terminé le débogage
        //var_dump($us);

        return view('layouts.dashboard.logistique', compact('us'));
    }

    public function comptabilite()
    {
        $us = DB::connection('mysql2')->table('order_request')->count();

        // Utilisez var_dump() pour déboguer, commentez-le une fois que vous avez terminé le débogage
        //var_dump($us);

        return view('layouts.dashboard.comptabilite', compact('us'));
    }

   

    /* *************point store olog******************* */
    public function liste_point_store(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        $point_store_driver = DB::connection('mysql2')
        ->table('orders as o')
        ->leftJoin('register_user as ru', 'ru.iUserId', '=', 'o.iUserId')
        ->leftJoin('order_details as od', 'od.iOrderId', '=', 'o.iOrderId')
        ->select(
            'o.vCompany',
            'ru.iUserId as iDriverId',
            'o.vName',
            'o.vLastName',
            'ru.vPhone',
            DB::raw("SUM(od.iQty) as nombre"),
            DB::raw("SUM(o.fTotalGenerateFare) AS montant"),
            DB::raw("SUM(o.fDeliveryCharge) AS fDeliveryCharge"),
            DB::raw("SUM(o.fOffersDiscount) AS discount"),
            DB::raw("SUM(o.fWalletDebit) AS debit")
        )
        ->where('o.iCompanyId', 569)
        ->where('iStatusCode', 6)
        ->whereBetween('tOrderRequestDate', [$startDate, $endDate])
        ->groupBy('ru.iUserId','o.vCompany','o.vName',
            'o.vLastName')
        ->get();
       
        //$point_store_driver= $point_store_driver->get();

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.logistique.liste_point_store_driver', compact('point_store_driver','startDate','endDate'));
    }
    
    public function liste_point_store_detail(Request $request, $id)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        $point_store_driver_details = DB::connection('mysql2')
        ->table('orders as o')
        ->leftJoin('register_user as ru', 'ru.iUserId', '=', 'o.iUserId')
        ->leftJoin('order_details as od', 'od.iOrderId', '=', 'o.iOrderId')
        ->leftJoin('menu_items as mi', 'mi.iMenuItemId', '=', 'od.iMenuItemId')
        ->leftJoin('food_menu as fm', 'fm.iFoodMenuId', '=', 'mi.iFoodMenuId')
       
        ->select(
            'o.vCompany',
            'o.vOrderNo',
            'o.tOrderRequestDate as tDate',
            'o.vName',
            'o.vLastName',
            'ru.vPhone',
            //'o.fTotalGenerateFare as montant',
           // 'o.fDeliveryCharge',
           // 'o.fOffersDiscount',
            //'o.fOffersDiscount as discount',
            //'o.fWalletDebit as debit',
            'mi.vItemType_FR as itemtype',
            'od.fTotalPrice as totalPrice',
            'od.fTotalDiscountPrice as discountPrice',
            'od.iQty as nombre',
            'fm.vMenu_FR as menu'
        )
        ->where('o.iCompanyId', 569)
        ->where('o.iStatusCode', 6)
        ->where('o.iUserId', $id)
        ->whereBetween('o.tOrderRequestDate', [$startDate, $endDate])
        ->get();
       
        //$point_store_driver= $point_store_driver->get();

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.logistique.liste_point_store_driver_detail', compact('point_store_driver_details','startDate','endDate','id'));
    }

    /* +===========================depense drive==============================+ */
    
    public function liste_depense_drive(Request $request)
    {
        
        $sqls="register_user.vName LIKE 'D- %' OR register_user.vLastName LIKE 'D- %'";
        //Select option
        $driveurs = DB::connection('mysql2')
        ->table('register_user')
        ->select('iUserId','vPhone',DB::raw("CONCAT(vName, ' ', vLastName) as name"))
        ->where('eStatus','=','active')
        ->whereRaw($sqls)
        ->get();
        
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        $depense_driver = DB::connection('mysql2')
        ->table('driver_expense as de')
        ->leftJoin('register_user as rd', 'rd.iUserId', '=', 'de.iDriverId')
        ->select(
            'de.expenseId',
            'de.titre',
            'de.description',
            'de.montant',
            'de.date_created as date_c',
            'de.expense_date as edate',
            'de.iDriverId',
            'rd.vName',
            'rd.vLastName',
            'rd.vPhone',
            DB::raw("CONCAT(rd.vName, ' ', rd.vLastName) as driveur")
        )
        ->whereBetween('de.expense_date', [$startDate, $endDate])
        ->get();
       
        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.logistique.liste_depense_drive', compact('depense_driver','driveurs','startDate','endDate'));
    }
    
    public function saveDepense(Request $request){
        
            $date_day=Carbon::now()->format('Y-m-d');
            
            //
            $montant = $request->input('montant');
            $titre = $request->input('titre');
            $description = $request->input('description');
            $edate = $request->input('edate');
            $iDriverId = $request->input('driveur');
                // Stockage de l'image
            //$imageName = time().'.'.$request->image->extension();
            //$request->image->move(public_path('image_factures'), $imageName);
            
            //var_dump($montant);
            $data = [
                'montant' => $montant,
                'titre' => $titre,
                'description' => $description,
                'expense_date' => $edate,
                'iDriverId'=>$iDriverId,
               'files'=>'null',
            ];
            
        // var_dump($montant);
            
            DB::connection('mysql2')->table('driver_expense')->Insert(
                $data
            );
            
             DB::connection('mysql2')->table('user_wallet')->insert([
                    'iUserId' =>  $iDriverId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => 'Rider',
                    'iBalance' => $montant,
                    'eType' => 'Credit',
                    'iTripId' => 0,
                    'eFor' => 'Deposit',
                    'tDescription' => '#OLOG_DEPENSE#',
                    'ePaymentStatus' => 'Unsettelled',
                    'dDate' => $date_day,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>'',
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                        
                ]);
            
            
         // Redirect to HomeController@index
        return redirect()->action([Logistique::class, 'liste_depense_drive']);
        
    }
    
    public function updateDepense(Request $request){
         $date_day=Carbon::now()->format('Y-m-d');
            $expenseId = $request->input('expenseId');
            $montant = $request->input('montant');
            $titre = $request->input('titre');
            $description = $request->input('description');
            $edate = $request->input('edate');
            $iDriverId = $request->input('driveur');
        
            $data = [
                'expenseId' => $expenseId,
                'montant' => $montant,
                'titre' => $titre,
                'description' => $description,
                'expense_date' => $edate,
                'iDriverId'=>$iDriverId
            ];
            
        
            DB::connection('mysql2')->table('driver_expenses')->Update(
                ['expenseId' => $expenseId],
                $data
            );
            
            /*DB::connection('mysql2')->table('user_wallets')->insert([
                    'iUserId' =>  $iDriverId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => 'Rider',
                    'iBalance' => $montant,
                    'eType' => 'Credit',
                    'iTripId' => 0,
                    'eFor' => 'Deposit',
                    'tDescription' => '#LBL_AMOUNT_CREDIT_BY_ADMIN#',
                    'ePaymentStatus' => 'Unsettelled',
                    'dDate' => $date_day,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>'',
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                        
                ]);*/
            
            
            
            
         // Redirect to HomeController@index
        return redirect()->action([Logistique::class, 'liste_depense_drive']);
        
    }
    
    
    
    /* +=============================================================================================+ */
    
    
    
    public function liste_wallet_statistic(){

        return view('layouts.administration.liste_wallet_statistic');

    }

    function formatNombreAvecEspaces($nombre) {
        // Utilise number_format avec un espace comme séparateur des milliers
        return number_format($nombre, 0, ',', ' ');
    }


    function login(){
        return view('layouts.login');
    }
}
