<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
class Marketing extends Controller
{

    public function index()
    {
        //return redirect()->route('dashboard-administration');
        return redirect()->route('dashboard-administration');
    }
    

    /* +========================+Review+====================================+ */
    public function liste_review(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        $reviews = DB::table('ratings_user_driver as r')
        ->select(
            't.vRideNo as number',
            //'cr.vTitle_FR as reas',
            'r.eUserType as writeBy',
            'r.vRating1 as rating',
            'r.vMessage as comment',
            'rd.vPhone as dphone',
            'ru.vPhone as uphone',
            DB::raw('CONCAT(rd.vName, " ", rd.vLastName) as provider'),
            DB::raw('CONCAT(ru.vName, " ", ru.vLastName) as user'),
            'r.tDate as datet'
        )
        ->leftJoin('trips as t', 'r.iTripId', '=', 't.iTripId')
        //->leftJoin('cancel_reason as cr', 'cr.iCancelReasonId', '=', 't.iCancelReasonId')
        ->leftJoin('register_driver as rd', 'rd.iDriverId', '=', 't.iDriverId')
        ->leftJoin('register_user as ru', 'ru.iUserId', '=', 't.iUserId')
        ->where('ru.eStatus', '!=', 'Deleted')
        ->where('t.eSystem', 'General')
        ->where('r.vRating1', '!=', '')
        ->where('r.eStatus', '!=', 'Deleted')
        ->whereBetween('r.tDate', [$startDate, $endDate])
        ->orderBy('r.iRatingId', 'ASC')
        ->get();
        
        
        //$point_store_driver= $point_store_driver->get();

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.marketing.liste_review', compact('reviews','startDate','endDate'));
    }
    
     /* +========================+Review+====================================+ */
    public function liste_parrain(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        $parrains = DB::table('register_user as ru1')
        ->select(
            'ru2.nRegistrationDate as date',
            'ru1.vPhone as pphone',
            'ru2.vPhone as uphone',
            DB::raw('CONCAT(ru1.vName, " ", ru1.vLastName) as parrain'),
            DB::raw('CONCAT(ru2.vName, " ", ru2.vLastName) as user'),
            DB::raw("COUNT(tr.iTripId) as total_courses"),
            DB::raw("COUNT(CASE WHEN tr.eSystem = 'General' AND tr.eType NOT IN ('Deliver', 'Multi-Delivery') THEN 1 END) as total_drive"), // Courses "drive"
            DB::raw("COUNT(CASE WHEN tr.eSystem ='DeliverAll' AND tr.eType = 'Ride' THEN 1 END) as total_store"), // Courses "colis"
            DB::raw("COUNT(CASE WHEN tr.eType = 'Multi-Delivery' THEN 1 END) as total_colis")
    
            
        )
        ->leftJoin('register_user as ru2', 'ru2.iRefUserId', '=', 'ru1.iUserId')
        // ->leftJoin('trips as tr', 'tr.iUserId', '=', 'ru2.iUserId')
         ->leftJoin('trips as tr', function ($join) {
             $join->on('tr.iUserId', '=', 'ru2.iUserId')
             ->where('tr.iActive', '=', 'Finished');
             //->where('tr.eCancelled'); // Filtrer seulement les courses terminées
        })
        ->whereBetween('ru2.nRegistrationDate', [$startDate, $endDate])
        ->groupBy('ru2.nRegistrationDate', 'ru1.vPhone', 'ru2.vPhone', 'ru1.vName', 'ru1.vLastName', 'ru2.vName', 'ru2.vLastName','ru1.iUserId')
        ->orderBy('ru1.iUserId', 'ASC')
        ->get();
        
        //$point_store_driver= $point_store_driver->get();

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.marketing.liste_parrain', compact('parrains','startDate','endDate'));
    }
     /* +========================Reviews drivers cancelled============================================+ */
     /* +========================+Review+====================================+ */
    public function liste_canceled_driver(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));
        //$option2 = $request->input('option2');
   

        /*if ($option2 == 'externe') {
            $sqls[] = "(register_driver.vName LIKE 'DEX%' OR register_driver.vLastName LIKE 'DEX%')";
        }
    
        if ($option2 == 'interne') {
            $sqls[] = "(register_driver.vName LIKE 'D-%' OR register_driver.vLastName LIKE 'D-%')";
        }*/

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        $canceles = DB::table('trips as t')
        ->select(
            't.iTripId as iTripId',
            't.vRideNo as number',
            't.eCancelledBy as canceBy',
            't.iCancelReasonId',
            't.vCancelReason as vCancelOther',
            'cr.vTitle_FR as vReason',
            't.vCancelComment as cancelComment',
            DB::raw('CONCAT(rd.vName, " ", rd.vLastName) as provider'),
            DB::raw('CONCAT(ru.vName, " ", ru.vLastName) as user'),
            'rd.vPhone as vPhone',
            'rd.iDriverId as iDriverId',
            't.tTripRequestDate as tdate',
            't.eAmountCancelledByDriver as frais',
            //'ad.iAdminId as fromAdminId',
            DB::raw('CONCAT(ad.vFirstName, " ", ad.vLastName) as admin')
        )
        ->leftJoin('cancel_reason as cr', 'cr.iCancelReasonId', '=', 't.iCancelReasonId')
        ->leftJoin('register_driver as rd', 'rd.iDriverId', '=', 't.iDriverId')
        ->leftJoin('register_user as ru', 'ru.iUserId', '=', 't.iUserId')
        ->leftJoin('administrators as ad', 'ad.iAdminId', '=', 't.iRemFromAdminId')
        ->where('ru.eStatus', '!=', 'Deleted')
        ->where('t.eSystem', 'General')
        ->where('t.eCancelled', 'Yes')
        ->where('t.eCancelledBy', 'Driver')
        
        ->whereBetween('t.tTripRequestDate', [$startDate, $endDate]);
        /*if($option2=='' || $option2=='all'){}else{
            $canceles->where('t.eCancelledBy',$option2);
        }*/
        
        $canceles->orderBy('t.iTripId', 'ASC');
        $canceles= $canceles->get();

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.marketing.liste_canceled_driver', compact('canceles','startDate','endDate'));
    }

    /* +========================+Review+====================================+ */
    public function liste_canceled(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));
        $option2 = $request->input('option2');
   

        /*if ($option2 == 'externe') {
            $sqls[] = "(register_driver.vName LIKE 'DEX%' OR register_driver.vLastName LIKE 'DEX%')";
        }
    
        if ($option2 == 'interne') {
            $sqls[] = "(register_driver.vName LIKE 'D-%' OR register_driver.vLastName LIKE 'D-%')";
        }*/

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        $canceles = DB::table('trips as t')
        ->select(
            't.vRideNo as number',
            't.eCancelledBy as canceBy',
            't.iCancelReasonId',
            't.vCancelReason as vCancelOther',
            'cr.vTitle_FR as vReason',
            't.vCancelComment as cancelComment',
            'rd.vPhone as dphone',
            'ru.vPhone as uphone',
            DB::raw('CONCAT(rd.vName, " ", rd.vLastName) as provider'),
            DB::raw('CONCAT(ru.vName, " ", ru.vLastName) as user'),
            't.tTripRequestDate as tdate'
        )
        ->leftJoin('cancel_reason as cr', 'cr.iCancelReasonId', '=', 't.iCancelReasonId')
        ->leftJoin('register_driver as rd', 'rd.iDriverId', '=', 't.iDriverId')
        ->leftJoin('register_user as ru', 'ru.iUserId', '=', 't.iUserId')
        ->where('ru.eStatus', '!=', 'Deleted')
        ->where('t.eSystem', 'General')
        ->where('t.eCancelled', 'Yes')
       
        ->whereBetween('t.tTripRequestDate', [$startDate, $endDate]);
        if($option2=='' || $option2=='all'){}else{
            $canceles->where('t.eCancelledBy',$option2);
        }
        
        $canceles->orderBy('t.iTripId', 'ASC');
        $canceles= $canceles->get();

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.marketing.liste_canceled', compact('canceles','option2','startDate','endDate'));
    }
    
    /* +==================+ Booking From Admin +===============================+ */
    
    public function liste_booking_by_admin(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        $bookings = DB::table('trips as t')
        ->select(
            't.vRideNo as number',
            DB::raw('CONCAT(rd.vName, " ", rd.vLastName) as provider'),
            DB::raw('CONCAT(ru.vName, " ", ru.vLastName) as user'),
            'ru.vPhone as vPhone',
            't.tTripRequestDate as tdate'
        )
        //->leftJoin('register_user as ru', 'ru.iTripId', '=', 't.iTripId')
        ->leftJoin('register_driver as rd', 'rd.iDriverId', '=', 't.iDriverId')
        ->leftJoin('register_user as ru', 'ru.iUserId', '=', 't.iUserId')
        ->where('ru.eStatus', '!=', 'Deleted')
        ->where('t.eSystem', 'General')
        ->where('t.eBookingFrom','Admin')
       
        ->whereBetween('t.tTripRequestDate', [$startDate, $endDate])
        ->orderBy('t.iTripId', 'ASC')
        ->get();

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.marketing.liste_bookingbyadmin', compact('bookings','startDate','endDate'));
    }
    
    /* +===================+ Booking From Admin User Group +===================+ */
    public function user_list_by_admin_booking(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        $bookingsu = DB::table('trips as t')
        ->select(
            //'t.vRideNo as number',
            //DB::raw('CONCAT(rd.vName, " ", rd.vLastName) as provider'),
            DB::raw('CONCAT(ru.vName, " ", ru.vLastName) as user'),
            'ru.vPhone as vPhone',
            DB::raw('COUNT(t.iTripId) as totalCourse'),
            DB::raw('MAX(t.tTripRequestDate) as tdate')
        )
        ->leftJoin('register_user as ru', 'ru.iUserId', '=', 't.iUserId')
        ->where('ru.eStatus', '!=', 'Deleted')
        ->where('t.eSystem', 'General')
        ->where('t.eBookingFrom','Admin')
        ->whereBetween('t.tTripRequestDate', [$startDate, $endDate])
        ->groupBy('ru.iUserId', 'ru.vPhone')
        //->orderBy('t.iTripId', 'ASC')
        ->get();

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.marketing.liste_booking_by_admin_user', compact('bookingsu','startDate','endDate'));
    }
    
    /* +===================+ Recherche drive or Demande drive+===================+ */
    public function recherche_drive(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        $rdrives = DB::table('trips as t')
        ->select(
            //'t.vRideNo as number',
            //DB::raw('CONCAT(rd.vName, " ", rd.vLastName) as provider'),
            DB::raw('CONCAT(ru.vName, " ", ru.vLastName) as user'),
            'ru.vPhone as vPhone',
            DB::raw('COUNT(t.iTripId) as totalCourse'),
            DB::raw('MAX(t.tTripRequestDate) as tdate')
        )
        ->leftJoin('register_user as ru', 'ru.iUserId', '=', 't.iUserId')
        ->where('ru.eStatus', '!=', 'Deleted')
        ->where('t.eSystem', 'General')
        ->where('t.eBookingFrom','Admin')
        ->whereBetween('t.tTripRequestDate', [$startDate, $endDate])
        ->groupBy('ru.iUserId', 'ru.vPhone')
        //->orderBy('t.iTripId', 'ASC')
        ->get();

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.marketing.recherche_drive', compact('rdrives','startDate','endDate'));
    } 
    
    
    
    
    
    
    /* +================================+ */
    function formatNombreAvecEspaces($nombre) {
        // Utilise number_format avec un espace comme séparateur des milliers
        return number_format($nombre, 0, ',', ' ');
    }


    function login(){
        return view('layouts.login');
    }
}
