<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
class Setting extends Controller
{
    
    public function index()
    {
        return redirect()->route('dashboard-administration');
    }
    
    public function parametre_driver(Request $request)
    {
        $setting_drivers = DB::connection('mysql2')
        ->table('driver_setting as ds')
        ->select(
            'ds.iDriverSettingId',
            'ds.iRayonFixe',
            'ds.iAmountValid',
            'ds.iTripCountLimit'
        )
        ->get();
        
        $setting_driver_earns = DB::connection('mysql2')
        ->table('driver_setting_earn as dse')
        ->select(
            'dse.iDriverSettingEarnId',
            'dse.iAmountOfferFromMaxTrip',
            'dse.iTripCountMin',
            'dse.iTripCountMax',
            'dse.iStatus'
        )
        ->get();
       
        return view('layouts.setting.add_driver_parameter', compact('setting_drivers','setting_driver_earns'));
    }
    
    public function updateParametre(Request $request)
    {
           // Récupérer les données du formulaire
        $iDriverSettingId= $request->input('idriversettingid');
        $iRayonFixe = $request->input('rayonlimite');
        $iAmountValid = $request->input('montantmini');
        $iTripCountLimit = $request->input('coursemini');
        
        DB::table('driver_setting')
            ->where('iDriverSettingId', $iDriverSettingId)
            ->update([
                'iRayonFixe' => $iRayonFixe,
                'iAmountValid' => $iAmountValid,
                'iTripCountLimit' => $iTripCountLimit
            ]);
            // Réponse de succès
            return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    public function updateParametre2(Request $request)
    {
           // Récupérer les données du formulaire
        $iDriverSettingEarnId= $request->input('idriversettingearnid');
        $iTripCountMin = $request->input('courseminis');
        $iAmountOfferFromMaxTrip =$request->input('montantrecomps');
        $iTripCountMax =  $request->input('coursemaxis');
        
       // var_dump($iDriverSettingEarnId);
        
        // Mettre à jour les données dans la base de données en utilisant le Query Builder
        DB::table('driver_setting_earn')
            ->where('iDriverSettingEarnId', $iDriverSettingEarnId)
            ->update([
                'iAmountOfferFromMaxTrip' => $iAmountOfferFromMaxTrip,
                'iTripCountMin' => $iTripCountMin,
                'iTripCountMax' => $iTripCountMax
            ]);
            // Réponse de succès
            return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    
    public function addParametre2(Request $request)
    {
           // Récupérer les données du formulaire
        $iTripCountMin = $request->input('coursemin');
        $iAmountOfferFromMaxTrip =$request->input('montantrecomps');
        $iTripCountMax =  $request->input('coursemax');
        
        // Mettre à jour les données dans la base de données en utilisant le Query Builder
    
            DB::connection('mysql2')->table('driver_setting_earn')->insert([
                'iAmountOfferFromMaxTrip' => $iAmountOfferFromMaxTrip,
                'iTripCountMin' => $iTripCountMin,
                'iTripCountMax' => $iTripCountMax
            ]);
            
            // Réponse de succès
            return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    
    /*public function driver_list_checkin(Request $request){
        
        //setting param getting
         $setting_get = DB::connection('mysql2')
        ->table('driver_setting as ds')
        ->select(
            'ds.iDriverSettingId',
            'ds.iRayonFixe',
            'ds.iAmountValid',
            'ds.iTripCountLimit'
        )
        ->first();
        
        if ($setting_get) {
            $driverSettingId = $setting_get->iDriverSettingId;
            $rayonFixe = $setting_get->iRayonFixe;
            $amountValid = $setting_get->iAmountValid;
            $tripCountLimit = $setting_get->iTripCountLimit;
            // Do something with the retrieved values
        } else {
            // Handle the case where no record is found
            $amountValid = 30000;
            $tripCountLimit = 30;
        }

        
         // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;

        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

        // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $sqls='';
        $option2 = $request->input('option2');
        $option3 = $request->input('option3');

        if($option2 == 'externe' && $startDate>0 && $endDate>0){
            $sqls="register_driver.vName LIKE 'DEX%' OR register_driver.vLastName LIKE 'DEX%'";
        }

        if($option2 == 'interne' && $startDate>0 && $endDate>0){
            $sqls="register_driver.vName LIKE 'D-%' OR register_driver.vLastName LIKE 'D-%'";
        }
        
        if ($option3 == 'active') {
            $sqls .= !empty($sqls) ? " AND " : "";
            $sqls .= "register_driver.vStatusRounded LIKE 'Active'";
        }
    
        if ($option3 == 'desactive') {
            $sqls .= !empty($sqls) ? " AND " : "";
            $sqls .= "register_driver.vStatusRounded LIKE 'Deactive'";
        }
        

        $drivers2= DB::connection('mysql2')
        ->table('trips')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=', 'vehicle_type.iVehicleTypeId')
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->select('register_driver.iDriverId as DriverId','register_driver.vPhone as vPhone','register_driver.vEmail as vEmail',
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as Driver,register_driver.vStatusRounded as vStatusRounded"),
            DB::raw('COUNT(trips.iTripId) as TotalCourse'),
            DB::raw('ROUND(SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN trips.fTripGenerateFare ELSE 0 END),0) as MontantCourse')
        )
        ->where('trips.eSystem', 'General')
        ->where('trips.iActive', 'Finished')
        ->where('register_driver.eStatus', 'active')
        ->whereIn('trips.eHailTrip', ['No', 'Yes'])
        ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T','Taxi Jaune']) 
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
        ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
       
        if(!empty($sqls)) {
            $drivers2->whereRaw($sqls);
        }
       
        $drivers2 = $drivers2
            ->groupBy('register_driver.iDriverId', 'register_driver.vName')
             ->having('MontantCourse', '<', $amountValid)
            ->orHaving('TotalCourse', '<', $tripCountLimit)
            ->get();
        
        
        return view('layouts.setting.liste_driver_checkin', compact('drivers2','startDate', 'endDate','option2','option3'));
        
    }*/
    
    public function driver_list_checkin(Request $request){
    // Setting parameters getting
    $setting_get = DB::connection('mysql2')
        ->table('driver_setting as ds')
        ->select('ds.iDriverSettingId', 'ds.iRayonFixe', 'ds.iAmountValid', 'ds.iTripCountLimit')
        ->first();

    if ($setting_get) {
        $amountValid = $setting_get->iAmountValid;
        $tripCountLimit = $setting_get->iTripCountLimit;
    } else {
        $amountValid = 30000;
        $tripCountLimit = 30;
    }

    // Dates pour le mois en cours par défaut
    $startDate = "";//$request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
    $endDate = "";//$request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

    // Si le formulaire a été soumis, mettre à jour les dates avec les nouvelles valeurs
    if ($request->has('startDate') && $request->has('endDate')) {
        $startDate = $request->input('startDate');
        $endDate = $request->input('endDate');
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
    }

    $sqls = [];
    $option2 = $request->input('option2');
    $option3 = $request->input('option3');

    if ($option2 == 'externe') {
        $sqls[] = "(register_driver.vName LIKE 'DEX%' OR register_driver.vLastName LIKE 'DEX%')";
    }

    if ($option2 == 'interne') {
        $sqls[] = "(register_driver.vName LIKE 'D-%' OR register_driver.vLastName LIKE 'D-%')";
    }

    if ($option3 == 'active') {
        $sqls[] = "register_driver.vStatusRounded LIKE 'Active'";
    }

    if ($option3 == 'desactive') {
        $sqls[] = "register_driver.vStatusRounded LIKE 'Deactive'";
    }
    

    $drivers2 = DB::connection('mysql2')
        ->table('trips')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=', 'vehicle_type.iVehicleTypeId')
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->select(
            'register_driver.iDriverId as DriverId',
            'register_driver.vPhone as vPhone',
            'register_driver.vEmail as vEmail',
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as Driver"),
            'register_driver.vStatusRounded as vStatusRounded',
            DB::raw('COUNT(trips.iTripId) as TotalCourse'),
            DB::raw('ROUND(SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN trips.fTripGenerateFare ELSE 0 END),0) as MontantCourse')
        )
        ->where('trips.eSystem', 'General')
        ->where('trips.iActive', 'Finished')
        ->where('register_driver.eStatus', 'active')
        ->whereIn('trips.eHailTrip', ['No', 'Yes'])
        ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T', 'Taxi Jaune'])
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery']);
        if($request->has('startDate') && $request->has('endDate')){
            $drivers2->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
             $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }

    if (!empty($sqls)) {
        $drivers2->whereRaw(implode(' AND ', $sqls));
    }

    $drivers2 = $drivers2
        ->groupBy('register_driver.iDriverId', 'register_driver.vName')
        ->havingRaw('SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN trips.fTripGenerateFare ELSE 0 END) < ?', [$amountValid])
        ->orHavingRaw('COUNT(trips.iTripId) < ?', [$tripCountLimit])
        ->get();//paginate($itemsPerPage);

   
    return view('layouts.setting.liste_driver_checkin', compact('drivers2', 'startDate', 'endDate', 'option2', 'option3'));
}

 public function best_driver(Request $request){
    // Setting parameters getting
    $setting_gets = DB::connection('mysql2')
        ->table('driver_setting as ds')
        ->select('ds.iDriverSettingId', 'ds.iRayonFixe', 'ds.iAmountValid', 'ds.iTripCountLimit','ds.iAmountOfferFromMaxTrip','ds.iTripCountMax')
        ->first();

    if ($setting_gets) {
        $iAmountOfferFromMaxTrip = $setting_gets->iAmountOfferFromMaxTrip;
        $iTripCountMax = $setting_gets->iTripCountMax;
    } else {
        $iAmountOfferFromMaxTrip = 1000;
        $iTripCountMax = 50;
    }

    // Dates pour le mois en cours par défaut
    $startDate = "";
    $endDate = "";

    // Si le formulaire a été soumis, mettre à jour les dates avec les nouvelles valeurs
    if ($request->has('startDate') && $request->has('endDate')) {
        $startDate = $request->input('startDate');
        $endDate = $request->input('endDate');
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
    }

    $sqls = [];
    $option2 = $request->input('option2');
    //$option3 = $request->input('option3');

    if ($option2 == 'externe') {
        $sqls[] = "(register_driver.vName LIKE 'DEX%' OR register_driver.vLastName LIKE 'DEX%')";
    }

    if ($option2 == 'interne') {
        $sqls[] = "(register_driver.vName LIKE 'D-%' OR register_driver.vLastName LIKE 'D-%')";
    }

    $drivers3 = DB::connection('mysql2')
        ->table('trips')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=', 'vehicle_type.iVehicleTypeId')
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->select(
            'register_driver.iDriverId as DriverId',
            'register_driver.vPhone as vPhone',
            'register_driver.vEmail as vEmail',
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as Driver"),
            'register_driver.vStatusRounded as vStatusRounded',
            DB::raw('COUNT(trips.iTripId) as TotalCourse'),
            DB::raw('ROUND(SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN trips.fTripGenerateFare ELSE 0 END),0) as MontantCourse')
        )
        ->where('trips.eSystem', 'General')
        ->where('trips.iActive', 'Finished')
        ->where('register_driver.eStatus', 'active')
        ->whereIn('trips.eHailTrip', ['No', 'Yes'])
        ->whereNotIn('vehicle_type.vVehicleType_FR', ['Confort T', 'Eco T', 'Taxi Jaune'])
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery']);
        
        if($request->has('startDate') && $request->has('endDate')){
            $drivers3->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
             $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        }

    if (!empty($sqls)) {
        $drivers3->whereRaw(implode(' AND ', $sqls));
    }

    $drivers3 = $drivers3
        ->groupBy('register_driver.iDriverId', 'register_driver.vName')
        //->havingRaw('SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN trips.fTripGenerateFare ELSE 0 END) < ?', [$amountValid])
        ->havingRaw('COUNT(trips.iTripId) > ?', [$iTripCountMax])
        ->get();//paginate($itemsPerPage);

   
    return view('layouts.setting.liste_driver_earn', compact('drivers3', 'startDate', 'endDate', 'option2'));
}

    
    /* +================================Option activ or deactiv==================================================================+ */
    public function activate(Request $request, $id)
    {
           try {
            $register_driver = DB::connection('mysql2')->table('register_driver')->where('iDriverId', $id);
            
            if ($register_driver) {
                DB::connection('mysql2')->table('register_driver')
                    ->where('iDriverId', $id)
                    ->update([
                        'vWorkLocationRadius' => 3, 
                        'vStatusRounded' => 'Active',
                        'eSelectWorkLocation' => 'Dynamic'
                    ]);
                return response()->json(['success' => true]);
            } else {
                return response()->json(['success' => false, 'message' => 'Le conducteur n\'a pas été trouvé.'], 404);
                }
            } catch (\Exception $e) {
                return response()->json(['success' => false, 'message' => 'Une erreur est survenue lors de l\'activation du conducteur: ' . $e->getMessage()], 500);
            }
    }

    public function deactivate(Request $request, $id)
    {
               
       try {
            $register_driver = DB::connection('mysql2')->table('register_driver')->where('iDriverId', $id);
            
            if ($register_driver) {
                DB::connection('mysql2')->table('register_driver')
                    ->where('iDriverId', $id)
                    ->update([
                        'vWorkLocationRadius' => 0, 
                        'vStatusRounded' => 'Deactive',
                        'eSelectWorkLocation' => 'Fixed'
                    ]);
                return response()->json(['success' => true]);
            } else {
                return response()->json(['success' => false, 'message' => 'Le conducteur n\'a pas été trouvé.'], 404);
                }
            } catch (\Exception $e) {
                return response()->json(['success' => false, 'message' => 'Une erreur est survenue lors de l\'activation du conducteur: ' . $e->getMessage()], 500);
            }
    }
    
    /* +=======================================+param option activ or deactiv +====================================+*/
    
    public function actparam(Request $request, $id)
    {
           try {
            $driver_setting_earn = DB::connection('mysql2')->table('driver_setting_earn')->where('iDriverSettingEarnId', $id);
            
            if ($driver_setting_earn) {
                DB::connection('mysql2')->table('driver_setting_earn')
                    ->where('iDriverId', $id)
                    ->update([
                        'vStatusRounded' => 'Active'
                    ]);
                return response()->json(['success' => true]);
            } else {
                return response()->json(['success' => false, 'message' => 'Le conducteur n\'a pas été trouvé.'], 404);
                }
            } catch (\Exception $e) {
                return response()->json(['success' => false, 'message' => 'Une erreur est survenue lors de l\'activation du conducteur: ' . $e->getMessage()], 500);
            }
    }

    public function deactparam(Request $request, $id)
    {
               
       try {
            $driver_setting_earn = DB::connection('mysql2')->table('driver_setting_earn')->where('iDriverSettingEarnId', $id);
            
            if ($driver_setting_earn) {
                DB::connection('mysql2')->table('driver_setting_earn')
                    ->where('iDriverId', $id)
                    ->update([
                        'iStatus' => 'Inactive'

                    ]);
                return response()->json(['success' => true]);
            } else {
                return response()->json(['success' => false, 'message' => 'Le conducteur n\'a pas été trouvé.'], 404);
                }
            } catch (\Exception $e) {
                return response()->json(['success' => false, 'message' => 'Une erreur est survenue lors de l\'activation du conducteur: ' . $e->getMessage()], 500);
            }
    }
    
    
    /* +=================================================================================================+ */
   
    function formatNombreAvecEspaces($nombre) {
        // Utilise number_format avec un espace comme séparateur des milliers
        return number_format($nombre, 0, ',', ' ');
    }


    function login(){
        return view('layouts.login');
    }
}
