<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
class Support extends Controller
{
  

    public function index()
    {
        //return redirect()->route('dashboard-administration');
        return redirect()->route('dashboard-administration');
    }
    
    
    public function getUserOtp()
    {
        $resultats=null;
        return view('layouts.support.search_otp', compact('resultats'));
    }
    

    /* ******************************** */
    public function liste_user_otp(Request $request)
    {
        $searchTerm = $request->get('query');
       
       $resultats = DB::table('register_user')
                    ->select('*') 
                    ->where(function($query) use ($searchTerm) {
                        $query->where('vName', 'like', '%' . $searchTerm . '%')
                              ->orWhere('vLastName', 'like', '%' . $searchTerm . '%')
                              ->orWhere('vPhone', 'like', '%' . $searchTerm . '%')
                              ->orWhere('vEmail', 'like', '%' . $searchTerm . '%');
                        // Add more columns as needed
                    })
                    ->get();
                    
            return view('layouts.support.search_otp', compact('resultats','searchTerm'));
        
        //return response()->json($results);
    }
    
    public function update(Request $request)
    {
       // Récupérer les données du formulaire
    $userId = $request->input('userId');
    $name = $request->input('name');
    $lname = $request->input('lname');
    $phone = $request->input('phone');
    $email = $request->input('email');
    $phoneVerified = $request->input('phoneVerified');

    // Mettre à jour les données dans la base de données en utilisant le Query Builder
    DB::table('register_user')
        ->where('iUserId', $userId)
        ->update([
            'vName' => $name,
            'vLastName' => $lname,
            'vPhone' => $phone,
            'vEmail' => $email,
            'ePhoneVerified' => $phoneVerified,
            'iTripId' => 0,
            'vTripStatus' => 'NONE'
        ]);

    
        // Réponse de succès
        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    
    /* +========================get command =================================+ */
    public function getCommand(Request $request){
        
        
        $sqls="register_driver.vName LIKE 'L-%' OR register_driver.vName LIKE 'L %' OR register_driver.vLastName LIKE 'L-%' OR register_driver.vLastName LIKE 'L %' OR register_driver.vName LIKE 'LEX-%' OR register_driver.vName LIKE 'LEX %' OR register_driver.vLastName LIKE 'LEX-%' OR register_driver.vLastName LIKE 'LEX %' ";
            //Select option
           $livreurs = DB::connection('mysql2')
            ->table('register_driver')
            ->select('iDriverId',DB::raw("CONCAT(vName, ' ', vLastName) as name"))
            ->where('eStatus','=','active')
            ->whereRaw($sqls)
            ->get();
            
           
            $itemsPerPage = 6;
            // utilisez les dates du mois en cours
            $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

            if ($request->has('startDate') && $request->has('endDate')) {
                $startDate = $request->input('startDate');
                $endDate = $request->input('endDate');
            }
    
            $commandes = DB::connection('mysql2')
                ->table('orders')
                ->select('orders.iOrderId','orders.iDriverId', 
                'service_categories.vServiceName_FR as service', 
                'orders.vOrderNo', 'orders.dDate','orders.fPackingCharge as fPackingCharge','register_user.iUserId as clientId',
                DB::raw('CONCAT(register_user.vName, " ", register_user.vLastName) as client'),
                'orders.vCompany', 
                DB::raw('CONCAT(register_driver.vName, " ", register_driver.vLastName) as livreur'),
                    'orders.fNetTotal as montant', 'orders.fDeliveryCharge as fDelivery', 'orders.fWalletDebit as walletMontant', 'orders.fTotalGenerateFare as montantTotal', 'orders.ePaymentOption')
                ->join('register_user', 'orders.iUserId', '=', 'register_user.iUserId')
                ->join('register_driver', 'register_driver.iDriverId', '=', 'orders.iDriverId')
                ->join('service_categories', 'orders.iServiceId', '=', 'service_categories.iServiceId')
                ->where('orders.iStatusCode', '<=', 6)
                ->where('eRestaurantPaymentStatus', 'Unsettled')
                ->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate]);
           $commandes = $commandes->get();

        return view('layouts.support.list_gerer_command', compact('commandes','livreurs','startDate', 'endDate'));
    }
    
    
    public function getItems(Request $request){
        
        // Récupérer l'ID de la requête AJAX
        $id = $request->id;
        
        $itemlist = DB::connection('mysql2')
        ->table('menu_items')
        ->select('iFoodMenuId', 'vItemType_FR as item', 'iMenuItemId as itemId')
        ->whereIn('iFoodMenuId', function ($query) use ($id) {
            $query->select('food_menu.iFoodMenuId')
                ->from('food_menu')
                ->whereIn('food_menu.iCompanyId', function ($subQuery) use ($id) {
                    $subQuery->select('company.iCompanyId')
                        ->from('company')
                        ->join('orders', 'company.iCompanyId', '=', 'orders.iCompanyId')
                        ->where('orders.iOrderId', $id);
                });
        })
        ->get();
        
        // Récupérer les données en fonction de l'ID
        $items = DB::connection('mysql2')
                ->table('order_details')
                ->select('order_details.iOrderDetailId as iOrderDeId','order_details.iOrderId','order_details.iMenuItemId','order_details.iQty as qty','order_details.fPrice as price','order_details.fTotalPrice as tprice','menu_items.vItemType_FR as itema')
                ->join('menu_items', 'order_details.iMenuItemId', '=', 'menu_items.iMenuItemId')
                ->where('order_details.iOrderId', $id)
                ->get();
                
                // Retourner les données au format JSON
        return response()->json([
            'items' => $items,
            'itemlist' => $itemlist
        ]);

        // Retourner les données au format JSON
        //return response()->json($items);
    }
    
    
    public function updateCommand(Request $request){
        $today = Carbon::now();
        $currentdate = $today->format('Y-m-d H:i');
        
        // Récupérer les données du formulaire
        $orderId = $request->input('orderId');
        $vorder = $request->input('vorder');
        //$client = $request->input('client');
        $livreurId = $request->input('livreur');
        $delivery = $request->input('delivery');
        $cashpay = $request->input('cashpay');
        $walletpay = $request->input('walletpay');
        $tmontant = $request->input('tmontant');
        //$fPackingCharge=$request->input('fPackingCharge');
        $genererData = $request->input('genererData');
        
        /* +=====================trips get=========================+ */
        $chec_fdeliverage = DB::connection('mysql2')
            ->table('trips')
            ->select('iTripId','fDeliveryCharge','fWalletDebit','fTripGenerateFare')
            ->where('iOrderId',$orderId)
            ->first();
            
            if($chec_fdeliverage){
                 $fDeliveryCharge=$chec_fdeliverage->fDeliveryCharge;
                 $iTripId=$chec_fdeliverage->iTripId; 
                 $fNet=$chec_fdeliverage->fTripGenerateFare;
                 $fWalletDebi=$chec_fdeliverage->fWalletDebit;
            }
            
            //`fWalletDebit`>0 and `fNetTotal`>0 
        /* +====================orders get========================+ */    
         $order_user = DB::connection('mysql2')
            ->table('orders')
            ->select('iUserId','dDate','fWalletDebit','fNetTotal')
            ->where('iOrderId',$orderId)
            ->first(); 
            
            if($order_user) {
                $userId=$order_user->iUserId;
                $dDate=$order_user->dDate;
            }   
                                
        /* +==================Get company =============+ */
            $company = DB::connection('mysql2')
                    ->table('orders')
                    ->select('company.vCommissionPercentage as vCommission')
                    ->join('company', 'orders.icompanyId', '=', 'company.icompanyId')
                    ->where('orders.iOrderId',  $orderId)
                    ->first(); // Utilisez first() pour obtenir la première ligne uniquement
                        
                if ($company) {
                    $companyCommissionPer = $company->vCommission;
                } else {
                    $companyCommissionPer=15;
                }
        /* +==========================================+ */
        if(($tmontant<=$cashpay || $tmontant>$cashpay) && $walletpay==0){
             $cashpay=$tmontant;
             
             //if(($fNet>0 && $fWalletDebi>0) || ($fWalletDebi>0 && $fNet==0)){// Basile commenter pour voir le comportement
                 
                  DB::connection('mysql2')
                    ->table('user_wallet')
                    //->where('iTripId',$iTripId)
                    ->where('tDescription', 'like', '%'.$vorder.'%')
                    ->delete();
                 
            // }
         
            /* +=========================+ gain livreur +==============================+ */ 
                 $check_driver_earn_wallet = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('*')
                        ->where('tDescription','like', '#LBL_ADJUSTMENT_EARNING_ORDER#%'.$vorder.'%')
                        ->where('ePaymentStatus','Settelled')
                        ->where('eUserType','Driver')
                        ->where('eType','Credit')
                        ->where('eFor','Deposit')
                        ->first();
                        
                        if($check_driver_earn_wallet)  {
                            /* +==========+ update earn +=========+ */        
                             DB::connection('mysql2')
                                    ->table('user_wallet')
                                    ->where([
                                        //'iUserWalletId' => $iUserWalletId,
                                        'eFor' => 'Deposit',
                                        ['tDescription', 'LIKE', '#LBL_ADJUSTMENT_EARNING_ORDER#'.$vorder],
                                        'ePaymentStatus' => 'Settelled',
                                        'eUserType'=>'Driver',
                                        'eType'=>'Credit'
                                    ])
                                    ->update([
                                        'iUserId' => $livreurId,
                                        'iBalance' => $fDeliveryCharge
                                    ]);  
                        }else{
                            DB::connection('mysql2')->table('user_wallet')->insert([
                            'iUserId' =>$livreurId,
                            'vName' =>'',
                            'vLastName' =>'',
                            'vPhone' =>'',
                            'eUserType' => 'Driver',
                            'iBalance' => $fDeliveryCharge,
                            'eType' => 'Credit',
                            'iTripId' => $iTripId,
                            'eFor' => 'Deposit',
                            'tDescription' => '#LBL_ADJUSTMENT_EARNING_ORDER#'.$vorder.' ',
                            'ePaymentStatus' => 'Settelled',
                            'dDate' => $dDate,
                            'fRatio_USD' => 0.0017000,
                            'fRatio_XOF' => 1.0000000,
                            'iOrderId'=>0,
                            'iTransactionId'=>'',
                            'fromUserId'=>0,
                            'fromUserType'=>'Driver',
                            'fromAdminId'=>'',
                            'service'=>'',
                            'serviceType'=>'',
                            'iBiddingPostId'=>0,
                            'iRentItemPostId'=>0,
                            'iTmpRentItemPostId'=>0,
                            'iBookingId'=>0,
                            // Ajoutez d'autres colonnes avec leurs valeurs ici
                        ]);
                    }
                
                /* +=========================Driver operation=====================+ */
                
                    $check_driver_wallet = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('*')
                        ->where('tDescription','like', '#LBL_DEBITED_BOOKING_DL#%'.$vorder.'%')
                        ->where('ePaymentStatus','Settelled')
                        ->where('eUserType','Driver')
                        ->where('eType','Debit')
                        ->where('eFor','Withdrawl')
                        ->first(); 
                        
                         if($check_driver_wallet)  {
                              DB::connection('mysql2')
                                    ->table('user_wallet')
                                    ->where([
                                        //'iUserWalletId' => $iUserWalletId,
                                        'eFor' => 'Withdrawl',
                                        ['tDescription', 'LIKE', '#LBL_DEBITED_BOOKING_DL#  '.$vorder],
                                        'ePaymentStatus' => 'Settelled',
                                        'eUserType'=>'Driver',
                                        'eType'=>'Debit'
                                    ])
                                    ->update([
                                        'iUserId' => $livreurId,
                                        'iBalance' => $cashpay
                                    ]);
                         }else{
                             DB::connection('mysql2')->table('user_wallet')->insert([
                                    'iUserId' => $livreurId,
                                    'vName' =>'',
                                    'vLastName' =>'',
                                    'vPhone' =>'',
                                    'eUserType' => 'Driver',
                                    'iBalance' => $cashpay,
                                    'eType' => 'Debit',
                                    'iTripId' => $iTripId,
                                    'eFor' => 'Withdrawl',
                                    'tDescription' => '#LBL_DEBITED_BOOKING_DL#  '.$vorder.' ',
                                    'ePaymentStatus' => 'Settelled',
                                    'dDate' => $dDate,
                                    'fRatio_USD' => '0.0016000',
                                    'fRatio_XOF' => '1.0000000',
                                    'iOrderId' => $orderId,
                                    'iTransactionId'=>'',
                                    'fromUserId'=>0,
                                    'fromUserType'=>'Driver',
                                    'fromAdminId'=>'',
                                    'service'=>'',
                                    'serviceType'=>'',
                                    'iBiddingPostId'=>0,
                                    'iRentItemPostId'=>0,
                                    'iTmpRentItemPostId'=>0,
                                    'iBookingId'=>0,
                                    // Add other columns and values here
                                ]);
                         }
           
        }elseif($walletpay>0 && $cashpay>0){
            
             if(($fNet>0 && $fWalletDebi==0) || ($fWalletDebi>0 && $fNet==0)){
                 
                  DB::connection('mysql2')
                    ->table('user_wallet')
                    //->where('iTripId',$iTripId)
                    ->where('tDescription', 'like', '%'.$vorder.'%')
                    ->delete();
                 
             }
            
            
            
             $cashpay=$tmontant-$walletpay;
            
                /* +========================+ user operation +=========================+ */
                
                    $check_user_wallet = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('*')
                        ->where('tDescription','like', '#LBL_DEBITED_BOOKING_DL#%'.$vorder.'%')
                        ->where('ePaymentStatus','Unsettelled')
                        ->where('eUserType','Rider')
                        ->where('eType','Debit')
                        ->where( 'eFor','Booking')
                        ->first();
                        
                        if($check_user_wallet){
                        /* +=======+ update wallet pay +=======+ */
                            DB::connection('mysql2')
                                ->table('user_wallet')
                                ->where(['eFor' => 'Booking', ['tDescription', 'LIKE', '#LBL_DEBITED_BOOKING_DL#%'.$vorder.'%'],'ePaymentStatus' => 'Unsettelled','eUserType'=>'Rider','eType'=>'Debit'])
                                ->update([
                                    'iBalance' => $walletpay
                                ]); 
                        }else{
                             DB::connection('mysql2')->table('user_wallet')->insert([
                                'iUserId' => $userId,
                                'vName' =>'',
                                'vLastName' =>'',
                                'vPhone' =>'',
                                'eUserType' => 'Rider',
                                'iBalance' => $walletpay,
                                'eType' => 'Debit',
                                'iTripId'=>0,
                                'eFor' => 'Booking',
                                'tDescription' => '#LBL_DEBITED_BOOKING_DL# '.$vorder.' ',
                                'ePaymentStatus' => 'Unsettelled',
                                'dDate' => $dDate,
                                'fRatio_USD' => '0.0016000',
                                'fRatio_XOF' => '1.0000000',
                                'iOrderId' => $orderId,
                                'iTransactionId'=>'',
                                'fromUserId'=>0,
                                'fromUserType'=>'Driver',
                                'fromAdminId'=>'',
                                'service'=>'',
                                'serviceType'=>'',
                                'iBiddingPostId'=>0,
                                'iRentItemPostId'=>0,
                                'iTmpRentItemPostId'=>0,
                                'iBookingId'=>0,
                                       
                            ]);
                        }          
                    /* +===============+ Driver operation +===============+ */
                
                    $check_driver_wallet = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('*')
                        ->where('tDescription','like', '#LBL_DEBITED_BOOKING_DL#%'.$vorder.'%')
                        ->where('ePaymentStatus','Settelled')
                        ->where('eUserType','Driver')
                        ->where('eType','Debit')
                        ->where('eFor','Withdrawl')
                        ->first(); 
                        
                         if($check_driver_wallet)  {
                              DB::connection('mysql2')
                                    ->table('user_wallet')
                                    ->where(['eFor' => 'Withdrawl',['tDescription', 'LIKE', '#LBL_DEBITED_BOOKING_DL#  '.$vorder],'ePaymentStatus' => 'Settelled','eUserType'=>'Driver','eType'=>'Debit'])
                                    ->update([
                                        'iUserId' => $livreurId,
                                        'iBalance' => $cashpay
                                    ]);
                         }else{
                             DB::connection('mysql2')->table('user_wallet')->insert([
                                    'iUserId' => $livreurId,
                                    'vName' =>'',
                                    'vLastName' =>'',
                                    'vPhone' =>'',
                                    'eUserType' => 'Driver',
                                    'iBalance' => $cashpay,
                                    'eType' => 'Debit',
                                    'iTripId' => $iTripId,
                                    'eFor' => 'Withdrawl',
                                    'tDescription' => '#LBL_DEBITED_BOOKING_DL#  '.$vorder.' ',
                                    'ePaymentStatus' => 'Settelled',
                                    'dDate' => $dDate,
                                    'fRatio_USD' => '0.0016000',
                                    'fRatio_XOF' => '1.0000000',
                                    'iOrderId' => $orderId,
                                    'iTransactionId'=>'',
                                    'fromUserId'=>0,
                                    'fromUserType'=>'Driver',
                                    'fromAdminId'=>'',
                                    'service'=>'',
                                    'serviceType'=>'',
                                    'iBiddingPostId'=>0,
                                    'iRentItemPostId'=>0,
                                    'iTmpRentItemPostId'=>0,
                                    'iBookingId'=>0,
                                    // Add other columns and values here
                                ]);
                         }
                /* +=========================gain livreur=====================================+ */ 
                 $check_driver_earn_wallet = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('*')
                        ->where('tDescription','like', '#LBL_ADJUSTMENT_EARNING_ORDER#%'.$vorder.'%')
                        ->where('ePaymentStatus','Settelled')
                        ->where('eUserType','Driver')
                        ->where('eType','Credit')
                        ->where('eFor','Deposit')
                        ->first();
                        
                        if($check_driver_earn_wallet)  {
                            /****************update earn****************************/        
                             DB::connection('mysql2')
                                    ->table('user_wallet')
                                    ->where([
                                        //'iUserWalletId' => $iUserWalletId,
                                        'eFor' => 'Deposit',
                                        ['tDescription', 'LIKE', '#LBL_ADJUSTMENT_EARNING_ORDER#'.$vorder],
                                        'ePaymentStatus' => 'Settelled',
                                        'eUserType'=>'Driver',
                                        'eType'=>'Credit'
                                    ])
                                    ->update([
                                        'iUserId' => $livreurId,
                                        'iBalance' => $fDeliveryCharge
                                    ]);  
                        }else{
                            DB::connection('mysql2')->table('user_wallet')->insert([
                            'iUserId' =>$livreurId,
                            'vName' =>'',
                            'vLastName' =>'',
                            'vPhone' =>'',
                            'eUserType' => 'Driver',
                            'iBalance' => $fDeliveryCharge,
                            'eType' => 'Credit',
                            'iTripId' => $iTripId,
                            'eFor' => 'Deposit',
                            'tDescription' => '#LBL_ADJUSTMENT_EARNING_ORDER#'.$vorder.' ',
                            'ePaymentStatus' => 'Settelled',
                            'dDate' => $dDate,
                            'fRatio_USD' => 0.0017000,
                            'fRatio_XOF' => 1.0000000,
                            'iOrderId'=>0,
                            'iTransactionId'=>'',
                            'fromUserId'=>0,
                            'fromUserType'=>'Driver',
                            'fromAdminId'=>'',
                            'service'=>'',
                            'serviceType'=>'',
                            'iBiddingPostId'=>0,
                            'iRentItemPostId'=>0,
                            'iTmpRentItemPostId'=>0,
                            'iBookingId'=>0,
                            // Ajoutez d'autres colonnes avec leurs valeurs ici
                        ]);
                    }
                        
                }elseif(($tmontant<=$walletpay || $tmontant>$walletpay) && $cashpay==0){
             
                 $walletpay=$tmontant;
                 $cashpay=0;
                 
                 if(($fNet>0 && $fWalletDebi>0) || ($fWalletDebi==0 && $fNet>0)){
                 
                  DB::connection('mysql2')
                    ->table('user_wallet')
                    //->where('iTripId',$iTripId)
                    ->where('tDescription', 'like', '%'.$vorder.'%')
                    ->delete();
                }
                  
                /* +======================+ user operation +========================+ */
                
                    $check_user_wallet = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('*')
                        ->where('tDescription','like', '#LBL_DEBITED_BOOKING_DL#%'.$vorder.'%')
                        ->where('ePaymentStatus','Unsettelled')
                        ->where('eUserType','Rider')
                        ->where('eType','Debit')
                        ->where( 'eFor','Booking')
                        ->first();
                        
                        if($check_user_wallet){
                        /*b +====update wallet pay=======+ */
                            DB::connection('mysql2')
                                ->table('user_wallet')
                                ->where([
                                                //'iUserWalletId' => $iUserWalletId,
                                        'eFor' => 'Booking',
                                        ['tDescription', 'LIKE', '#LBL_DEBITED_BOOKING_DL#%'.$vorder.'%'],
                                        'ePaymentStatus' => 'Unsettelled',
                                        'eUserType'=>'Rider',
                                        'eType'=>'Debit'
                                    ])
                                ->update([
                                        //'iUserId' => $Id,
                                    'iBalance' => $walletpay
                                ]); 
                        }else{
                             DB::connection('mysql2')->table('user_wallet')->insert([
                                'iUserId' => $userId,
                                'vName' =>'',
                                'vLastName' =>'',
                                'vPhone' =>'',
                                'eUserType' => 'Rider',
                                'iBalance' => $walletpay,
                                'eType' => 'Debit',
                                'iTripId'=>0,
                                'eFor' => 'Booking',
                                'tDescription' => '#LBL_DEBITED_BOOKING_DL# '.$vorder.' ',
                                'ePaymentStatus' => 'Unsettelled',
                                'dDate' => $dDate,
                                'fRatio_USD' => '0.0016000',
                                'fRatio_XOF' => '1.0000000',
                                'iOrderId' => $orderId,
                                'iTransactionId'=>'',
                                'fromUserId'=>0,
                                'fromUserType'=>'Driver',
                                'fromAdminId'=>'',
                                'service'=>'',
                                'serviceType'=>'',
                                'iBiddingPostId'=>0,
                                'iRentItemPostId'=>0,
                                'iTmpRentItemPostId'=>0,
                                'iBookingId'=>0,
                                       
                            ]);
                        }
                        
                        
                        /* +==================+ gain livreur +==================+ */ 
                      $check_driver_earn_wallet = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('*')
                        ->where('tDescription','like', '#LBL_ADJUSTMENT_EARNING_ORDER#%'.$vorder.'%')
                        ->where('ePaymentStatus','Settelled')
                        ->where('eUserType','Driver')
                        ->where('eType','Credit')
                        ->where('eFor','Deposit')
                        ->first();
                        
                        if($check_driver_earn_wallet)  {
                            /* +========update earn======+*/        
                             DB::connection('mysql2')
                                    ->table('user_wallet')
                                    ->where([
                                        //'iUserWalletId' => $iUserWalletId,
                                        'eFor' => 'Deposit',
                                        ['tDescription', 'LIKE', '#LBL_ADJUSTMENT_EARNING_ORDER#'.$vorder],
                                        'ePaymentStatus' => 'Settelled',
                                        'eUserType'=>'Driver',
                                        'eType'=>'Credit'
                                    ])
                                    ->update([
                                        'iUserId' => $livreurId,
                                        'iBalance' => $fDeliveryCharge
                                    ]);  
                        }else{
                            DB::connection('mysql2')->table('user_wallet')->insert([
                            'iUserId' =>$livreurId,
                            'vName' =>'',
                            'vLastName' =>'',
                            'vPhone' =>'',
                            'eUserType' => 'Driver',
                            'iBalance' => $fDeliveryCharge,
                            'eType' => 'Credit',
                            'iTripId' => $iTripId,
                            'eFor' => 'Deposit',
                            'tDescription' => '#LBL_ADJUSTMENT_EARNING_ORDER#'.$vorder.' ',
                            'ePaymentStatus' => 'Settelled',
                            'dDate' => $dDate,
                            'fRatio_USD' => 0.0017000,
                            'fRatio_XOF' => 1.0000000,
                            'iOrderId'=>0,
                            'iTransactionId'=>'',
                            'fromUserId'=>0,
                            'fromUserType'=>'Driver',
                            'fromAdminId'=>'',
                            'service'=>'',
                            'serviceType'=>'',
                            'iBiddingPostId'=>0,
                            'iRentItemPostId'=>0,
                            'iTmpRentItemPostId'=>0,
                            'iBookingId'=>0,
                            // Ajoutez d'autres colonnes avec leurs valeurs ici
                        ]);
                    }
             
         }
         
        $fSubTotal=$tmontant-$delivery;
        $fTotalGenerateFare=$tmontant;
        $fNetTotal=$cashpay;
        $fWalletDebit=$tmontant-$cashpay;
        $commicion=$fSubTotal*($companyCommissionPer/100);
        
        /* +=====================+ */
        
        // If you want to access individual elements of genererData
        foreach ($genererData as $data) {
            $odetailid=$data['detailoid'];
            $article = $data['article'];
            $qte = $data['qte'];
            $price = $data['price'];
            
            DB::table('order_details')
            ->where(['iOrderDetailId'=>$odetailid,'iOrderId'=>$orderId])
            ->update([
                'iMenuItemId' => $article,
                'iQty' => $qte,
                'fTotalPrice' => $price
            ]);
            
        }
        
     if($fNetTotal>0 && $fWalletDebit==0){    
        // Mettre à jour trips
       DB::table('trips')
            ->where(['iOrderId'=>$orderId,'iActive'=>'Finished'])
            ->update([
                'IDriverId' => $livreurId,
                'fWalletDebit' => $fWalletDebit,
                //'iFare' =>$fNetTotal,
                'fTripGenerateFare' =>$fNetTotal, //$fTotalGenerateFare
                'vTripPaymentMode'=>'Cash',
                 'eWalletDebitAllow'=>'No',
                'ePayWallet'=>'No'
        ]);
        
        // Mettre à jour orders
       DB::table('orders')
            ->where('iOrderId', $orderId)
            ->update([
                'iDriverId' => $livreurId,
                'fSubTotal' => $fSubTotal,
                'fWalletDebit' => $fWalletDebit,
                'fCommision' => $commicion,
                'fDeliveryCharge'=>$delivery,
                'fNetTotal' => $fNetTotal,
                'fTotalGenerateFare'=>$fTotalGenerateFare,
                'ePayWallet'=>'No',
                'ePaymentOption'=>'Cash'
        ]);
     }elseif($fNetTotal>0 && $fWalletDebit>0){
          // Mettre à jour trips
       DB::table('trips')
            ->where(['iOrderId'=>$orderId,'iActive'=>'Finished'])
            ->update([
                'IDriverId' => $livreurId,
                'fWalletDebit' => $fWalletDebit,
                //'iFare' =>$fNetTotal,
                'fTripGenerateFare' =>$fNetTotal, //$fTotalGenerateFare
                'vTripPaymentMode'=>'Cash',
                 'eWalletDebitAllow'=>'Yes',
                'ePayWallet'=>'Yes'
        ]);
        
        // Mettre à jour orders
       DB::table('orders')
            ->where('iOrderId', $orderId)
            ->update([
                'iDriverId' => $livreurId,
                'fSubTotal' => $fSubTotal,
                'fWalletDebit' => $fWalletDebit,
                'fCommision' => $commicion,
                'fDeliveryCharge'=>$delivery,
                'fNetTotal' => $fNetTotal,
                'fTotalGenerateFare'=>$fTotalGenerateFare,
                'ePayWallet'=>'Yes',
                'ePaymentOption'=>'Cash'
        ]);
     }else{
          // Mettre à jour trips
       DB::table('trips')
            ->where(['iOrderId'=>$orderId,'iActive'=>'Finished'])
            ->update([
                'IDriverId' => $livreurId,
                'fWalletDebit' => $fWalletDebit,
                //'iFare' =>$fNetTotal,
                'fTripGenerateFare' =>$fNetTotal, //$fTotalGenerateFare
                'vTripPaymentMode'=>'Wallet',
                 'eWalletDebitAllow'=>'Yes',
                'ePayWallet'=>'Yes'
        ]);
        
        // Mettre à jour orders
       DB::table('orders')
            ->where('iOrderId', $orderId)
            ->update([
                'iDriverId' => $livreurId,
                'fSubTotal' => $fSubTotal,
                'fWalletDebit' => $fWalletDebit,
                'fCommision' => $commicion,
                'fDeliveryCharge'=>$delivery,
                'fNetTotal' => $fNetTotal,
                'fTotalGenerateFare'=>$fTotalGenerateFare,
                'ePayWallet'=>'Yes',
                'ePaymentOption'=>'Wallet'
        ]);
     }
        
        // Réponse de succès
        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    
    /* +=================================+ courses annulées par admin +=======================+ */
    public function getAdminCourse(Request $request){
        
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
        
        if ($request->has('startDate') && $request->has('endDate')) {
           $startDate = $request->input('startDate');
           $endDate = $request->input('endDate');
        }
       
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
       
        $admin_courses = DB::connection('mysql2')
            ->table('trips')
            ->select('trips.iTripId', 'trips.vRideNo as vRideNo','trips.iDriverId', 'register_user.vPhone as user_phone','register_driver.vPhone as driver_phone',
            DB::raw('CONCAT(register_user.vName, " ", register_user.vLastName) as passenger'),
            DB::raw('CONCAT(register_driver.vName, " ", register_driver.vLastName) as driveur'),
            'trips.tTripRequestDate as dDate', 'vehicle_type.vVehicleType_FR as categorie',
            'trips.iFare as ifare',
            'trips.fTripGenerateFare as total','trips.vCancelReason as raison','trips.iActive as status','trips.eCancelledBy as by','trips.eBookingFrom as froms')
            ->join('register_user', 'register_user.iUserId', '=', 'trips.iUserId')
            ->join('register_driver', 'register_driver.iDriverId', '=', 'trips.iDriverId')
            ->join('vehicle_type', 'vehicle_type.iVehicleTypeId', '=', 'trips.iVehicleTypeId')
            ->where('trips.iActive', 'Canceled')
            ->where('trips.eBookingFrom', 'Admin')
            ->where('trips.eSystem', 'General')
            ->where('trips.eType', 'Ride');
            
            if($startDate>0 && $endDate>0){
                $admin_courses->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
            }
             
            $admin_courses->orderByRaw('DATE(trips.tTripRequestDate) DESC');
            //$admin_courses->limit(100);
            $admin_courses=$admin_courses->get();
            

         $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));  
        
        return view('layouts.support.list_admin_drive', compact('admin_courses','startDate','endDate'));
    }
    /* +=================================+ get course +===================================+ */
    
    public function getCourse(Request $request){
         
        $sqls="(register_driver.vName NOT LIKE 'L-%' 
            AND register_driver.vLastName NOT LIKE 'L-%' 
            AND register_driver.vName NOT LIKE 'LEX-%' 
            AND register_driver.vLastName NOT LIKE 'LEX-%')
        ";
        
        //register_driver.vName LIKE 'D-%' OR register_driver.vName LIKE 'D %' OR register_driver.vLastName LIKE 'D-%' OR register_driver.vLastName LIKE 'D %' OR register_driver.vName LIKE 'DEX-%' OR register_driver.vName LIKE 'DEX %' OR register_driver.vLastName LIKE 'DEX-%' OR register_driver.vLastName LIKE 'DEX %'";
        //Select option
       $driveurs = DB::connection('mysql2')
        ->table('register_driver')
        ->select('iDriverId',DB::raw("CONCAT(vName, ' ', vLastName) as name"))
        ->where('eStatus','=','active')
        ->whereRaw($sqls)
        ->get();
        
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
    
        $courses = DB::connection('mysql2')
                ->table('trips')
                ->select('trips.iTripId', 'trips.vRideNo as vRideNo','trips.iDriverId', 
                DB::raw('CONCAT(register_user.vName, " ", register_user.vLastName) as passenger'),
                DB::raw('CONCAT(register_driver.vName, " ", register_driver.vLastName) as driver'),
                'trips.tStartDate as tEndDate', 'vehicle_type.vVehicleType_FR as categorie',
                'trips.fDuration as duree', 'trips.fDistance as distance','trips.fWalletDebit as fwalletdebit','trips.iFare as ifare',
                'trips.fTripGenerateFare as total', 'trips.fCommision as comission',
                'trips.vTripPaymentMode as paiement')
                ->join('register_user', 'register_user.iUserId', '=', 'trips.iUserId')
                ->join('register_driver', 'register_driver.iDriverId', '=', 'trips.iDriverId')
                ->join('vehicle_type', 'vehicle_type.iVehicleTypeId', '=', 'trips.iVehicleTypeId')
                ->where('trips.iActive', 'Finished')
                ->where('trips.eSystem', 'General')
                ->where('trips.eType', 'Ride')
                ->whereBetween('trips.tStartDate', [$startDate, $endDate])
                ->orderBy('trips.iTripId', 'desc')
                ->get();
                
            return view('layouts.support.list_gerer_course', compact('courses','driveurs','startDate', 'endDate'));
    }
    
    public function updateCourse(Request $request){
       
      //var_dump($request);

        $today = Carbon::now();
        $currentdate = $today->format('Y-m-d H:i'); // Format YYYY-MM-DD HH:MM
        //echo $dateEtHeureFormatees;
        
        
        // Récupérer les données du formulaire
        $tripId = $request->input('tripId');
        $vtrip =$request->input('vtrip');
        $driverId = $request->input('drivreur');
        $distance = $request->input('distance');
        $duree = $request->input('duree');
        $client = $request->input('client');
        $cashpay = $request->input('cashpay');
        $walletpay = $request->input('walletpay');
        $tmontant = $request->input('montant');
        $commission = $request->input('commission');
       
        $commission=$tmontant*0.15;
        $tva=$commission*0.18;
        $commissiontva=$commission+$tva;
        
        
         $driverwallet=$tmontant-$commissiontva;
         /*  +===================get trip ============================+ */
         $check_tripDate = DB::connection('mysql2')
            ->table('trips')
            ->select('iTripId','iUserId','tTripRequestDate','vTripPaymentMode','iFare','fWalletDebit')
            ->where('iTripId',$tripId)
            ->first();
            
        //var_dump($check_tripDate);
            if($check_tripDate){
                 $dDate=$check_tripDate->tTripRequestDate;
                 $iUserId=$check_tripDate->iUserId; 
                 $vTripPaymentMode=$check_tripDate->vTripPaymentMode;
                 $iFare=$check_tripDate->iFare;
                 $fWalletDebit= $check_tripDate->fWalletDebit;
            }
         /*  +========================================================+  */
         if($vTripPaymentMode=='Organization'){
             
             DB::table('user_wallet')
                        ->where(['iTripId'=>$tripId,'eFor'=>'Deposit','eType'=>'Credit',['tDescription', 'LIKE', '#LBL_CREDITED_TRIP_EARNING_PROVIDER#'.'%'.$vtrip.'%'],'ePaymentStatus'=>'Settelled'])
                        ->update([
                            'iUserId' => $driverId,
                            'iBalance' => $driverwallet,
                    ]);
             
         }else{
         
         
         if(($tmontant<=$cashpay || $tmontant>$cashpay) && $walletpay==0){
             
             
             /* +=========================Delete option===================================+ */
             
             if($iFare>0 && $fWalletDebit>0){
                 DB::connection('mysql2')
                    ->table('user_wallet')
                    ->where('iTripId',$tripId)
                    ->where('tDescription', 'like', '%'.$vtrip.'%')
                    ->delete();
             }
             
            $check_user_w_to_delete = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('*')
                ->where('tDescription','like', '#LBL_DEBITED_BOOKING#%'.$vtrip)
                ->where('eUserType','Rider')
                ->where('eType','Debit')
                ->where('eFor','Booking')
                ->where('ePaymentStatus','Settelled')
                ->first();
                
            if($check_user_w_to_delete){
                    DB::connection('mysql2')
                    ->table('user_wallet')
                    ->where('iTripId',$tripId)
                    ->where('tDescription', 'like', '#LBL_DEBITED_BOOKING#%'.'%'.$vtrip)
                    ->where('eUserType', 'Rider')
                    ->where('eFor', 'Booking')
                    ->delete();
            } 
                
            $check_driver_w_to_delete = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('*')
                ->where('tDescription','like', '#LBL_CREDITED_TRIP_EARNING_PROVIDER#%'.$vtrip)
                ->where('eUserType','Driver')
                ->where('eType','Credit')
                ->where('eFor','Deposit')
                ->where('ePaymentStatus','Settelled')
                ->first(); 
                        
            if($check_driver_w_to_delete){
                 DB::connection('mysql2')
                    ->table('user_wallet')
                    ->where('iTripId',$tripId)
                    ->where('tDescription', 'like', '#LBL_CREDITED_TRIP_EARNING_PROVIDER#%'.'%'.$vtrip)//      '%' . $vtrip . '%')
                    ->where('eUserType', 'Driver')
                    ->where('eFor', 'Deposit')
                    ->where('eType','Credit')
                    ->delete();
            }
            /******************End delete*********************************/ 
             
            $cashpay=$tmontant;
             
            $check_driver_earn = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('iUserId','iUserWalletId')
                        ->where('tDescription','like', '%'.$vtrip.'%')
                        ->where('eUserType', 'Driver')
                        ->where('eFor','Withdrawl')
                        ->first(); 
                        
            if($check_driver_earn) {        
             
                     DB::table('user_wallet')
                        ->where(['iTripId'=>$tripId,'eFor'=>'Withdrawl','eType'=>'Debit',['tDescription', 'LIKE', '#LBL_DEBITED_SITE_EARNING_BOOKING#'.'%'.$vtrip.'%'],'ePaymentStatus'=>'Settelled'])
                        ->update([
                            'iUserId' => $driverId,
                            'iBalance' => $commissiontva,
                    ]);
                    
            }else{    

                    DB::connection('mysql2')->table('user_wallet')->insert([
                        'iUserId' => $driverId,
                        'vName' =>'',
                        'vLastName' =>'',
                        'vPhone' =>'',
                        'eUserType' => 'Driver',
                        'iBalance' => $commissiontva,
                        'eType' => 'Debit',
                        'iTripId' => $tripId,
                        'eFor' => 'Withdrawl',
                        'tDescription' => '#LBL_DEBITED_SITE_EARNING_BOOKING#'.$vtrip,
                        'ePaymentStatus' => 'Settelled',
                        'dDate' => $dDate,
                        'fRatio_USD' => 0.0017000,
                        'fRatio_XOF' => 1.0000000,
                        'iOrderId'=>0,
                        'iTransactionId'=>'',
                        'fromUserId'=>0,
                        'fromUserType'=>'Driver',
                        'fromAdminId'=>'',
                        'service'=>'',
                        'serviceType'=>'',
                        'iBiddingPostId'=>0,
                        'iRentItemPostId'=>0,
                        'iTmpRentItemPostId'=>0,
                        'iBookingId'=>0,
                        // Ajoutez d'autres colonnes avec leurs valeurs ici
                    ]);
             
            }
             
         }elseif($cashpay>0 && $walletpay>0){
             
             /* +=================Delete option===================+ */
             
              if(($iFare>0 && $fWalletDebit==0) || ($iFare==0 && $fWalletDebit>0 )){
                 DB::connection('mysql2')
                    ->table('user_wallet')
                    ->where('iTripId',$tripId)
                    ->where('tDescription', 'like', '%'.$vtrip.'%')
                    ->delete();
             }
             /*+=================End delete=======================+ */
             
             
             
             
            $cashpay=$tmontant-$walletpay;
             
            $check_user_wc = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('*')
                ->where('tDescription','like', '#LBL_DEBITED_BOOKING#%'.$vtrip)
                ->where('eUserType','Rider')
                ->where('eType','Debit')
                ->where('eFor','Booking')
                ->where('ePaymentStatus','Settelled')
                ->first();
                
            if($check_user_wc){
                $iUserWalletId=$check_user_wc->iUserWalletId;
                DB::table('user_wallet')
                    ->where(['iUserWalletId'=>$iUserWalletId,'iTripId'=>$tripId,['tDescription', 'LIKE', '#LBL_DEBITED_BOOKING#%'],'ePaymentStatus'=>'Settelled'])
                    ->update([
                            'iBalance' => $walletpay,
                    ]);
            }else{
                
                DB::connection('mysql2')->table('user_wallet')->insert([
                    'iUserId' => $iUserId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => 'Rider',
                    'iBalance' => $walletpay,
                    'eType' => 'Debit',
                    'iTripId' => $tripId,
                    'eFor' => 'Booking',
                    'tDescription' => '#LBL_DEBITED_BOOKING# '.$vtrip,
                    'ePaymentStatus' => 'Settelled',
                    'dDate' => $dDate,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>'',
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                ]);
            }            
            
            
            $check_driver_wc = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('*')
                ->where('tDescription','like', '#LBL_CREDITED_BOOKING#%'.$vtrip)
                ->where('eUserType','Driver')
                ->where('eType','Credit')
                ->where('eFor','Deposit')
                ->where('ePaymentStatus','Settelled')
                ->first(); 
                
            
            if($check_driver_wc){
                $iUserWalletId=$check_driver_wc->iUserWalletId;
                 DB::table('user_wallet')
                    ->where(['iUserWalletId'=>$iUserWalletId,'iTripId'=>$tripId,['tDescription', 'LIKE', '#LBL_CREDITED_BOOKING#%'],'ePaymentStatus'=>'Settelled'])
                    ->update([
                            'iUserId' => $driverId,
                            'iBalance' => $driverwallet,
                    ]);
            }else{
                
                DB::connection('mysql2')->table('user_wallet')->insert([
                    'iUserId' => $driverId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => 'Driver',
                    'iBalance' => $walletpay,
                    'eType' => 'Credit',
                    'iTripId' => $tripId,
                    'eFor' => 'Deposit',
                    'tDescription' => '#LBL_CREDITED_BOOKING#'.$vtrip,
                    'ePaymentStatus' => 'Settelled',
                    'dDate' => $dDate,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>'',
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                        
                ]);
            }    
            
             $check_driver_earn_wc = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('iUserId','iUserWalletId')
                        ->where('tDescription','like', '%'.$vtrip.'%')
                        ->where('eUserType', 'Driver')
                        ->where('eFor','Withdrawl')
                        ->first(); 
                
           if($check_driver_earn_wc) {        
             
                     DB::table('user_wallet')
                        ->where(['iTripId'=>$tripId,'eFor'=>'Withdrawl','eType'=>'Debit',['tDescription', 'LIKE', '#LBL_DEBITED_SITE_EARNING_BOOKING#'.'%'.$vtrip.'%'],'ePaymentStatus'=>'Settelled'])
                        ->update([
                            'iUserId' => $driverId,
                            'iBalance' => $commissiontva,
                    ]);
                    
               }else{    

                    DB::connection('mysql2')->table('user_wallet')->insert([
                        'iUserId' => $driverId,
                        'vName' =>'',
                        'vLastName' =>'',
                        'vPhone' =>'',
                        'eUserType' => 'Driver',
                        'iBalance' => $commissiontva,
                        'eType' => 'Debit',
                        'iTripId' => $tripId,
                        'eFor' => 'Withdrawl',
                        'tDescription' => '#LBL_DEBITED_SITE_EARNING_BOOKING#'.$vtrip,
                        'ePaymentStatus' => 'Settelled',
                        'dDate' => $dDate,
                        'fRatio_USD' => 0.0017000,
                        'fRatio_XOF' => 1.0000000,
                        'iOrderId'=>0,
                        'iTransactionId'=>'',
                        'fromUserId'=>0,
                        'fromUserType'=>'Driver',
                        'fromAdminId'=>'',
                        'service'=>'',
                        'serviceType'=>'',
                        'iBiddingPostId'=>0,
                        'iRentItemPostId'=>0,
                        'iTmpRentItemPostId'=>0,
                        'iBookingId'=>0,
                        // Ajoutez d'autres colonnes avec leurs valeurs ici
                    ]);
             
               }     
             
             
         }elseif(($tmontant<=$walletpay || $tmontant>$walletpay) && $cashpay==0){
             $walletpay=$tmontant;
             $cashpay=0;
             
             /* +====================Delete option ==================+ */
             if($iFare>0 && $fWalletDebit>0){
                 DB::connection('mysql2')
                    ->table('user_wallet')
                    ->where('iTripId',$tripId)
                    ->where('tDescription', 'like', '%'.$vtrip.'%')
                    ->delete();
             }
             
            $check_driver_earn_to_delete = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('iUserId','iUserWalletId')
                        ->where('tDescription','like', '%'.$vtrip.'%')
                        ->where('eUserType', 'Driver')
                        ->where('eFor','Withdrawl')
                        ->first(); 
                        
            if($check_driver_earn_to_delete) {        
                    DB::connection('mysql2')
                    ->table('user_wallet')
                    ->where('iTripId',$tripId)
                    ->where('tDescription', 'like', '%' . $vtrip . '%')
                    ->where('eUserType', 'Driver')
                    ->where('eFor', 'Withdrawl')
                    ->delete();
            }
            
            /* +==================End delete=========================+ */
             
            $check_user_w = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('*')
                ->where('tDescription','like', '#LBL_DEBITED_BOOKING#%'.$vtrip)
                ->where('eUserType','Rider')
                ->where('eType','Debit')
                ->where('eFor','Booking')
                ->where('ePaymentStatus','Settelled')
                ->first();
                        
            if($check_user_w){
                
                $iUserWalletId=$check_user_w->iUserWalletId;
                DB::table('user_wallet')
                            ->where(['iUserWalletId'=>$iUserWalletId,'iTripId'=>$tripId,['tDescription', 'LIKE', '#LBL_DEBITED_BOOKING#%'],'ePaymentStatus'=>'Settelled'])
                            ->update([
                                'iBalance' => $tmontant,
                            ]);
            }else{
                DB::connection('mysql2')->table('user_wallet')->insert([
                    'iUserId' => $iUserId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => 'Rider',
                    'iBalance' => $tmontant,
                    'eType' => 'Debit',
                    'iTripId' => $tripId,
                    'eFor' => 'Booking',
                    'tDescription' => '#LBL_DEBITED_BOOKING# '.$vtrip,
                    'ePaymentStatus' => 'Settelled',
                    'dDate' => $dDate,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>'',
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                ]);
            }            
                        
                        
            $check_driver_w = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('*')
                ->where('tDescription','like', '#LBL_CREDITED_TRIP_EARNING_PROVIDER#%'.$vtrip)
                ->where('eUserType','Driver')
                ->where('eType','Credit')
                ->where('eFor','Deposit')
                ->where('ePaymentStatus','Settelled')
                ->first(); 
                        
            if($check_driver_w){
                $iUserWalletId=$check_driver_w->$iUserWalletId;
                 DB::table('user_wallet')
                    ->where(['iUserWalletId'=>$iUserWalletId,'iTripId'=>$tripId,['tDescription', 'LIKE', '#LBL_CREDITED_TRIP_EARNING_PROVIDER#%'],'ePaymentStatus'=>'Settelled'])
                    ->update([
                            'iUserId' => $driverId,
                            'iBalance' => $driverwallet,
                    ]);
            }else{
                
                DB::connection('mysql2')->table('user_wallet')->insert([
                    'iUserId' => $driverId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => 'Driver',
                    'iBalance' => $driverwallet,
                    'eType' => 'Credit',
                    'iTripId' => $tripId,
                    'eFor' => 'Deposit',
                    'tDescription' => '#LBL_CREDITED_TRIP_EARNING_PROVIDER#'.$vtrip,
                    'ePaymentStatus' => 'Settelled',
                    'dDate' => $dDate,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>'',
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                        
                ]);
            }            
         }
         
         }
         
        $fWalletDebits=$tmontant-$cashpay;
        
        if($vTripPaymentMode=='Organization'){
            DB::table('trips')
                        ->where(['iTripId'=>$tripId,'iActive'=>'Finished'])
                        ->update([
                            'iDriverId' => $driverId,
                            'fDistance' => $distance,
                            'fDuration' => $duree,
                             'iFare' =>$tmontant,
                             'iBaseFare' =>$tmontant,
                            //'fWalletDebit' => $fWalletDebits,
                            'fTripGenerateFare' =>$tmontant,
                            'fcommision' =>$commission,
                            'fTva'=>$tva
                ]);
        }else{
                
          if($cashpay>0 && $fWalletDebit==0){
                DB::table('trips')
                    ->where(['iTripId'=>$tripId,'iActive'=>'Finished'])
                    ->update([
                        'iDriverId' => $driverId,
                        'fDistance' => $distance,
                        'fDuration' => $duree,
                         'iFare' =>$cashpay,
                        'fWalletDebit' => $fWalletDebits,
                        'fTripGenerateFare' =>$tmontant,
                        'fcommision' =>$commission,
                        'fTva'=>$tva,
                        'vTripPaymentMode'=>'Cash',
                        'eWalletDebitAllow'=>'No',
                        'ePayWallet'=>'No'
            ]);
            }elseif($cashpay>0 && $fWalletDebit>0){
                 DB::table('trips')
                ->where(['iTripId'=>$tripId,'iActive'=>'Finished'])
                ->update([
                    'iDriverId' => $driverId,
                    'fDistance' => $distance,
                    'fDuration' => $duree,
                     'iFare' =>$cashpay,
                    'fWalletDebit' => $fWalletDebits,
                    'fTripGenerateFare' =>$tmontant,
                    'fcommision' =>$commission,
                    'fTva' =>$tva,
                    'vTripPaymentMode'=>'Cash',
                    'eWalletDebitAllow'=>'Yes',
                    'ePayWallet'=>'Yes'
                ]);
            }else{
                 DB::table('trips')
                ->where(['iTripId'=>$tripId,'iActive'=>'Finished'])
                ->update([
                    'iDriverId' => $driverId,
                    'fDistance' => $distance,
                    'fDuration' => $duree,
                     'iFare' =>$cashpay,
                    'fWalletDebit' => $fWalletDebits,
                    'fTripGenerateFare' =>$tmontant,
                    'fcommision' =>$commission,
                    'fTva' => $tva,
                    'vTripPaymentMode'=>'Wallet',
                    'eWalletDebitAllow'=>'Yes',
                    'ePayWallet'=>'Yes'
                ]);
            }
        }
        
        // Réponse de succès
        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    
    /* +================================get colis ==========================================+ */
    
     public function getColis(Request $request){
         
        $sqls="register_driver.vName LIKE 'L-%' OR register_driver.vName LIKE 'L %' OR register_driver.vLastName LIKE 'L-%' OR register_driver.vLastName LIKE 'L %' OR register_driver.vName LIKE 'LEX-%' OR register_driver.vName LIKE 'LEX %' OR register_driver.vLastName LIKE 'LEX-%' OR register_driver.vLastName LIKE 'LEX %'";
        //Select option
       $liveurs = DB::connection('mysql2')
        ->table('register_driver')
        ->select('iDriverId',DB::raw("CONCAT(vName, ' ', vLastName) as name"))
        ->where('eStatus','=','active')
        ->whereRaw($sqls)
        ->get();
        
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
    
        $colis = DB::connection('mysql2')
                ->table('trips')
                ->select('trips.iTripId', 'trips.vRideNo as vRideNo','trips.iDriverId', 
                DB::raw('CONCAT(register_user.vName, " ", register_user.vLastName) as passenger'),
                DB::raw('CONCAT(register_driver.vName, " ", register_driver.vLastName) as driver'),
                'trips.tStartDate as tEndDate', 'vehicle_type.vVehicleType_FR as categorie',
                'trips.fDuration as duree', 'trips.fDistance as distance','trips.fWalletDebit as fwalletdebit','trips.iFare as ifare',
                'trips.fTripGenerateFare as total', 'trips.fCommision as comission',
                'trips.vTripPaymentMode as paiement')
                ->join('register_user', 'register_user.iUserId', '=', 'trips.iUserId')
                ->join('register_driver', 'register_driver.iDriverId', '=', 'trips.iDriverId')
                ->join('vehicle_type', 'vehicle_type.iVehicleTypeId', '=', 'trips.iVehicleTypeId')
                ->where('trips.iActive', 'Finished')
                ->where('trips.eSystem', 'General')
                ->where('eCancelled', 'No')
                ->whereIn('trips.eType', ['Deliver','Multi-Delivery'])
                ->whereBetween('trips.tStartDate', [$startDate, $endDate])
                ->orderBy('trips.iTripId', 'desc')
                ->get();
                
            return view('layouts.support.list_gerer_colis', compact('colis','liveurs','startDate', 'endDate'));
    }
    
    
    
    public function updateColis(Request $request){
       

        $today = Carbon::now();
        $currentdate = $today->format('Y-m-d H:i'); // Format YYYY-MM-DD HH:MM
        //echo $dateEtHeureFormatees;
        
        
        // Récupérer les données du formulaire
        $tripId = $request->input('tripId');
        $vtrip = $request->input('vtrip');
        $driverId = $request->input('livreur');
        $distance = $request->input('distance');
        $duree = $request->input('duree');
        $client = $request->input('client');
        $cashpay = $request->input('cashpay');
        $walletpay = $request->input('walletpay');
        $tmontant = $request->input('montant');
        $commission = $request->input('commission');
       
        
         
         /*  +===================get trip ============================+ */
         $check_tripDate = DB::connection('mysql2')
            ->table('trips')
            ->select('iTripId','iUserId','tTripRequestDate','vTripPaymentMode','iFare','fWalletDebit','fTripGenerateFare','iVehicleTypeId')
            ->where('iTripId',$tripId)
            ->first();
            
            if($check_tripDate){
                 $dDate=$check_tripDate->tTripRequestDate;
                 $iUserId=$check_tripDate->iUserId; 
                 $vTripPaymentMode=$check_tripDate->vTripPaymentMode;
                 $iFare=$check_tripDate->iFare;
                 $fWalletDebit= $check_tripDate->fWalletDebit;
                 $fTripGenerateFare= $check_tripDate->fTripGenerateFare;
                 $iVehicleTypeId= $check_tripDate->iVehicleTypeId;
            }
            
             $check_vehicle_type = DB::connection('mysql2')
            ->table('vehicle_type')
            ->select('iVehicleTypeId','fCommision')
            ->where('iVehicleTypeId',$iVehicleTypeId)
            ->first();
            
            if($check_vehicle_type){
                $fCommi=$check_vehicle_type->fCommision;
            }
            $commission=$tmontant*($fCommi/100);
        
        
            $driverwallet=$tmontant-$commission;
         /*  +========================================================+  */
         
         if(($tmontant<=$cashpay || $tmontant>$cashpay) && $walletpay==0){
             
             
             /* +=========================Delete option===================================+ */
             
             //#LBL_DEBITED_SITE_EARNING_BOOKING# 2387949179
             
            if(($iFare>0 && $fWalletDebit>0) || ($fWalletDebit>0 && $iFare==0)){
                 DB::connection('mysql2')
                    ->table('user_wallet')
                    ->where('iTripId',$tripId)
                    ->where('tDescription', 'like', '%'.$vtrip.'%')
                    ->delete();
            }
             
            /******************End delete*********************************/ 
             
            $cashpay=$tmontant;
             
            $check_driver_earn = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('iUserId','iUserWalletId')
                        ->where('tDescription','like', '%'.$vtrip.'%')
                        ->where('eUserType', 'Driver')
                        ->where('eFor','Withdrawl')
                        ->first(); 
                        
               if($check_driver_earn) {        
             
                     DB::table('user_wallet')
                        ->where(['iTripId'=>$tripId,'eFor'=>'Withdrawl','eType'=>'Debit',['tDescription', 'LIKE', '#LBL_DEBITED_SITE_EARNING_BOOKING#'.'%'.$vtrip.'%'],'ePaymentStatus'=>'Settelled'])
                        ->update([
                            'iUserId' => $driverId,
                            'iBalance' => $commission,
                    ]);
                    
               }else{    

                    DB::connection('mysql2')->table('user_wallet')->insert([
                        'iUserId' => $driverId,
                        'vName' =>'',
                        'vLastName' =>'',
                        'vPhone' =>'',
                        'eUserType' => 'Driver',
                        'iBalance' => $commission,
                        'eType' => 'Debit',
                        'iTripId' => $tripId,
                        'eFor' => 'Withdrawl',
                        'tDescription' => '#LBL_DEBITED_SITE_EARNING_BOOKING#'.$vtrip,
                        'ePaymentStatus' => 'Settelled',
                        'dDate' => $dDate,
                        'fRatio_USD' => 0.0017000,
                        'fRatio_XOF' => 1.0000000,
                        'iOrderId'=>0,
                        'iTransactionId'=>'',
                        'fromUserId'=>0,
                        'fromUserType'=>'Driver',
                        'fromAdminId'=>'',
                        'service'=>'',
                        'serviceType'=>'',
                        'iBiddingPostId'=>0,
                        'iRentItemPostId'=>0,
                        'iTmpRentItemPostId'=>0,
                        'iBookingId'=>0,
                        // Ajoutez d'autres colonnes avec leurs valeurs ici
                    ]);
             
               }
             
         }elseif($cashpay>0 && $walletpay>0){
             
            /* +=================Delete option===================+ */
             
             if(($iFare>0 && $fWalletDebit==0) || ($iFare==0 && $fWalletDebit>0 )){
                 DB::connection('mysql2')
                    ->table('user_wallet')
                    ->where('iTripId',$tripId)
                    ->where('tDescription', 'like', '%'.$vtrip.'%')
                    ->delete();
             }
            /*+=================End delete=======================+ */
             
            $cashpay=$tmontant-$walletpay;
             
            $check_user_wc = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('*')
                ->where('tDescription','like', '#LBL_DEBITED_BOOKING#%'.$vtrip)
                ->where('eUserType','Rider')
                ->where('eType','Debit')
                ->where('eFor','Booking')
                ->where('ePaymentStatus','Settelled')
                ->first();
                
            if($check_user_wc){
                $iUserWalletId=$check_user_wc->iUserWalletId;
                DB::table('user_wallet')
                    ->where(['iUserWalletId'=>$iUserWalletId,'iTripId'=>$tripId,['tDescription', 'LIKE', '#LBL_DEBITED_BOOKING#%'],'ePaymentStatus'=>'Settelled'])
                    ->update([
                            'iBalance' => $walletpay,
                    ]);
            }else{
                
                DB::connection('mysql2')->table('user_wallet')->insert([
                    'iUserId' => $iUserId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => 'Rider',
                    'iBalance' => $walletpay,
                    'eType' => 'Debit',
                    'iTripId' => $tripId,
                    'eFor' => 'Booking',
                    'tDescription' => '#LBL_DEBITED_BOOKING# '.$vtrip,
                    'ePaymentStatus' => 'Settelled',
                    'dDate' => $dDate,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>'',
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                ]);
            }            
            
            
            $check_driver_wc = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('*')
                ->where('tDescription','like', '#LBL_CREDITED_BOOKING#%'.$vtrip)
                ->where('eUserType','Driver')
                ->where('eType','Credit')
                ->where('eFor','Deposit')
                ->where('ePaymentStatus','Settelled')
                ->first(); 
                
            
            if($check_driver_wc){
                $iUserWalletId=$check_driver_wc->iUserWalletId;
                 DB::table('user_wallet')
                    ->where(['iUserWalletId'=>$iUserWalletId,'iTripId'=>$tripId,['tDescription', 'LIKE', '#LBL_CREDITED_BOOKING#%'],'ePaymentStatus'=>'Settelled'])
                    ->update([
                            'iUserId' => $driverId,
                            'iBalance' => $driverwallet,
                    ]);
            }else{
                
                DB::connection('mysql2')->table('user_wallet')->insert([
                    'iUserId' => $driverId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => 'Driver',
                    'iBalance' => $walletpay,
                    'eType' => 'Credit',
                    'iTripId' => $tripId,
                    'eFor' => 'Deposit',
                    'tDescription' => '#LBL_CREDITED_BOOKING#'.$vtrip,
                    'ePaymentStatus' => 'Settelled',
                    'dDate' => $dDate,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>'',
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                        
                ]);
            }    
            
             $check_driver_earn_wc = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('iUserId','iUserWalletId')
                        ->where('tDescription','like', '%'.$vtrip.'%')
                        ->where('eUserType', 'Driver')
                        ->where('eFor','Withdrawl')
                        ->first(); 
                
           if($check_driver_earn_wc) {        
             
                     DB::table('user_wallet')
                        ->where(['iTripId'=>$tripId,'eFor'=>'Withdrawl','eType'=>'Debit',['tDescription', 'LIKE', '#LBL_DEBITED_SITE_EARNING_BOOKING#'.'%'.$vtrip.'%'],'ePaymentStatus'=>'Settelled'])
                        ->update([
                            'iUserId' => $driverId,
                            'iBalance' => $commission,
                    ]);
                    
               }else{    

                    DB::connection('mysql2')->table('user_wallet')->insert([
                        'iUserId' => $driverId,
                        'vName' =>'',
                        'vLastName' =>'',
                        'vPhone' =>'',
                        'eUserType' => 'Driver',
                        'iBalance' => $commission,
                        'eType' => 'Debit',
                        'iTripId' => $tripId,
                        'eFor' => 'Withdrawl',
                        'tDescription' => '#LBL_DEBITED_SITE_EARNING_BOOKING#'.$vtrip,
                        'ePaymentStatus' => 'Settelled',
                        'dDate' => $dDate,
                        'fRatio_USD' => 0.0017000,
                        'fRatio_XOF' => 1.0000000,
                        'iOrderId'=>0,
                        'iTransactionId'=>'',
                        'fromUserId'=>0,
                        'fromUserType'=>'Driver',
                        'fromAdminId'=>'',
                        'service'=>'',
                        'serviceType'=>'',
                        'iBiddingPostId'=>0,
                        'iRentItemPostId'=>0,
                        'iTmpRentItemPostId'=>0,
                        'iBookingId'=>0,
                        // Ajoutez d'autres colonnes avec leurs valeurs ici
                    ]);
             
               }     
             
             
         }elseif(($tmontant<=$walletpay || $tmontant>$walletpay) && $cashpay==0){
             $walletpay=$tmontant;
             $cashpay=0;
             
             /* +====================Delete option ==================+ */
             if(($iFare>0 && $fWalletDebit>0) || ($iFare>0 && $fWalletDebit==0)){
                 DB::connection('mysql2')
                    ->table('user_wallet')
                    ->where('iTripId',$tripId)
                    ->where('tDescription', 'like', '%'.$vtrip.'%')
                    ->delete();
             }
             
            /* +==================End delete=========================+ */
             
            $check_user_w = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('*')
                ->where('tDescription','like', '#LBL_DEBITED_BOOKING#%'.$vtrip)
                ->where('eUserType','Rider')
                ->where('eType','Debit')
                ->where('eFor','Booking')
                ->where('ePaymentStatus','Settelled')
                ->first();
                        
            if($check_user_w){
                
                $iUserWalletId=$check_user_w->iUserWalletId;
                DB::table('user_wallet')
                            ->where(['iUserWalletId'=>$iUserWalletId,'iTripId'=>$tripId,['tDescription', 'LIKE', '#LBL_DEBITED_BOOKING#%'],'ePaymentStatus'=>'Settelled'])
                            ->update([
                                'iBalance' => $tmontant,
                            ]);
            }else{
                DB::connection('mysql2')->table('user_wallet')->insert([
                    'iUserId' => $iUserId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => 'Rider',
                    'iBalance' => $tmontant,
                    'eType' => 'Debit',
                    'iTripId' => $tripId,
                    'eFor' => 'Booking',
                    'tDescription' => '#LBL_DEBITED_BOOKING#'.$vtrip,
                    'ePaymentStatus' => 'Settelled',
                    'dDate' => $dDate,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>'',
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                ]);
            }            
                        
                        
            $check_driver_w = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('*')
                ->where('tDescription','like', '#LBL_CREDITED_TRIP_EARNING_PROVIDER#%'.$vtrip)
                ->where('eUserType','Driver')
                ->where('eType','Credit')
                ->where('eFor','Deposit')
                ->where('ePaymentStatus','Settelled')
                ->first(); 
                        
            if($check_driver_w){
                $iUserWalletId=$check_driver_w->$iUserWalletId;
                 DB::table('user_wallet')
                    ->where(['iUserWalletId'=>$iUserWalletId,'iTripId'=>$tripId,['tDescription', 'LIKE', '#LBL_CREDITED_TRIP_EARNING_PROVIDER#%'],'ePaymentStatus'=>'Settelled'])
                    ->update([
                            'iUserId' => $driverId,
                            'iBalance' => $driverwallet,
                    ]);
            }else{
                
                DB::connection('mysql2')->table('user_wallet')->insert([
                    'iUserId' => $driverId,
                    'vName' =>'',
                    'vLastName' =>'',
                    'vPhone' =>'',
                    'eUserType' => 'Driver',
                    'iBalance' => $driverwallet,
                    'eType' => 'Credit',
                    'iTripId' => $tripId,
                    'eFor' => 'Deposit',
                    'tDescription' => '#LBL_CREDITED_TRIP_EARNING_PROVIDER#'.$vtrip,
                    'ePaymentStatus' => 'Settelled',
                    'dDate' => $dDate,
                    'fRatio_USD' => 0.0017000,
                    'fRatio_XOF' => 1.0000000,
                    'iOrderId'=>0,
                    'iTransactionId'=>'',
                    'fromUserId'=>0,
                    'fromUserType'=>'Driver',
                    'fromAdminId'=>'',
                    'service'=>'',
                    'serviceType'=>'',
                    'iBiddingPostId'=>0,
                    'iRentItemPostId'=>0,
                    'iTmpRentItemPostId'=>0,
                    'iBookingId'=>0,
                        
                ]);
            }            
         }
         
       
        $fWalletDebits=$tmontant-$cashpay;
        
        if($vTripPaymentMode=='Organization'){
            DB::table('trips')
                        ->where(['iTripId'=>$tripId,'iActive'=>'Finished'])
                        ->update([
                            'iDriverId' => $driverId,
                            'fDistance' => $distance,
                            'fDuration' => $duree,
                             'iFare' =>$cashpay,
                            'fWalletDebit' => $fWalletDebits,
                            'fTripGenerateFare' =>$tmontant,
                            'fcommision' =>$commission
                ]);
        }else{
                
          if($cashpay>0 && $fWalletDebit==0){
                DB::table('trips')
                    ->where(['iTripId'=>$tripId,'iActive'=>'Finished'])
                    ->update([
                        'iDriverId' => $driverId,
                        'fDistance' => $distance,
                        'fDuration' => $duree,
                         'iFare' =>$cashpay,
                        'fWalletDebit' => $fWalletDebits,
                        'fTripGenerateFare' =>$tmontant,
                        'fcommision' =>$commission,
                        'vTripPaymentMode'=>'Cash',
                        'eWalletDebitAllow'=>'No',
                        'ePayWallet'=>'No'
            ]);
            }elseif($cashpay>0 && $fWalletDebit>0){
                 DB::table('trips')
                ->where(['iTripId'=>$tripId,'iActive'=>'Finished'])
                ->update([
                    'iDriverId' => $driverId,
                    'fDistance' => $distance,
                    'fDuration' => $duree,
                     'iFare' =>$cashpay,
                    'fWalletDebit' => $fWalletDebits,
                    'fTripGenerateFare' =>$tmontant,
                    'fcommision' =>$commission,
                    'vTripPaymentMode'=>'Cash',
                    'eWalletDebitAllow'=>'Yes',
                    'ePayWallet'=>'Yes'
                ]);
            }else{
                 DB::table('trips')
                ->where(['iTripId'=>$tripId,'iActive'=>'Finished'])
                ->update([
                    'iDriverId' => $driverId,
                    'fDistance' => $distance,
                    'fDuration' => $duree,
                     'iFare' =>$cashpay,
                    'fWalletDebit' => $fWalletDebits,
                    'fTripGenerateFare' =>$tmontant,
                    'fcommision' =>$commission,
                    'vTripPaymentMode'=>'Wallet',
                    'eWalletDebitAllow'=>'Yes',
                    'ePayWallet'=>'Yes'
                ]);
            }
        }
        
        // Réponse de succès
        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    
    /*********************** Manage drive scolaire ***************************************/
    public function getParents(Request $request)
    {
        $search = $request->input('q'); // Texte saisi par l'utilisateur
    
        $parents = DB::connection('mysql2')
            ->table('register_user')
            ->select('iUserId', 'vPhone', DB::raw("CONCAT(vName, ' ', vLastName) as name"))
            ->where('eStatus', '=', 'active')
            ->when($search, function ($query, $search) {
                return $query->where(function ($q) use ($search) {
                    $q->where('vName', 'like', "%$search%")
                      ->orWhere('vLastName', 'like', "%$search%")
                      ->orWhere('vPhone', 'like', "%$search%");
                });
            })
            ->limit(20) // Limiter le nombre de résultats pour éviter la surcharge
            ->get();
    
        return response()->json($parents);
    }

    public function getDriveScolaire(Request $request){
         
        $sqls="(register_driver.vName NOT LIKE 'L-%' 
            AND register_driver.vLastName NOT LIKE 'L-%' 
            AND register_driver.vName NOT LIKE 'LEX-%' 
            AND register_driver.vLastName NOT LIKE 'LEX-%')
        ";
         
        $parents = DB::connection('mysql2')
        ->table('register_user')
        ->select('iUserId','vPhone',DB::raw("CONCAT(vName, ' ', vLastName) as name"))
        ->where('eStatus','=','active')
        ->get();
        
       $driveurs = DB::connection('mysql2')
        ->table('register_driver')
        ->select('iDriverId','vPhone',DB::raw("CONCAT(vName, ' ', vLastName) as name"))
        ->where('eStatus','=','active')
        ->whereRaw($sqls)
        ->get();
         
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', '2020-01-01');
        $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
    
        $manage_schools = DB::connection('mysql2')
                ->table('manage_school_location')
                ->select('manage_school_location.*','register_user.vPhone as phoneP','register_driver.vPhone as phoneD',
                DB::raw('CONCAT(register_user.vName, " ", register_user.vLastName) as passenger'),
                DB::raw('CONCAT(register_driver.vName, " ", register_driver.vLastName) as driver'))
                ->join('register_user', 'register_user.iUserId', '=', 'manage_school_location.iUserId')
                ->join('register_driver', 'register_driver.iDriverId', '=', 'manage_school_location.iDriverId')
                //->whereBetween('manage_school_location.iDate', [$startDate, $endDate])
                ->get();
                
            return view('layouts.support.list_drive_scolaire', compact('manage_schools','startDate', 'endDate','parents','driveurs'));
    }
    
    public function saveDriveSchool(Request $request){
        
            $date_day=Carbon::now()->format('Y-m-d');
            
            $montant1 = $request->input('montant1');
            $montant2 = $request->input('montant2');
            $day = $request->input('day');
            $edate = $request->input('edate');
            $iUserId = $request->input('client');
            $iDriverId = $request->input('driveur');
            $nombre=$request->input('nombre');
            $tSadd = $request->input('tsaddress');
            $tDadd = $request->input('tdaddress');
            
            //var_dump($montant1);
            $data = [
                'iAmountByMonth' => $montant1,
                'iAmountByDay' => $montant2,
                'iChildrenNumber' => $nombre,
                'iDayWork' => $day,
                'iDate' => $edate,
                'iDriverId'=>$iDriverId,
                'iUserId'=>$iUserId,
                'iCreatedBy'=>session('user_id'),
                'tSaddress' => $tSadd,
                'tDaddress' => $tDadd,
            ];
            
        // var_dump($montant);
            
            DB::connection('mysql2')->table('manage_school_location')->Insert(
                $data
            );
            
         // Redirect to HomeController@index
        return redirect()->action([Support::class, 'getDriveScolaire']);
        
    }
    /***********Change status school manage**************************************/
    
    
    public function updateStatus($id, $status)
    {
        //dd($status);
        try {
            // Mise à jour de la table dans la base de données secondaire
            DB::connection('mysql2')->table('manage_school_location')
                ->where('iManageSchoolId', $id)
                ->update(['iActive' => $status]);

            return redirect()->back()->with('success', 'Statut mis à jour avec succès.');
        } catch (\Exception $e) {
            // Gestion des erreurs
            return redirect()->back()->with('error', 'Une erreur s\'est produite : ' . $e->getMessage());
        }
    }

    
    /***************Get drive deactive*********************/
    
     public function getDriveDeactive(Request $request){
         
        $sqls="(register_driver.vName NOT LIKE 'L-%' 
            AND register_driver.vLastName NOT LIKE 'L-%' 
            AND register_driver.vName NOT LIKE 'LEX-%' 
            AND register_driver.vLastName NOT LIKE 'LEX-%')
        ";
         
        $driveurs = DB::connection('mysql2')
            ->table('register_driver')
            ->select('iDriverId','vPhone',DB::raw("CONCAT(vName, ' ', vLastName) as name"))
            ->where('eStatus','=','active')
            ->whereRaw($sqls)
            ->get();
         
        $itemsPerPage = 6;
        
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', '2020-01-01');
        $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
    
        $manage_deactives = DB::connection('mysql2')
                ->table('manage_drivers_deativate')
                ->select('manage_drivers_deativate.*','model.vTitle','make.vMake','driver_vehicle.iYear','driver_vehicle.vLicencePlate', 
                DB::raw('CONCAT(register_driver.vName, " ", register_driver.vLastName) as driver'))
                ->join('register_driver', 'register_driver.iDriverId', '=', 'manage_drivers_deativate.iDriverId')
                ->join('driver_vehicle', 'driver_vehicle.iDriverVehicleId', '=', 'manage_drivers_deativate.iVehicleId')
                ->join('model', 'model.iModelId', '=', 'driver_vehicle.iModelId')
                ->join('make', 'make.iMakeId', '=', 'driver_vehicle.iMakeId')
                //->where('driver_vehicle.eStatus','Active')
               // ->where('driver_vehicle.eAddedDeliverVehicle','No')
                ->whereBetween('manage_drivers_deativate.iCreated_at', [$startDate, $endDate])
                ->get();
                
        return view('layouts.support.list_drive_deactive', compact('manage_deactives','startDate', 'endDate','driveurs'));
    }
    
    /* +++++++++++++++++++++++++++++++Save drive deactive+++++++++++++++++++++++++++++ */
    
     public function saveDriveDeactive(Request $request){
        
            $date_day=Carbon::now()->format('Y-m-d');
            
            $iDriverId = $request->input('driveur');
            $iRaison = $request->input('raison');
            
            $lastData = DB::connection('mysql2')
            ->table('register_driver')
            ->where('iDriverId', $iDriverId)
            //->where('eStatus','Active')
            //->where('eAddedDeliverVehicle','No')
            //->orderBy('iDriverVehicleId', 'desc')
            ->first();
            
            $iVehicle= $lastData->iDriverVehicleId;
           
            //var_dump($montant1);
            $data = [
                'iDriverId'=>$iDriverId,
                'iReason'=>$iRaison,
                'iDeactiveDate'=>$date_day,
                'iVehicleId' =>$iVehicle
            ];
            
             DB::connection('mysql2')->table('register_driver')
                ->where('iDriverId', $iDriverId)
                ->update(['eStatus' => 'inactive']);
            //eStatus= inactive, vAvailability= Not Available
            
        // var_dump($montant);
            
            DB::connection('mysql2')->table('manage_drivers_deativate')->Insert(
                $data
            );
            
         // Redirect to HomeController@index
        return redirect()->action([Support::class, 'getDriveDeactive']);
        
    }
    
    /* *+++++++++++++*+++++++*+++++++++++++*****+++***** */
    public function updateDStatus($id, $idriver)
    {
         $date_day=Carbon::now()->format('Y-m-d');
        //dd($status);
        try {
            // Mise à jour de la table dans la base de données secondaire
            DB::connection('mysql2')->table('manage_drivers_deativate')
                ->where('iManageDriverId', $id)
                ->update(['iStatus' => 'Active','iReactiveDate' => $date_day]);
                
            DB::connection('mysql2')->table('register_driver')
                ->where('iDriverId', $idriver)
                ->update(['eStatus' => 'active']);    

            return redirect()->back()->with('success', 'Statut mis à jour avec succès.');
        } catch (\Exception $e) {
            // Gestion des erreurs
            return redirect()->back()->with('error', 'Une erreur s\'est produite : ' . $e->getMessage());
        }
    }
    
    
     /* ++++++++++++++++++++++++++++++++++++++++* Get livreur debloque *++++++++++++++++++++++++++++++++++ */
    
    
    public function getDriveDeblok(Request $request)
    {
        $searchTerm = $request->get('query');
        $resultats = collect();
        
        // Calculer la plage d'une semaine
        $oneWeekAgo = Carbon::now()->subMonth(3)->startOfDay(); 
        $today = Carbon::now()->endOfDay();
        
        //if(!empty($searchTerm)) {
            $query = DB::table('orders')
                ->select(
                    'orders.iOrderId as iOrderId0', 'orders.iUserId as iUserId0', 'orders.vOrderNo', 
                    'orders.iCompanyId as iCompanyId0', 'orders.iDriverId as iDriverId0', 
                    'orders.iServiceId as iServiceId0', 'orders.tOrderRequestDate', 
                    'orders.dDeliveryDate', 'orders.fSubTotal', 'orders.fNetTotal', 
                    'orders.fTotalGenerateFare', 'orders.iStatusCode','orders.fDeliveryCharge as fDeliveryCharge0',
                    'orders.iUserAddressId as iUserAddressId0','orders.ePaymentOption as ePaymentOption0',
                    'trips.*', 
                    DB::raw('CONCAT(register_driver.vName, " ", register_driver.vLastName) as livreur'),
                    DB::raw('ROW_NUMBER() OVER (PARTITION BY orders.iOrderId ORDER BY trips.iTripId) as is_first') // Marque la première ligne
                )
                ->join('trips', 'trips.iOrderId', '=', 'orders.iOrderId')
                ->join('register_driver', 'register_driver.iDriverId', '=', 'trips.iDriverId');
               

              // Si une recherche est effectuée, ignorer l'intervalle de dates
            if(!empty($searchTerm)){
                  $query->where('orders.vOrderNo', 'like', '%' . $searchTerm . '%');
            }else{
                $query->whereIn('orders.iOrderId', function ($subQuery){
                 $subQuery->select('iOrderId')
                     ->from('trips')
                     ->groupBy('iOrderId')
                     ->havingRaw('COUNT(*) > 1'); // Commandes avec au moins 2 trips
                });
               // Appliquer l'intervalle de dates uniquement si aucune recherche
               $query->whereBetween('orders.tOrderRequestDate', [$oneWeekAgo, $today]);
            }

         $resultats = $query->orderBy('orders.iOrderId')->get();
       // }
        
        return view('layouts.support.list_drive_debloque', compact('resultats', 'searchTerm'));
    }

    public function updateFreeLivreur(Request $request)
    {
       // Récupérer les données du formulaire
        $driverId = $request->input('driverId'); // choix qui a livrer
        $driverId0 = $request->input('driverId0');
        $tripId = $request->input('tripId');
        $orderId = $request->input('orderId');
        
        $orders = DB::table('orders')
                    ->select(
                        'orders.*'
                    )
                    ->where('iOrderId', '=', $orderId)
                    ->first();
                    
        $dDateWallet=$orders->dDeliveryDate;
        $vorder=$orders->vOrderNo;
        $montantT=$orders->fTotalGenerateFare;
        
        
        // Date initiale
        $initialDate = Carbon::createFromFormat('Y-m-d H:i:s', $orders->dDeliveryDate);
       // Soustraire 5 minutes
        $startD = $initialDate->subMinutes(10);
        $arrivedD = $startD->subMinutes(5);
        
        //var_dump($arrivedD); 
    
        $trips = DB::table('trips')
                    ->select(
                        'trips.*'
                    )
                    ->where('iOrderId', '=', $orderId)
                    ->get();                
        
        //var_dump($trips);
        
       // Vérifier si le résultat n'est pas vide et contient plus d'un enregistrement
       $countDriverExist=0;
       if ($trips->isNotEmpty() && $trips->count() > 1) {
            foreach ($trips as $trip) {
                // Suppression de l'enregistrement
                $iTrip=$trip->iTripId;
                $idDriver=$trip->iDriverId;
                $fDeliveryCharge=$trip->fDeliveryCharge;
                
                if($idDriver != $driverId){
                   DB::table('register_driver')
                      ->where('iDriverId', $idDriver)
                      ->update(['iTripId' => 0,'vTripStatus'=>'None','vAvailability' => 'Available']);  
                   
                   DB::table('trips')->where('iTripId', '=', $iTrip)->delete();
                   
                ///echo "Enregistrement supprimé : ID = " . $trip->iTripId . "\n";
                
                }else{

                    if($tripId != $iTrip){
                          DB::table('trips')->where('iTripId', '=', $iTrip)->delete();
                    }else{
                    
                        DB::table('orders')
                          ->where('iOrderId', $orderId)
                          ->update(['iDriverId' => $driverId,'iStatusCode'=>6]);  
                        
                         DB::table('register_driver')
                          ->where('iDriverId', $idDriver)
                          ->update(['iTripId' => $tripId,'vTripStatus'=>'Finished','vAvailability' => 'Available']);  
                          
                          
                          DB::table('trips')
                          ->where('iTripId', $tripId)
                          ->update(['iUserId'=>$orders->iUserId, 'iServiceId' =>$orders->iServiceId, 'iCompanyId'=>$orders->iCompanyId, 'tTripRequestDate'=>$arrivedD, 'tDriverArrivedDate'=>$arrivedD, 'tStartDate'=>$startD, 'tEndDate'=>$orders->dDeliveryDate, 'iActive'=>'Finished', 'vTripPaymentMode'=>$orders->ePaymentOption,'vCurrencyPassenger'=>'XOF', 'vCurrencyDriver'=>'XOF', 'eDriverPaymentStatus'=>'Settelled', 'fTripGenerateFare'=>$orders->fTotalGenerateFare, 'vCountryUnitRider'=>'KMs','vCountryUnitDriver'=>'KMs','iUserAddressId'=>$orders->iUserAddressId, 'eRoundingTypeDriver'=>'Substraction']);
                   
                   
                        $check_driver_earn_wallet = DB::connection('mysql2')
                            ->table('user_wallet')
                            ->select('*')
                            ->where('tDescription','like', '#LBL_ADJUSTMENT_EARNING_ORDER#%'.$vorder)
                            ->where('ePaymentStatus','Settelled')
                            ->where('eUserType','Driver')
                            ->where('eType','Credit')
                            ->where('eFor','Deposit')
                            ->get();
                            
                        if($check_driver_earn_wallet->count()>0 && $check_driver_earn_wallet->count()==1){
                            
                             DB::connection('mysql2')
                                ->table('user_wallet')
                                ->where([
                                    'ePaymentStatus' => 'Settelled',
                                    'eUserType'=>'Driver',
                                    ['tDescription', 'LIKE', '#LBL_ADJUSTMENT_EARNING_ORDER#%'.$vorder],
                                ])
                                ->update([
                                    'iUserId' => $driverId
                                ]);  
                        }else{
                            
                            DB::connection('mysql2')
                            ->table('user_wallet')
                            //->where('iTripId',$iTripId)
                            ->where('tDescription', 'like', '#LBL_ADJUSTMENT_EARNING_ORDER#%'.$vorder)
                            ->where('eUserType','Driver')
                            ->where('eType','Credit')
                            ->where('eFor','Deposit')
                            ->delete();
                            
                            
                            DB::connection('mysql2')->table('user_wallet')->insert([
                                'iUserId' =>$driverId,
                                'vName' =>'',
                                'vLastName' =>'',
                                'vPhone' =>'',
                                'eUserType' =>'Driver',
                                'iBalance' => $fDeliveryCharge,
                                'eType' => 'Credit',
                                'iTripId' => $tripId,
                                'eFor' => 'Deposit',
                                'tDescription' => '#LBL_ADJUSTMENT_EARNING_ORDER#'.$vorder,
                                'ePaymentStatus' => 'Settelled',
                                'dDate' => $dDateWallet,
                                'fRatio_USD' => 0.0017000,
                                'fRatio_XOF' => 1.0000000,
                                'iOrderId'=>0,
                                'iTransactionId'=>'',
                                'fromUserId'=>0,
                                'fromUserType'=>'Driver',
                                'fromAdminId'=>'',
                                'service'=>'',
                                'serviceType'=>'',
                                'iBiddingPostId'=>0,
                                'iRentItemPostId'=>0,
                                'iTmpRentItemPostId'=>0,
                                'iBookingId'=>0,
                            ]);
                            
                            
                        }    
                        
                    
                        
                        $check_driver_wallet = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('*')
                        ->where('tDescription','like', '#LBL_DEBITED_BOOKING_DL#%'.$vorder)
                        ->where('ePaymentStatus','Settelled')
                        ->where('eUserType','Driver')
                        ->where('eType','Debit')
                        ->where('eFor','Withdrawl')
                        ->get(); 
                        
                        if($check_driver_wallet->count()>0 && $check_driver_wallet->count()==1){
                            
                             DB::connection('mysql2')
                                ->table('user_wallet')
                                ->where([
                                    'ePaymentStatus' => 'Settelled',
                                    'eUserType'=>'Driver',
                                    ['tDescription', 'LIKE', '#LBL_DEBITED_BOOKING_DL#'.$vorder],
                                ])
                                ->update([
                                    'iUserId' => $driverId
                                ]);
                        }else{
    
                             DB::connection('mysql2')
                            ->table('user_wallet')
                            //->where('iTripId',$iTripId)
                            ->where('tDescription', 'like', '#LBL_DEBITED_BOOKING_DL#%'.$vorder)
                            ->where('eUserType','Driver')
                            ->where('eType','Credit')
                            ->where('eFor','Deposit')
                            ->delete();
                            
                             DB::connection('mysql2')->table('user_wallet')->insert([
                                    'iUserId' => $driverId,
                                    'vName' =>'',
                                    'vLastName' =>'',
                                    'vPhone' =>'',
                                    'eUserType' => 'Driver',
                                    'iBalance' => $montantT,
                                    'eType' => 'Debit',
                                    'iTripId' => $tripId,
                                    'eFor' => 'Withdrawl',
                                    'tDescription' => '#LBL_DEBITED_BOOKING_DL#  '.$vorder.' ',
                                    'ePaymentStatus' => 'Settelled',
                                    'dDate' => $dDateWallet,
                                    'fRatio_USD' => '0.0016000',
                                    'fRatio_XOF' => '1.0000000',
                                    'iOrderId' => $orderId,
                                    'iTransactionId'=>'',
                                    'fromUserId'=>0,
                                    'fromUserType'=>'Driver',
                                    'fromAdminId'=>'',
                                    'service'=>'',
                                    'serviceType'=>'',
                                    'iBiddingPostId'=>0,
                                    'iRentItemPostId'=>0,
                                    'iTmpRentItemPostId'=>0,
                                    'iBookingId'=>0,
                                    // Add other columns and values here
                                ]);
                        }        
                        
                   
                    }
                        
                       
       
                }
        
                
            }
        } else {
            if ($trips->isEmpty()) {
                
                echo "Aucun enregistrement trouvé pour iOrderId = $orderId\n";
                
            } elseif ($trips->count() === 1) {
                
                //dd($trips);
                 foreach ($trips as $trip) {
                
                    $iTrip=$trip->iTripId;
                    $idDriver=$trip->iDriverId;
                    $fDeliveryCharge=$trip->fDeliveryCharge;
                
                
                    DB::table('orders')
                      ->where('iOrderId', $orderId)
                      ->update(['iDriverId' => $driverId,'iStatusCode'=>6]);  
                    
                    DB::table('register_driver')
                      ->where('iDriverId', $idDriver)
                      ->update(['iTripId' => $tripId,'vTripStatus'=>'Finished','vAvailability' => 'Available']);  
                      
                      
                    DB::table('trips')
                      ->where('iTripId', $tripId)
                      ->update(['iUserId'=>$orders->iUserId, 'iServiceId' =>$orders->iServiceId, 'iCompanyId'=>$orders->iCompanyId, 'tTripRequestDate'=>$arrivedD, 'tDriverArrivedDate'=>$arrivedD, 'tStartDate'=>$startD, 'tEndDate'=>$orders->dDeliveryDate, 'iActive'=>'Finished', 'vTripPaymentMode'=>$orders->ePaymentOption,'vCurrencyPassenger'=>'XOF', 'vCurrencyDriver'=>'XOF', 'eDriverPaymentStatus'=>'Settelled', 'fTripGenerateFare'=>$orders->fTotalGenerateFare, 'vCountryUnitRider'=>'KMs','vCountryUnitDriver'=>'KMs','iUserAddressId'=>$orders->iUserAddressId, 'eRoundingTypeDriver'=>'Substraction']);
             
                  
                   $check_driver_earn_wallet = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('*')
                        ->where('tDescription','like', '#LBL_ADJUSTMENT_EARNING_ORDER#%'.$vorder)
                        ->where('ePaymentStatus','Settelled')
                        ->where('eUserType','Driver')
                        ->where('eType','Credit')
                        ->where('eFor','Deposit')
                        ->get();
                            
                        if($check_driver_earn_wallet->count()>0 && $check_driver_earn_wallet->count()==1){
                            
                            DB::connection('mysql2')
                                ->table('user_wallet')
                                ->where([
                                    'ePaymentStatus' => 'Settelled',
                                    'eUserType'=>'Driver',
                                    ['tDescription', 'LIKE', '#LBL_ADJUSTMENT_EARNING_ORDER#%'.$vorder],
                                ])
                                ->update([
                                    'iUserId' => $driverId
                                ]);  
                        }else{
                            
                            DB::connection('mysql2')
                            ->table('user_wallet')
                            //->where('iTripId',$iTripId)
                            ->where('tDescription', 'like', '#LBL_ADJUSTMENT_EARNING_ORDER#%'.$vorder)
                            ->where('eUserType','Driver')
                            ->where('eType','Credit')
                            ->where('eFor','Deposit')
                            ->delete();
                            
                            
                            DB::connection('mysql2')->table('user_wallet')->insert([
                                'iUserId' =>$driverId,
                                'vName' =>'',
                                'vLastName' =>'',
                                'vPhone' =>'',
                                'eUserType' =>'Driver',
                                'iBalance' => $fDeliveryCharge,
                                'eType' => 'Credit',
                                'iTripId' => $tripId,
                                'eFor' => 'Deposit',
                                'tDescription' => '#LBL_ADJUSTMENT_EARNING_ORDER#'.$vorder,
                                'ePaymentStatus' => 'Settelled',
                                'dDate' => $dDateWallet,
                                'fRatio_USD' => 0.0017000,
                                'fRatio_XOF' => 1.0000000,
                                'iOrderId'=>0,
                                'iTransactionId'=>'',
                                'fromUserId'=>0,
                                'fromUserType'=>'Driver',
                                'fromAdminId'=>'',
                                'service'=>'',
                                'serviceType'=>'',
                                'iBiddingPostId'=>0,
                                'iRentItemPostId'=>0,
                                'iTmpRentItemPostId'=>0,
                                'iBookingId'=>0,
                            ]);
                            
                            
                        }    
                        
                    
                        
                        $check_driver_wallet = DB::connection('mysql2')
                        ->table('user_wallet')
                        ->select('*')
                        ->where('tDescription','like', '#LBL_DEBITED_BOOKING_DL#%'.$vorder)
                        ->where('ePaymentStatus','Settelled')
                        ->where('eUserType','Driver')
                        ->where('eType','Debit')
                        ->where('eFor','Withdrawl')
                        ->get(); 
                        
                        if($check_driver_wallet->count()>0 && $check_driver_wallet->count()==1){
                            
                             DB::connection('mysql2')
                                ->table('user_wallet')
                                ->where([
                                    'ePaymentStatus' => 'Settelled',
                                    'eUserType'=>'Driver',
                                    ['tDescription', 'LIKE', '#LBL_DEBITED_BOOKING_DL#'.$vorder],
                                ])
                                ->update([
                                    'iUserId' => $driverId
                                ]);
                        }else{
    
                             DB::connection('mysql2')
                            ->table('user_wallet')
                            //->where('iTripId',$iTripId)
                            ->where('tDescription', 'like', '#LBL_DEBITED_BOOKING_DL#%'.$vorder)
                            ->where('eUserType','Driver')
                            ->where('eType','Credit')
                            ->where('eFor','Deposit')
                            ->delete();
                            
                             DB::connection('mysql2')->table('user_wallet')->insert([
                                    'iUserId' => $driverId,
                                    'vName' =>'',
                                    'vLastName' =>'',
                                    'vPhone' =>'',
                                    'eUserType' => 'Driver',
                                    'iBalance' => $montantT,
                                    'eType' => 'Debit',
                                    'iTripId' => $tripId,
                                    'eFor' => 'Withdrawl',
                                    'tDescription' => '#LBL_DEBITED_BOOKING_DL#  '.$vorder.' ',
                                    'ePaymentStatus' => 'Settelled',
                                    'dDate' => $dDateWallet,
                                    'fRatio_USD' => '0.0016000',
                                    'fRatio_XOF' => '1.0000000',
                                    'iOrderId' => $orderId,
                                    'iTransactionId'=>'',
                                    'fromUserId'=>0,
                                    'fromUserType'=>'Driver',
                                    'fromAdminId'=>'',
                                    'service'=>'',
                                    'serviceType'=>'',
                                    'iBiddingPostId'=>0,
                                    'iRentItemPostId'=>0,
                                    'iTmpRentItemPostId'=>0,
                                    'iBookingId'=>0,
                                    // Add other columns and values here
                                ]);
                        }        
                        
                }
                
            }
        }

    
        // Réponse de succès
        return response()->json(['message' => 'Données mises à jour avec succès'], 200);
    }
    
    
    
    
    function formatNombreAvecEspaces($nombre) {
        // Utilise number_format avec un espace comme séparateur des milliers
        return number_format($nombre, 0, ',', ' ');
    }


    function login(){
        return view('layouts.login');
    }
}



























