<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
class Administration extends Controller
{

    public function index()
    {
        //return redirect()->route('dashboard-administration');
        return redirect()->route('dashboard-administration');
    }
    public function liste_driver(Request $request)
    {
        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;

        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

        // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $sqls='';
        $option2 = $request->input('option2');

        if($option2 == 'externe' && $startDate>0 && $endDate>0){
            $sqls="register_driver.vName LIKE 'DEX%' OR register_driver.vLastName LIKE 'DEX%'";
        }

        if($option2 == 'interne' && $startDate>0 && $endDate>0){
            $sqls="register_driver.vName LIKE 'D-%' OR register_driver.vLastName LIKE 'D-%'";
        }

        
        $drivers= DB::connection('mysql2')
        ->table('trips')
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->select('register_driver.iDriverId as DriverId','register_driver.vPhone as vPhone','register_driver.vEmail as vEmail',
            DB::raw('MAX(trips.tEndDate) as lastdate'),
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as Driver"),
            DB::raw('COUNT(trips.iTripId) as TotalCourse'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN 1 ELSE 0 END) as Completed'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" THEN 1 ELSE 0 END) as Annulation'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "Driver" THEN 1 ELSE 0 END) as DeDriver'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "Passenger" THEN 1 ELSE 0 END) as DeClient'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "" THEN 1 ELSE 0 END) as DeAdmin'),
            DB::raw('ROUND(SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN trips.fTripGenerateFare ELSE 0 END),0) as MontantCourse'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" THEN trips.fCancellationFare ELSE 0 END) as MontantAnnulation')
        )
        ->where('trips.eSystem', 'General')
        ->whereIn('trips.eHailTrip', ['No', 'Yes'])
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
        ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);

        if (!empty($sqls)) {
            $drivers->whereRaw($sqls);
        }
        
        $drivers = $drivers->groupBy('register_driver.iDriverId', 'register_driver.vName')->paginate($itemsPerPage);


        /*  */

        $drivers2= DB::connection('mysql2')
        ->table('trips')
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->select('register_driver.iDriverId as DriverId','register_driver.vPhone as vPhone','register_driver.vEmail as vEmail',
            DB::raw('MAX(trips.tEndDate) as lastdate'),
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as Driver"),
            DB::raw('COUNT(trips.iTripId) as TotalCourse'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN 1 ELSE 0 END) as Completed'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" THEN 1 ELSE 0 END) as Annulation'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "Driver" THEN 1 ELSE 0 END) as DeDriver'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "Passenger" THEN 1 ELSE 0 END) as DeClient'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "" THEN 1 ELSE 0 END) as DeAdmin'),
            DB::raw('ROUND(SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN trips.fTripGenerateFare ELSE 0 END),0) as MontantCourse'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" THEN trips.fCancellationFare ELSE 0 END) as MontantAnnulation')
        )
        ->where('trips.eSystem', 'General')
        ->whereIn('trips.eHailTrip', ['No', 'Yes'])
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
        ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
       
        if(!empty($sqls)) {
            $drivers2->whereRaw($sqls);
        }
        //->get();
        // Ajoutez des conditions pour filtrer les résultats par date
        //$drivers2->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
        $drivers2 = $drivers2->groupBy('register_driver.iDriverId', 'register_driver.vName')->get();
        return view('layouts.administration.liste_driver', compact('drivers','drivers2','startDate', 'endDate','option2'));
    }

    public function liste_users_conver()
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // Récupération des utilisateurs paginés
        $stores = DB::connection('mysql2')->table('company')->paginate($itemsPerPage);
        //return view('users.index', compact('users'));
        return view('layouts.administration.liste_store', compact('stores'));
    }

    public function liste_users_non_conver()
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // Récupération des utilisateurs paginés
        $stores = DB::connection('mysql2')->table('company')->paginate($itemsPerPage);
        //return view('users.index', compact('users'));
        return view('layouts.administration.liste_store', compact('stores'));
    }

    public function liste_user(Request $request)
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = '';//$request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = '';//$request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $option1 = $request->input('option1');
        $option11 = $request->input('option11');

        if( $option1=='all'){
            $startDate = '';
            $endDate = '';
        }

        $sqls11='';
       
        if($option11 == 'ios'){
            $sqls11="register_user.eDeviceType LIKE 'Ios'";
        }

        if($option11 == 'android'){
            $sqls11="register_user.eDeviceType LIKE 'Android'";
        }
        $users= DB::connection('mysql2')
        ->table('trips')
        ->join('register_user', 'trips.iUserId', '=', 'register_user.iUserId')
        ->select('register_user.iUserId as UserId','register_user.vPhone as vPhone','register_user.vEmail as vEmail',
            DB::raw('MAX(trips.tTripRequestDate) as lastdate'),
            DB::raw("CONCAT(register_user.vName, ' ', register_user.vLastName) as Client"),
            DB::raw('COUNT(trips.iTripId) as TotalCourse'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN 1 ELSE 0 END) as Completed'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" THEN 1 ELSE 0 END) as Annulation'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "Driver" THEN 1 ELSE 0 END) as DeDriver'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "Passenger" THEN 1 ELSE 0 END) as DeClient'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" AND trips.eCancelledBy = "" THEN 1 ELSE 0 END) as DeAdmin'),
            DB::raw('ROUND(SUM(CASE WHEN trips.iActive = "Finished" AND trips.eCancelled = "No" THEN trips.fTripGenerateFare ELSE 0 END),0) as MontantCourse'),
            DB::raw('SUM(CASE WHEN trips.iActive = "Canceled" AND trips.eCancelled = "Yes" THEN trips.fCancellationFare ELSE 0 END) as MontantAnnulation')
        )
        ->where('trips.eSystem', 'General')
        ->whereIn('trips.eHailTrip', ['No', 'Yes'])
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
        ->whereNotIn('register_user.vPhone', ['72210808', '78805461']);
        if($startDate>0 && $endDate>0){
            $users->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]);
        }else{
           
        }
        if(!empty($sqls11)) {
            $users->whereRaw($sqls11);
        }

        $users =  $users->groupBy('register_user.iUserId', 'register_user.vName')->get();

        //->get();
        // Ajoutez des conditions pour filtrer les résultats par date
        
        //$users = $users->get();

        return view('layouts.administration.liste_user', compact('users','startDate', 'endDate','option1','option11'));
    }


    public function liste_drive(Request $request)
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        
        $drives = DB::connection('mysql2')
        ->table('trips')
        ->join('register_user', 'trips.iUserId', '=','register_user.iUserId' )
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=','vehicle_type.iVehicleTypeId')
        ->join('company', 'company.iCompanyId', '=','register_driver.iCompanyId')
        ->select(
            'trips.iTripId as iTripId',
            'trips.vRideNo as vRideNo',
            DB::raw("CONCAT(register_user.vName, ' ', register_user.vLastName) as passenger"),
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as driver"),
            'company.vCompany as vCompanyName',
            'register_user.vPhone as vPhone',
            'register_driver.vPhone as vPhone_rd',
            'trips.tTripRequestDate as tDate',
            'trips.tDriverArrivedDate as arrivedDate',
            'trips.tStartDate as startDate',
            'trips.tEndDate as endDate',
            'trips.tSaddress as source',
            'trips.tDaddress as destination',
            'vehicle_type.vVehicleType_FR as categorie',
            'trips.fDuration as duree',
            'trips.fDistance as distance',
            'trips.fTripGenerateFare as total',
            'trips.fCommision as comission',
            'trips.vTripPaymentMode as paiement',
            'trips.iActive as status'
            )
          
            ->where('trips.iActive', '=', 'Finished')
            ->where('trips.eSystem', '=', 'General')
            ->where('trips.eType', '=', 'Ride')
            //->where('register_user.iUserId', '=', 'trips.iUserId')
            //->where('register_driver.iDriverId', '=', 'trips.iDriverId')
            //->where('trips.iVehicleTypeId', '=', 'vehicle_type.iVehicleTypeId')
            ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
            ->get();

        return view('layouts.administration.liste_drive', compact('drives','startDate', 'endDate'));
    }

    public function parcour_drive(Request $request)
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // utilisez les dates du mois en cours
        $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

            // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
        
        $parcours = DB::connection('mysql2')
        ->table('trips')
        ->join('register_user', 'trips.iUserId', '=','register_user.iUserId' )
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=','vehicle_type.iVehicleTypeId')
        ->join('company', 'company.iCompanyId', '=','register_driver.iCompanyId')
        ->select(
            'trips.iTripId as iTripId',
            'trips.vRideNo as vRideNo',
            DB::raw("CONCAT(register_user.vName, ' ', register_user.vLastName) as passenger"),
            DB::raw("CONCAT(register_driver.vName, ' ', register_driver.vLastName) as driver"),
            'company.vCompany as vCompanyName',
            'register_user.vPhone as vPhone',
            'register_driver.vPhone as vPhone_rd',
            'trips.tTripRequestDate as tDate',
            'trips.tDriverArrivedDate as arrivedDate',
            'trips.tStartDate as startDate',
            'trips.tEndDate as endDate',
            'trips.tSaddress as source',
            'trips.tDaddress as destination',
            'vehicle_type.vVehicleType_FR as categorie',
            'trips.fDuration as duree',
            'trips.fDistance as distance',
            'trips.fTripGenerateFare as total',
            'trips.fCommision as comission',
            'trips.vTripPaymentMode as paiement',
            'trips.iActive as status'
            )
          
            ->where('trips.iActive', '=', 'Finished')
            ->where('trips.eSystem', '=', 'General')
            ->where('trips.eType', '=', 'Ride')
            ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
            ->get();

        return view('layouts.administration.liste_parcour', compact('parcours','startDate', 'endDate'));
    }

    public function liste_store(Request $request)
    {


        // Nombre d'éléments à afficher par page
       $itemsPerPage = 6;
       // utilisez les dates du mois en cours
       $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
       $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

           // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
       if ($request->has('startDate') && $request->has('endDate')) {
           $startDate = $request->input('startDate');
           $endDate = $request->input('endDate');
       }


       $stores_d = DB::connection('mysql2')
       ->table('trips')
       //->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
       ->join('company', 'company.iCompanyId', '=', 'trips.iCompanyId')
       ->select(
           'company.iCompanyId as vIdentifiant',
           'company.vCompany as vCompanyName',
           'company.vPhone as vPhone',
           'company.tRegistrationDate as vDate',
           DB::raw('COUNT(trips.iTripId) as nbCommande'),
           DB::raw('ROUND(SUM(trips.fTripGenerateFare), 0) as montant'),
           //DB::raw('(SELECT COUNT(register_driver.iDriverId) FROM register_driver WHERE register_driver.iCompanyId = company.iCompanyId AND register_driver.eStatus = "Active") as nbvehicule')

       )
       ->where('trips.iActive', '=', 'Finished')
       ->where('trips.eSystem', '=', 'DeliverAll')
       ->where('trips.eType', '=', 'Ride')
       ->where('trips.iOrderId', '>', 0)
       ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
       ->groupBy(
           'company.iCompanyId',
           'company.vCompany',
           'company.vPhone',
           'company.tRegistrationDate'
       )
       ->get();
       


        $stores_d = DB::connection('mysql2')->table('company')->paginate($itemsPerPage);
        //return view('users.index', compact('users'));



        return view('layouts.administration.liste_store', compact('stores_d','startDate','endDate'));
    }

    public function liste_course()
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // Récupération des utilisateurs paginés
        $stores = DB::connection('mysql2')->table('company')->paginate($itemsPerPage);
        //return view('users.index', compact('users'));
        return view('layouts.administration.liste_store', compact('stores'));
    }

    public function liste_commande()
    {

        // Nombre d'éléments à afficher par page
        $itemsPerPage = 6;
        // Récupération des utilisateurs paginés
        $stores = DB::connection('mysql2')->table('company')->paginate($itemsPerPage);
        //return view('users.index', compact('users'));
        return view('layouts.administration.liste_store', compact('stores'));
    }


    public function liste_partner_store(Request $request)
    {

       // Nombre d'éléments à afficher par page
       $itemsPerPage = 6;
       // utilisez les dates du mois en cours
       $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
       $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));

           // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
       if ($request->has('startDate') && $request->has('endDate')) {
           $startDate = $request->input('startDate');
           $endDate = $request->input('endDate');
       }
        
       $stores = DB::connection('mysql2')
       ->table('trips')
       //->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
       ->join('company', 'company.iCompanyId', '=', 'trips.iCompanyId')
       ->select(
           'company.iCompanyId as vIdentifiant',
           'company.vCompany as vCompanyName',
           'company.vPhone as vPhone',
           'company.tRegistrationDate as vDate',
           DB::raw('COUNT(trips.iTripId) as nbCommande'),
           DB::raw('ROUND(SUM(trips.fTripGenerateFare), 0) as montant'),
           //DB::raw('(SELECT COUNT(register_driver.iDriverId) FROM register_driver WHERE register_driver.iCompanyId = company.iCompanyId AND register_driver.eStatus = "Active") as nbvehicule')

       )
       ->where('trips.iActive', '=', 'Finished')
       ->where('trips.eSystem', '=', 'DeliverAll')
       ->where('trips.eType', '=', 'Ride')
       ->where('trips.iOrderId', '>', 0)
       ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
       ->groupBy(
           'company.iCompanyId',
           'company.vCompany',
           'company.vPhone',
           'company.tRegistrationDate'
       )
       ->get();


        return view('layouts.administration.liste_partners_store', compact('stores','startDate', 'endDate'));
    }
    public function liste_partner_taxi(Request $request)
    {
       // Nombre d'éléments à afficher par page
       $itemsPerPage = 6;
       // utilisez les dates du mois en cours
       $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
       $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
           // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
       if ($request->has('startDate') && $request->has('endDate')) {
           $startDate = $request->input('startDate');
           $endDate = $request->input('endDate');
       }
       
        $taxis = DB::connection('mysql2')
            ->table('trips')
            ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
            ->join('company', 'company.iCompanyId', '=', 'register_driver.iCompanyId')
            ->select(
                'company.iCompanyId as vIdentifiant',
                'company.vCompany as vCompanyName',
                'company.vPhone as vPhone',
                'company.tRegistrationDate as vDate',
                DB::raw('COUNT(trips.iTripId) as nbCourse'),
                DB::raw('ROUND(SUM(trips.fTripGenerateFare), 0) as montant'),
                DB::raw('(SELECT COUNT(register_driver.iDriverId) FROM register_driver WHERE register_driver.iCompanyId = company.iCompanyId AND register_driver.eStatus = "Active") as nbvehicule')
    
            )
            ->where('trips.iActive', '=', 'Finished')
            ->where('trips.eSystem', '=', 'General')
            ->where('trips.eType', '=', 'Ride')
            ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
            ->groupBy(
                'company.iCompanyId',
                'company.vCompany',
                'company.vPhone',
                'company.tRegistrationDate'
        )
        ->get();

        return view('layouts.administration.liste_partners_taxi', compact('taxis','startDate', 'endDate'));
    }

    /* +===+**************Administration******************** +===+*/

    public function logistique()
    {
        $us = DB::connection('mysql2')->table('order_request')->count();

        // Utilisez var_dump() pour déboguer, commentez-le une fois que vous avez terminé le débogage
        //var_dump($us);

        return view('layouts.dashboard.logistique', compact('us'));
    }

    public function comptabilite()
    {
        $us = DB::connection('mysql2')->table('order_request')->count();

        // Utilisez var_dump() pour déboguer, commentez-le une fois que vous avez terminé le débogage
        //var_dump($us);

        return view('layouts.dashboard.comptabilite', compact('us'));
    }

   

    /* ******************************** */
    public function liste_deposit(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $option22 = $request->input('option22');
        $option33 = $request->input('option33');

        if($option22=='today'){
            $startDate = Carbon::now()->format('Y-m-d');
            $endDate = Carbon::now()->format('Y-m-d');
        }
        if($option22=='week'){
            $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));
        }
        if($option22=='month'){
            $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
        }
        if($option22=='other'){
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $sqls='';

        if($option33 == 'driver' && $startDate>0 && $endDate>0){
            $sqls="user_wallet.eUserType LIKE 'Driver' AND (register_driver.vName LIKE 'D%' OR register_driver.vLastName LIKE 'D%')";
        }
        

        if($option33 == 'user' && $startDate>0 && $endDate>0){
            $sqls="user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_USER#' AND user_wallet.eUserType LIKE 'Rider'";
        }

        if($option33 == 'admin' && $startDate>0 && $endDate>0){
            $sqls="user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_ADMIN%'";
        }

        if($option33 == 'deliver' && $startDate>0 && $endDate>0){
            $sqls="user_wallet.eUserType LIKE 'Driver' AND (register_driver.vName LIKE 'L%' OR register_driver.vLastName LIKE 'L%') ";
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        /*$deposits= DB::connection('mysql2')
        ->table('user_wallet')
        ->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->select('register_user.iUserId as iUserId','register_user.vName as name','register_user.vLastName as lastname','register_user.vPhone as vPhone','register_user.vEmail as vEmail','user_wallet.eType as type','user_wallet.eUserType as eusertype',DB::raw('ROUND(user_wallet.ibalance)  as montant'),'user_wallet.eFor as raison','user_wallet.tDescription as description','user_wallet.dDate as date')
        ->where('user_wallet.eType', 'Credit')
        ->where('user_wallet.eFor', 'Deposit')
        ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
        ->get();*/

        $deposits = DB::connection('mysql2')
        ->table('user_wallet')
        ->select(
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.iUserId, register_driver.iDriverId) as iUserId'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vName, register_driver.vName) as name'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vLastName, register_driver.vLastName) as lastname'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vPhone, register_driver.vPhone) as vPhone'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vEmail, register_driver.vEmail) as vEmail'),
            'user_wallet.eType as type',
            'user_wallet.eUserType as eusertype',
            DB::raw('ROUND(user_wallet.ibalance)  as montant'),
            'user_wallet.eFor as raison',
            'user_wallet.tDescription as description',
            'user_wallet.dDate as date'
        )
        ->where('user_wallet.eType', 'Credit')
        ->where('user_wallet.eFor', 'Deposit');
        if(!empty($sqls)) {
            $deposits->whereRaw($sqls);
        }
        $deposits->whereBetween('user_wallet.dDate', [$startDate, $endDate]);
       

        $deposits->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
            ->where('user_wallet.eUserType', '=', 'Rider');
        });
        $deposits->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
            ->where('user_wallet.eUserType', '=', 'Driver');
        });
        
        $deposits=$deposits->get();

        $total= DB::connection('mysql2')
        ->table('user_wallet')
        //->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Credit')
        ->where('user_wallet.eFor', 'Deposit');
        if(!empty($sqls)) {
            $total->whereRaw($sqls);
        }

        $total->whereBetween('user_wallet.dDate', [$startDate, $endDate]);
        
        $total->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
            ->where('user_wallet.eUserType', '=', 'Rider');
        });
        $total->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
            ->where('user_wallet.eUserType', '=', 'Driver');
        });
        $total= $total->value('montant');

        $total=$this->formatNombreAvecEspaces($total);

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_deposit', compact('deposits','total','startDate','endDate','option22','option33'));
    }

    public function liste_transaction(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

       $option1 = $request->input('option1');
       $option2 = $request->input('option2');



       if($option1=='today'){
            $startDate = Carbon::now()->format('Y-m-d');
            $endDate = Carbon::now()->format('Y-m-d');
        }
        if($option1=='week'){
            $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));
        }
        if($option1=='month'){
            $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
        }
        if($option1=='other'){
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        if($option2 == 'driver' && $startDate>0 && $endDate>0){
            $sqls="user_wallet.eUserType LIKE 'Driver' AND (register_driver.vName LIKE 'D%' OR register_driver.vLastName LIKE 'D%')";
        }

        if($option2 == 'user' && $startDate>0 && $endDate>0){
            $sqls="user_wallet.eUserType LIKE 'Rider'";
        }

        if($option2 == 'admin' && $startDate>0 && $endDate>0){
            $sqls="user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_ADMIN%'";
        }

        if($option2 == 'deliver' && $startDate>0 && $endDate>0){
            $sqls="user_wallet.eUserType LIKE 'Driver' AND (register_driver.vName LIKE 'L%' OR register_driver.vLastName LIKE 'L%')";
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        /*if($option2 == 'interne' && $startDate>0 && $endDate>0){
            $sqls="register_driver.vName LIKE 'D-%' OR register_driver.vLastName LIKE 'D-%'";
        }*/


        /*$transactions= DB::connection('mysql2')
        ->table('user_wallet')
        ->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->select('register_user.iUserId as iUserId','register_user.vName as name','register_user.vLastName as lastname','register_user.vPhone as vPhone','register_user.vEmail as vEmail','user_wallet.eType as type','user_wallet.eUserType as eusertype','user_wallet.ibalance as montant','user_wallet.eFor as raison','user_wallet.tDescription as description','user_wallet.dDate as date')
        ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
        ->get();*/

        $transactions = DB::connection('mysql2')
        ->table('user_wallet')
        ->select(
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.iUserId, register_driver.iDriverId) as iUserId'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vName, register_driver.vName) as name'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vLastName, register_driver.vLastName) as lastname'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vPhone, register_driver.vPhone) as vPhone'),
            DB::raw('IF(user_wallet.eUserType = "Rider", register_user.vEmail, register_driver.vEmail) as vEmail'),
            'user_wallet.eType as type',
            'user_wallet.eUserType as eusertype',
            DB::raw('ROUND(user_wallet.ibalance)  as montant'),
            'user_wallet.eFor as raison',
            'user_wallet.tDescription as description',
            'user_wallet.dDate as date'
        );
        if(!empty($sqls)) {
            $transactions->whereRaw($sqls);
        }
        $transactions->whereBetween('user_wallet.dDate', [$startDate, $endDate]);

        $transactions->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
                ->where('user_wallet.eUserType', '=', 'Rider');
        });
        $transactions->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
                ->where('user_wallet.eUserType', '=', 'Driver');
        });

        $transactions=$transactions->get();


        $credits= DB::connection('mysql2')
        ->table('user_wallet')
        //->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Credit');
        if(!empty($sqls)) {
            $credits->whereRaw($sqls);
        }
        $credits->whereBetween('user_wallet.dDate', [$startDate, $endDate]);
        

        $credits->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
            ->where('user_wallet.eUserType', '=', 'Rider');
        });
        $credits->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
            ->where('user_wallet.eUserType', '=', 'Driver');
        });
        $credits= $credits->value('montant');

        $debits= DB::connection('mysql2')
        ->table('user_wallet')
        //->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Debit');
        if(!empty($sqls)) {
            $debits->whereRaw($sqls);
        }
        $debits->whereBetween('user_wallet.dDate', [$startDate, $endDate]);

    
        $debits->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
            ->where('user_wallet.eUserType', '=', 'Rider');
        });
        $debits->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
            ->where('user_wallet.eUserType', '=', 'Driver');
        });

        $debits= $debits->value('montant');

        $balance=$credits-$debits;
        $debits=$this->formatNombreAvecEspaces($debits);
        $credits=$this->formatNombreAvecEspaces($credits);
        $balance=$this->formatNombreAvecEspaces($balance);

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
        return view('layouts.administration.liste_transaction', compact('transactions','debits','credits','balance','startDate','endDate','option1','option2'));
    }


    public function liste_wallet_statistic(){

        return view('layouts.administration.liste_wallet_statistic');

    }




    function formatNombreAvecEspaces($nombre) {
        // Utilise number_format avec un espace comme séparateur des milliers
        return number_format($nombre, 0, ',', ' ');
    }


    function login(){
        return view('layouts.login');
    }
}
