<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;

class Dashboard extends Controller
{

    public function index()
    {
        // Logique pour récupérer et afficher une liste de demandes de commandes (order requests)
        $us = DB::connection('mysql2')->table('order_request')->count();

        // Utilisez dd() pour déboguer, commentez-le une fois que vous avez terminé le débogage
        //dd($us);

        // Retourne la vue avec les données récupérées
        return view('layouts.dashboard.index');
    }

    public function administration(Request $request)
    {

        $startDate = $request->input('startDate', Carbon::now()->startOfYear()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));

        $option1 = $request->input('option1');

        if( $option1=='all'){
            $startDate = '2020-08-01';
            $endDate = Carbon::now()->format('Y-m-d');
        }
        
        if( $option1=='currenty'){
            $startDate = $request->input('startDate', Carbon::now()->startOfYear()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));
        }

        if( $option1=='currentm'){
            $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
        }
        if( $option1=='currentw'){
            $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));
        }

        if( $option1=='today'){
            $startDate = Carbon::now()->format('Y-m-d');
            $endDate = Carbon::now()->format('Y-m-d');
        }
       if( $option1=='interval'){
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
 
         // Si le formulaire a été soumis, mettez à jour les dates avec les nouvelles valeurs
        /* if ($request->has('startDate') && $request->has('endDate')) {
             $startDate = $request->input('startDate');
             $endDate = $request->input('endDate');

             $startDate = DateTime::createFromFormat('d/m/Y', $startDate)->format('Y-m-d');
             $endDate = DateTime::createFromFormat('d/m/Y', $endDate)->format('Y-m-d');
         }*/

         $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        /* Panier moyen course */

       $averageTripGenerateFare = DB::connection('mysql2')->table('trips')
        ->where('iActive', 'Finished')
        ->where('eSystem', 'General')
        ->where('eType', 'Ride')
        ->where('eCancelled', 'No')
        ->whereBetween('tTripRequestDate', [$startDate, $endDate])
        ->avg('fTripGenerateFare');
        $averageTripGenerateFare =$this->formatNombreAvecEspaces($averageTripGenerateFare );
        /* Panier moyen plat */

        $averageSubTotal = DB::connection('mysql2')->table('orders')
        ->where('iStatusCode', 6)
        ->whereBetween('tOrderRequestDate', [$startDate, $endDate])
        ->whereNotIn('iCompanyId', [2, 87, 40])
        ->avg('fSubTotal');
        $averageSubTotal=$this->formatNombreAvecEspaces($averageSubTotal);

        /****************Nombre de commande trips, colis, repas**************** */
        $subquery = DB::connection('mysql2')->table('trips')
        ->select('iUserId')
        ->where('iActive', 'Finished')
        //->whereBetween('tTripRequestDate', [$startDate, $endDate])
        ->whereIn('eSystem', ['DeliverAll', 'General'])
        ->where('eCancelled', 'No');
    
        $countNbcom = DB::connection('mysql2')->table('register_user')
        ->whereBetween('nRegistrationDate', [$startDate, $endDate])
        ->whereIn('iUserId', $subquery)
        ->count();
        $countNbcom=$this->formatNombreAvecEspaces($countNbcom);
        /************Commande par portefeuille*************** */

        $countTp = DB::connection('mysql2')->table('orders')
        ->where('iStatusCode', 6)
        ->whereBetween('tOrderRequestDate', [$startDate, $endDate])
        ->where('ePaymentOption', 'Card')
        ->count();
        $countTp=$this->formatNombreAvecEspaces($countTp);
        /* +====All trips (drivers + orders+colis ===+  */

        $allDrive = DB::connection('mysql2')->table('trips')
        ->where('eSystem', 'General')
        ->whereBetween('tTripRequestDate', [$startDate, $endDate])
        ->whereIn('eHailTrip', ['No', 'Yes'])
        ->whereNotIn('eType', ['Deliver', 'Multi-Delivery'])
        ->count();
         /*     All trips(drive)        */
        $countAllDrive = DB::connection('mysql2')->table('trips')
        ->where('iActive', 'Finished')
        ->where('eCancelled', 'No')
        ->where('eSystem', 'General')
        ->whereBetween('tTripRequestDate', [$startDate, $endDate])
        ->whereIn('eHailTrip', ['No', 'Yes'])
        ->whereNotIn('eType', ['Deliver', 'Multi-Delivery'])
        ->count();
       
         /*       Somme trips (drive)        */
        $sumDrive = DB::connection('mysql2')
        ->table('trips')
        ->select(DB::raw('SUM(fTripGenerateFare) as totalTripgenerate'))
        ->where('iActive', 'Finished')
        ->where('eCancelled', 'No')
        ->where('eSystem', 'General')
        ->whereBetween('tTripRequestDate', [$startDate, $endDate])
        ->whereIn('eHailTrip', ['No', 'Yes'])
        ->whereNotIn('eType', ['Deliver', 'Multi-Delivery'])
        ->value('totalTripgenerate');
        

        $countAllDriveCancel = DB::connection('mysql2')->table('trips')
        ->where('iActive', 'Canceled')
        ->where('eCancelled', 'Yes')
        ->where('eSystem', 'General')
        ->whereBetween('tTripRequestDate', [$startDate, $endDate])
        ->whereIn('eHailTrip', ['No', 'Yes'])
        ->whereNotIn('eType', ['Deliver', 'Multi-Delivery'])
        ->count();

        /*$countAllDriverCancel = DB::connection('mysql2')
        ->table('trips')
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->select('trips.iDriverId', DB::raw('COUNT(*) as cancelCount'))
        ->where('iActive', 'Canceled')
        ->where('eCancelled', 'Yes')
        ->where('eSystem', 'General')
        ->whereIn('eHailTrip', ['No', 'Yes'])
        ->whereNotIn('eType', ['Deliver', 'Multi-Delivery'])
        ->groupBy('trips.iDriverId')
        ->get();*/

        /* ==== Les drivers qui ont annulés des courses   ===*/
        $countAllDriverCancel = DB::connection('mysql2')
        ->table('trips')
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->select(DB::raw('COUNT(DISTINCT trips.iDriverId) as uniqueDriversCanceledCount'))
        ->where('iActive', 'Canceled')
        ->where('eCancelled', 'Yes')
        ->where('eSystem', 'General')
        ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
        ->whereIn('eHailTrip', ['No', 'Yes'])
        ->whereNotIn('eType', ['Deliver', 'Multi-Delivery'])
        //->where('register_driver.eStatus', 'Active') 
        ->value('uniqueDriversCanceledCount');

        /* +==+ Les drivers qui ont effectué une courses +==+ */

        $countAllDriverForTrips= DB::connection('mysql2')
        ->table('trips')
        ->join('register_driver', 'trips.iDriverId', '=', 'register_driver.iDriverId')
        ->select(DB::raw('COUNT(DISTINCT trips.iDriverId) as uniqueDriversTripCount'))
        //->where('iActive', 'Canceled')
        //->where('eCancelled', 'Yes')
        ->where('eSystem', 'General')
        ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate])
        ->whereIn('eHailTrip', ['No', 'Yes'])
        ->whereNotIn('eType', ['Deliver', 'Multi-Delivery'])
        //->where('register_driver.eStatus', 'Active') 
        ->value('uniqueDriversTripCount');

        /* +==+  Somme des commandes +==+ */
        $sumOrder =  DB::connection('mysql2')->table('orders')
        ->select(DB::raw('SUM(orders.fTotalGenerateFare) as totalGenerate'))
        ->join('company', 'orders.iCompanyId', '=', 'company.iCompanyId')
        ->where('iStatusCode', 6)
        ->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate])
        ->whereNotIn('company.iCompanyId', [2, 87, 40])
        ->value('totalGenerate');

        $countAllOrder =  DB::connection('mysql2')->table('orders')
        ->join('company', 'orders.iCompanyId', '=', 'company.iCompanyId')
        ->where('iStatusCode', 6)
        ->whereBetween('orders.tOrderRequestDate', [$startDate, $endDate])
        ->whereNotIn('company.iCompanyId', [2, 87, 40])
        ->count();
       

        $countAllUser = DB::connection('mysql2')->table('register_user')
        ->whereNotNull('nRegistrationDate')
        ->whereBetween('nRegistrationDate', [$startDate, $endDate])
        ->where('vManualBooking', 'No')
        ->count();

        $countAllDriver = DB::connection('mysql2')->table('register_driver')
        ->whereNotNull('nRegistrationDate')
        ->whereBetween('nRegistrationDate', [$startDate, $endDate])
       // ->where('eStatus', 'Active')
        ->count();
        /* les drivers actifs */
        $countAllDriverActive = DB::connection('mysql2')->table('register_driver')
        ->whereNotNull('nRegistrationDate')
        ->where('eStatus', 'Active')
        ->whereBetween('nRegistrationDate', [$startDate, $endDate])
        ->count();
       

        $countOrderCanceled = DB::connection('mysql2')->table('orders')
        ->whereIn('iStatusCode', ['9', '8', '7'])
        ->whereBetween('tOrderRequestDate', [$startDate, $endDate])
        ->whereNotIn('iCompanyId', [2, 87, 40])
        ->count();
        //$countOrderCanceled =2;
        $countColis = DB::connection('mysql2')->table('trips')
        ->where('iActive', 'Finished')
        ->where('eSystem', 'General')
        ->where('eCancelled', 'No')
        ->whereBetween('tTripRequestDate', [$startDate, $endDate])
        ->whereIn('eType', ['Deliver', 'MultiDelivery'])
        ->count();

        $sumColis = DB::connection('mysql2')->table('trips')
        ->select(DB::raw('SUM(fTripGenerateFare) as totalTripgenerate'))
        ->where('iActive', 'Finished')
        ->where('eSystem', 'General')
        ->where('eCancelled', 'No')
        ->whereBetween('tTripRequestDate', [$startDate, $endDate])
        ->whereIn('eType', ['Deliver', 'MultiDelivery'])
        ->value('totalTripgenerate');

        /*  +==+ Wallet transaction debit credit +==+    */
         /*****Transaction******/
         $transactions= DB::connection('mysql2')
         ->table('user_wallet')
         ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
         ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
         ->leftJoin('register_user', function($join) {
             $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
             ->where('user_wallet.eUserType', '=', 'Rider');
         })
         ->leftJoin('register_driver', function($join) {
             $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
             ->where('user_wallet.eUserType', '=', 'Driver');
         })
         ->value('montant');
        /*****Credit******/
        $credits= DB::connection('mysql2')
        ->table('user_wallet')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Credit')
        ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
        ->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
            ->where('user_wallet.eUserType', '=', 'Rider');
        })
        ->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
            ->where('user_wallet.eUserType', '=', 'Driver');
        })
        ->value('montant');

        /*****Dedit******/
        $debits= DB::connection('mysql2')
        ->table('user_wallet')
        //->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Debit')
        ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
        ->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
            ->where('user_wallet.eUserType', '=', 'Rider');
        })
        ->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
            ->where('user_wallet.eUserType', '=', 'Driver');
        })
        ->value('montant');

        $balance=$credits-$debits;
        $transactions=$this->formatNombreAvecEspaces($transactions);
        $debits=$this->formatNombreAvecEspaces($debits);
        $credits=$this->formatNombreAvecEspaces($credits);
        $balances=$this->formatNombreAvecEspaces($balance);
        /*                Fin                     */
        
        $tauxAnnulationOrder=0; $tauxDriverCancel=0; $tauxAnnulationDrive=0;
        $sumTotal=$sumColis+$sumOrder+$sumDrive;
        if($allDrive>0){
             $tauxAnnulationDrive= round(($countAllDriveCancel/$allDrive)*100,2);
        }
        if($countAllOrder>0){
            $tauxAnnulationOrder= round(($countOrderCanceled/$countAllOrder)*100,2);
        }
       /* if($countAllDriverActive>0){
            $tauxDriverCancel= round(($countAllDriverCancel/ $countAllDriverActive)*100,2);
        }*/
        if($countAllDriverForTrips>0){
            $tauxDriverCancel= round(($countAllDriverCancel/ $countAllDriverForTrips)*100,2);
        }
        

        $countAllDrive=$this->formatNombreAvecEspaces($countAllDrive);
        $sumDrive=$this->formatNombreAvecEspaces(round($sumDrive,0));
        $countAllOrder=$this->formatNombreAvecEspaces($countAllOrder);
        $countAllUser=$this->formatNombreAvecEspaces($countAllUser);
        $countColis=$this->formatNombreAvecEspaces($countColis);
        $countAllDriveCancel=$this->formatNombreAvecEspaces($countAllDriveCancel);
        $sumOrder=$this->formatNombreAvecEspaces($sumOrder);
        $sumColis=$this->formatNombreAvecEspaces($sumColis);

        $sumTotal=$this->formatNombreAvecEspaces($sumTotal);
        $countAllDriver=$this->formatNombreAvecEspaces($countAllDriver);

        $allDrive=$this->formatNombreAvecEspaces($allDrive);

        
        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
    
        return view('layouts.dashboard.administration', compact('countAllDrive','sumDrive','countAllDriveCancel','tauxAnnulationDrive','countAllOrder','sumOrder','countOrderCanceled','tauxAnnulationOrder','countColis','sumColis','countAllUser','countAllDriver','countAllDriverActive','countAllDriverCancel','tauxDriverCancel','sumTotal','allDrive','averageTripGenerateFare','averageSubTotal','countNbcom','countTp','startDate', 'endDate','option1','transactions','debits','credits','balances'));
    
    }

    public function logistique()
    {
        $us = DB::connection('mysql2')->table('order_request')->count();

        // Utilisez var_dump() pour déboguer, commentez-le une fois que vous avez terminé le débogage
        var_dump($us);

        return view('layouts.dashboard.logistique', compact('us'));
    }

    public function comptabilite()
    {
        $us = DB::connection('mysql2')->table('order_request')->count();

        // Utilisez var_dump() pour déboguer, commentez-le une fois que vous avez terminé le débogage
        var_dump($us);

        return view('layouts.dashboard.comptabilite', compact('us'));
    }


    /******************************************************* Wallet transaction  ************************************************ */

    public function wallet(Request $request)
    {

        $startDate = $request->input('startDate', Carbon::now()->startOfYear()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));

        $option4 = $request->input('option4');

        if( $option4=='all'){
            $startDate = '2020-08-01';
            $endDate = Carbon::now()->format('Y-m-d');
        }
        
        if( $option4=='currenty'){
            $startDate = $request->input('startDate', Carbon::now()->startOfYear()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));
        }

        if( $option4=='currentm'){
            $startDate = $request->input('startDate', Carbon::now()->startOfMonth()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfMonth()->format('Y-m-d'));
        }
        if( $option4=='currentw'){
            $startDate = $request->input('startDate', Carbon::now()->startOfWeek()->format('Y-m-d'));
            $endDate = $request->input('endDate', Carbon::now()->endOfWeek()->format('Y-m-d'));
        }

        if( $option4=='today'){
            $startDate = Carbon::now()->format('Y-m-d');
            $endDate = Carbon::now()->format('Y-m-d');
        }
       if( $option4=='interval'){
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }
 
       
        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        /*  +==+ Wallet transaction debit credit +==+    */
         /* Transaction */
         $transactions= DB::connection('mysql2')
         ->table('user_wallet')
         ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
         ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
         ->leftJoin('register_user', function($join) {
             $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
             ->where('user_wallet.eUserType', '=', 'Rider');
         })
         ->leftJoin('register_driver', function($join) {
             $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
             ->where('user_wallet.eUserType', '=', 'Driver');
         })
         ->value('montant');
        /* Credit */
        $credits= DB::connection('mysql2')
        ->table('user_wallet')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Credit')
        ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
        ->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
            ->where('user_wallet.eUserType', '=', 'Rider');
        })
        ->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
            ->where('user_wallet.eUserType', '=', 'Driver');
        })
        ->value('montant');

        /* Dedit */
        $debits= DB::connection('mysql2')
        ->table('user_wallet')
        //->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
        ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
        ->where('user_wallet.eType', 'Debit')
        ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
        ->leftJoin('register_user', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_user.iUserId')
            ->where('user_wallet.eUserType', '=', 'Rider');
        })
        ->leftJoin('register_driver', function($join) {
            $join->on('user_wallet.iUserId', '=', 'register_driver.iDriverId')
            ->where('user_wallet.eUserType', '=', 'Driver');
        })
        ->value('montant');
        /*Fin*/
        /* recharge */

                /* Credit total*/
                $sqlst="user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_%'";
                $credit_totals= DB::connection('mysql2')
                ->table('user_wallet')
                ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
                ->where('user_wallet.eType', 'Credit')
                ->where('user_wallet.eFor', 'Deposit')
                ->whereRaw($sqlst)
                ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
                ->value('montant');

                /****Fin */
                /* Credit client*/

                $credit_clients= DB::connection('mysql2')
                ->table('user_wallet')
                ->join('register_user', 'user_wallet.iUserId', '=', 'register_user.iUserId')
                ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
                ->where('user_wallet.eType', 'Credit')
                ->where('user_wallet.eFor', 'Deposit')
                ->where('user_wallet.eUserType', 'Rider')
                 ->where('user_wallet.tDescription','LIKE' ,'#LBL_AMOUNT_CREDIT_BY_USER#')
                ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
                ->value('montant');

                /****Fin */
                /* Credit driver*/

                $sqlsd="(register_driver.vName LIKE 'D%' OR register_driver.vLastName LIKE 'D%') AND user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_USER%'";
                $credit_drivers= DB::connection('mysql2')
                ->table('user_wallet')
                ->join('register_driver', 'user_wallet.iUserId', '=', 'register_driver.iDriverId')
                ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
                ->where('user_wallet.eType', 'Credit')
                ->where('user_wallet.eFor', 'Deposit')
                ->where('user_wallet.eUserType', 'Driver')
                //->where('user_wallet.tDescription','LIKE' ,'#LBL_AMOUNT_CREDIT_BY_USER')
                ->whereRaw($sqlsd)
                ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
                ->value('montant');

                /****Fin */
                /* Credit livreur*/

                $sqlsl="(register_driver.vName LIKE 'L%' OR register_driver.vLastName LIKE 'L%') AND user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_USER%'";
                $credit_delivers= DB::connection('mysql2')
                ->table('user_wallet')
                ->join('register_driver', 'user_wallet.iUserId', '=', 'register_driver.iDriverId')
                ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
                ->where('user_wallet.eType', 'Credit')
                ->where('user_wallet.eFor', 'Deposit')
                ->where('user_wallet.eUserType', 'Driver')
                //->where('user_wallet.tDescription','LIKE' ,'#LBL_AMOUNT_CREDIT_BY_USER')
                ->whereRaw($sqlsl)
                ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
                ->value('montant');
                /****Fin */

                  /* Credit admin*/

                  $sqlsa="user_wallet.tDescription LIKE '#LBL_AMOUNT_CREDIT_BY_ADMIN%'";
                  $credit_admins= DB::connection('mysql2')
                  ->table('user_wallet')
                  ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
                  ->where('user_wallet.eType', 'Credit')
                  ->where('user_wallet.eFor', 'Deposit')
                  ->whereRaw($sqlsa)
                  ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
                  ->value('montant');
                  /****Fin */

                   /* Credit admin*/

                   $sqlsg="user_wallet.tDescription LIKE '#LBL_DEBITED_SITE_EARNING_BOOKING#%'";
                   $debit_gains= DB::connection('mysql2')
                   ->table('user_wallet')
                   ->select(DB::raw('ROUND(SUM(user_wallet.iBalance), 0) as montant'))
                   ->where('user_wallet.eType', 'Debit')
                   ->where('user_wallet.eFor', 'Withdrawl')
                   ->whereRaw($sqlsg)
                   ->whereBetween('user_wallet.dDate', [$startDate, $endDate])
                   ->value('montant');
                   /****Fin */
                  
//Withdrawl #LBL_DEBITED_SITE_EARNING_BOOKING#126500915
        /** Fin ***/
        $balance=$credits-$debits;
        $transactions=$this->formatNombreAvecEspaces($transactions);
        $debits=$this->formatNombreAvecEspaces($debits);
        $credits=$this->formatNombreAvecEspaces($credits);
        $balances=$this->formatNombreAvecEspaces($balance);
        /*                Fin                     */
        $credit_totals=$this->formatNombreAvecEspaces($credit_totals);
        $credit_clients=$this->formatNombreAvecEspaces($credit_clients);
        $credit_drivers=$this->formatNombreAvecEspaces($credit_drivers);
        $credit_delivers=$this->formatNombreAvecEspaces($credit_delivers);
        $credit_admins=$this->formatNombreAvecEspaces($credit_admins);
        $debit_gains=$this->formatNombreAvecEspaces($debit_gains);

        $endDate = date('Y-m-d', strtotime($endDate . ' - 1 day'));
    
        return view('layouts.dashboard.wallet', compact('startDate', 'endDate','option4','transactions','debits','credits','balances','credit_totals','credit_drivers','credit_clients','credit_delivers','credit_admins','debit_gains'));
    
    }








    

    function formatNombreAvecEspaces($nombre) {
        // Utilise number_format avec un espace comme séparateur des milliers
        return number_format($nombre, 0, ',', ' ');
    }
    
    

    /** +===+ Graphiques +===+ */
    /* ******************************** */
    public function getChartData(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->startOfYear()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        try {

        $chartData = DB::connection('mysql2')->table('trips')
        ->join('vehicle_type', 'trips.iVehicleTypeId', '=', 'vehicle_type.iVehicleTypeId')
        ->select('vehicle_type.vVehicleType_FR as categorie', DB::raw('COUNT(*) as nombre'))
        ->where('trips.iActive', 'Finished')
        ->where('trips.eCancelled', 'No')
        ->where('trips.eSystem', 'General')
        ->whereIn('trips.eHailTrip', ['No', 'Yes'])
        ->whereIn('vehicle_type.vVehicleType_FR', ['Economique', 'Confort'])
        ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
        ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]) // Ajoutez cette condition pour filtrer par date
        ->groupBy('vehicle_type.vVehicleType_FR')
        ->get();

        //var_dump($chartData);
        return response()->json($chartData);

        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    public function getChartDataDevice(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->startOfYear()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        try {

            $chartDataDevice = DB::connection('mysql2')->table('trips')
            ->join('register_user', 'register_user.iUserId', '=', 'trips.iUserId')
            ->select('register_user.eDeviceType as device', DB::raw('COUNT(*) as nombre'))
            ->where('trips.iActive', 'Finished')
            ->where('trips.eCancelled', 'No')
            ->where('trips.eSystem', 'General')
            ->whereIn('trips.eHailTrip', ['No', 'Yes'])
            ->whereNotIn('trips.eType', ['Deliver', 'Multi-Delivery'])
            ->whereBetween('trips.tTripRequestDate', [$startDate, $endDate]) // Ajoutez cette condition pour filtrer par date
            ->groupBy('register_user.eDeviceType')
            ->get();

            //var_dump($chartData);
            return response()->json($chartDataDevice);

        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    public function getChartDataWallet(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->startOfYear()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));

        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

        try {
            /*$chartDataWallet = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('eUserType as type', 'tDescription as description', DB::raw('ROUND(SUM(iBalance), 0) as montant'))
                ->where('eType', 'Credit')
                ->where('eFor', 'Deposit')
                ->whereIn('tDescription', ['#LBL_AMOUNT_CREDIT_BY_USER', '#LBL_AMOUNT_CREDIT_BY_ADMIN'])
                ->whereBetween('dDate', [$startDate, $endDate])
                ->groupBy('eUserType', 'tDescription')
                ->get();*/
            
            $chartDataWallet = DB::connection('mysql2')
                ->table('user_wallet')
                ->select('eUserType as type', DB::raw('ROUND(SUM(iBalance), 0) as montant'))
                ->where('eType', 'Credit')
                ->where('eFor', 'Deposit')
                ->where('tDescription','like', '#LBL_AMOUNT_CREDIT_BY_USER%')
                ->whereBetween('dDate', [$startDate, $endDate])
                ->groupBy('eUserType')
                ->get();


            // Conditionally set category based on description
           /* $chartDataWallet = $chartDataWallet->map(function ($dataPoint) {
                // Determine the category based on the description
                $category = (strpos($dataPoint->description, '#LBL_AMOUNT_CREDIT_BY_USER%') !== false) ? 'user' : 'admin';

                // Set the category in the result
                $dataPoint->category = $category;

                return $dataPoint;
            });*/

            return response()->json($chartDataWallet);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }


    public function getChartDataPanierMoins(Request $request)
    {
            //SELECT  AVG(fTripGenerateFare)  as moyen FROM  trips WHERE  iActive = 'Finished' AND eSystem = 'General' AND eType = 'Ride' AND eCancelled = 'No';
            //SELECT avg(fSubTotal) as moyen from orders where iStatusCode=6 and iCompanyId not in (2,87,40)
            //$startDate = Carbon::now()->startOfYear()->format('Y-m-d');//$request->input('startDate', Carbon::now()->startOfYear()->format('Y-m-d'));
            //$endDate = Carbon::now()->endOfYear()->format('Y-m-d');//$request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));


        $startDate = $request->input('startDate', Carbon::now()->startOfYear()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }

        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));

            $allMonths = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

            // Récupérez les données pour les courses
            $chartDataTripPanier = DB::connection('mysql2')
                ->table('trips')
                ->select(
                    DB::raw("MONTHNAME(tTripRequestDate) as month"),
                    DB::raw('ROUND(AVG(fTripGenerateFare), 0) as course')
                )
                ->where('iActive', 'Finished')
                ->where('eSystem', 'General')
                ->where('eType', 'Ride')
                ->where('eCancelled', 'No')
                ->whereBetween('tTripRequestDate', [$startDate, $endDate])
                ->groupBy('month')
                ->get();
    
            // Récupérez les données pour les commandes
            $chartDataOrderPanier = DB::connection('mysql2')
                ->table('orders')
                ->select(
                    DB::raw("MONTHNAME(tOrderRequestDate) as month"),
                    DB::raw('ROUND(AVG(fSubTotal), 0) as commande')
                )
                ->where('iStatusCode', 6)
                ->whereNotIn('iCompanyId', [2, 87, 40])
                ->whereBetween('tOrderRequestDate', [$startDate, $endDate])
                ->groupBy('month')
                ->get();

            $data = [
                'labels' => $allMonths,
                'datasets' => [
                    [
                        'label' => 'Courses',
                        'backgroundColor' => 'rgba(60,141,188,0.9)',
                        'borderColor' => 'rgba(60,141,188,0.8)',
                        'data' => array_fill_keys($allMonths, 0),
                    ],
                    [
                        'label' => 'Commandes',
                        'backgroundColor' => 'rgba(210, 214, 222, 1)',
                        'borderColor' => 'rgba(210, 214, 222, 1)',
                        'data' => array_fill_keys($allMonths, 0),
                    ],
                ],
            ];
    
            // Remplir les données de courses dans le tableau
            foreach ($chartDataTripPanier as $result) {
                $month = $result->month;
                $data['datasets'][0]['data'][$month] = $result->course;
            }

            // Remplir les données de commandes dans le tableau
            foreach ($chartDataOrderPanier as $result) {
                $month = $result->month;
                $data['datasets'][1]['data'][$month] = $result->commande;
            }


            // Convertir les tableaux associatifs en tableaux numériques pour Chart.js
            $data['datasets'][0]['data'] = array_values($data['datasets'][0]['data']);
            $data['datasets'][1]['data'] = array_values($data['datasets'][1]['data']);

                
            return response()->json($data);
    }

    public function getChartDataCompareTripLastYear(Request $request)
    {
        $startDate = $request->input('startDate', Carbon::now()->startOfYear()->format('Y-m-d'));
        $endDate = $request->input('endDate', Carbon::now()->endOfYear()->format('Y-m-d'));

           
        if ($request->has('startDate') && $request->has('endDate')) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');
        }



       /* $startDate = Carbon::now()->startOfYear()->format('Y-m-d');
        $endDate = Carbon::now()->endOfYear()->format('Y-m-d');*/

        // Create a Carbon instance from the start date
        $startDateCarbon = Carbon::parse($startDate);

        // Obtenez l'année précédente en soustrayant un an à la date sélectionnée
        $previousYear = $startDateCarbon->subYear();

        // Obtenez la date de début de l'année précédente
        $startDate2 = $previousYear->startOfYear()->format('Y-m-d');

        // Obtenez la date de fin de l'année précédente
        $endDate2 = $previousYear->endOfYear()->format('Y-m-d');
        $data = [
            'labels' => ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
            'datasets' => [],
        ];


        $endDate = date('Y-m-d', strtotime($endDate . ' + 1 day'));
        // Récupérez les données pour les courses
        $chartDataTripNewYear = DB::connection('mysql2')
            ->table('trips')
            ->select(
                DB::raw("MONTHNAME(tTripRequestDate) as month"),
                DB::raw('ROUND(COUNT(iTripId), 0) as course2')
            )
            ->where('iActive', 'Finished')
            ->where('eSystem', 'General')
            ->where('eType', 'Ride')
            ->where('eCancelled', 'No')
            ->whereBetween('tTripRequestDate', [$startDate, $endDate])
            ->groupBy('month')
            ->get();

        $chartDataTripLastYear = DB::connection('mysql2')
            ->table('trips')
            ->select(
                DB::raw("MONTHNAME(tTripRequestDate) as month"),
                DB::raw('ROUND(COUNT(iTripId), 0) as course1')
            )
            ->where('iActive', 'Finished')
            ->where('eSystem', 'General')
            ->where('eType', 'Ride')
            ->where('eCancelled', 'No')
            ->whereBetween('tTripRequestDate', [$startDate2, $endDate2])
            ->groupBy('month')
            ->get();


            // Remplissez les datasets
            $data['datasets'][] = [
                'label' => 'Année',
                'backgroundColor' => 'rgba(60,141,188,0.9)',
                'borderColor' => 'rgba(60,141,188,0.8)',
                'data' => $chartDataTripNewYear->pluck('course2')->toArray(),
            ];

            $data['datasets'][] = [
                'label' => 'Année-1',
                'backgroundColor' => 'rgba(210, 214, 222, 1)',
                'borderColor' => 'rgba(210, 214, 222, 1)',
                'data' => $chartDataTripLastYear->pluck('course1')->toArray(),
            ];

            // Convertissez les noms de mois en majuscules (ou ajustez selon vos besoins)
            $data['labels'] = array_map('strtoupper', $data['labels']);

            
        return response()->json($data);

    }

}
