@extends('master')
@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Drivers</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Administration</a></li>
              <li class="breadcrumb-item active">Liste Driver</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <section class="content">
        <div class="card card-solid">
            <div class="card-body pb-0">
                <div class="row">
                    @foreach ($drivers as $driver)
                    <div class="col-12 col-sm-6 col-md-4 d-flex align-items-stretch flex-column">
                        <div class="card bg-light d-flex flex-fill">
                        <div class="card-header text-muted border-bottom-0">
                            Interne
                        </div>
                        <div class="card-body pt-0">
                            <div class="row">
                            <div class="col-7">
                                <h2 class="lead"><b>{{ $driver->vLastName }} {{ $driver->vName }}</b></h2>
                                <h2 class="lead"><b>Total course: 252</b></h2>
                                <p class="text-muted text-sm"><b>Course Terminé: </b> 25 (10%)</p>
                                <p class="text-muted text-sm"><b>Course Annulé: </b> 25 (15%)</p>
                                <p class="text-muted text-sm"><b>Par le chaufeur: </b> 21 (48%)</p>
                                <p class="text-muted text-sm"><b>Par le client: </b> 21 (52%)</p>
                                <h2 class="text-muted text-sm"><b>Montant total course : FCFA 253000</b></h2>
                                </br>
                                <ul class="ml-4 mb-0 fa-ul text-muted">
                                <li class="small"><span class="fa-li"><i class="fas fa-lg fa-building"></i></span> Email: {{ $driver->vEmail }}</li>
                                <li class="small"><span class="fa-li"><i class="fas fa-lg fa-phone"></i></span> Téléphone #: {{ $driver->vPhone }}</li>
                                </ul>
                            </div>
                            <div class="col-5 text-center">
                                <img src="../../dist/img/user1-128x128.jpg" alt="user-avatar" class="img-circle img-fluid">
                            </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="text-right">
                            <a href="#" class="btn btn-sm btn-primary">
                                <i class="fas fa-user"></i> Voir détails
                            </a>
                            </div>
                        </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            <div class="card-footer">
                
                @include('layouts.administration.pagination', ['paginator' => $drivers])
    
            </div>
        </div>
    </section>
</div>
@endsection