@extends('master')
@section('content')

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Wallet</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
              <li class="breadcrumb-item active">Wallet</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <form action="{{ route('dashboard-wallet') }}" method="GET">
                    <div class="card-header">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Periode:</label>
                            <select  id="filterOption4" class="form-control" name="option4" >
                                <option value="all" {{ old('option4', $option4) == 'all' ? 'selected' : '' }}>All</option>
                                <option value="currenty" {{ old('option4', $option4) =='currenty' || !$option4 ? 'selected' : '' }}>Cette année</option>
                                <option value="currentm" {{ old('option4', $option4) == 'currentm' ? 'selected' : '' }}>Ce mois</option>
                                <option value="currentw" {{ old('option4', $option4) =='currentw' ? 'selected' : '' }}>Cette Semaine</option>
                                <option value="today" {{ old('option4', $option4) =='today' ? 'selected' : '' }}>Aujourd'hui</option>
                                <option value="interval" {{ old('option4', $option4) =='interval' ? 'selected' : '' }}>Autre date</option>
                            </select>

                        </div>
                        <div class="col-md-3">
                            <label>Date de début:</label>
                            <input id="startDate4" type="date" class="form-control" name="startDate"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3">
                            <label>Date de fin:</label>
                            <input id="endDate4"  type="date" class="form-control" name="endDate" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                    </div>
                    </form>
                    <div class="card-body">
                        <div class="row">
                           
                            <!-- ./col -->
                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <div class="small-box bg-dark">
                                <div class="inner">
                                    <h3>{{$credit_clients}}<sup style="font-size: 20px"></sup></h3>

                                    <p>Recharges Clients</p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-stats-bars">XOF</i>
                                </div>
                                <a href="#" class="small-box-footer">Voir <i class="fas fa-arrow-circle-right"></i></a>
                                </div>
                            </div>
                            <!-- ./col -->
                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <div class="small-box bg-secondary">
                                <div class="inner">
                                    <h3>{{$credit_drivers}}</h3>

                                    <p>Recharges Drivers</p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-person-add">XOF</i>
                                </div>
                                <a href="#" class="small-box-footer">Voir <i class="fas fa-arrow-circle-right"></i></a>
                                </div>
                            </div>
                            <!-- ./col -->
                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <div class="small-box bg-light">
                                <div class="inner">
                                    <h3>{{$credit_delivers}}</h3>

                                    <p>Recharges Livreurs</p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-pie-graph">XOF</i>
                                </div>
                                <a href="#" class="small-box-footer"> Voir<i class="fas fa-arrow-circle-right"></i></a>
                                </div>
                            </div>
                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{$credit_admins}}</h3>

                                    <p>Recharges Admin</p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-pie-graph">XOF</i>
                                </div>
                                <a href="#" class="small-box-footer"> Voir<i class="fas fa-arrow-circle-right"></i></a>
                                </div>
                            </div>
                           
                            <!-- ./col -->
                        </div>
                        <div class="row">
                            <div class="col-lg-6 col-6">
                                <!-- small box -->
                                <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3>{{$credit_totals}}</h3>

                                    <p>Totale Recharges</p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-bag">XOF</i>
                                </div>
                                <a href="#" class="small-box-footer"> A<i class=""></i></a>
                                </div>
                            </div>
                            
                            <div class="col-lg-6 col-6">
                                <!-- small box -->
                                <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{$debit_gains}}</h3>

                                    <p>Gains</p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-pie-graph">XOF</i>
                                </div>
                                <a href="#" class="small-box-footer">B <i class=""></i></a>
                                </div>
                            </div>
                            <!-- ./col -->
                        </div>
                        <div class="row">
                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{$transactions}}</h3>

                                    <p>Transactions</p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-bag">XOF</i>
                                </div>
                                <a href="#" class="small-box-footer">Voir <i class="fas fa-arrow-circle-right"></i></a>
                                </div>
                            </div>
                            <!-- ./col -->
                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{$credits}}<sup style="font-size: 20px"></sup></h3>

                                    <p>Crédits</p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-stats-bars">XOF</i>
                                </div>
                                <a href="#" class="small-box-footer">Voir <i class="fas fa-arrow-circle-right"></i></a>
                                </div>
                            </div>
                            <!-- ./col -->
                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <div class="small-box  bg-info">
                                <div class="inner">
                                    <h3>{{$debits}}</h3>

                                    <p>Débits</p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-person-add">XOF</i>
                                </div>
                                <a href="#" class="small-box-footer">Voir <i class="fas fa-arrow-circle-right"></i></a>
                                </div>
                            </div>
                            <!-- ./col -->
                            <div class="col-lg-3 col-6">
                                <!-- small box -->
                                <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{$balances}}</h3>

                                    <p>Balance</p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-pie-graph">XOF</i>
                                </div>
                                <a href="#" class="small-box-footer">C <i class=""></i></a>
                                </div>
                            </div>
                        <!-- ./col -->
                        </div>
                    </div>
                <!-- /.row -->
                </div><!--/. container-fluid -->
        </div>
        <!-- /.row -->
        <!-- Main row -->
        
        <!-- /.row (main row) -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
@endsection