<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Okalmreport</title>
  <style>
    .pointille {
      border-left: 1px dotted #000; /* 1 pixel de large, pointillé, couleur noire */
      height: 100px; /* ajustez la hauteur selon vos besoins */
    }

    .nav-item.active {
        background-color: #000;
    }

    .nav-link.active {
        background-color: #000;
    }

  </style>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="{{asset('plugins/fontawesome-free/css/all.min.css')}}">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="{{asset('plugins/overlayScrollbars/css/OverlayScrollbars.min.css')}}">
  <!-- Theme style -->
  <link rel="stylesheet" href="{{asset('dist/css/adminlte.min.css')}}">
  
</head>
<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed layout-footer-fixed')}}">
<div class="wrapper">

  <!-- Preloader -->
  <div class="preloader flex-column justify-content-center align-items-center">
    <img class="animation__wobble" src="{{asset('dist/img/okalmicon/icone_logo.jpg')}}" alt="Okalm" height="60" width="60">
  </div>

  @include('partials.sidebar')
  @include('partials.header')
  @yield('content')

 
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  @include('partials.footer')
</div>
<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->
<!-- jQuery -->
<script src="{{asset('plugins/jquery/jquery.min.js')}}"></script>
<!-- jQuery UI 1.11.4 -->
<script src="{{asset('plugins/jquery-ui/jquery-ui.min.js')}}"></script>

<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge('uibutton', $.ui.button)
</script>
<!-- Bootstrap -->
<script src="{{asset('plugins/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
<!-- overlayScrollbars -->
<script src="{{asset('plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js')}}"></script>
<!-- AdminLTE App -->
<script src="{{asset('dist/js/adminlte.js')}}"></script>

<!-- PAGE PLUGINS -->
<!-- jQuery Mapael -->
<script src="{{asset('jquery-mousewheel/jquery.mousewheel.js')}}"></script>
<script src="{{asset('plugins/raphael/raphael.min.js')}}"></script>
<script src="{{asset('/jquery-mapael/jquery.mapael.min.js')}}"></script>
<script src="{{asset('plugins/jquery-mapael/maps/usa_states.min.js')}}"></script>
<!-- ChartJS -->
<script src="{{asset('plugins/chart.js/Chart.min.js')}}"></script>

<!-- DataTables  & Plugins -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')}}"></script>
<script src="{{asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')}}"></script>
<script src="{{asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')}}"></script>
<script src="{{asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')}}"></script>
<script src="{{asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')}}"></script>
<script src="{{asset('/plugins/jszip/jszip.min.js')}}"></script>
<script src="{{asset('plugins/pdfmake/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{asset('plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{asset('plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>

<!-- AdminLTE for demo purposes -->
<script src="{{asset('dist/js/demo.js')}}"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="{{asset('dist/js/pages/dashboard2.js')}}"></script>
<!--<script src="{{asset('dist/js/pages/dashboard.js')}}"></script>-->
<script>
  $(function () {
    var startDate = $('#startDate').val();
    var endDate = $('#endDate').val();
    //alert('0000'); 

    $("#example1").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });


    $('#filterOption').change(function () {
            var start = $('#start');
            var end = $('#end');

            // Affiche/masque les champs de date en fonction de la sélection
            if ($(this).val() === 'interval') {
                start.show();
                end.show();
            } else {
                start.hide();
                end.hide();
                window.location.href = window.location.href.split('?')[0];
            }
    });

    $('#filterOption').on('change', function () {
            // Si "all" est sélectionné, rediriger vers la même URL sans les paramètres
            if ($(this).val() === 'all') {
                window.location.href = window.location.href.split('?')[0];
            }
        });

        $.ajax({
          url: '../getChartData',
          method: 'GET',
          data: { startDate: startDate, endDate: endDate },
          success: function (data) {
            console.log('Data received:', data);
            //alert('0000');



            // Trier les données par nombre décroissant
            data.sort((a, b) => b.nombre - a.nombre);

            // Regrouper les catégories avec un faible nombre d'occurrences
            const seuil = 100; // Définir le seuil en fonction de vos besoins
            const groupedData = data.reduce((result, item, index) => {
                if (index < seuil) {
                    result.push(item);
                } else {
                    const others = result.find(i => i.categorie === 'Autres');
                    if (others) {
                        others.nombre += item.nombre;
                    } else {
                        result.push({ categorie: 'Autres', nombre: item.nombre });
                    }
                }
                return result;
            }, []);


              // Process the data received from the server
              var dynamicChartData = {
                  labels: data.map(item => item.categorie),
                  datasets: [
                      {
                          data: data.map(item => item.nombre),
                          backgroundColor: ['#f56954', '#00a65a', '#f39c12', '#00c0ef', '#3c8dbc', '#d2d6de','#d2d6df'],
                      }
                  ]
              };

              // Set up the canvas and create the chart dynamically
              var pieChartCanvas = $('#pieChart11').get(0).getContext('2d');
              var pieOptions = {
                  maintainAspectRatio: false,
                  responsive: true,
                  /*legend: {
                    display: false // Désactiver l'affichage de la légende par défaut
                },
            scales: {
                y: {
                    type: 'logarithmic',
                    position: 'left',
                },
              },*/
              };

              // Create pie chart
              new Chart(pieChartCanvas, {
                  type: 'pie',
                  data: dynamicChartData,
                  options: pieOptions
              });

              // Ajouter les légendes dynamiquement
            /*var chartLegend = $('#chartLegend');
            chartLegend.empty(); // Supprimer les anciennes légendes

            data.forEach(function (item, index) {
                var legendItem = $('<li></li>').html('<i class="far fa-circle" style="color:' + dynamicChartData.datasets[0].backgroundColor[index] + '"></i> ' + item.categorie);
                chartLegend.append(legendItem);
            });*/
          },
          error: function (error) {
              //console.error('Error fetching chart data:', error);
              console.error('Error fetching chart data:', error.responseText);
              alert(error);
              alert('1111');
          }
        });

        /*+====+*/
        $.ajax({
          url: '../getChartDataDevice',
          method: 'GET',
          data: { startDate: startDate, endDate: endDate },
          success: function (data) {
            console.log('Data received:', data);
            //alert('0000');



            // Trier les données par nombre décroissant
            data.sort((a, b) => b.nombre - a.nombre);

            // Regrouper les catégories avec un faible nombre d'occurrences
            const seuil = 3; // Définir le seuil en fonction de vos besoins
            const groupedData = data.reduce((result, item, index) => {
                if (index < seuil) {
                    result.push(item);
                } else {
                    const others = result.find(i => i.categorie === 'Autres');
                    if (others) {
                        others.nombre += item.nombre;
                    } else {
                        result.push({ categorie: 'Autres', nombre: item.nombre });
                    }
                }
                return result;
            }, []);


              // Process the data received from the server
              var dynamicChartData = {
                  labels: data.map(item => item.device),
                  datasets: [
                      {
                          data: data.map(item => item.nombre),
                          backgroundColor: ['#3c8dbc', '#d2d6de','#d2d6df'],
                      }
                  ]
              };

              // Set up the canvas and create the chart dynamically
              var pieChartCanvas = $('#pieChart111').get(0).getContext('2d');
              var pieOptions = {
                  maintainAspectRatio: false,
                  responsive: true,
              };

              // Create pie chart
              new Chart(pieChartCanvas, {
                  type: 'pie',
                  data: dynamicChartData,
                  options: pieOptions
              });
          },
          error: function (error) {
              //console.error('Error fetching chart data:', error);
              console.error('Error fetching chart data:', error.responseText);
              alert(error);
              alert('1111');
          }
        });

       

        $.ajax({
          url: '../getChartDataWallet',
          method: 'GET',
          data: { startDate: startDate, endDate: endDate },
          success: function (data) {
            console.log('Data received:', data);
            //alert('0000');



            // Trier les données par nombre décroissant
            data.sort((a, b) => b.nombre - a.nombre);

            // Regrouper les catégories avec un faible nombre d'occurrences
            const seuil = 3; // Définir le seuil en fonction de vos besoins
            const groupedData = data.reduce((result, item, index) => {
                if (index < seuil) {
                    result.push(item);
                } else {
                    const others = result.find(i => i.montant === 'Autres');
                    if (others) {
                        others.montant += item.montant;
                    } else {
                        //result.push({type: 'Autres', montant: item.montant });//parseFloat(item.montant).toLocaleString('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 });
                        result.push({type: 'Autres', montant: parseFloat(item.montant).toLocaleString('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 }) });//parseFloat(item.montant).toLocaleString('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 });
                    }
                }
                return result;
            }, []);


              // Process the data received from the server
              var dynamicChartData = {
                  labels: data.map(item => item.type),
                  datasets: [
                      {
                          data: data.map(item => item.montant),
                          backgroundColor: ['#f39c12', '#00c0ef', '#3c8dbc','#3c8dbc'],
                      }
                  ]
              };

              // Set up the canvas and create the chart dynamically
              var pieChartCanvas = $('#pieChart1111').get(0).getContext('2d');
              var pieOptions = {
                  maintainAspectRatio: false,
                  responsive: true,
              };

              // Create pie chart
              new Chart(pieChartCanvas, {
                  type: 'pie',
                  data: dynamicChartData,
                  options: pieOptions
              });
          },
          error: function (error) {
              //console.error('Error fetching chart data:', error);
              console.error('Error fetching chart data:', error.responseText);
              alert(error);
              alert('1111');
          }
        });

    function getChartData() {

        var startDate = $('#startDate').val();
        var endDate = $('#endDate').val();
            alert(0000)
            $.ajax({
                url: '../getChartDataPanierMoins', // Assurez-vous d'ajuster la route
                type: 'GET',
                dataType: 'json',
                data: { startDate: startDate, endDate: endDate },
                success: function(data) {
                    //alert('222223333');
                    console.log(data);
                    // Créer le graphique avec les données reçues
                    createChart(data);
                },
                error: function(error) {
                    console.log('Erreur lors de la récupération des données:', error);
                    //alert('22222');
                }
            });
       }

    // Fonction pour créer le graphique avec Chart.js
    function createChart(chartData) {
        var ctx = document.getElementById('myChart').getContext('2d');

        var myChart = new Chart(ctx, {
            type: 'bar',
            data: chartData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
            }
        });
    }

    // Appeler la fonction pour récupérer les données lors du chargement de la page
    getChartData();


    //$(document).ready(function() {
    $.ajax({
                url: '../getChartDataCompareTripLastYear',
                type: 'GET',
                dataType: 'json',
                data: { startDate: startDate, endDate: endDate },
                success: function(data) {
                    // Appeler la fonction pour créer le graphique avec les données récupérées
                    createChart2(data);
                },
                error: function(error) {
                    console.log(error);
                }
    });

    function createChart2(data) {

        console.log('Données reçues :', data);

            var ticksStyle = {
                fontColor: '#495057',
                fontStyle: 'bold'
            };

            var mode = 'index';
            var intersect = true;

            var $salesChart = $('#sales-chart');
            var salesChart = new Chart($salesChart, {
                    type: 'bar',
                    data: {
                        labels: data.labels,
                        datasets: data.datasets,
                    },
                    options: {
                        maintainAspectRatio: false,
                        tooltips: {
                            mode: mode,
                            intersect: intersect
                        },
                        hover: {
                            mode: mode,
                            intersect: intersect
                        },
                        legend: {
                            display: true,
                        },
                        scales: {
                            yAxes: [{
                                gridLines: {
                                    display: true,
                                    lineWidth: '4px',
                                    color: 'rgba(0, 0, 0, .2)',
                                    zeroLineColor: 'transparent'
                                },
                                ticks: $.extend({
                                    beginAtZero: true,
                                    callback: function(value) {
                                        if (value >= 1000) {
                                            value /= 1000;
                                            value += '';
                                        }
                                        return '' + value;
                                    }
                                }, ticksStyle)
                            }],
                            xAxes: [{
                                display: true,
                                gridLines: {
                                    display: false
                                },
                                ticks: ticksStyle
                            }]
                        }
                    }
            });
        }
       // });




    function updateDates() {
            var filterOption = $('#filterOption2').val();
            var today = new Date().toISOString().split('T')[0]; // Date d'aujourd'hui

            switch (filterOption) {
                case 'all':
                    // Ajustez ces valeurs en fonction de vos besoins
                    $('#startDate').val('2020-08-01');
                    $('#endDate').val(today);
                    //
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
                case 'currenty':
                    $('#startDate').val(today.substring(0, 4) + '-01-01');
                    $('#endDate').val(today);
                    //
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
                case 'currentm':
                    var firstDayOfMonth = today.substring(0, 7) + '-01';
                    $('#startDate').val(firstDayOfMonth);
                    $('#endDate').val(today);
                    //
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
                case 'currentw':
                    var currentDay = new Date(today);
                    var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                    $('#startDate').val(firstDayOfWeek.toISOString().split('T')[0]);
                    $('#endDate').val(today);
                    //
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
                case 'today':
                    $('#startDate').val(today);
                    $('#endDate').val(today);
                    //
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
               
                case 'interval':
                    $('#startDate').prop('disabled', false);
                    $('#endDate').prop('disabled', false);

                    // Ajoutez ces conditions pour vider les champs seulement si l'option "interval" est sélectionnée et si les champs ne sont pas vides
                    if ($('#filterOption2').val() == 'interval') {
                        if ($('#startDate').val() == '') {
                            $('#startDate').val('');
                        }
                        if ($('#endDate').val() == '') {
                            $('#endDate').val('');
                        }
                    }
                    break; 
                default:
                    // Par défaut, si aucune option n'est sélectionnée, utilisez "Cette année"
                    $('#filterOption2').val('currenty');
                    $('#startDate').val(today.substring(0, 4) + '-01-01');
                    $('#endDate').val(today);
                    //
                    // Désactiver les champs de saisie des dates pour "Cette année"
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
            }
    }
    // Appeler la fonction lorsqu'il y a un changement dans la sélection
    $('#filterOption2').change(updateDates);
    updateDates();
    

});

  //$('#start').hide();
  //$('#end').hide();


    document.getElementById('hide1').style.display = 'block';
    document.getElementById('hide2').style.display = 'none';

    function cacherDiv() {
        var div = document.getElementById('hide1');
        var div1 = document.getElementById('hide2');
        if (div.style.display === 'none') {
            div.style.display = 'block'; // Si déjà caché, affiche le div
        } else {
            div.style.display = 'none'; // Sinon, cache le div
        }

        if (div1.style.display ==='none') {
            div1.style.display = 'block'; // Si déjà caché, affiche le div
        } else {
            div1.style.display = 'none'; // Sinon, cache le div
        }
    }
    
    
        // Ajoutez un écouteur d'événements pour détecter les changements dans la sélection de l'option
      
  // Assuming you are using jQuery for AJAX


 // $(document).ready(function () {
        // Fonction pour mettre à jour les dates en fonction de l'option sélectionnée
       
   // });

</script>
<script>
    $(function () {

        function updateDatesDepot() {
        
        var filterOption1 = $('#filterOption1').val();
        var today = new Date().toISOString().split('T')[0];
       

        switch (filterOption1) {
            case 'today':
                $('#startDate2').val(today);
                $('#endDate2').val(today);
                $('#startDate2').prop('disabled', true);
                $('#endDate2').prop('disabled', true);
                break;

            case 'week':
               
                var currentDay = new Date(today);
                var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                $('#startDate2').val(firstDayOfWeek.toISOString().split('T')[0]);
                $('#endDate2').val(today);
                $('#startDate2').prop('disabled', true);
                $('#endDate2').prop('disabled', true);
                break;

            case 'month':
                var firstDayOfMonth = today.substring(0, 7) + '-01';
                $('#startDate2').val(firstDayOfMonth);
                $('#endDate2').val(today);
                $('#startDate2').prop('disabled', true);
                $('#endDate2').prop('disabled', true);
                break;

            case 'other':
                $('#startDate2').prop('disabled', false);
                $('#endDate2').prop('disabled', false);

                if ($('#filterOption1').val() == 'other') {
                    if ($('#startDate2').val() == '') {
                        $('#startDate2').val('');
                    }
                    if ($('#endDate2').val() == '') {
                        $('#endDate2').val('');
                    }
                }
                break;

            default:
                $('#filterOption1').val('week');
                var currentDay = new Date(today);
                var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                $('#startDate2').val(firstDayOfWeek.toISOString().split('T')[0]);
                $('#endDate2').val(today);
                $('#startDate2').prop('disabled', true);
                $('#endDate2').prop('disabled', true);
                break;
        }
    }

            // Appeler la fonction lorsqu'il y a un changement dans la sélection
            $('#filterOption1').change(updateDatesDepot);
            updateDatesDepot();  // Appel initial pour définir l'état initial
    });
</script>

<script>
    $(function () {

        function updateDatesTransaction() {
        
        var filterOption3 = $('#filterOption3').val();
        var today = new Date().toISOString().split('T')[0];
       

        switch (filterOption3) {
            case 'today':
                $('#startDate1').val(today);
                $('#endDate1').val(today);
                $('#startDate1').prop('disabled', true);
                $('#endDate1').prop('disabled', true);
                break;

            case 'week':
               
                var currentDay = new Date(today);
                var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                $('#startDate1').val(firstDayOfWeek.toISOString().split('T')[0]);
                $('#endDate1').val(today);
                $('#startDate1').prop('disabled', true);
                $('#endDate1').prop('disabled', true);
                break;

            case 'month':
                var firstDayOfMonth = today.substring(0, 7) + '-01';
                $('#startDate1').val(firstDayOfMonth);
                $('#endDate1').val(today);
                $('#startDate1').prop('disabled', true);
                $('#endDate1').prop('disabled', true);
                break;

            case 'other':
                $('#startDate1').prop('disabled', false);
                $('#endDate1').prop('disabled', false);

                if ($('#filterOption3').val() == 'other') {
                    if ($('#startDate1').val() == '') {
                        $('#startDate1').val('');
                    }
                    if ($('#endDate1').val() == '') {
                        $('#endDate1').val('');
                    }
                }
                break;

            default:
                $('#filterOption3').val('week');
                var currentDay = new Date(today);
                var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                $('#startDate1').val(firstDayOfWeek.toISOString().split('T')[0]);
                $('#endDate1').val(today);
                $('#startDate1').prop('disabled', true);
                $('#endDate1').prop('disabled', true);
                break;
        }
    }

            // Appeler la fonction lorsqu'il y a un changement dans la sélection
            $('#filterOption3').change(updateDatesTransaction);
            updateDatesTransaction();  // Appel initial pour définir l'état initial
    });
</script>

<script>
   
    $(function () {
      
        function updateDatesWallet() {
           
            var filterOption4 = $('#filterOption4').val();
            var today = new Date().toISOString().split('T')[0];
            //alert(filterOption4);

                switch (filterOption4) {
                    
                    case 'all':
                        // Ajustez ces valeurs en fonction de vos besoins
                        $('#startDate4').val('2020-08-01');
                        $('#endDate4').val(today);
                        //
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                    case 'currenty':
                        $('#startDate4').val(today.substring(0, 4) + '-01-01');
                        $('#endDate4').val(today);
                        //
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                    case 'currentm':
                        var firstDayOfMonth = today.substring(0, 7) + '-01';
                        $('#startDate4').val(firstDayOfMonth);
                        $('#endDate4').val(today);
                        //
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                    case 'currentw':
                        var currentDay = new Date(today);
                        var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                        $('#startDate4').val(firstDayOfWeek.toISOString().split('T')[0]);
                        $('#endDate4').val(today);
                        //
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                    case 'today':
                        $('#startDate4').val(today);
                        $('#endDate4').val(today);
                        //
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                
                    case 'interval':
                        $('#startDate4').prop('disabled', false);
                        $('#endDate4').prop('disabled', false);

                        // Ajoutez ces conditions pour vider les champs seulement si l'option "interval" est sélectionnée et si les champs ne sont pas vides
                        if ($('#filterOption4').val() == 'interval') {
                            if ($('#startDate4').val() == '') {
                                $('#startDate4').val('');
                            }
                            if ($('#endDate4').val() == '') {
                                $('#endDate4').val('');
                            }
                        }
                        break; 
                    default:
                        // Par défaut, si aucune option n'est sélectionnée, utilisez "Cette année"
                        $('#filterOption4').val('currenty');
                        $('#startDate4').val(today.substring(0, 4) + '-01-01');
                        $('#endDate4').val(today);
                        //
                        // Désactiver les champs de saisie des dates pour "Cette année"
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                }
            }

                // Appeler la fonction lorsqu'il y a un changement dans la sélection
                $('#filterOption4').change(updateDatesWallet);
                updateDatesWallet();  // Appel initial pour définir l'état initial
        });
</script>
</body>
</html>
