@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Liste des balance</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Administration</a></li>
              <li class="breadcrumb-item active">Balance</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('administration-balance') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-2">
                             <label>Filtre:</label>
                            <input type="text" class="form-control" name="numero" id="numero" value="{{ old('numero', $numero) }}" placeholder="Saisir numéro pour filtrer">
                        </div>
                        
                        <div class="col-md-2">
                            <label>Date de Solde:</label>
                            <input type="date" class="form-control" name="soldeDate" id="soldeDate2" value="{{ old('soldeDate', $soldeDate) }}">
                        </div>
                        <div class="col-md-1">
                            <label>Option :</label>
                            <select class="form-control" name="option33">
                                <option value="all" {{ old('option33', $option33) == 'all' ? 'selected' : '' }}>All</option>
                                <!--<option value="admin" {{ old('option33', $option33) == 'admin' ? 'selected' : '' }}>Admin</option>-->
                                <option value="user" {{ old('option33', $option33) == 'user' ? 'selected' : '' }}>User</option>
                                <option value="driver" {{ old('option33', $option33) == 'driver' ? 'selected' : '' }}>Driver</option>
                                <option value="deliver" {{ old('option33', $option33) == 'deliver' ? 'selected' : '' }}>Livreur</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label>Nombre ligne :</label>
                            <select class="form-control" name="ligne">
                                <option value="10" {{ old('ligne', $ligne) == '10' ? 'selected' : '' }}>10</option>
                                <!--<option value="admin" {{ old('option33', $option33) == 'admin' ? 'selected' : '' }}>Admin</option>-->
                                <option value="40" {{ old('ligne', $ligne) == '40' ? 'selected' : '' }}>40</option>
                                <option value="60" {{ old('ligne', $ligne) == '60' ? 'selected' : '' }}>60</option>
                                <option value="100" {{ old('ligne', $ligne) == '100' ? 'selected' : '' }}>100</option>
                            </select>
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                        
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <label>&nbsp;</label>
                        </div>
                        <div class="col-md-2">
                            <label>Total solde</label>
                            <input readonly value="{{$total}}" class="form-control btn btn-secondary text-dark">
                        </div>
                        
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1368" class="table table-bordered table-stripedg">
                  <thead>
                  <tr>
                    <th>Client</th>
                    <th>Tél</th>
                    <th class="sortable">Date enrégistrement</th>
                    <th>Type Client</th>
                    <th class="sortable">Solde</th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($balances as $item)
                  <tr>
                    <!--<td>{{ $item->iUserId }}</td>-->
                    <td>{{ $item->name }} {{ $item->lastname }}</td>
                    <td>{{ $item->vPhone }}</td>
                     <td>{{ $item->vDate }}</td>
                    <td>{{ $item->eusertype }}</td>
                    <td>{{ $item->balance }}</td>
                  </tr>
                  @endforeach
                  </tbody>
                 
                  <!--<tfoot>
                  <tr>
                    <th>Client</th>
                    <th>Tél</th>
                    <th>Date enrégistrement</th>
                    <th>Type Client</th>
                    <th>Solde</th>
                  </tr>
                  </tfoot>-->
                </table>
               <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center">
                        {{ $balances->links() }}
                    </ul>
                </nav>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
    
    
  </div>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    $(document).ready(function () {
        $('.sortable').on('click', function () {
            var table = $(this).closest('table');
            var rows = table.find('tr:gt(0)').toArray().sort(comparer($(this).index()));
            this.asc = !this.asc;
            if (!this.asc) { rows = rows.reverse(); }
            for (var i = 0; i < rows.length; i++) { table.append(rows[i]); }
        });

        function comparer(index) {
            return function (a, b) {
                var valA = getCellValue(a, index), valB = getCellValue(b, index);
                return $.isNumeric(valA) && $.isNumeric(valB) ? valA - valB : valA.toString().localeCompare(valB);
            };
        }

        function getCellValue(row, index) {
            return $(row).children('td').eq(index).text();
        }
    });
</script>
  @endsection