@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Liste des commandes livrées</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Administration</a></li>
              <li class="breadcrumb-item active">Commandes</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('administration-commande') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate12"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate12" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Date commande</th>
                    <th>Partenaire</th>
                    <th>N° commande</th>
                    <th>Client</th>
                    <th>Montant</th>
                    <th>Frais</th>
                    <th>Montant Total(FCFA)</th>
                    <th>Cash</th>
                    <th>Wallet</th>
                    <th>Livreur</th>
                    <th>Paie</th>
                    
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($commandes as $item)
                  <tr>
                    <td>{{ $item->tDate }}</td> 
                    <td>{{ $item->vCompanyName }}</td>
                    <td>{{ $item->vOrderNo }}</td>
                    <td>{{ $item->passenger }} <br><b>{{ $item->vPhone }}</b></td>
                    <!--<td>D : {{ $item->startDate }}<br><b class="pointille"></b><br><b>A : {{ $item->endDate }}</b></td>-->
                    <td>{{ $item->montant }}</td>
                    <td>{{ $item->frais }}</td>
                    <td>{{ $item->total }}</td>
                    <td>{{ $item->cash }}</td>
                    <td>{{ $item->wallet }}</td>
                    <td>{{ $item->driver }}<br><b>{{ $item->vPhone_rd }}</b></td>
                    <td>{{ $item->paie }}</td>
                    
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Date commande</th>
                    <th>Partenaire</th>
                    <th>N° commande</th>
                    <th>Client</th>
                    <th>Montant</th>
                    <th>Frais</th>
                    <th>Montant Total(FCFA)</th>
                    <th>Cash</th>
                    <th>Wallet</th>
                    <th>Livreur</th>
                    <th>Paie</th>
                   
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection