@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Liste des courses réalisées</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Administration</a></li>
              <li class="breadcrumb-item active">Courses</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('administration-drive-group') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate12"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate12" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Partenaire</th>
                    <th>Chauffeur</th>
                    <th>Montant</th>
                    <th>Commission</th>
                    <th>TVA</th>
                    <th>Derniere date fin</th>
                    <th>Dernierer destination</th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($drives as $item)
                  <tr>
                    <td>{{ $item->vCompanyName }}</td>
                    <td>{{ $item->driver }}<br><b>{{ $item->vPhone_rd }}</b></td>
                    <td>{{ $item->total }}</td>
                    <td>{{ $item->fcommision }}</td>
                    <td>{{ $item->ftva }}</td>
                    <td>{{ $item->lastEndDate }}</td>
                    <td>{{ $item->lastDestination }}</td>
                    
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Partenaire</th>
                    <th>Chauffeur</th>
                    <th>Montant</th>
                    <th>Commission</th>
                    <th>TVA</th>
                    <th>Derniere date fin</th>
                    <th>Dernierer destination</th>
                  </tr>
                  </tfoot>
                </table>
                {{ $drives->links() }}

              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection