@extends('master')

@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Liste forfait</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Administration</a></li>
                        <li class="breadcrumb-item active">Recharge</li>
                        <li class="breadcrumb-item active">Forfait</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                        <div class="card">
                        @if(session('error'))
                        <div class="alert alert-danger">{{ session('error') }}</div>
                        @endif
                        <div class="card-body">
                            <table id="example" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Titre</th>
                                        <th>Opérateur</th>
                                        <th>Montant (F)</th>
                                        <th>Description</th>
                                        <th>Jours Bonus</th>
                                        <th>Jours Disponibles</th>
                                        <th>Facteur Bonus</th>
                                        <th>Disponible</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($forfaits as $forfait)
                                        <tr>
                                            <td>{{ $forfait['title'] }}</td>
                                            <td>{{ $forfait['operator'] }}</td>
                                            <td>{{ number_format($forfait['amount']) }}</td>
                                            <td>{{ $forfait['description'] }}</td>
                                            <td>{{ implode(', ', $forfait['bonusDays']) }}</td>
                                            <td>{{ implode(', ', $forfait['availableDays']) }}</td>
                                            <td>{{ $forfait['bonusFactor'] }}%</td>
                                            <td>
                                                @if($forfait['isAvailable'])
                                                    <span class="badge badge-success">Oui</span>
                                                @else
                                                    <span class="badge badge-danger">Non</span>
                                                @endif
                                            </td>
                                            <td>
                                                <button type="button"
                                                        class="btn btn-success btn-sm open-modal-souscription"
                                                        data-toggle="modal"
                                                        data-target="#modalSouscription"
                                                        data-id="{{ $forfait['id'] }}"
                                                        data-title="{{ $forfait['title'] }}"
                                                        data-amount="{{ $forfait['amount'] }}"
                                                        data-operator="{{ $forfait['operator'] }}">
                                                    <i class="fas fa-paper-plane"></i>
                                                </button>
                                            </td>


                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="8" class="text-center">Aucun forfait disponible</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        
                    </div>
                </div>
            </div>
            
          <div class="modal fade" id="modalSouscription" tabindex="-1" role="dialog" aria-labelledby="modalSouscriptionLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <form method="POST" action="{{ route('subscribe-forfait') }}">
                    @csrf
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Souscription à un forfait</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Fermer">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        
                        <div class="modal-body">
                            {{-- OPÉRATEUR --}}
                            <div class="form-group">
                                <label>Opérateur</label>
                                <input type="text" class="form-control" id="modalOperator" readonly>
                            </div>
                            {{-- Affichage forfait sélectionné (titre) --}}
                            <div class="form-group">
                                <label>Forfait sélectionné :</label>
                                <input type="text" id="modalTitleDisplay" class="form-control" readonly>
                            </div>
        
                            {{-- Affichage du montant --}}
                            <div class="form-group">
                                <label>Montant (F CFA) :</label>
                                <input type="text" id="modalAmountDisplay" class="form-control" readonly>
                            </div>
        
                            {{-- Affichage du nom de la campagne --}}
                            <div class="form-group">
                                <label>Nom de la campagne :</label>
                                <input type="text" name="campaignName" class="form-control" placeholder="Recharge de mois de juillet" value="" required>
                            </div>
        
                            {{-- Numéro à recharger --}}
                            <div class="form-group">
                                <label for="sentTo">Numéro de téléphone :</label>
                                <input type="text" name="sentTo" id="modalPhone" class="form-control" placeholder="226XXXXXXXX" required>
                            </div>
        
                            {{-- Champs cachés pour l’envoi --}}
                           
                            <input type="hidden" name="ref" id="modalRef">
                            <input type="hidden" name="amount" id="modalAmount">
                            <input type="hidden" name="countryStringCode" value="BF">
                            <input type="hidden" name="countryNumberCode" value="226">
                        </div>
                        
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">Souscrire</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>


            
        </div>
    </section>
</div>
@endsection
@push('scripts')

<script>
$(document).ready(function () {
    $('.open-modal-souscription').on('click', function () {
        alert('okk');
        const title = $(this).data('title');
        const ref = $(this).data('id');
        const amount = $(this).data('amount');
        const operator = $(this).data('operator');
        
        alert('ok');

        // Affichage
        $('#modalTitleDisplay').val(title);
        $('#modalAmountDisplay').val(amount + ' F');

        // Champs cachés
        $('#modalRef').val(ref);
        $('#modalAmount').val(amount);
    });
});
</script>


@endpush
