@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Liste commandes livreurs</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Administration</a></li>
              <li class="breadcrumb-item active">Drivers</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content" id="hide1">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
               <div class="card-header d-flex justify-content-between align-items-center">
                      <h3 class="card-title"> </h3>
                      <button onclick="cacherDiv()" class="btn btn-primary">En carte</button>
                </div>
                <form action="{{ route('administration-livreur') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                    <div class="col-md-3">
                            <label>Filtre:</label>
                            <select class="form-control" name="option2">
                                <option value="all" {{ old('option2', $option2) == 'all' ? 'selected' : '' }}>All</option>
                                <option value="interne" {{ old('option2', $option2) == 'interne' ? 'selected' : '' }}>Interne</option>
                                <option value="externe" {{ old('option2', $option2) == 'externe' ? 'selected' : '' }}>Externe</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate13"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate13" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Liveur</th>
                    <th>Nombre</th>
                    <th>Réalisée</th>
                    <th>Annulée</th>
                    <th>Du livreur (Tx annulé)</th>
                    <th>Du client (Tx annulé)</th>
                    <th>Du Admin (Tx annulé)</th>
                    <th>Montant(FCFA)</th>
                    <th>Dernière date</th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($livreurs as $item)
                  <tr>
                    <td>{{ $item->Driver }}<br/><b>({{ $item->vPhone }})</b></td>
                    <td>{{ $item->totalCommande }}</td>
                    <td>{{ $item->Completed }}</td>
                    <td> {{ $item->Annulation }}</td>
                    <td>{{ $item->DeDriver }}</td>
                    <td>{{ $item->DeClient }}</td>
                    <td>{{ $item->DeAdmin }}</td>
                    <td>{{ $item->MontantCommande }}</td>
                    <td>{{ $item->lastdate }}</td>
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Livreur</th>
                    <th>Nombre</th>
                    <th>Réalisée</th>
                    <th>Annulée</th>
                    <th>Du livreur (Tx annulé)</th>
                    <th>Du client (Tx annulé)</th>
                    <th>Du Admin (Tx annulé)</th>
                    <th>Montant(FCFA)</th>
                    <th>Dernière date</th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
   
    <!-- /.content -->
  </div>
  @endsection