@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Parcours drives</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Administration</a></li>
              <li class="breadcrumb-item active">Parcours</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('administration-parcour') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate12"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate12" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>N° course</th>
                    <th>Hail</th>
                    <th>Chauffeur</th>
                    <th>Type Véhicule</th>
                    <th>Temps TA(min)</th>
                    <th>Distance(km)</th>
                    <th>Durée(min)</th>
                    <th>Frais Attente (FCFA)</th>
                    <th>Frais Attente Transit (FCFA)</th>
                    <th>Temps Transit</th>
                    <th>Montant(FCFA)</th>
                     <th>Acceptation</th>
                    <th>Arrivée</th>
                    <th>Départ</th>
                    <th>Fin</th>
                    <th>Début Pause</th>
                    <th>Fin Pause</th>
                    
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($parcours as $item)
                    @php
                        $minutesDifference = \App\Http\Controllers\Administration::calculateMinutesDifference($item->tDate, $item->arrivedDate);
                         $minutesPause = \App\Http\Controllers\Administration::calculateMinutesDifference($item->startp, $item->endp);
                    @endphp
                  <tr>
                    <td>{{ $item->vRideNo }}</td>
                     <td>{{ $item->ehail }}</td>
                    <td>{{ $item->driver }}<br><b>{{ $item->vPhone_rd }}</b></td>
                    <!--<td> {{ $item->tDate }}<br><b class="pointille"></b><br><b>{{ $item->arrivedDate }}</b><br><b class="pointille"></b><br>{{ $item->startDate }}<br><b class="pointille"></b><br><b>{{ $item->endDate }}</b></td>-->
                    <td>{{ $item->categorie }}</td>
                    <td>{{ $minutesDifference }}</td>
                    <td>{{ $item->distance }}</td>
                    <td>{{ $item->duree }}</td>
                    <td>{{ $item->waitingfees }}</td>
                    <td>{{ $item->transitfee }}</td>
                    <td>{{ $minutesPause }}</td>
                    <td>{{ $item->total }}</td>
                    <td>{{ $item->tDate }}</td>
                    <td>{{ $item->arrivedDate }}</td>
                    <td>{{ $item->startDate }}</td>
                    <td>{{ $item->endDate }}</td>
                    <td>{{ $item->startp }}</td>
                    <td>{{ $item->endp }}</td>
                    
                   
                    
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>N° course</th>
                    <th>Hail</th>
                    <th>Chauffeur</th>
                    <th>Type Véhicule</th>
                    <th>Temps TA(min)</th>
                    <th>Distance(km)</th>
                    <th>Durée(min)</th>
                    <th>Frais Attente (FCFA)</th>
                    <th>Frais Attente Transit (FCFA)</th>
                     <th>Temps Transit</th>
                    <th>Montant(FCFA)</th>
                     <th>Acceptation</th>
                    <th>Arrivée</th>
                    <th>Départ</th>
                    <th>Fin</th>
                    <th>Début Pause</th>
                    <th>Fin Pause</th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection