@php
$current_route=request()->route()->getName();
@endphp
@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Récharge Admin</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Comptabilité</a></li>
              <li class="breadcrumb-item active">Dépense</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            @if(session('error'))
                                        <div class="alert alert-danger">
                                            {{ session('error') }}
                                        </div>
                                        @endif
                                        @if(session('success'))
                                            <div class="alert alert-success">
                                                {{ session('success') }}
                                            </div>
                                        @endif
             <div class="card">
                <form action="{{ route('comptabilite-depense') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->
                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                         <div class="col-md-4"></div>
                        <div class="col-md-1">
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#saveDepenseAll">
                             Ajouter
                            </button>
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                      <tr>
                        <th>Type dépense</th>
                        <th>Description</th>
                        <th>Montant (XOF)</th>
                        <th>Type</th>
                        <th>Propiétaire</th>
                        <th>Téléphone</th>
                        <th>Date Dép</th>
                        <th>Date Rech</th>
                        <th>Créér par</th>
                      </tr>
                  </thead>
                  <tbody>
                      @foreach ($depense_driver as $item)
                      <tr>
                        <td>{{$item->titre}}</td>
                        <td>{{$item->description }}</td>
                        <td>{{$item->montant }}</td>
                        <td>{{$item->user_type }}</td>
                        <td>{{$item->nom_personne}}</td>
                        <td>{{$item->telephone}}</td>
                        <td>{{$item->edate}}</td>
                        <td>{{$item->date_c}}</td>
                        <td>{{$item->nom_creation}}</td>
                        <!--<td>
                            <div class="btn-group btn-group-sm">
                                <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#updateDepenseModal"
                                                data-sidex="{{ $item->aexpenseId }}"
                                                data-stitre="{{ $item->titre }}"
                                                data-sdescription="{{ $item->description }}"
                                                data-smontant="{{ $item->montant }}"
                                                data-sdriveur="{{ $item->iUserId }}"
                                                data-isdriveur="{{ $item->nom_personne }}"
                                                data-sedate="{{ $item->edate }}"
                                                 data-sedate="{{ $item->user_type }}">
                                 <i class="fas fa-edit"></i>
                                </a>
                                               
                            </div>
                        </td>-->
                      </tr>
                      @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Type dépense</th>
                    <th>Description</th>
                    <th>Montant (XOF)</th>
                     <th>Type</th>
                    <th>Propiétaire</th>
                    <th>Téléphone</th>
                    <th>Date Dép</th>
                    <th>Date Rech</th>
                    <th>Créér par</th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
        
        <div class="modal fade" id="updateDepenseModal" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalScrollableTitle">Modification de dépense</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <form id="depenseUpdateForm">
                            <input type="hidden" id="updateId" name="aexpenseId">
                            <div class="modal-body">
                                <!--<div class="form-group">
                                    <label for="montant">Intitulé Dépense</label>
                                    <input type="text" class="form-control titre" id="updateTitre" name="titre" placeholder="" required>
                                </div>-->
                                <div class="form-group">
                                <label>Type Dépense</label>
                                <select name="titre" class="form-control select2bs4 titre" id="updateTitre" style="width: 100%; " required>
                                    <option>Veuillez choisir type dépense</option>
                                    <option value="Réparation">Réparation</option>
                                    <option value="Pièce">Pièce</option>
                                </select>
                            </div>
                                 <div class="form-group">
                                    <label for="description">Description</label>
                                    <input type="text" class="form-control description" id="updateDescription" name="description" placeholder="" required>
                                </div>
                                <div class="form-group">
                                    <label for="montant">Montant</label>
                                    <input type="text" class="form-control montant" name="montant" id="updateMontant" placeholder="0" required>
                                </div>
                                <div class="form-group">
                                    <label>Drivers</label>
                                    <select name="driveur" class="form-control select2bs4 driveur" id="updateDriveur" style="width: 100%;">
                                        <option></option>
                                        @foreach($driveurs as $driveur)
                                            <option value="{{ $driveur->iUserId }}">{{ $driveur->name }} {{$driveur->vPhone}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="date">Date</label>
                                    <input type="date" class="form-control edate" id="updateDate" name="edate"  placeholder="" required>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                                <button type="submit" class="btn btn-primary" id="updateDepense">Modifier</button>
                            </div>
                        </form>
                </div>
            </div>
        </div>
        
        
        <div class="modal fade" id="saveDepenseAll" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalScrollableTitle">Insertion de dépense</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    <form id="depenseSaveFormAll" enctype="multipart/form-data">
                        <div class="modal-body" style="max-height: 400px; overflow-y: auto;">
                            <div class="form-group">
                                <label>Type User</label>
                                <select name="usertype" class="form-control type" id="saveTypeAll" style="width: 100%;">
                                    <option></option>
                                    <option value="user">User</option>
                                    <option value="driver">Driveur/Livreur</option>
                                    <!--<option value="deliver">Livreur</option>-->
                                </select>
                            </div>
                             <div class="form-group">
                                <label for="numero">Numéro de Téléphone</label>
                                <input type="text" class="form-control numero" id="saveNumeroAll" name="numero" placeholder="0" required>
                            </div>
                            
                            <!--<div class="form-group" id="driveurs" style="display: none;">
                                <label>Drivers</label>
                                <select name="driver" class="form-control select2bs4 driveur" id="saveDriverAll" style="width: 100%;">
                                    <option></option>
                                    @foreach($driveurs as $driveur)
                                        <option value="{{ $driveur->iUserId }}">{{ $driveur->name }} {{$driveur->vPhone}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group" id="users" style="display: none;">
                                <label>Users</label>
                                <select name="user" class="form-control select2bs4 user" id="saveUserAll" style="width: 100%;">
                                    <option></option>
                                    @foreach($users as $user)
                                        <option value="{{ $user->iUserId }}">{{ $user->name }} {{$user->vPhone}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group" id="livreurs" style="display: none;">
                                <label>Livreurs</label>
                                <select name="deliver" class="form-control select2bs4 livreur" id="saveDeliverAll" style="width: 100%;">
                                    <option></option>
                                    @foreach($livreurs as $livreur)
                                        <option value="{{ $livreur->iUserId }}">{{ $livreur->name }} {{$livreur->vPhone}}</option>
                                    @endforeach
                                </select>
                            </div>-->
                            <div class="form-group">
                                <label>Type Dépense</label>
                                <select name="titre" class="form-control select2bs4 titre" id="saveTitreAll" style="width: 100%;" required>
                                    <option value="None">Veuillez choisir type dépense</option>
                                    <option value="Réparation">Réparation</option>
                                    <option value="Achat">Achat produit</option>
                                    <option value="Carburant">Carburant</option>
                                    <option value="Recharge client">Recharge client</option>
                                    <option value="Commande annulée">Commande annulée</option>
                                    <option value="Colis ext">Colis ext</option>
                                    <option value="Manque wallet">Manque wallet</option>
                                    <option value="Remboursement">Remboursement</option>
                                    <option value="Commande Okalm">Commande Okalm</option>
                                    <option value="Compensation course (KM)">Compensation course (KM)</option>
                                    <option value="Défaut de recharge">Défaut de recharge</option>
                                    <option value="Transfert d'argent">Transfert d'argent</option>
                                    <option value="Activation livreur">Activation livreur</option>
                                    <option value="Okalm Logistique">Okalm Logistique</option>
                                    <option value="Communication Okalm">Communication Okalm</option>
                                    <option value="Drive Pro">Drive Pro</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea class="form-control description" id="saveDescriptionAll" name="description" placeholder="Décrire la dépense" required></textarea>
                            </div>
                            <div class="form-group">
                                <label for="montant">Montant</label>
                                <input type="text" class="form-control montant" id="saveMontantAll" name="montant" placeholder="0" required>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <label for="date">Date</label>
                                    <input type="datetime-local" class="form-control edate" id="saveDateAll" name="edate" value="{{ date('Y-m-d\TH:i')}}" placeholder="" required>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                            <button type="submit" class="btn btn-primary" id="saveDepenseChangeAll">Valider</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection