@php
$current_route=request()->route()->getName();
@endphp
@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Facture</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Comptabilité</a></li>
              <li class="breadcrumb-item active">Facture</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            @if(session('error'))
               <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            <div class="card">
                <form action="{{ route('comptabilite-facture') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                         <div class="col-md-4"></div>
                        <div class="col-md-1">
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#saveFactureAll">
                             Ajouter
                            </button>
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
                <div class="card-body">
    <table id="example1" class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Date</th>
                <th>N° facture</th>
                <th>Client</th>
                <th>Numéro client</th>
                <th>Montant</th>
                <th>Service</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($invoices as $item)
            <tr>
                <td>{{ $item->date_invoice }}</td>
                <td>{{ $item->numero_facture }}</td>
                <td>{{ $item->client }}</td>
                <td>{{ $item->numero_client }}</td>
                <td>{{ number_format($item->montant, 0, ',', ' ') }} F CFA</td>
                <td>{{ $item->service }}</td>
                <td>
                    <span class="badge 
                        @if($item->status == 'payé') bg-success 
                        @elseif($item->status == 'Non payé') bg-warning 
                        @else bg-danger @endif">
                        {{ $item->status }}
                    </span>
                </td>
                <td>
                    <!-- Formulaire pour changer le statut -->
                    <form action="{{ route('invoices.updateStatus', $item->invoice_internalId) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <select name="status" class="form-control form-control-sm d-inline-block" style="width:120px;" onchange="this.form.submit()">
                            <option value="Non payé" {{ $item->status == 'Non payé' ? 'selected' : '' }}>Non payé</option>
                            <option value="Payé" {{ $item->status == 'Payé' ? 'selected' : '' }}>Payé</option>
                        </select>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <th>Date</th>
                <th>N° facture</th>
                <th>Client</th>
                <th>Numéro client</th>
                <th>Montant</th>
                <th>Service</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </tfoot>
    </table>
</div>

              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
        
        <div class="modal fade" id="updateFactureModal" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalScrollableTitle">Modification de Facture</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form id="factureUpdateForm">
                            <input type="hidden" id="updateId" name="aexpenseId">
                            <div class="modal-body">
                                <!--<div class="form-group">
                                    <label for="montant">Intitulé Dépense</label>
                                    <input type="text" class="form-control titre" id="updateTitre" name="titre" placeholder="" required>
                                </div>-->
                                <div class="form-group">
                                <label>Type Dépense</label>
                                <select name="titre" class="form-control select2bs4 titre" id="updateTitre" style="width: 100%; " required>
                                    <option>Veuillez choisir type dépense</option>
                                    <option value="Réparation">Réparation</option>
                                    <option value="Pièce">Pièce</option>
                                </select>
                            </div>
                                 <div class="form-group">
                                    <label for="description">Description</label>
                                    <input type="text" class="form-control description" id="updateDescription" name="description" placeholder="" required>
                                </div>
                                <div class="form-group">
                                    <label for="montant">Montant</label>
                                    <input type="text" class="form-control montant" name="montant" id="updateMontant" placeholder="0" required>
                                </div>
                               
                                <div class="form-group">
                                    <label for="date">Date</label>
                                    <input type="date" class="form-control edate" id="updateDate" name="edate"  placeholder="" required>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                                <button type="submit" class="btn btn-primary" id="updateDepense">Modifier</button>
                            </div>
                        </form>
                </div>
            </div>
        </div>
        
        
        <div class="modal fade" id="saveFactureAll" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalScrollableTitle">Insertion de facture</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    <form id="factureSaveFormAll" enctype="multipart/form-data">
                        <div class="modal-body" style="max-height: 400px; overflow-y: auto;">
                            <div class="form-group">
                                <label>Service</label>
                                <select name="service" class="form-control service" id="saveServiceAll" style="width: 100%;">
                                    <option></option>
                                    <option value="Drive">Drive</option>
                                    <option value="Store">Store</option>
                                </select>
                            </div>
                             <div class="form-group">
                                <label for="numero">Numéro facture</label>
                                <input type="text" class="form-control numerofacture" id="saveNumeroFactAll" name="numerofact" required>
                            </div>
                            <div class="form-group">
                                <label for="client">Client</label>
                                <input type="text" class="form-control clients" id="saveClientAll" name="client" required>
                            </div>
                            <div class="form-group">
                                <label for="numero">Numéro client</label>
                                <input type="text" class="form-control numeros" id="saveNumeroAll" name="numero" placeholder="0" required>
                            </div>

                            <div class="form-group">
                                <label for="montant">Montant</label>
                                <input type="text" class="form-control montant" id="saveMontantAll" name="montant" placeholder="0" required>
                            </div>
                            <div class="form-group">
                                <label>Status</label>
                                <select name="status" class="form-control type" id="saveStatusAll" style="width: 100%;">
                                    <option></option>
                                    <option value="Payé">Payée</option>
                                    <option value="Non payé">Non payée</option>
                                </select>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <label for="date">Date</label>
                                    <input type="datetime-local" class="form-control edate" id="saveDateAll" name="date_invoice" value="{{ date('Y-m-d\TH:i')}}" placeholder="" required>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                            <button type="submit" class="btn btn-primary" id="saveFactureChangeAll">Valider</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection