@php
$current_route=request()->route()->getName();
@endphp
@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Historique paiement</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Comptabilite</a></li>
              <li class="breadcrumb-item active">Historique</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('comptabilite-hpaiement') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-2">
                            <label>Filtre:</label>
                            <select class="form-control" name="option2">
                                <option value="All" {{ old('option2', $option2) == 'All' ? 'selected' : '' }}>All</option>
                                <option value="Hebdomadaire" {{ old('option2', $option2) == 'Hebdomadaire' ? 'selected' : '' }}>Hebdomadaire</option>
                                 <option value="Bimensuel" {{ old('option2', $option2) == 'Bimensuel' ? 'selected' : '' }}>Bimensuel</option>
                                  <option value="Mensuel" {{ old('option2', $option2) == 'Mensuel' ? 'selected' : '' }}>Mensuel</option>
                            </select>
                        </div>
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->
                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Type Service</th>
                    <th>Restaurant</th>
                    <th>Montant total</th>
                    <th>Frais livraison</th>
                    <th>Montant commande</th>
                    <th>Montant Commission</th>
                    <th>Montant net</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($pay_historiques as $item)
                  <tr>
                    <td>{{$item->vServiceName}}</b></td>
                    <td>{{$item->vCompany}}<br/><b>{{$item->vPhone}}</b></td>
                    <td>{{ number_format($item->totalFare , 0, '.', ' ') }}</td>
                    <td>{{ number_format($item->totalDeliveryCharge, 0, '.', ' ') }}</td>
                    <td>{{ number_format($item->subTotal , 0, '.', ' ') }}</td>
                    <td>{{ number_format($item->totalCommision , 0, '.', ' ') }}</td>
                    <td>{{ number_format($item->totalFare-($item->totalCommision+$item->totalDeliveryCharge+$item->totalOffersDiscount + $item->totalOutStandingAmount), 0, '.', ' ') }}</td>
                    
                     <!--<td><input type="checkbox" class="showAlertCheckbox" data-item-id="{{$item->iCompanyId}}">
                    </td>-->
                    <td>
                        <div class="btn-group btn-group-sm">
                        <a href="{{ route('comptabilite-hpaiementd', ['id' => $item->iCompanyId,'startDate' => $startDate, 'endDate' => $endDate])}}" class="nav-link {{$current_route=='comptabilite-hpaiement'?' active':''}}"  class="btn btn-info"><i class="fas fa-eye"></i></a>
                                           
                        </div>
                    </td>
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                     <th>Type Service</th>
                    <th>Restaurant</th>
                    <th>Montant total</th>
                    <th>Frais livraison</th>
                    <th>Montant commande</th>
                    <th>Montant Commission</th>
                    <th>Montant net</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection