@php
$current_route=request()->route()->getName();
@endphp
@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Paiement resto</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Comptabilite</a></li>
              <li class="breadcrumb-item active">Paiement resto</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('comptabilite-rpaiement') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-2">
                            <label>Filtre:</label>
                            <select class="form-control" name="option2">
                                <option value="All" {{ old('option2', $option2) == 'All' ? 'selected' : '' }}>All</option>
                                <option value="Hebdomadaire" {{ old('option2', $option2) == 'Hebdomadaire' ? 'selected' : '' }}>Hebdomadaire</option>
                                 <option value="Bimensuel" {{ old('option2', $option2) == 'Bimensuel' ? 'selected' : '' }}>Bimensuel</option>
                                  <option value="Mensuel" {{ old('option2', $option2) == 'Mensuel' ? 'selected' : '' }}>Mensuel</option>
                            </select>
                        </div>
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->
                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                        
                        <div class="col-md-2"></div>
                        <div class="col-md-1"></div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Type Service</th>
                    <th>Restaurant</th>
                    <th>Mobile Money</th>
                    <th>Responsable Mobile Money</th>
                    <!--<th>Montant total</th>
                     <th>Montant Commission</th>
                    <th>Frais livraison</th>
                    <th>Reduction</th>-->
                    <th>Versement Resto</th>
                    <th>Payer</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($paiement_restos as $item)
                  <tr>
                    <td>Repas</b></td>
                    <td>{{$item->vCompany}}<br/><b>{{$item->vPhone}}</b></td>
                    <td>{{$item->money}}</b></td>
                    <td>{{$item->moneyResp}}</b></td>
                    <td>{{ $item->totalFare-($item->totalCommision+$item->totalDeliveryCharge+$item->totalOffersDiscount + $item->totalOutStandingAmount) }}</td>
                    <td data-toggle="modal" data-target="#paieresto" data-id="{{ $item->iCompanyId }}" data-resto="{{ $item->vCompany }}" data-dated="{{ $startDate }}" data-datef="{{ $endDate }}" data-montant="{{ $item->totalFare-($item->totalCommision+$item->totalDeliveryCharge+$item->totalOffersDiscount + $item->totalOutStandingAmount) }}">
                        <input type="checkbox" class="showAlertCheckbox" data-item-id="{{ $item->iCompanyId }}"></td>
                    <td>
                        <div class="btn-group btn-group-sm">
                            <a href="{{ route('comptabilite-rpaiementd', ['id' => $item->iCompanyId,'startDate' => $startDate, 'endDate' => $endDate])}}" class="nav-link {{$current_route=='comptabilite-rpaiement'?' active':''}}"  class="btn btn-info"><i class="fas fa-eye"></i></a>
                        </div>
                    </td>
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                     <th colspan=3></th>
                    <th>Total versement resto</th>
                    <th>{{number_format($paiement_restos->sum('totalFare') - ($paiement_restos->sum('totalCommision') + $paiement_restos->sum('totalDeliveryCharge')+$paiement_restos->sum('totalOffersDiscount') + $paiement_restos->sum('totalOutStandingAmount')), 0, '.', ' ')  }}</th>
                    <th></th>
                      <th></th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        
        <div class="modal fade" id="paieresto" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalScrollableTitle">Confirmation paiement du restaurant :</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form id="editForm">
                            <input type="hidden" name="iCompanyId" id="iCompanyId"> 
                            <input type="hidden" class="form-control" name="dated" id="startdate"> 
                            <input type="hidden" class="form-control" name="datef" id="enddate"> 
                            <div class="modal-body">
                                {{-- Form fields --}}
                                <div class="form-group">
                                    <input type="hidden" class="form-control" name="iCompanyId" id="iIdC"> 
                                    <input type="hidden" class="form-control" name="dated" id="dated"> 
                                    <input type="hidden" class="form-control" name="datef" id="datef"> 
                                    <input type="text" class="form-control" name="resto"  id="resto" readonly>
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" name="montant"  id="montant" readonly>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <a href="#" class="btn btn-secondary" data-dismiss="modal">Fermer</a>
                                <button type="button" class="btn btn-primary" id="updatePaieResto">Payer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        
        
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection