
@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Ajustement paiement detail</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Comptabilite</a></li>
              <li class="breadcrumb-item active">Ajustement detail</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('comptabilite-spaydetail', $id) }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->
                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Type Service</th>
                    <th>Restaurant</th>
                    <th>N°Commande</th>
                    <th>Date commande</th>
                    <th>Montant total</th>
                    <th>Frais livraison</th>
                    <th>Montant commande</th>
                     <th>Montant Commission</th>
                    <th>Reduction</th>
                    <th>Montant net</th>
                    <th></th>
                    
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($pay_store_details as $item)
                  <tr>
                    <td>{{$item->vServiceName}}</b></td>
                    <td>{{$item->vCompany}}<br/><b>{{$item->vPhone}}</b></td>
                     <td>{{$item->vOrderNo}}</td>
                     <td>{{$item->oDate}}</td>
                    <td>{{ $item->totalFare}}</td>
                    <td>{{ $item->totalDeliveryCharge }}</td>
                     <td>{{ $item->subTotal }}</td>
                    <td>{{ $item->totalCommision}}</td>
                    <td>{{ $item->totalOffersDiscount }}</td>
                    <td>{{ $item->totalFare-($item->totalCommision+$item->totalDeliveryCharge+$item->totalOffersDiscount + $item->totalOutStandingAmount)}}</td>
                    
                     <td>
                         @if($item->vServiceName != 'Repas')
                            <div class="btn-group btn-group-sm">
                                                
                                <a href="#" class="btn btn-danger commision" data-toggle="modal" data-target="#exampleModalScrollable"
                                                        data-id="{{ $item->iOrderId }}"
                                                        data-company-id="{{ $item->iCompanyId }}"
                                                        data-company="{{ $item->vCompany }}"
                                                        data-subtotal="{{ $item->subTotal }}"
                                                       
                                                       data-commission="{{
                                                       $item->subTotal * (intval($item->commissionP) / 100);}}"

                                             >
                                <i class="fas fa-edit"></i>
                                </a>
                            </div>
                        @endif
                    </td>
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Type Service</th>
                    <th>Restaurant</th>
                    <th>N°Commande</th>
                    <th>Date commande</th>
                    <th>Montant total</th>
                    <th>Frais livraison</th>
                    <th>Montant commande</th>
                    <th>Montant Commission</th>
                    <th>Reduction</th>
                    <th>Montant net</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
           
            </div>
           
          </div>
         
        </div>
        <div class="modal fade" id="exampleModalScrollable" tabindex="-1" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalScrollableTitle">
                                    Modification commission
                            </h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form id="commissionForm" action="{{ route('comptabilite-updatec', ['id' => $item->iOrderId]) }}" method="POST">
                            @csrf
                            <input type="hidden" name="_method" value="'PUT'" id="methodInput">

                            <div class="modal-body">
                                {{-- Form fields --}}
                                <div class="form-group">
                                    <label for="resto">Restaurant</label>
                                    <input type="text" class="form-control" name="resto" id="resto" placeholder="Restaurant" disabled>
                                </div>
                                <div class="form-group">
                                    <label for="montant">Montant commande</label>
                                    <input type="text" class="form-control" name="subtotal" id="subtotal" placeholder="Montant commande" disabled>
                                </div>
                                <div class="form-group">
                                    <label for="commission">Commission()</label>
                                    <input type="text" class="form-control" name="commission" id="commission" placeholder="0" disabled>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                                <button type="submit" class="btn btn-primary">Valider</button>
                            </div>
                        </form>
                    </div>
                </div>
        </div>
        </div>
      
    </section>
    
    <!-- /.content -->
  </div>
  @endsection