@extends('master')

@php
    $current_route = request()->route()->getName();
    
     $controller = app()->make('App\Http\Controllers\Comptabilite');
    //$data = $controller->list_colis_by_livreur();
@endphp

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Point Drive Entreprise</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Comptabilite</a></li>
              <li class="breadcrumb-item active">Point Drive Entreprise</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('comptabilite-lpdriveo') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                       
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->
                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Entreprise</th>
                    <th>Nb course</th>
                    <th>Montant course (FCFA)</th>
                    <th>Gain okalm (FCFA)</th>
                    <th>Montant TVA (FCFA)</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>
                   @foreach ($organizations as $item)
                        <tr>
                            <td>{{$item->vCompany}}</td>
                            <td>{{$item->TotalCourse}}</td>
                            <td>{{$item->MontantCourse}}</td>
                            <td>{{$item->CommisionCourse}}</td>
                            <td>{{$item->MontantTva}}</td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('comptabilite-lpdriveodetail', ['id' => $item->organizationId,'startDate' => $startDate, 'endDate' => $endDate])}}" class="nav-link {{$current_route=='comptabilite-lpdriveo'?' active':''}}"  class="btn btn-info"><i class="fas fa-eye"></i></a>
                                           
                                </div>
                            </td>
                        </tr>
                    @endforeach

                  </tbody>
                  <tfoot>
                  <tr>
                   <th>Entreprise</th>
                    <th>Nb course</th>
                    <th>Montant course (FCFA)</th>
                    <th>Gain okalm (FCFA)</th>
                    <th>Montant TVA (FCFA)</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->

        
        <div class="modal fade" id="fairepoint" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalScrollableTitle">Confirmation du point du livreur :</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        
                        <form id="editForm">
                            <input type="hidden" name="iDriverId" id="iDriverId"> 
                            <input type="hidden" class="form-control" name="dated" id="startdate"> 
                            <input type="hidden" class="form-control" name="datef" id="enddate"> 
                            <div class="modal-body">
                                {{-- Form fields --}}
                                <div class="form-group">
                                    <input type="hidden" class="form-control" name="iDriverId" id="iId"> 
                                    <input type="hidden" class="form-control" name="dated" id="dated"> 
                                    <input type="hidden" class="form-control" name="datef" id="datef"> 
                                    <input type="text" class="form-control" name="livreur"  id="livreur" readonly>
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" name="balance"  id="balance" readonly>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <a href="#" class="btn btn-secondary" data-dismiss="modal">Fermer</a>
                                <button type="button" class="btn btn-primary" id="updateLivreurPoint">Confirmer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection