@extends('master')

@php
    $current_route = request()->route()->getName();
    
     $controller = app()->make('App\Http\Controllers\Comptabilite');
    //$data = $controller->list_colis_by_livreur();
@endphp

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Point Store livreur</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Comptabilite</a></li>
              <li class="breadcrumb-item active">Point Store livreur</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('comptabilite-lpstore') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-2">
                            <label>Type livreur:</label>
                            <select class="form-control" name="option2">
                                <option value="All" {{ old('option2', $option2) == 'All' ? 'selected' : '' }}>All</option>
                                <option value="Interne" {{ old('option2', $option2) == 'Interne' ? 'selected' : '' }}>Interne</option>
                                <option value="Externe" {{ old('option2', $option2) == 'Externe' ? 'selected' : '' }}>Externe</option>
                            </select>
                        </div>
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->
                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Livreur</th>
                    <th>Nb commande</th>
                    <th>Frais livraison</th>
                    <th>Gains livreur</th>
                    <th>Gain okalm</th>
                  </tr>
                  </thead>
                  <tbody>
                   @foreach ($point_deliveries as $item)
                        
                        <tr>
                            <td>{{$item->dname}}<br/><b>{{$item->vPhone}}</td>
                            <td>{{$item->nbCommande}}</td>
                            <td>{{$item->totalDeliverie}}</td>
                             @if (substr($item->vName, 0, 3) == 'LEX' || substr($item->vLastName, 0, 3)=='LEX')
                                <td>{{ $item->totalPaie }}</td>
                                <td>{{ $item->totalDeliverie-$item->totalPaie }}</td>
                             @else
                                <td>0</td>
                                <td>{{ $item->totalDeliverie }}</td>
                             @endif
                        </tr>
                    @endforeach

                  </tbody>
                  <tfoot>
                  <tr>
                   <th>Livreur</th>
                    <th>Nb commande</th>
                    <th>Frais livraison</th>
                    <th>Gains livreur</th>
                    <th>Gain okalm</th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->

        
        <div class="modal fade" id="fairepoint" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalScrollableTitle">Confirmation du point du livreur :</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        
                        <form id="editForm">
                            <input type="hidden" name="iDriverId" id="iDriverId"> 
                            <input type="hidden" class="form-control" name="dated" id="startdate"> 
                            <input type="hidden" class="form-control" name="datef" id="enddate"> 
                            <div class="modal-body">
                                {{-- Form fields --}}
                                <div class="form-group">
                                    <input type="hidden" class="form-control" name="iDriverId" id="iId"> 
                                    <input type="hidden" class="form-control" name="dated" id="dated"> 
                                    <input type="hidden" class="form-control" name="datef" id="datef"> 
                                    <input type="text" class="form-control" name="livreur"  id="livreur" readonly>
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" name="balance"  id="balance" readonly>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <a href="#" class="btn btn-secondary" data-dismiss="modal">Fermer</a>
                                <button type="button" class="btn btn-primary" id="updateLivreurPoint">Confirmer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection