@extends('master')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Paiement planning</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Comptabilite</a></li>
                        <li class="breadcrumb-item active">Paiement planning</li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6"></div>
                                <div class="col-md-5"></div>
                                <div class="col-md-1">
                                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModalScrollable">
                                        Ajouter
                                    </button>
                                </div>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Restaurant</th>
                                        <th>Période</th>
                                        <th>Commission</th>
                                         <th>Mobile money</th>
                                          <th>Responsable Mobile money</th>
                                        <th>Status</th>
                                        <th>Date enregistrement</th>
                                        <th colspan="">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($storeplans as $item)
                                    <tr>
                                        <td>{{$item->vCompanyName}}</b></td>
                                        <td>{{$item->vPeriode}}</td>
                                        <td>{{ $item->vCommission }}</td>
                                         <td>{{ $item->vMoney}}</td>
                                          <td>{{ $item->vMoneyResp}}</td>
                                        <td>{{ $item->eStatus }}</td>
                                        <td>{{$item->tDate}}</td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <!--<a href="#" class="btn btn-info"><i class="fas fa-eye"></i></a>-->
                                                <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#exampleModalScrollable"
                                                    data-id="{{ $item->iStoreTimingId }}"
                                                    data-company-id="{{ $item->iCompanyId }}"
                                                    data-periode="{{ $item->iPeriode }}"
                                                    data-commission="{{ $item->iCommission }}"
                                                     data-money="{{ $item->iMoney }}"
                                                     data-moneyresp="{{ $item->iMoneyResponsable }}"
                                                >
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Restaurant</th>
                                        <th>Période</th>
                                        <th>Commission</th>
                                         <th>Mobile money</th>
                                          <th>Responsable Mobile money</th>
                                        <th>Status</th>
                                        <th>Date d'enregistrement</th>
                                        <th colspan="">Action</th>
                                    </tr>
                                </tfoot>
                            </table>

                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
            </div>

            <!-- Modal -->
            <!--<div class="modal fade" id="exampleModalScrollable" tabindex="-1" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">-->
            <div class="modal fade" id="exampleModalScrollable" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalScrollableTitle">
                                {{-- Dynamic title --}}
                                @if(isset($modalItem))
                                    Modification de planning
                                @else
                                    Insertion de planning
                                @endif
                            </h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form id="planningForm" action="{{ isset($modalItem) ? route('comptabilite-update', ['id' => $modalItem->iStoreTimingId]) : route('comptabilite-save') }}" method="POST">
                            @csrf
                            <input type="hidden" name="_method" value="{{ isset($modalItem) ? 'PUT' : 'POST' }}" id="methodInput">


                            <div class="modal-body">
                                {{-- Form fields --}}
                                <div class="form-group">
                                    <label>Restaurant</label>
                                    <select name="iCompanyId"  class="form-control select2bs4" id="companyOption" style="width: 100%;">
                                        <option></option>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->iCompanyId }}">{{ $company->vCompany }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label>Période</label>
                                    <select name="iPeriode" class="form-control select2bs4" style="width: 100%;">
                                        <!--<option value="Quotidien" selected="selected">Quotidien</option>-->
                                        <option value="Hebdomadaire">Hebdomadaire</option>
                                        <!--<option value="Decadaire">Décadaire</option>-->
                                        <option value="Bimensuel">Bimensuel</option>
                                        <option value="Mensuel">Mensuel</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="commission">Commission(%)</label>
                                    <input type="text" class="form-control" name="iCommission" id="commission" placeholder="0" required>
                                </div>
                                <div class="form-group">
                                    <label for="momonay">Numéro mobile money</label>
                                    <input type="text" class="form-control" name="iMoney" id="money" placeholder="Mobile money" required>
                                </div>
                                <div class="form-group">
                                    <label for="moneyresp">Responsable mobile money</label>
                                    <input type="text" class="form-control" name="iMoneyResponsable" id="money_resp" placeholder="Responsable Mobile Money" required>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                                <button type="submit" class="btn btn-primary">Valider</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
@endsection


