@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Dashboard</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
              <li class="breadcrumb-item active">Administration</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
      <div class="row">
        <div class="col-12">
        <div class="card">
        <form action="{{ route('dashboard-administration') }}" method="GET">
        <div class="card-header">
          <div class="row">
              <div class="col-md-3">
                <label>Periode:</label>
                <select class="form-control" name="option1" id="filterOption2">
                      <option value="all" {{ old('option1', $option1) == 'all' ? 'selected' : '' }}>All</option>
                      <option value="currenty" {{ old('option1', $option1) =='currenty' || !$option1 ? 'selected' : '' }}>Cette année</option>
                      <option value="currentm" {{ old('option1', $option1) == 'currentm' ? 'selected' : '' }}>Ce mois</option>
                      <option value="currentw" {{ old('option1', $option1) =='currentw' ? 'selected' : '' }}>Cette Semaine</option>
                      <option value="today" {{ old('option1', $option1) =='today' ? 'selected' : '' }}>Aujourd'hui</option>
                      <option value="interval" {{ old('option1', $option1) =='interval' ? 'selected' : '' }}>Autre date</option>
                </select>

              </div>
              <div class="col-md-3">
                  <label>Date de début:</label>
                  <input type="date" class="form-control" name="startDate" id="startDate" value="{{ old('startDate', $startDate) }}">
              </div>
              <div class="col-md-3">
                  <label>Date de fin:</label>
                  <input type="date" class="form-control" name="endDate" id="endDate" value="{{ old('endDate', $endDate) }}">
              </div>
              <div class="col-md-1">
                  <label>&nbsp;</label>
                  <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
              </div>
          </div>
        </div>
        </form>
        <div class="card-body">
          <div class="row">
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><img src="{{asset('dist/img/okalmicon/okalm_taxi.png')}}"></span>

                <div class="info-box-content">
                  <span class="info-box-text">Courses terminées</span>
                  <span class="info-box-number">
                  {{$countAllDrive}}
                    <small></small>
                  </span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><img src="{{asset('dist/img/okalmicon/okalm_taxi.png')}}"></span>

                <div class="info-box-content">
                  <span class="info-box-text">Courses annulées</span>
                  <span class="info-box-number">
                  {{$countAllDriveCancel}} ({{$tauxAnnulationDrive}} % )
                    <small></small>
                  </span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-users"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Annulation des Chauffeurs</span>
                  <span class="info-box-number">{{$countAllDriverCancel}} ({{$tauxDriverCancel}} % )</span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->

            <!-- fix for small devices only -->
            <div class="clearfix hidden-md-up"></div>

            
            <!-- /.col -->
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-users"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Chauffeurs ( actifs / totaux) </span>
                  <span class="info-box-number">{{$countAllDriverActive}} / {{$countAllDriver}}</span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            
            <!-- /.col -->
          </div>
          <div class="row">
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><img src="{{asset('dist/img/okalmicon/okalm_repas.png')}}"></span>

                <div class="info-box-content">
                  <span class="info-box-text">Commandes livrées</span>
                  <span class="info-box-number">
                      {{$countAllOrder}}
                    <small></small>
                  </span>
                  
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><img src="{{asset('dist/img/okalmicon/okalm_repas.png')}}"></span>

                <div class="info-box-content">
                  <span class="info-box-text">Commandes annulées</span>
                  <span class="info-box-number">
                  {{$countOrderCanceled}} ({{$tauxAnnulationOrder}} %)
                    <small></small>
                  </span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-danger elevation-1"><img src="{{asset('dist/img/okalmicon/okalm_colis.png')}}"></span>

                <div class="info-box-content">
                  <span class="info-box-text">Colis livrés</span>
                  <span class="info-box-number">{{$countColis}}</span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->

            <!-- fix for small devices only -->
            <div class="clearfix hidden-md-up"></div>
            <!-- /.col -->
            <!-- /.col -->
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-users"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Utilisateurs enrégistrés </span>
                  <span class="info-box-number">{{$countAllUser}}</span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
          </div>
          <!-- /.row -->
          <!--<div class="row">
            <div class="col-12 col-sm-6 col-md-2">
              <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><img src="{{asset('dist/img/okalmicon/okalm_repas.png')}}"></span>

                <div class="info-box-content">
                  <span class="info-box-text">Transaction</span>
                  <span class="info-box-number">
                      {{$transactions}}
                    <small></small>
                  </span>
                  
                </div>
                
              </div>
             
            </div>
            <div class="col-12 col-sm-6 col-md-2">
              <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><img src="{{asset('dist/img/okalmicon/okalm_repas.png')}}"></span>

                <div class="info-box-content">
                  <span class="info-box-text">Crédit</span>
                  <span class="info-box-number">
                  {{$credits}} 
                    <small></small>
                  </span>
                </div>
                
              </div>
              
            </div>
            
            <div class="col-12 col-sm-6 col-md-2">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-danger elevation-1"><img src="{{asset('dist/img/okalmicon/okalm_colis.png')}}"></span>

                <div class="info-box-content">
                  <span class="info-box-text">Débit</span>
                  <span class="info-box-number">{{$debits}}</span>
                </div>
                
              </div>
             
            </div>
           
            <div class="clearfix hidden-md-up"></div>
          
            <div class="col-12 col-sm-6 col-md-2">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-users"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Balance</span>
                  <span class="info-box-number">{{$balances}}</span>
                </div>
               
              </div>
              
            </div>
           
              <div class="col-12 col-sm-6 col-md-2">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-users"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Wallet drive</span>
                  <span class="info-box-number">{{$countAllUser}}</span>
                </div>
               
              </div>
             
            </div>
           
              <div class="col-12 col-sm-6 col-md-2">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-users"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Wallet client</span>
                  <span class="info-box-number">{{$countAllUser}}</span>
                </div>
              
              </div>
           
            </div>
          </div>-->
        
          <div class="row">
            <div class="col-md-12">
              <div class="card">
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-9">
                        <div class="row">
                            <div class="col-md-4 col-6">
                                <div class="card">
                                    <div class="card-header">
                                      <h3 class="card-title">Type de vehicule (Drive)</h3>
                    
                                      <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                          <i class="fas fa-minus"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                                          <i class="fas fa-times"></i>
                                        </button>
                                      </div>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                          <div class="chart-responsive">
                                            <canvas id="pieChart11" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                                          </div>
                                    </div>
                                 </div>
                            <!-- /.card -->
                           </div>
                            <div class="col-md-4 col-6">
                              <div class="card">
                                <div class="card-header">
                                  <h3 class="card-title">Type de téléphone (Drive)</h3>
                
                                  <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                      <i class="fas fa-minus"></i>
                                    </button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                                      <i class="fas fa-times"></i>
                                    </button>
                                  </div>
                                </div>
                                <!-- /.card-header -->
                                <div class="card-body">
                              
                                      <div class="chart-responsive">
                                        <canvas id="pieChart111" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                                      </div>
                                </div>
                              </div>
                            </div>
                            <div class="col-md-4 col-6">
                              <div class="card">
                                <div class="card-header">
                                  <h3 class="card-title">Recharge wallet</h3>
                
                                  <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                      <i class="fas fa-minus"></i>
                                    </button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                                      <i class="fas fa-times"></i>
                                    </button>
                                  </div>
                                </div>
                                <!-- /.card-header -->
                                <div class="card-body">
                              
                                      <div class="chart-responsive">
                                        <canvas id="pieChart1111" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                                      </div>
                                </div>
                              </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.col -->
                    <div class="col-md-3">
                      <p class="text-center">
                        <strong>Taux</strong>
                      </p>

                      <div class="progress-group">
                        Conversion Clients
                        <span class="float-right"><b>{{$countNbcom}}</b> / {{$countAllUser}}</span>
                        <div class="progress progress-sm">
                          <div class="progress-bar bg-primary" style="width: 80%"></div>
                        </div>
                      </div>
                      <!-- /.progress-group -->

                      <div class="progress-group">
                        Annulation courses
                        <span class="float-right"><b>{{$countAllDriveCancel}}</b> / {{$allDrive}}</span>
                        <div class="progress progress-sm">
                          <div class="progress-bar bg-danger" style="width: 75%"></div>
                        </div>
                      </div>

                      <!-- /.progress-group -->
                      <div class="progress-group">
                        <span class="progress-text">Annulation commandes</span>
                        <span class="float-right"><b>{{$countOrderCanceled}} </b> / {{$countAllOrderAll}}</span>
                        <div class="progress progress-sm">
                          <div class="progress-bar bg-success" style="width: 60%"></div>
                        </div>
                      </div>

                      <!-- /.progress-group -->
                      <div class="progress-group">
                        Commande par portefeuille
                        <span class="float-right"><b>{{$countTp}} </b>/ {{$countAllOrderAll}}</span>
                        <div class="progress progress-sm">
                          <div class="progress-bar bg-warning" style="width: 50%"></div>
                        </div>
                      </div>
                      <!-- /.progress-group -->
                    </div>
                    <!-- /.col -->
                  </div>
                  <!-- /.row -->
                </div>
                <!-- ./card-body -->
                <div class="card-footer">
                  <div class="row">
                    <div class="col-sm-3 col-6">
                      <div class="description-block border-right">
                        <span class="description-percentage text-success"><i class="fas fa-caret-up"></i> </span>
                        <h5 class="description-header">FCFA {{$sumDrive}}</h5>
                        <span class="description-text">TOTAL COURSE</span>
                      </div>
                      <!-- /.description-block -->
                    </div>
                    <!-- /.col -->
                    <div class="col-sm-3 col-6">
                      <div class="description-block border-right">
                        <span class="description-percentage text-warning"><i class="fas fa-caret-left"></i></span>
                        <h5 class="description-header">FCFA {{$sumOrder}}</h5>
                        <span class="description-text">TOTAL COMMANDE</span>
                      </div>
                      <!-- /.description-block -->
                    </div>
                    <!-- /.col -->
                    <div class="col-sm-3 col-6">
                      <div class="description-block border-right">
                        <span class="description-percentage text-success"><i class="fas fa-caret-up"></i></span>
                        <h5 class="description-header">FCFA {{$sumColis}}</h5>
                        <span class="description-text">TOTAL COLIS</span>
                      </div>
                      <!-- /.description-block -->
                    </div>
                    <!-- /.col -->
                    <div class="col-sm-3 col-6">
                      <div class="description-block">
                        <span class="description-percentage text-danger"><i class="fas fa-caret-down"></i></span>
                        <h5 class="description-header">FCFA {{$sumTotal}}</h5>
                        <span class="description-text">Total</span>
                      </div>
                      <!-- /.description-block -->
                    </div>
                  </div>
                  <!-- /.row -->
                </div>
                <!-- /.card-footer -->
              </div>
              <!-- /.card -->
            </div>
            <!-- /.col -->
          </div>
          <!-- /.row -->

          <!-- Main row -->
          
          <div class="row">
            <!-- Left col -->
            <div class="col-md-6">
              <div class="card">
                <div class="card-header border-0">
                  <div class="d-flex justify-content-between">
                    <h3 class="card-title">Nombre Courses</h3>
                    <!--<a href="javascript:void(0);">View Report</a>-->
                  </div>
                </div>
                <div class="card-body">
                  <div class="d-flex">
                    <p class="d-flex flex-column">
                      <span class="text-bold text-lg"></span>
                      <span></span>
                    </p>
                    <p class="ml-auto d-flex flex-column text-right">
                      <span class="text-success">
                        <i class="fas fa-arrow-up"></i> 
                      </span>
                      <span class="text-muted"></span>
                    </p>
                  </div>
                  <!-- /.d-flex -->

                  <div class="position-relative mb-4">
                    <canvas id="sales-chart" height="200"></canvas>
                  </div>

                  <div class="d-flex flex-row justify-content-end">
                    <span class="mr-2">
                      <i class="fas fa-square text-primary"></i> Année
                    </span>

                    <span>
                      <i class="fas fa-square text-gray"></i> Année-1 
                    </span>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title">Nombre de commande</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
              
                      <div class="chart-responsive">
                        <canvas id="pieChart1111" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                      </div>
                </div>
              </div>
            </div>
            
          </div>

          <div class="row">
            <!-- Left col -->
            <div class="col-md-12">
                <div class="card card-success">
                  <div class="card-header">
                    <h3 class="card-title">Panier moyen</h3>

                    <div class="card-tools">
                      <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                      </button>
                      <button type="button" class="btn btn-tool" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                      </button>
                    </div>
                  </div>
                  <div class="card-body">
                    <div class="chart">
                      <canvas id="myChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                  </div>
                  <!-- /.card-body -->
                </div>
            </div>
            
          </div>
        </div>
        <!-- /.row -->
      </div><!--/. container-fluid -->
      </div>
      </div>
      </div>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  @endsection