@extends('master')
@section('content')

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Course</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
              <li class="breadcrumb-item active">Course</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <form action="{{ route('dashboard-course') }}" method="GET">
                    <div class="card-header">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Periode:</label>
                            <select  id="filterOption4" class="form-control" name="option4" >
                                <option value="all" {{ old('option4', $option4) == 'all' ? 'selected' : '' }}>All</option>
                                <option value="currenty" {{ old('option4', $option4) =='currenty' || !$option4 ? 'selected' : '' }}>Cette année</option>
                                <option value="currentm" {{ old('option4', $option4) == 'currentm' ? 'selected' : '' }}>Ce mois</option>
                                <option value="currentw" {{ old('option4', $option4) =='currentw' ? 'selected' : '' }}>Cette Semaine</option>
                                <option value="today" {{ old('option4', $option4) =='today' ? 'selected' : '' }}>Aujourd'hui</option>
                                <option value="interval" {{ old('option4', $option4) =='interval' ? 'selected' : '' }}>Autre date</option>
                            </select>

                        </div>
                        <div class="col-md-3">
                            <label>Date de début:</label>
                            <input id="startDate4" type="date" class="form-control" name="startDate"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3">
                            <label>Date de fin:</label>
                            <input id="endDate4"  type="date" class="form-control" name="endDate" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                    </div>
                    </form>
                    <div class="card-body">
                        <div class="row">
            @php
                $colorsss = [
                        'bg-info', 'bg-info', 'bg-', 'bg-warning',
                        'bg-info', 'bg-secondary', 'bg-dark', 'bg-light',
                        'bg-primary', 'bg-danger', 'bg-warning', 'bg-success'
                ];
                 $colors = [
                        'bg-light', 'bg-light', 'bg-light', 'bg-light',
                        'bg-light', 'bg-light', 'bg-light', 'bg-light',
                        'bg-light', 'bg-light', 'bg-light', 'bg-light'
                ];
                
                $colorss = [
                    'bg-color-1','bg-color-2','bg-color-3','bg-color-4',
                    'bg-color-5','bg-color-6','bg-color-7','bg-color-8',
                    'bg-color-9','bg-color-10','bg-color-11','bg-color-12'
                ];
              $moisNoms = [
                  1 => 'Janvier', 2 => 'Février', 3 => 'Mars',
                  4 => 'Avril', 5 => 'Mai', 6 => 'Juin',
                  7 => 'Juillet', 8 => 'Août', 9 => 'Septembre',
                  10 => 'Octobre', 11 => 'Novembre', 12 => 'Décembre'
              ];
            @endphp

            @foreach($result as $mois => $valeurs)
              <div class="col-lg-3 col-6">
                <div class="card-body text-white {{ $colors[$mois-1]}}  fw-bold">
                  <div class="inner">
                    <h4>{{ $moisNoms[$mois] }}</h4>
                    <p><strong>Total:</strong> {{ number_format($valeurs['total'], 0, ',', ' ') }} XOF</p>
                    <p><strong>Commission:</strong> {{ number_format($valeurs['fcommision'], 0, ',', ' ') }} XOF</p>
                    <p><strong>TVA:</strong> {{ number_format($valeurs['ftva'], 0, ',', ' ') }} XOF</p>
                  </div>
                  <div class="icon">
                    <i class="ion ion-stats-bars"></i>
                  </div>
                </div>
              </div>
            @endforeach
        </div>

                    </div>
                <!-- /.row -->
                </div><!--/. container-fluid -->
        </div>
        <!-- /.row -->
        <!-- Main row -->
        
        <!-- /.row (main row) -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
@endsection