<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Okalm</title>
      <style>
        body, html {
            margin: 0;
            padding: 0;
            height: 100%;
            font-family: Arial, sans-serif;
        }
        .container {
            display: flex;
            height: 100%;
        }
        .login-section, .image-section {
            flex: 1;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .login-section {
            background: #f5f7fa;
            flex-direction: column;
        }
        .image-section {
            background: url('dist/img/2708755.jpg') no-repeat center center;
            background-size: cover;
            color: white;
            text-align: center;
            position: relative;
        }
        .login-form {
            width: 80%;
            max-width: 400px;
        }
        .login-form h2 {
            margin-bottom: 20px;
        }
        .login-form input, .login-form button {
            width: 100%;
            padding: 15px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box; /* Ensures padding and border are included in the element's total width and height */
        }
        .login-form button {
            background: #007bff;
            border: none;
            color: white;
            cursor: pointer;
            font-size: 16px;
        }
        .login-form button:hover {
            background: #0056b3;
        }
        .image-section .content {
            position: absolute;
            bottom: 20px;
            left: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="login-section">
            <div class="login-form">
                <h2>Connexion</h2>
                <form method="post" action="{{ route('login') }}">
                    {{csrf_field()}}
                    <input type="email" name="email" placeholder="Email" required>
                    <input type="password" name="password" placeholder="Password" required>
                    <button type="submit">Se connecter</button>
                </form>
                
                
            </div>
        </div>
        <div class="image-section">
            <div class="content">
                <h1></h1>
                <p>!</p>
            </div>
        </div>
    </div>
</body>
</html>
