@php
$current_route=request()->route()->getName();
@endphp
@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Dépense</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Logistique</a></li>
              <li class="breadcrumb-item active">Dépense</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('logistique-depense') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->
                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                         <div class="col-md-4"></div>
                        <div class="col-md-1">
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#saveDepense">
                             Ajouter
                            </button>
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Type dépense</th>
                    <th>Description</th>
                    <th>Montant (XOF)</th>
                    <th>Driver</th>
                    <th>Date</th>
                    <!--<th></th>-->
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($depense_driver as $item)
                  <tr>
                    <td>{{$item->titre}}</td>
                    <td>{{$item->description }}</td>
                    <td>{{$item->montant }}</td>
                    <td>{{$item->driveur}}</td>
                    <td>{{$item->edate}}</td>
                    <!--<td>
                        <div class="btn-group btn-group-sm">
                            <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#updateDepenseModal"
                                            data-sidex="{{ $item->expenseId }}"
                                            data-stitre="{{ $item->titre }}"
                                            data-sdescription="{{ $item->description }}"
                                            data-smontant="{{ $item->montant }}"
                                            data-sdriveur="{{ $item->iDriverId }}"
                                            data-isdriveur="{{ $item->driveur }}"
                                            data-sedate="{{ $item->edate }}">
                             <i class="fas fa-edit"></i>
                            </a>
                                           
                        </div>
                    </td>-->
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Type dépense</th>
                    <th>Description</th>
                    <th>Montant (XOF)</th>
                    <th>Driver</th>
                    <th>Date</th>
                    <!--<th></th>-->
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
        
        <div class="modal fade" id="updateDepenseModal" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalScrollableTitle">Modification de dépense</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <form id="depenseUpdateForm">
                            <input type="hidden" id="updateId" name="expenseId">
                            <div class="modal-body">
                                <!--<div class="form-group">
                                    <label for="montant">Intitulé Dépense</label>
                                    <input type="text" class="form-control titre" id="updateTitre" name="titre" placeholder="" required>
                                </div>-->
                                <div class="form-group">
                                <label>Type Dépense</label>
                                <select name="titre" class="form-control select2bs4 titre" id="updateTitre" style="width: 100%; " required>
                                    <option>Veuillez choisir type dépense</option>
                                    <option value="Réparation">Réparation</option>
                                    <option value="Pièce">Pièce</option>
                                </select>
                            </div>
                                 <div class="form-group">
                                    <label for="description">Description</label>
                                    <input type="text" class="form-control description" id="updateDescription" name="description" placeholder="" required>
                                </div>
                                <div class="form-group">
                                    <label for="montant">Montant</label>
                                    <input type="text" class="form-control montant" name="montant" id="updateMontant" placeholder="0" required>
                                </div>
                                <div class="form-group">
                                    <label>Drivers</label>
                                    <select name="driveur" class="form-control select2bs4 driveur" id="updateDriveur" style="width: 100%;">
                                        <option></option>
                                        @foreach($driveurs as $driveur)
                                            <option value="{{ $driveur->iUserId }}">{{ $driveur->name }} {{$driveur->vPhone}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="date">Date</label>
                                    <input type="date" class="form-control edate" id="updateDate" name="edate"  placeholder="" required>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                                <button type="submit" class="btn btn-primary" id="updateDepense">Modifier</button>
                            </div>
                        </form>
                </div>
            </div>
        </div>
        
        
        <div class="modal fade" id="saveDepense" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalScrollableTitle">Insertion de dépense</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="depenseSaveForm" enctype="multipart/form-data">
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Type Dépense</label>
                                <select name="titre" class="form-control select2bs4 titre" id="saveTitre" style="width: 100%; " required>
                                    <option value="None">Veuillez choisir type dépense</option>
                                    <option value="Réparation">Réparation</option>
                                    <option value="Pièce">Pièce</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="description">Description</label>
                                <input type="text" class="form-control description" id="saveDescription" name="description" placeholder="Décrire la dépense" required>
                            </div>
                            <div class="form-group">
                                <label for="montant">Montant</label>
                                <input type="text" class="form-control montant" id="saveMontant" name="montant" placeholder="0" required>
                            </div>
                            <div class="form-group">
                                <label>Drivers</label>
                                <select name="driveur" class="form-control select2bs4 driveur" id="saveDriveur" style="width: 100%;">
                                    <option></option>
                                    @foreach($driveurs as $driveur)
                                        <option value="{{ $driveur->iUserId }}">{{ $driveur->name }} {{$driveur->vPhone}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-row">
                                <!--<div class="form-group col-md-8">
                                    <label for="image">Charger l'image de la facture</label>
                                    <input type="file" class="form-control image" name="image" id="image">
                                </div>-->
                                <div class="form-group col-md-12">
                                    <label for="date">Date</label>
                                    <input type="date" class="form-control edate" id="saveDate" name="edate" value="{{ date('Y-m-d') }}" placeholder="" required>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                            <button type="submit" class="btn btn-primary" id="saveDepenseChange">Valider</button>
                        </div>
                    </form>
            </div>
        </div>
        </div>

      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection