@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Point store OLOG details</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Logistique</a></li>
              <li class="breadcrumb-item active">Point store OLOG details</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('logistique-stored',['id' => $id]) }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->
                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>N°Commande</th>
                    <th>Store</th>
                    <th>Client</th>
                    <th>Téléphone</th>
                    <th>Article</th>
                    <th>Menu</th>
                    <th>Nombre</th>
                    <th>Montant (XOF)</th>
                    <th>Discount (XOF)</th>
                    <th>Reçu(XOF)</th>
                    <th>Date</th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($point_store_driver_details as $item)
                  <tr>
                    <td>{{$item->vOrderNo}}</b></td>
                    <td>{{$item->vCompany}}</td>
                    <td>{{ $item->vName }} {{ $item->vLastName }}</td>
                    <td>{{ $item->vPhone }}</td>
                    <td>{{$item->itemtype}}</td>
                    <td>{{$item->menu}}</td>
                     <td>{{$item->nombre}}</td>
                    <td>{{ $item->totalPrice }}</td>
                    <td>{{ $item->discountPrice}}</td>
                    <td>{{ $item->totalPrice - $item->discountPrice}}</td>
                    <td>{{$item->tDate}}</td>
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>N°Commande</th>
                    <th>Store</th>
                    <th>Client</th>
                    <th>Téléphone</th>
                    <th>Article</th>
                    <th>Menu</th>
                    <th>Nombre</th>
                    <th>Montant (XOF)</th>
                    <th>Discount (XOF)</th>
                    <th>Reçu(XOF)</th>
                    <th>Date</th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection