@php
$current_route=request()->route()->getName();
@endphp
@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Annulation</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Marketing</a></li>
              <li class="breadcrumb-item active">Annulation</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('marketing-canceled-driver') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                       
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Numéro</th>
                    <th>Raison</th>
                    <th>Commentaire</th>
                    <th>Chauffeur</th>
                    <th>Client</th>
                    <th>Date</th>
                    <th>Frais</th>
                    <th colspan=1></th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($canceles as $item)
                  <tr>
                    <td>{{$item->number}}</td>
                    @if($item->iCancelReasonId==0)
                        <td>{{$item->vCancelOther}}</td>
                    @else
                        <td>{{$item->vReason}}</td>
                    @endif
                    <td>{{$item->cancelComment}}</td>
                    <!--<td>{{$item->canceBy}}</td>-->
                    <td>{{ $item->provider}} ({{ $item->vPhone}})</td>
                    <td>{{$item->user}}</td>
                    <td>{{ $item->tdate}}</td>
                    @if($item->frais==1)
                        <td></td>
                        <td>{{ $item->admin}}</td>
                    @else
                        <td>{{ $item->frais}}</td>
                        <td>
                        <a title="Rembourser" href="#" class="btn btn-success btn-sm open-popuplus" data-toggle="modal" data-target="#myModalPlusRem" data-ide="{{ $item->iDriverId }}" data-idtri="{{ $item->iTripId }}">
                           <i class="fas fa-plus"></i> <!-- Icône FontAwesome -->
                        </a>
                        </td>
                    @endif
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                   <th>Numéro</th>
                    <th>Raison</th>
                    <th>Commentaire</th>
                    <th>Chauffeur</th>
                    <th>Client</th>
                    <th>Date</th>
                    <th>Frais</th>
                    <th colspan=1></th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
         <div class="modal fade" id="myModalPlusRem" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel">Remboursement</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form id="formPopup">
                                <input type="hidden" name="iDriverId" id="idride"> 
                                 <input type="hidden" name="iTripId" id="itride"> 
                                <div class="form-group">
                                    <p>Voulez-vous effectuer le remboursement?</p>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                            <button type="button" class="btn btn-primary" id="savePlusRem">Rembourser</button>
                        </div>
                    </div>
                </div>
            </div>
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection