@php
$current_route=request()->route()->getName();
@endphp
@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Parrainage</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Marketing</a></li>
              <li class="breadcrumb-item active">Liste parrainages</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('marketing-parrain') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->
                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Date</th>
                    <th>Client</th>
                    <th>Téléphone</th>
                    <th>Parrain</th>
                    <th>Téléphone</th>
                    <th>Drive</th>
                    <th>Repas</th>
                    <th>Colis</th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($parrains as $item)
                  <tr>
                    <td>{{$item->date}}</td>
                    <td>{{ $item->user }}</td>
                    <td>{{$item->uphone}}</td>
                    <td>{{ $item->parrain}}</td>
                    <td>{{ $item->pphone}}</td>
                    <td>{{ $item->total_drive}}</td>
                    <td>{{ $item->total_store}}</td>
                    <td>{{ $item->total_colis}}</td>
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                    <tr>
                        <th>Date</th>
                        <th>Client</th>
                        <th>Téléphone</th>
                        <th>Parrain</th>
                        <th>Téléphone</th>
                        <th>Drive</th>
                        <th>Repas</th>
                        <th>Colis</th>
                    </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection