@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Courses annulées</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Support</a></li>
              <li class="breadcrumb-item active">Courses</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
               <form action="{{ route('administration-commande') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate12"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate12" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form> 
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>N° course</th>
                    <th>Date course</th>
                    <th>Lancé par</th>
                    <th>Client</th>
                    <th>Drivreur</th>
                    <th>Montant(FCFA)</th>
                    <th>Statut</th>
                    <th>Raison</th>
                    <th>Par</th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($admin_courses as $item)
                  <tr>
                    <td>{{ $item->vRideNo }}</td>
                    <td>{{ $item->dDate }}</b></td>
                     <td>{{ $item->froms }}</td>
                    <td>{{ $item->passenger }} <br/> <b>{{ $item->user_phone }}</b></td>
                    <td>{{ $item->driveur }}<br/><b>{{ $item->driver_phone }}</b></td>
                    <td>{{ number_format($item->total , 0, '.', ' ') }}</td>
                    <td>{{ $item->status }}</td>
                    <td>{{ $item->raison }}</td>
                    <td>{{ $item->by }}</td>
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                   <tr>
                    <th>N° course</th>
                    <th>Date course</th>
                    <td>Lancé par</td>
                    <th>Client</th>
                    <th>Drivreur</th>
                    <th>Montant(FCFA)</th>
                    <th>Statut</th>
                    <th>Raison</th>
                    <th>Par</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
      </div>
    </section>
    
    <!-- /.content -->
  </div>
  @endsection