@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Liste des colis </h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Support</a></li>
              <li class="breadcrumb-item active">Colis</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('support-colis') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate12"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate12" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>N° colis</th>
                    <th>Client</th>
                    <th>Livreur</th>
                    <th>Date colis</th>
                    <!--<th>Catégorie</th>-->
                    <th>Distance</th>
                    <th>Durée</th>
                    <th>Montant(FCFA)</th>
                    <th>Commission</th>
                    <th>Paiement</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($colis as $item)
                  <tr>
                    <td>{{ $item->vRideNo }}</td>
                    <td>{{ $item->passenger }}</b></td>
                    <td>{{ $item->driver }}</td>
                    <td>{{ $item->tEndDate }}</td>
                    <!--<td>{{ $item->categorie }}</td>-->
                    <td>{{ $item->distance }}</td>
                    <td>{{ $item->duree }}</td>
                   <td>{{$item->total}}</td>
                    <td>{{ $item->comission }}</td>
                    <td>{{ $item->paiement }}</td>
                    <td>
                        <div class="btn-group btn-group-sm">
                            <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#editModalColis"
                            data-id="{{ $item->iTripId }}"
                            data-vride="{{ $item->vRideNo }}"
                            data-client="{{ $item->passenger }}"
                            data-livreurid="{{ $item->iDriverId }}"
                            data-livreur="{{ $item->driver }}"
                            data-tdate="{{ $item->tEndDate }}"
                            data-categorie="{{ $item->categorie }}"
                            data-distance="{{ $item->distance }}"
                            data-duree="{{ $item->duree }}"
                            data-walletpay="{{ $item->fwalletdebit }}"
                            data-cashpay="{{ $item->ifare }}"
                            data-total="{{ $item->total }}"
                            data-commission="{{ $item->comission }}">
                            <i class="fas fa-edit"></i>
                            </a>
                        </div>
                    </td>
                    
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                   <tr>
                    <th>N° colis</th>
                    <th>Client</th>
                    <th>Livreur</th>
                    <th>Date colis</th>
                    <!--<th>Catégorie</th>-->
                    <th>Distance</th>
                    <th>Durée</th>
                    <th>Montant(FCFA)</th>
                    <th>Commission</th>
                    <th>Paiement</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
        
        
          <!-- Modal -->
        <div class="modal fade" id="editModalColis" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editModalLabel">Modifier info colis</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                       <form id="editFormColis">
                        <input type="hidden" id="tripId" name="tripId"> <!-- Champ caché pour stocker l'ID de l'utilisateur -->
                        <div class="form-group">
                            <label for="vtrip">Réference course</label>
                            <input type="text" class="form-control" id="vtrip" name="vtrip" readonly>
                        </div>
                        <div class="form-group">
                            <label for="client">Client</label>
                            <input type="text" class="form-control" id="client" name="client" readonly>
                        </div>
                        <div class="form-group">
                            <label for="liveur">Livreur</label>
                            <select name="livreur"  class="form-control select2bs4" id="livreur" style="width: 100%;">
                                <option></option>
                                @foreach($liveurs as $livreur)
                                    <option value="{{ $livreur->iDriverId }}">{{ $livreur->name }}</option>
                                @endforeach
                            </select>
                        </div>
                       
                        <div class="generer"></div>
                        
                        <div class="form-group">
                            <label for="distance">Distance en KM</label>
                            <input type="text" class="form-control" id="distance" name="distance">
                        </div>
                         <div class="form-group">
                            <label for="duree">Durée en MN</label>
                            <input type="text" class="form-control" id="duree" name="duree">
                        </div>
                        <div class="form-group">
                            <label for="cashpay">Paiement cash</label>
                            <input type="text" class="form-control" id="cashpay" name="cashpay">
                        </div>
                        <div class="form-group">
                            <label for="walletpay">Paiement portefeuille</label>
                            <input type="text" class="form-control" id="walletpay" name="walletpay">
                        </div>
                        <div class="form-group">
                            <label for="montant">Montant total</label>
                            <input type="text" class="form-control" id="tmontant" name="tmontant">
                        </div>
                        <div class="form-group">
                            <label for="montant">Commission</label>
                            <input type="text" class="form-control" id="commision" name="commision" readonly>
                        </div>
                      
                        <!-- Ajoutez d'autres champs d'édition ici -->
                    </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                        <button type="button" class="btn btn-primary" id="saveChangeColis">Enregistrer les modifications</button>
                    </div>
                </div>
            </div>
        </div>
        
        
        
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection