@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Liste des commandes</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Support</a></li>
              <li class="breadcrumb-item active">Commandes</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('support-commande') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate12"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate12" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>N° commande</th>
                    <th>Date commande</th>
                    <th>Client</th>
                    <th>Partenaire</th>
                    <th>Livreur</th>
                    <th>Montant(FCFA)</th>
                    <th>Paiement</th>
                     <th></th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($commandes as $item)
                  <tr>
                    <td>{{ $item->vOrderNo }}</td>
                    <td>{{ $item->dDate }}</b></td>
                    <td>{{ $item->client }}</td>
                    <td>{{ $item->vCompany }}</td>
                    <td>{{ $item->livreur }}</td>
                    <td>{{ number_format($item->montant , 0, '.', ' ') }}</td>
                    <td>{{ $item->ePaymentOption }}</td>
                    <td>
                        <div class="btn-group btn-group-sm">
                            <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#editModalCommand"
                            data-id="{{ $item->iOrderId }}"
                            data-vorder="{{ $item->vOrderNo }}"
                            data-odate="{{ $item->dDate }}"
                            data-client="{{ $item->client }}"
                            data-driverid="{{ $item->iDriverId }}"
                            data-livreur="{{ $item->livreur }}"
                            data-payment="{{ $item->ePaymentOption }}"
                            data-montant="{{ $item->montant }}"
                            data-delivery="{{ $item->fDelivery }}"
                            data-wallet=" {{ $item->walletMontant }} "
                            data-tmontant="{{ $item->montantTotal }}"
                            data-fPackingCharge="{{ $item->fPackingCharge }}">
                            <i class="fas fa-edit"></i>
                            </a>
                        </div>
                    </td>
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                   <tr>
                    <th>N° commande</th>
                    <th>Date commande</th>
                    <th>Client</th>
                    <th>Partenaire</th>
                    <th>Livreur</th>
                    <th>Montant(FCFA)</th>
                     <th>Paiement</th>
                      <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
        
         <!-- Modal -->
        <div class="modal fade" id="editModalCommand" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editModalLabel">Modifier info commande</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <!-- Ajoutez ici les champs d'édition des données -->
                        <!-- Ajoutez ici les champs d'édition des données -->
                    <form id="editFormCom">
                        <input type="hidden" id="orderId" name="orderId"> <!-- Champ caché pour stocker l'ID de l'utilisateur -->
                        <div class="form-group">
                            <label for="vorder">Réference commande</label>
                            <input type="text" class="form-control" id="vorder" name="vorder" readonly>
                        </div>
                        <div class="form-group">
                            <label for="client">Client</label>
                            <input type="text" class="form-control" id="client" name="client" readonly>
                        </div>
                        <div class="form-group">
                            <label for="liveur">Livreur</label>
                            <select name="livreur"  class="form-control select2bs4" id="livreur" style="width: 100%;">
                                <option></option>
                                @foreach($livreurs as $livreur)
                                    <option value="{{ $livreur->iDriverId }}">{{ $livreur->name }}</option>
                                @endforeach
                            </select>
                        </div>
                       
                        <div class="generer"></div>
                        <!--<div class="form-group">
                            <label for="deliverycharge">Frais d'emballage</label>
                            <input type="text" class="form-control" id="fPackingCharge" name="fPackingCharge">
                        </div>-->
                        <div class="form-group">
                            <label for="deliverycharge">Frais de livraison</label>
                            <input type="text" class="form-control" id="delivery" name="delivery">
                        </div>
                         <div class="form-group">
                            <label for="cashpayment">Paiement cash</label>
                            <input type="text" class="form-control" id="cashpay" name="cashpay">
                        </div>
                         <div class="form-group">
                            <label for="walletpay">Paiement portefeuille</label>
                            <input type="text" class="form-control" id="walletpay" name="walletpay">
                        </div>
                        <div class="form-group">
                            <label for="montant">Montant total</label>
                            <input type="text" class="form-control" id="tmontant" name="tmontant">
                        </div>
                      
                        <!-- Ajoutez d'autres champs d'édition ici -->
                    </form>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                        <button type="button" class="btn btn-primary" id="saveChangeCom">Enregistrer les modifications</button>
                    </div>
                </div>
            </div>
        </div>
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection