@extends('master')

@section('content')
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Liste des courses </h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Support</a></li>
              <li class="breadcrumb-item active">Courses</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="{{ route('support-course') }}" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate12"  value="{{ old('startDate', $startDate) }}">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate12" value="{{ old('endDate', $endDate) }}">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>N° course</th>
                    <th>Client</th>
                    <th>Chauffeur</th>
                    <th>Date course</th>
                    <th>Catégorie</th>
                    <th>Distance</th>
                    <th>Durée</th>
                    <th>Montant(FCFA)</th>
                    <th>Commission</th>
                    <th>Paiement</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach ($courses as $item)
                  <tr>
                    <td>{{ $item->vRideNo }}</td>
                    <td>{{ $item->passenger }}</b></td>
                    <td>{{ $item->driver }}</td>
                    <td>{{ $item->tEndDate }}</td>
                    <td>{{ $item->categorie }}</td>
                    <td>{{ $item->distance }}</td>
                    <td>{{ $item->duree }}</td>
                   <td>{{$item->total}}</td>
                    <td>{{ $item->comission }}</td>
                    <td>{{ $item->paiement }}</td>
                    @if($item->paiement == 'Organization')
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#editModalCourseOrg"
                                data-idt="{{ $item->iTripId }}"
                                data-vride="{{ $item->vRideNo }}"
                                data-client="{{ $item->passenger }}"
                                data-driveridt="{{ $item->iDriverId }}"
                                data-driveur="{{ $item->driver }}"
                                data-tdate="{{ $item->tEndDate }}"
                                data-categorie="{{ $item->categorie }}"
                                data-distancet="{{ $item->distance }}"
                                data-dureet="{{ $item->duree }}"
                                data-totalt="{{ $item->total }}"
                                data-commissiont="{{ $item->comission }}">
                                <i class="fas fa-edit"></i>
                                </a>
                            </div>
                        </td>
                    @else
                    
                    <td>
                        <div class="btn-group btn-group-sm">
                            <a href="#" class="btn btn-danger" data-toggle="modal" data-target="#editModalCourse"
                            data-id="{{ $item->iTripId }}"
                            data-vride="{{ $item->vRideNo }}"
                            data-client="{{ $item->passenger }}"
                            data-driverid="{{ $item->iDriverId }}"
                            data-driveur="{{ $item->driver }}"
                            data-tdate="{{ $item->tEndDate }}"
                            data-categorie="{{ $item->categorie }}"
                            data-distance="{{ $item->distance }}"
                            data-duree="{{ $item->duree }}"
                            data-walletpay="{{ $item->fwalletdebit }}"
                            data-cashpay="{{ $item->ifare }}"
                            data-total="{{ $item->total }}"
                            data-commission="{{ $item->comission }}">
                            <i class="fas fa-edit"></i>
                            </a>
                        </div>
                    </td>
                    @endif
                    
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                   <tr>
                    <th>N° course</th>
                    <th>Client</th>
                    <th>Chauffeur</th>
                    <th>Date course</th>
                    <th>Catégorie</th>
                    <th>Distance</th>
                    <th>Durée</th>
                    <th>Montant(FCFA)</th>
                    <th>Commission</th>
                    <th>Paiement</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
        
        
          <!-- Modal -->
        <div class="modal fade" id="editModalCourse" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editModalLabel">Modifier info course</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                       <form id="editFormCourse">
                        <input type="hidden" id="tripId" name="tripId"> <!-- Champ caché pour stocker l'ID de l'utilisateur -->
                        <div class="form-group">
                            <label for="vtrip">Réference course</label>
                            <input type="text" class="form-control" id="vtrip" name="vtrip" readonly>
                        </div>
                        <div class="form-group">
                            <label for="client">Client</label>
                            <input type="text" class="form-control" id="client" name="client" readonly>
                        </div>
                        <div class="form-group">
                            <label for="liveur">Chauffeur</label>
                            <select name="drivreur"  class="form-control select2bs4" id="drivreur" style="width: 100%;">
                                <option></option>
                                @foreach($driveurs as $drivreur)
                                    <option value="{{ $drivreur->iDriverId }}">{{ $drivreur->name }}</option>
                                @endforeach
                            </select>
                        </div>
                       
                        <div class="generer"></div>
                        
                        <div class="form-group">
                            <label for="distance">Distance en KM</label>
                            <input type="text" class="form-control" id="distance" name="distance">
                        </div>
                         <div class="form-group">
                            <label for="duree">Durée en MN</label>
                            <input type="text" class="form-control" id="duree" name="duree">
                        </div>
                        <div class="form-group">
                            <label for="cashpay">Paiement cash</label>
                            <input type="text" class="form-control" id="cashpay" name="cashpay">
                        </div>
                        <div class="form-group">
                            <label for="walletpay">Paiement portefeuille</label>
                            <input type="text" class="form-control" id="walletpay" name="walletpay">
                        </div>
                        <div class="form-group">
                            <label for="montant">Montant total</label>
                            <input type="text" class="form-control" id="tmontant" name="tmontant">
                        </div>
                        <div class="form-group">
                            <label for="montant">Commission</label>
                            <input type="text" class="form-control" id="commision" name="commision" readonly>
                        </div>
                      
                        <!-- Ajoutez d'autres champs d'édition ici -->
                    </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                        <button type="button" class="btn btn-primary" id="saveChangeCourse">Enregistrer les modifications</button>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="editModalCourseOrg" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editModalLabel">Modifier info course</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                       <form id="editFormCourseOrg">
                        <input type="hidden" id="tripIds" name="tripId"> <!-- Champ caché pour stocker l'ID de l'utilisateur -->
                        <div class="form-group">
                            <label for="vtrip">Réference course</label>
                            <input type="text" class="form-control" id="vtrip" name="vtrip" readonly>
                        </div>
                        <div class="form-group">
                            <label for="client">Client</label>
                            <input type="text" class="form-control" id="client" name="client" readonly>
                        </div>
                        <div class="form-group">
                            <label for="liveur">Chauffeur</label>
                            <select name="drivreur"  class="form-control select2bs4" id="drivreurt" style="width: 100%;">
                                <option></option>
                                @foreach($driveurs as $drivreur)
                                    <option value="{{ $drivreur->iDriverId }}">{{ $drivreur->name }}</option>
                                @endforeach
                            </select>
                        </div>
                       
                        <div class="generer"></div>
                        
                        <div class="form-group">
                            <label for="distance">Distance en KM</label>
                            <input type="text" class="form-control" id="distancet" name="distance">
                        </div>
                         <div class="form-group">
                            <label for="duree">Durée en MN</label>
                            <input type="text" class="form-control" id="dureet" name="duree">
                        </div>
                        
                        <div class="form-group">
                            <label for="montant">Montant total</label>
                            <input type="text" class="form-control" id="tmontantt" name="tmontant">
                        </div>
                        <div class="form-group">
                            <label for="montant">Commission</label>
                            <input type="text" class="form-control" id="commisiont" name="commision" readonly>
                        </div>
                      
                        <!-- Ajoutez d'autres champs d'édition ici -->
                    </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                        <button type="button" class="btn btn-primary" id="saveChangeCourseOrg">Enregistrer les modifications</button>
                    </div>
                </div>
            </div>
        </div>
        
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  @endsection