<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*Route::get('/', function () {
    return view('welcome');
});*/
Route::get('/', function () {
    // Rediriger vers la route nommée 'dashboard-administration'
    return redirect()->route('login');
});

use App\Http\Controllers\Dashboard;
use App\Http\Controllers\Administration;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\Logistique;
use App\Http\Controllers\Comptabilite;
use App\Http\Controllers\Marketing;
use App\Http\Controllers\Support;
use App\Http\Controllers\Setting;

//Route::get('/dashboard/administration', [Dashboard::class, 'administration'])->name('dashboard-administration');

/***/
//Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login'])->name('login');
Route::get('/logout', [LoginController::class, 'logout'])->name('logout');

/****/ 
/*/ */
Route::get('/administration/login', [Administration::class,'login'])->name('administration-login');
Route::get('/dashboard/administration', [Dashboard::class, 'administration'])->name('dashboard-administration');
Route::get('/dashboard/wallet', [Dashboard::class, 'wallet'])->name('dashboard-wallet');
Route::get('/dashboard/course', [Dashboard::class, 'course'])->name('dashboard-course');
Route::get('/dashboard/logistique', [Dashboard::class, 'logistique'])->name('dashboard-logistique');
Route::get('/dashboard/comptabilite', [Dashboard::class, 'comptabilite'])->name('dashboard-comptabilite');
Route::get('/administration/liste_driver', [Administration::class, 'liste_driver'])->name('administration-driver');
Route::get('/administration/liste_user', [Administration::class, 'liste_user'])->name('administration-user');
Route::get('/administration/liste_drive', [Administration::class, 'liste_drive'])->name('administration-drive');
Route::get('/administration/liste_drive_group', [Administration::class, 'liste_drive_group'])->name('administration-drive-group');
Route::get('/administration/parcour_drive', [Administration::class, 'parcour_drive'])->name('administration-parcour');
Route::get('/administration/liste_partners_store', [Administration::class, 'liste_partner_store'])->name('administration-store');
Route::get('/administration/liste_partners_taxi', [Administration::class, 'liste_partner_taxi'])->name('administration-taxi');
/* +=========================Admin wallet=============================+ */
Route::get('/administration/liste_deposit', [Administration::class, 'liste_deposit'])->name('administration-deposit');
Route::get('/administration/liste_balance', [Administration::class, 'liste_balance'])->name('administration-balance');
Route::post('/administration/soustract_balance', [Administration::class, 'soustract_balance'])->name('balance-soustract');
Route::post('/administration/additional_balance', [Administration::class, 'additional_balance'])->name('balance-additional');
Route::post('/administration/remboursement_balance', [Administration::class, 'remboursement_balance'])->name('balance-remboursement');

Route::get('/administration/liste_transaction', [Administration::class, 'liste_transaction'])->name('administration-transaction');
Route::get('/administration/liste_wallet_statistic', [Administration::class, 'liste_wallet_statistic'])->name('administration-statistic');
//Route::get('/getChartData', [D::class, 'getChartData']);
Route::get('/getChartData', [Dashboard::class, 'getChartData']);
Route::get('/getChartDataDevice', [Dashboard::class, 'getChartDataDevice']);
Route::get('/getChartDataWallet', [Dashboard::class, 'getChartDataWallet']);
Route::get('/getChartDataPanierMoins', [Dashboard::class, 'getChartDataPanierMoins']);
Route::get('/getChartDataCompareTripLastYear', [Dashboard::class, 'getChartDataCompareTripLastYear']);
//Commandes
Route::get('/administration/liste_livreur', [Administration::class, 'liste_livreur'])->name('administration-livreur');
Route::get('/administration/liste_user_commande', [Administration::class, 'liste_user_commande'])->name('administration-usercommande');

Route::get('/administration/liste_commande', [Administration::class, 'liste_commande'])->name('administration-commande');

//Comptabilite
Route::get('/comptabilite/liste_store_planning', [Comptabilite::class, 'liste_store_planning'])->name('comptabilite-store');

Route::post('/comptabilite/save_store_planning', [Comptabilite::class, 'save_store_planning'])->name('comptabilite-save');

Route::post('/comptabilite/update_store_planning', [Comptabilite::class, 'update_store_planning'])->name('comptabilite-update');

Route::put('/comptabilite/update_store_planning/{id}', [Comptabilite::class, 'update_store_planning'])->name('comptabilite-update');
/* ==============================comptabilite depense================================ */
Route::get('/comptabilite/liste_depense', [Comptabilite::class, 'liste_depense'])->name('comptabilite-depense');

Route::post('/comptabilite/saveDepense', [Comptabilite::class, 'saveDepense'])->name('comptabilite-dsave');


/* ==============================comptabilite facture================================ */
Route::get('/comptabilite/liste_facture', [Comptabilite::class, 'liste_facture'])->name('comptabilite-facture');

Route::post('/comptabilite/saveFacture', [Comptabilite::class, 'saveFacture'])->name('comptabilite-fsave');

Route::put('/factures/{id}/status', [Comptabilite::class, 'updateStatus'])->name('invoices.updateStatus');


/* =+===================Resto paiement==============+============ */

Route::get('/comptabilite/liste_paiement_resto', [Comptabilite::class, 'liste_paiement_resto'])->name('comptabilite-rpaiement');

Route::get('/comptabilite/liste_paiement_resto_detail/{id}', [Comptabilite::class, 'liste_paiement_resto_detail'])->name('comptabilite-rpaiementd');

Route::get('/comptabilite/liste_store_gain', [Comptabilite::class, 'liste_store_gain'])->name('comptabilite-sgain');

Route::get('/comptabilite/liste_historique_paiement', [Comptabilite::class, 'liste_historique_paiement'])->name('comptabilite-hpaiement');

Route::get('/comptabilite/liste_historique_paiement_detail/{id}', [Comptabilite::class, 'liste_historique_paiement_detail'])->name('comptabilite-hpaiementd');

Route::get('/comptabilite/liste_point_store_comptable', [Comptabilite::class, 'liste_point_store_comptable'])->name('comptabilite-pscomptable');

/* +====+=============+======================+=========+ */

Route::get('/comptabilite/liste_pay_store', [Comptabilite::class, 'liste_pay_store'])->name('comptabilite-spay');

Route::get('/comptabilite/liste_pay_store_detail/{id}', [Comptabilite::class, 'liste_pay_store_detail'])->name('comptabilite-spaydetail');

Route::post('/comptabilite/update_store_commission', [Comptabilite::class, 'update_store_commission'])->name('comptabilite-updatec');

Route::get('/comptabilite/liste_pay_livreur', [Comptabilite::class, 'liste_pay_livreur'])->name('comptabilite-lpay');

Route::get('/comptabilite/liste_pay_livreur_detail/{id}', [Comptabilite::class, 'liste_pay_livreur_detail'])->name('comptabilite-lpaydetail');

Route::get('/comptabilite/liste_point_pay_livreur', [Comptabilite::class, 'liste_point_pay_livreur'])->name('comptabilite-lppay');

Route::get('/comptabilite/liste_point_store_livreur', [Comptabilite::class, 'liste_point_store_livreur'])->name('comptabilite-lpstore');

Route::get('/comptabilite/liste_point_colis_livreur', [Comptabilite::class, 'liste_point_colis_livreur'])->name('comptabilite-lpcolis');

Route::get('/comptabilite/liste_point_drive', [Comptabilite::class, 'liste_point_drive'])->name('comptabilite-lpdrive');

Route::get('/comptabilite/liste_point_drive_orga', [Comptabilite::class, 'liste_point_drive_orga'])->name('comptabilite-lpdriveo');

Route::get('/comptabilite/liste_point_drive_orga_detail/{id}', [Comptabilite::class, 'liste_point_drive_orga_detail'])->name('comptabilite-lpdriveodetail');

Route::post('/Comptabilite/updateStatusLivreurPoint', [Comptabilite::class, 'updateStatusLivreurPoint'])->name('livreur-point');

Route::post('/Comptabilite/upStorePaymentStatus', [Comptabilite::class, 'upStorePaymentStatus'])->name('store-payment');

Route::post('/Comptabilite/upStoreDetailPaymentStatus', [Comptabilite::class, 'upStoreDetailPaymentStatus'])->name('storedetail-payment');

Route::get('/Comptabilite/getLoadCompanyCommission/{id}', [Comptabilite::class,'getLoadCompanyCommission'])->name('get-data');

/* +================Marketing===============+ */

Route::get('/marketing/liste_review', [Marketing::class, 'liste_review'])->name('marketing-review');
Route::get('/marketing/liste_parrain', [Marketing::class, 'liste_parrain'])->name('marketing-parrain');

Route::get('/marketing/liste_canceled', [Marketing::class, 'liste_canceled'])->name('marketing-canceled');

Route::get('/marketing/liste_canceled_driver', [Marketing::class, 'liste_canceled_driver'])->name('marketing-canceled-driver');

Route::get('/marketing/liste_booking_by_admin', [Marketing::class, 'liste_booking_by_admin'])->name('marketing-badmin');

Route::get('/marketing/user_list_by_admin_booking', [Marketing::class, 'user_list_by_admin_booking'])->name('marketing-badminu');

Route::get('/marketing/recherche_drive', [Marketing::class, 'recherche_drive'])->name('recherche-drive');

/*+================Support================+*/

Route::get('/support/liste_user_otp', [Support::class, 'liste_user_otp'])->name('user-otp');

Route::get('/support/getUserOtp', [Support::class, 'getUserOtp'])->name('search-otp');

Route::get('/support/getCommand', [Support::class, 'getCommand'])->name('support-commande');

Route::get('/support/getAdminCourse', [Support::class, 'getAdminCourse'])->name('support-dcourse');

Route::get('/support/getItems', [Support::class, 'getItems'])->name('support-items');

Route::get('/support/getCourse', [Support::class, 'getCourse'])->name('support-course');

Route::post('/support/update', [Support::class, 'update'])->name('update');
Route::post('/support/updateFreeLivreur', [Support::class, 'updateFreeLivreur'])->name('updateFree');

Route::get('/support/getColis', [Support::class, 'getColis'])->name('support-colis');

Route::post('/support/updateCommand', [Support::class, 'updateCommand'])->name('update-command');

Route::post('/support/updateCourse', [Support::class, 'updateCourse'])->name('update-course');

Route::post('/support/updateColis', [Support::class, 'updateColis'])->name('update-colis');

Route::get('/support/getDriveScolaire', [Support::class, 'getDriveScolaire'])->name('support-drive-scolaire');

Route::post('/support/saveDriveSchool', [Support::class, 'saveDriveSchool'])->name('support-dssave');

Route::get('/get-parents', [Support::class, 'getParents']);

Route::get('/support/getDriveDeactive', [Support::class, 'getDriveDeactive'])->name('support-drive-deactive');

Route::post('/support/saveDriveDeactive', [Support::class, 'saveDriveDeactive'])->name('support-dsssave');

Route::get('/update-status/{id}/{status}', [Support::class, 'updateStatus'])->name('updateStatus');

Route::get('/update-estatus/{id}/{idriver}', [Support::class, 'updateDStatus'])->name('updateDStatus');

Route::get('/support/getDriveDeblok', [Support::class, 'getDriveDeblok'])->name('support-livreur-deblok');


/* +===========Logistique=======================+ */

Route::get('/logistique/liste_point_store', [Logistique::class, 'liste_point_store'])->name('logistique-store');

Route::get('/logistique/liste_point_store_detail/{id}', [Logistique::class, 'liste_point_store_detail'])->name('logistique-stored');

Route::get('/logistique/liste_depense_drive', [Logistique::class, 'liste_depense_drive'])->name('logistique-depense');

Route::post('/logistique/saveDepense', [Logistique::class, 'saveDepense'])->name('logistique-dsave');

Route::post('/logistique/updateDepense', [Logistique::class, 'updateDepense'])->name('logistique-dupdate');

/* +==================================Settings=============================+ */
Route::get('/setting/parametre_driver', [Setting::class, 'parametre_driver'])->name('setting-dslimite');

Route::post('/setting/updateParametre', [Setting::class, 'updateParametre'])->name('setting-update');

Route::post('/setting/updateParametre2', [Setting::class, 'updateParametre2'])->name('setting-update2');

Route::post('/setting/addParametre2', [Setting::class, 'addParametre2'])->name('setting-add');

Route::get('/setting/driver_list_checkin', [Setting::class, 'driver_list_checkin'])->name('setting-dcheckin');

Route::get('/setting/best_driver', [Setting::class, 'best_driver'])->name('setting-ddriver');

Route::post('/setting/activate/{id}', [Setting::class, 'activate'])->name('setting-activate');

Route::post('/setting/desactivate/{id}', [Setting::class, 'deactivate'])->name('setting-deactivate');

Route::post('/setting/actparam/{id}', [Setting::class, 'actparam'])->name('setting-actparam');

Route::post('/setting/deactparam/{id}', [Setting::class, 'deactparam'])->name('setting-deactparam');

/* +=================================Recharge forfait internet ======================+ */
Route::get('/administration/form_unite', [Administration::class, 'view_unite'])->name('administration-unite');
Route::post('/administration/send_unite', [Administration::class, 'send_unite'])->name('send-unite');
//
Route::get('/administration/liste_forfait', [Administration::class, 'liste_forfait'])->name('administration-forfait');
Route::post('/administration/subscribe_forfait', [Administration::class, 'subscribe_forfait'])->name('subscribe-forfait');
//
Route::get('/administration/liste_historique', [Administration::class, 'liste_historique'])->name('administration-historique');
/* +====================================End==========================================+ */ 


