<?php
$current_route=request()->route()->getName();
?>


<?php $__env->startSection('content'); ?>
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Paie livreur</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Comptabilite</a></li>
              <li class="breadcrumb-item active">Paie livreur</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
                <form action="<?php echo e(route('comptabilite-lpay')); ?>" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-2">
                            <label>Type livreur:</label>
                            <select class="form-control" name="option2">
                                <option value="All" <?php echo e(old('option2', $option2) == 'All' ? 'selected' : ''); ?>>All</option>
                                <option value="Interne" <?php echo e(old('option2', $option2) == 'Interne' ? 'selected' : ''); ?>>Interne</option>
                                <option value="Externe" <?php echo e(old('option2', $option2) == 'Externe' ? 'selected' : ''); ?>>Externe</option>
                            </select>
                        </div>
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="<?php echo e(old('startDate', $startDate)); ?>">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="<?php echo e(old('endDate', $endDate)); ?>">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->
                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Livreur</th>
                    <th>Montant total</th>
                    <th>Frais livraison</th>
                    <th>Montant Commission</th>
                    <th>Gain Livreur</th>
                    <!--<td><th>Payer</th>-->
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>
                  <?php $__currentLoopData = $pay_deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($item->dname); ?><br/><b><?php echo e($item->vPhone); ?></td>
                    <td><?php echo e(number_format($item->totalAmount , 0, '.', ' ')); ?></td>
                    <td><?php echo e(number_format($item->totalDeliverie , 0, '.', ' ')); ?></td>
                    <td><?php echo e(number_format($item->totalDeliverie-$item->totalPaie , 0, '.', ' ')); ?></td>
                    <td><?php echo e(number_format($item->totalPaie , 0, '.', ' ')); ?></td>
                    <!--<td>
                        <input type="checkbox" class="showAlertCheckbox" data-item-id="<?php echo e($item->iDriverId); ?>">
                    </td>-->
                    <td>
                        <div class="btn-group btn-group-sm">
                        <a href="<?php echo e(route('comptabilite-lpaydetail', ['id' => $item->iDriverId,'startDate' => $startDate, 'endDate' => $endDate])); ?>" class="nav-link <?php echo e($current_route=='comptabilite-lpay'?' active':''); ?>"  class="btn btn-info"><i class="fas fa-eye"></i></a>
                                           
                        </div>
                    </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Livreur</th>
                    <th>Montant total</th>
                    <th>Frais livraison</th>
                    <th>Montant Commission</th>
                    <th>Gain Livreur</th>
                    <!--<td><th>Payer</th>-->
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  <?php $__env->stopSection(); ?>
<?php echo $__env->make('master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/report/public_html/resources/views/layouts/comptabilite/liste_pay_livreur.blade.php ENDPATH**/ ?>