

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Historique</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Administration</a></li>
                        <li class="breadcrumb-item active">Recharge</li>
                        <li class="breadcrumb-item active">Historique</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                       <div class="d-flex justify-content-between align-items-center flex-wrap">
                            
                            <form method="GET" action="<?php echo e(route('administration-historique')); ?>" class="form-inline mb-2 mb-md-0">
                                <label for="date_debut" class="mr-2">Du :</label>
                                <input type="date" name="date_debut" id="date_debut" class="form-control mr-3" value="<?php echo e(request('date_debut')); ?>">
                            
                                <label for="date_fin" class="mr-2">Au :</label>
                                <input type="date" name="date_fin" id="date_fin" class="form-control mr-3" value="<?php echo e(request('date_fin')); ?>">
                            
                                <button type="submit" class="btn btn-primary mr-2">Filtrer</button>
                                <a href="<?php echo e(route('administration-historique')); ?>" class="btn btn-secondary">Réinitialiser</a>
                            </form>
                
                            
                            <div class="ml-auto text-right">
                                <strong>Solde actuel :</strong>
                                <span class="badge badge-success"><?php echo e(number_format($solde, 0, ',', ' ')); ?> F</span>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="example" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Réf</th>
                                        <th>Téléphone</th>
                                        <th>Montant</th>
                                        <th>Opérateur</th>
                                        <th>Offre</th>
                                        <th>Status</th>
                                        <th>Campagne</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($item['ref']); ?></td>
                                            <td><?php echo e($item['to']); ?></td>
                                            <td><?php echo e($item['amount']); ?> F</td>
                                            <td><?php echo e(ucfirst($item['airtimeOperator'])); ?></td>
                                            <td><?php echo e($item['airtimeTitle']); ?></td>
                                            <td><span class="badge badge-success"><?php echo e($item['status']); ?></span></td>
                                            <td><?php echo e($item['campaignName']); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($item['createdAt'])->format('d/m/Y H:i')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="8" class="text-center">Aucune recharge trouvée</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function () {
        // Lorsque le bouton est cliqué
        $('.open-popup').on('click', function () {
            // Ouvrir le popup
            $('#myModal').modal('show');
        });
        $('.open-popuplus').on('click', function () {
            // Ouvrir le popup
            $('#myModalPlus').modal('show');
        });
        
      
        
       
    });
    
     
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/report/public_html/resources/views/layouts/administration/liste_historique.blade.php ENDPATH**/ ?>