<?php
$current_route=request()->route()->getName();
?>


<?php $__env->startSection('content'); ?>
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Facture</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Comptabilité</a></li>
              <li class="breadcrumb-item active">Facture</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <?php if(session('error')): ?>
               <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            <div class="card">
                <form action="<?php echo e(route('comptabilite-facture')); ?>" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3"  id="start1">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate33"  value="<?php echo e(old('startDate', $startDate)); ?>">
                        </div>
                        <div class="col-md-3"  id="end1">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate33" value="<?php echo e(old('endDate', $endDate)); ?>">
                        </div>
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                         <div class="col-md-4"></div>
                        <div class="col-md-1">
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#saveFactureAll">
                             Ajouter
                            </button>
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
                <div class="card-body">
    <table id="example1" class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Date</th>
                <th>N° facture</th>
                <th>Client</th>
                <th>Numéro client</th>
                <th>Montant</th>
                <th>Service</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($item->date_invoice); ?></td>
                <td><?php echo e($item->numero_facture); ?></td>
                <td><?php echo e($item->client); ?></td>
                <td><?php echo e($item->numero_client); ?></td>
                <td><?php echo e(number_format($item->montant, 0, ',', ' ')); ?> F CFA</td>
                <td><?php echo e($item->service); ?></td>
                <td>
                    <span class="badge 
                        <?php if($item->status == 'payé'): ?> bg-success 
                        <?php elseif($item->status == 'Non payé'): ?> bg-warning 
                        <?php else: ?> bg-danger <?php endif; ?>">
                        <?php echo e($item->status); ?>

                    </span>
                </td>
                <td>
                    <!-- Formulaire pour changer le statut -->
                    <form action="<?php echo e(route('invoices.updateStatus', $item->invoice_internalId)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <select name="status" class="form-control form-control-sm d-inline-block" style="width:120px;" onchange="this.form.submit()">
                            <option value="Non payé" <?php echo e($item->status == 'Non payé' ? 'selected' : ''); ?>>Non payé</option>
                            <option value="Payé" <?php echo e($item->status == 'Payé' ? 'selected' : ''); ?>>Payé</option>
                        </select>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <th>Date</th>
                <th>N° facture</th>
                <th>Client</th>
                <th>Numéro client</th>
                <th>Montant</th>
                <th>Service</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </tfoot>
    </table>
</div>

              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
        
        <div class="modal fade" id="updateFactureModal" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalScrollableTitle">Modification de Facture</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form id="factureUpdateForm">
                            <input type="hidden" id="updateId" name="aexpenseId">
                            <div class="modal-body">
                                <!--<div class="form-group">
                                    <label for="montant">Intitulé Dépense</label>
                                    <input type="text" class="form-control titre" id="updateTitre" name="titre" placeholder="" required>
                                </div>-->
                                <div class="form-group">
                                <label>Type Dépense</label>
                                <select name="titre" class="form-control select2bs4 titre" id="updateTitre" style="width: 100%; " required>
                                    <option>Veuillez choisir type dépense</option>
                                    <option value="Réparation">Réparation</option>
                                    <option value="Pièce">Pièce</option>
                                </select>
                            </div>
                                 <div class="form-group">
                                    <label for="description">Description</label>
                                    <input type="text" class="form-control description" id="updateDescription" name="description" placeholder="" required>
                                </div>
                                <div class="form-group">
                                    <label for="montant">Montant</label>
                                    <input type="text" class="form-control montant" name="montant" id="updateMontant" placeholder="0" required>
                                </div>
                               
                                <div class="form-group">
                                    <label for="date">Date</label>
                                    <input type="date" class="form-control edate" id="updateDate" name="edate"  placeholder="" required>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                                <button type="submit" class="btn btn-primary" id="updateDepense">Modifier</button>
                            </div>
                        </form>
                </div>
            </div>
        </div>
        
        
        <div class="modal fade" id="saveFactureAll" role="dialog" aria-labelledby="exampleModalScrollableTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalScrollableTitle">Insertion de facture</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                    <form id="factureSaveFormAll" enctype="multipart/form-data">
                        <div class="modal-body" style="max-height: 400px; overflow-y: auto;">
                            <div class="form-group">
                                <label>Service</label>
                                <select name="service" class="form-control service" id="saveServiceAll" style="width: 100%;">
                                    <option></option>
                                    <option value="Drive">Drive</option>
                                    <option value="Store">Store</option>
                                </select>
                            </div>
                             <div class="form-group">
                                <label for="numero">Numéro facture</label>
                                <input type="text" class="form-control numerofacture" id="saveNumeroFactAll" name="numerofact" required>
                            </div>
                            <div class="form-group">
                                <label for="client">Client</label>
                                <input type="text" class="form-control clients" id="saveClientAll" name="client" required>
                            </div>
                            <div class="form-group">
                                <label for="numero">Numéro client</label>
                                <input type="text" class="form-control numeros" id="saveNumeroAll" name="numero" placeholder="0" required>
                            </div>

                            <div class="form-group">
                                <label for="montant">Montant</label>
                                <input type="text" class="form-control montant" id="saveMontantAll" name="montant" placeholder="0" required>
                            </div>
                            <div class="form-group">
                                <label>Status</label>
                                <select name="status" class="form-control type" id="saveStatusAll" style="width: 100%;">
                                    <option></option>
                                    <option value="Payé">Payée</option>
                                    <option value="Non payé">Non payée</option>
                                </select>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <label for="date">Date</label>
                                    <input type="datetime-local" class="form-control edate" id="saveDateAll" name="date_invoice" value="<?php echo e(date('Y-m-d\TH:i')); ?>" placeholder="" required>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                            <button type="submit" class="btn btn-primary" id="saveFactureChangeAll">Valider</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  <?php $__env->stopSection(); ?>
<?php echo $__env->make('master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/report/public_html/resources/views/layouts/comptabilite/liste_facture.blade.php ENDPATH**/ ?>