<?php if(!session()->has('user_id') && !Request::routeIs('support-dcourse')): ?>
    <script>window.location = "<?php echo e(route('login')); ?>";</script>
<?php endif; ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title>livereport</title>
  
  <style>
    .pointille {
      border-left: 1px dotted #000; /* 1 pixel de large, pointillé, couleur noire */
      height: 100px; /* ajustez la hauteur selon vos besoins */
    }

    .nav-item.active {
        background-color: #000;
    }

    .nav-link.active {
        background-color: #000;
    }
    
            
        tbody .statistics-row {
            background-color: #f5f5f5; /* Couleur de fond différente pour les lignes de statistiques */
            font-weight: bold; /* Texte en gras pour les lignes de statistiques */
            /* Autres styles si nécessaire */
        }
        
        tbody tr:last-child {
            position: relative; /* Permet de positionner la ligne de statistiques par rapport au dernier tr du tbody */
        }
        
        tbody tr.statistics-row {
            position: absolute; /* Positionnement absolu pour sortir la ligne de statistiques du flux normal */
            bottom: 2%; /* La ligne de statistiques sera placée en bas du tbody */
            width: 100%; /* La largeur de la ligne de statistiques sera égale à la largeur du tbody */
            /* Autres styles si nécessaire */
        }
        
        
        $('.hidden-row').hide();


        .green-icon {
            color: green !important;
        }
        
        
        
        
        
        .bg-color-1 { background-color: #0d6efd !important; } /* bleu */
.bg-color-2 { background-color: #198754 !important; } /* vert */
.bg-color-3 { background-color: #dc3545 !important; } /* rouge */
.bg-color-4 { background-color: #ffc107 !important; } /* jaune */
.bg-color-5 { background-color: #0dcaf0 !important; } /* cyan */
.bg-color-6 { background-color: #6f42c1 !important; } /* violet */
.bg-color-7 { background-color: #fd7e14 !important; } /* orange */
.bg-color-8 { background-color: #20c997 !important; } /* turquoise */
.bg-color-9 { background-color: #6610f2 !important; } /* indigo */
.bg-color-10 { background-color: #e83e8c !important; } /* rose */
.bg-color-11 { background-color: #6c757d !important; } /* gris */
.bg-color-12 { background-color: #343a40 !important; } /* noir */

   
  </style>
  <link rel="icon" href="<?php echo e(asset('dist/img/okalmicon/icone_logo.jpg')); ?>" type="image/x-icon">
  <link rel="shortcut icon" href="<?php echo e(asset('dist/img/okalmicon/icone_logo.jpg')); ?>" type="image/x-icon">
    
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="<?php echo e(asset('plugins/fontawesome-free/css/all.min.css')); ?>">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="<?php echo e(asset('plugins/overlayScrollbars/css/OverlayScrollbars.min.css')); ?>">
  
  <!-- Select2 -->
  <link rel="stylesheet" href="<?php echo e(asset('plugins/select2/css/select2.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(asset('dist/css/adminlte.min.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
  
</head>
<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed layout-footer-fixed')}}">
<div class="wrapper">

  <!-- Preloader -->
  <div class="preloader flex-column justify-content-center align-items-center">
    <img class="animation__wobble" src="<?php echo e(asset('dist/img/okalmicon/logo.png')); ?>" alt="Okalm" height="60" width="60">
  </div>

  <?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php echo $__env->make('partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php echo $__env->yieldContent('content'); ?>

 
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  <?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->
<!-- jQuery -->
<script src="<?php echo e(asset('plugins/jquery/jquery.min.js')); ?>"></script>
<!-- jQuery UI 1.11.4 -->
<script src="<?php echo e(asset('plugins/jquery-ui/jquery-ui.min.js')); ?>"></script>

<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge('uibutton', $.ui.button)
</script>
<!-- Bootstrap -->
<script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- overlayScrollbars -->
<script src="<?php echo e(asset('plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/select2/js/select2.full.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(asset('dist/js/adminlte.js')); ?>"></script>

<!-- PAGE PLUGINS -->
<!-- jQuery Mapael -->
<script src="<?php echo e(asset('jquery-mousewheel/jquery.mousewheel.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/raphael/raphael.min.js')); ?>"></script>
<script src="<?php echo e(asset('/jquery-mapael/jquery.mapael.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/jquery-mapael/maps/usa_states.min.js')); ?>"></script>
<!-- ChartJS -->
<script src="<?php echo e(asset('plugins/chart.js/Chart.min.js')); ?>"></script>

<!-- DataTables  & Plugins -->
<script src="<?php echo e(asset('plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('/plugins/jszip/jszip.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/pdfmake/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/pdfmake/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
<!--<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>-->


<!-- AdminLTE for demo purposes -->
<!--<script src="<?php echo e(asset('dist/js/demo.js')); ?>"></script>-->
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="<?php echo e(asset('dist/js/pages/dashboard2.js')); ?>"></script>
<!--<script src="<?php echo e(asset('dist/js/pages/dashboard.js')); ?>"></script>-->

<script>

  $(function () {
     $('.select2bs4').select2()
    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    })
    var startDate = $('#startDate').val();
    var endDate = $('#endDate').val();
   
    

    $("#example1").DataTable({
      "responsive": true, 
      "lengthChange": true,
     "lengthMenu": [
            [10, 25, 50, 100], // Valeurs
            ['10', '25', '50', '100'] // Étiquettes
        ],
      "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    
    $('.hidden-row').hide();
    
    
/* +==============================export resto_paie==================================*/
    
   
var table = $('#example3').DataTable({
    responsive: true,
    lengthChange: false,
    autoWidth: false,
    buttons: [
        { extend: 'copy', text: 'Copier', footer: true },
        { extend: 'csv', text: 'Exporter en CSV', filename: function() { return generateFilename('csv'); }, footer: true },
        { extend: 'excel', text: 'Exporter en Excel',title :'Etat commandes', filename: function() { return generateFilename('excel'); }, footer: false},
        { extend: 'pdf', text: 'Exporter en PDF', title :'Etat commandes', filename: function() { return generateFilename('pdf'); }, footer: false },
        { extend: 'print', text: 'Imprimer',title :'Etat commandes',  }
    ]
});

// Fonction pour extraire le nom du restaurant à partir de la première colonne (index 0)
function getRestaurantNameFromTable() {
    
        
        // Utilisation de jQuery
        /*var fourthRow = $('#example3 tbody tr').eq(4); 
        var cellValue = fourthRow.find('td').eq(1).text(); 
        return cellValue;*/
        
        var motApresSlash='';
        var element = document.getElementById("resto_name");
       
        if (element) {
            // Extraire le contenu texte de l'élément
            var contenu = element.textContent || element.innerText;
            
                        // Diviser la chaîne en fonction du "/"
            var mots = contenu.split('/');
            
            // Accéder au dernier mot après le "/"
            motApresSlash = mots[mots.length - 1].trim();
        }
        
        return motApresSlash;
    
}

function generateFilename(type) {
    var restaurantName = getRestaurantNameFromTable(); 
   
    var concatenatedString = ''; 
    // Concaténer tous les mots avec _
    
    concatenatedString=restaurantName;
    var date = new Date();
    var dateString = date.getFullYear() + ('0' + (date.getMonth() + 1)).slice(-2) + ('0' + date.getDate()).slice(-2);
    var timeString = ('0' + date.getHours()).slice(-2) + ('0' + date.getMinutes()).slice(-2) + ('0' + date.getSeconds()).slice(-2);
    return "paiement_resto_" + concatenatedString + '_' + dateString;
}

// Fonction pour extraire les données du footer de DataTables
function getFooterData() {
    var footerData = [];
    $('#example3 tfoot').each(function() {
        $(this).find('tr').each(function() {
            var rowData = [];
            $(this).find('th').each(function() {
                rowData.push($(this).text().trim());
            });
            footerData.push(rowData);
        });
    });
    return footerData;
}

// Personnaliser les options d'exportation pour inclure le footer
$.extend(true, $.fn.dataTable.Buttons.defaults, {
    exportOptions: {
        footer: true
    }
});


// Assigner un gestionnaire d'événements à chaque bouton d'exportation
table.buttons().container().appendTo($('#example3_wrapper .col-md-6:eq(0)'));


/********************************************** eend*************************/
    
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });

    $('#filterOption').change(function () {
            var start = $('#start');
            var end = $('#end');

            // Affiche/masque les champs de date en fonction de la sélection
            if ($(this).val() === 'interval') {
                start.show();
                end.show();
            } else {
                start.hide();
                end.hide();
                window.location.href = window.location.href.split('?')[0];
            }
    });

    $('#filterOption').on('change', function () {
            // Si "all" est sélectionné, rediriger vers la même URL sans les paramètres
            if ($(this).val() === 'all') {
                window.location.href = window.location.href.split('?')[0];
            }
        });

        $.ajax({
          url: '../getChartData',
          method: 'GET',
          data: { startDate: startDate, endDate: endDate },
          success: function (data) {
            console.log('Data received:', data);
            // Trier les données par nombre décroissant
            data.sort((a, b) => b.nombre - a.nombre);

            // Regrouper les catégories avec un faible nombre d'occurrences
            const seuil = 100; // Définir le seuil en fonction de vos besoins
            const groupedData = data.reduce((result, item, index) => {
                if (index < seuil) {
                    result.push(item);
                } else {
                    const others = result.find(i => i.categorie === 'Autres');
                    if (others) {
                        others.nombre += item.nombre;
                    } else {
                        result.push({ categorie: 'Autres', nombre: item.nombre });
                    }
                }
                return result;
            }, []);


              // Process the data received from the server
              var dynamicChartData = {
                  labels: data.map(item => item.categorie),
                  datasets: [
                      {
                          data: data.map(item => item.nombre),
                          backgroundColor: ['#f56954', '#00a65a', '#f39c12', '#00c0ef', '#3c8dbc', '#d2d6de','#d2d6df'],
                      }
                  ]
              };

              // Set up the canvas and create the chart dynamically
              var pieChartCanvas = $('#pieChart11').get(0).getContext('2d');
              var pieOptions = {
                  maintainAspectRatio: false,
                  responsive: true,
                  /*legend: {
                    display: false // Désactiver l'affichage de la légende par défaut
                },
            scales: {
                y: {
                    type: 'logarithmic',
                    position: 'left',
                },
              },*/
              };

              // Create pie chart
              new Chart(pieChartCanvas, {
                  type: 'pie',
                  data: dynamicChartData,
                  options: pieOptions
              });

              // Ajouter les légendes dynamiquement
            /*var chartLegend = $('#chartLegend');
            chartLegend.empty(); // Supprimer les anciennes légendes

            data.forEach(function (item, index) {
                var legendItem = $('<li></li>').html('<i class="far fa-circle" style="color:' + dynamicChartData.datasets[0].backgroundColor[index] + '"></i> ' + item.categorie);
                chartLegend.append(legendItem);
            });*/
          },
          error: function (error) {
              //console.error('Error fetching chart data:', error);
              console.error('Error fetching chart data:', error.responseText);
          }
        });

        /*+====+*/
        $.ajax({
          url: '../getChartDataDevice',
          method: 'GET',
          data: { startDate: startDate, endDate: endDate },
          success: function (data) {
            console.log('Data received:', data);
           
            // Trier les données par nombre décroissant
            data.sort((a, b) => b.nombre - a.nombre);

            // Regrouper les catégories avec un faible nombre d'occurrences
            const seuil = 3; // Définir le seuil en fonction de vos besoins
            const groupedData = data.reduce((result, item, index) => {
                if (index < seuil) {
                    result.push(item);
                } else {
                    const others = result.find(i => i.categorie === 'Autres');
                    if (others) {
                        others.nombre += item.nombre;
                    } else {
                        result.push({ categorie: 'Autres', nombre: item.nombre });
                    }
                }
                return result;
            }, []);


              // Process the data received from the server
              var dynamicChartData = {
                  labels: data.map(item => item.device),
                  datasets: [
                      {
                          data: data.map(item => item.nombre),
                          backgroundColor: ['#3c8dbc', '#d2d6de','#d2d6df'],
                      }
                  ]
              };

              // Set up the canvas and create the chart dynamically
              var pieChartCanvas = $('#pieChart111').get(0).getContext('2d');
              var pieOptions = {
                  maintainAspectRatio: false,
                  responsive: true,
              };

              // Create pie chart
              new Chart(pieChartCanvas, {
                  type: 'pie',
                  data: dynamicChartData,
                  options: pieOptions
              });
          },
          error: function (error) {
              //console.error('Error fetching chart data:', error);
              console.error('Error fetching chart data:', error.responseText);
          }
        });

       

        $.ajax({
          url: '../getChartDataWallet',
          method: 'GET',
          data: { startDate: startDate, endDate: endDate },
          success: function (data) {
            console.log('Data received:', data);
            // Trier les données par nombre décroissant
            data.sort((a, b) => b.nombre - a.nombre);

            // Regrouper les catégories avec un faible nombre d'occurrences
            const seuil = 3; // Définir le seuil en fonction de vos besoins
            const groupedData = data.reduce((result, item, index) => {
                if (index < seuil) {
                    result.push(item);
                } else {
                    const others = result.find(i => i.montant === 'Autres');
                    if (others) {
                        others.montant += item.montant;
                    } else {
                        //result.push({type: 'Autres', montant: item.montant });//parseFloat(item.montant).toLocaleString('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 });
                        result.push({type: 'Autres', montant: parseFloat(item.montant).toLocaleString('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 }) });//parseFloat(item.montant).toLocaleString('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 });
                    }
                }
                return result;
            }, []);


              // Process the data received from the server
              var dynamicChartData = {
                  labels: data.map(item => item.type),
                  datasets: [
                      {
                          data: data.map(item => item.montant),
                          backgroundColor: ['#f39c12', '#00c0ef', '#3c8dbc','#3c8dbc'],
                      }
                  ]
              };

              // Set up the canvas and create the chart dynamically
              var pieChartCanvas = $('#pieChart1111').get(0).getContext('2d');
              var pieOptions = {
                  maintainAspectRatio: false,
                  responsive: true,
              };

              // Create pie chart
              new Chart(pieChartCanvas, {
                  type: 'pie',
                  data: dynamicChartData,
                  options: pieOptions
              });
          },
          error: function (error) {
              //console.error('Error fetching chart data:', error);
              console.error('Error fetching chart data:', error.responseText);
          }
        });

    function getChartData() {

        var startDate = $('#startDate').val();
        var endDate = $('#endDate').val();
            
            $.ajax({
                url: '../getChartDataPanierMoins', // Assurez-vous d'ajuster la route
                type: 'GET',
                dataType: 'json',
                data: { startDate: startDate, endDate: endDate },
                success: function(data) {
                    
                    console.log(data);
                    // Créer le graphique avec les données reçues
                    createChart(data);
                },
                error: function(error) {
                    console.log('Erreur lors de la récupération des données:', error);
                    
                }
            });
       }

    // Fonction pour créer le graphique avec Chart.js
    function createChart(chartData) {
        var ctx = document.getElementById('myChart').getContext('2d');

        var myChart = new Chart(ctx, {
            type: 'bar',
            data: chartData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
            }
        });
    }

    // Appeler la fonction pour récupérer les données lors du chargement de la page
    getChartData();


    /*$.ajax({
            url: '../getChartDataCompareTripLastYear',
            type: "GET",
            data: { startDate: startDate, endDate: endDate },
            success: function (data) {
                var ctx = document.getElementById('sales-chart').getContext('2d');
                var salesChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.labels,
                        datasets: data.datasetsphone-verified
                    },
                    options: {
                        scales: {
                            yAxes: [{
                                ticks: {
                                    beginAtZero: true
                                }
                            }]
                        }
                    }
                });
            }
        });*/

    //$(document).ready(function() {
    $.ajax({
                url: '../getChartDataCompareTripLastYear',
                type: 'GET',
                dataType: 'json',
                data: { startDate: startDate, endDate: endDate },
                success: function(data) {
                    // Appeler la fonction pour créer le graphique avec les données récupérées
                    createChart2(data);
                },
                error: function(error) {
                    console.log(error);
                }
    });

    function createChart2(data) {

        console.log('Données reçues :', data);

            var ticksStyle = {
                fontColor: '#495057',
                fontStyle: 'bold'
            };

            var mode = 'index';
            var intersect = true;

            var $salesChart = $('#sales-chart');
            var salesChart = new Chart($salesChart, {
                    type: 'bar',
                    data: {
                        labels: data.labels,
                        datasets: data.datasets,
                    },
                    options: {
                        maintainAspectRatio: false,
                        tooltips: {
                            mode: mode,
                            intersect: intersect
                        },
                        hover: {
                            mode: mode,
                            intersect: intersect
                        },
                        legend: {
                            display: true,
                        },
                        scales: {
                            yAxes: [{
                                gridLines: {
                                    display: true,
                                    lineWidth: '4px',
                                    color: 'rgba(0, 0, 0, .2)',
                                    zeroLineColor: 'transparent'
                                },
                                ticks: $.extend({
                                    beginAtZero: true,
                                    callback: function(value) {
                                        if (value >= 1000) {
                                            value /= 1000;
                                            value += '';
                                        }
                                        return '' + value;
                                    }
                                }, ticksStyle)
                            }],
                            xAxes: [{
                                display: true,
                                gridLines: {
                                    display: false
                                },
                                ticks: ticksStyle
                            }]
                        }
                    }
            });
        }
       // });




    function updateDates() {
            var filterOption = $('#filterOption2').val();
            var today = new Date().toISOString().split('T')[0]; // Date d'aujourd'hui

            switch (filterOption) {
                case 'all':
                    // Ajustez ces valeurs en fonction de vos besoins
                    $('#startDate').val('2020-08-01');
                    $('#endDate').val(today);
                    //
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
                case 'currenty':
                    $('#startDate').val(today.substring(0, 4) + '-01-01');
                    $('#endDate').val(today);
                    //
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
                case 'currentm':
                    var firstDayOfMonth = today.substring(0, 7) + '-01';
                    $('#startDate').val(firstDayOfMonth);
                    $('#endDate').val(today);
                    //
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
                case 'currentw':
                    var currentDay = new Date(today);
                    var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                    $('#startDate').val(firstDayOfWeek.toISOString().split('T')[0]);
                    $('#endDate').val(today);
                    //
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
                case 'today':
                    $('#startDate').val(today);
                    $('#endDate').val(today);
                    //
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
               
                case 'interval':
                    $('#startDate').prop('disabled', false);
                    $('#endDate').prop('disabled', false);

                    // Ajoutez ces conditions pour vider les champs seulement si l'option "interval" est sélectionnée et si les champs ne sont pas vides
                    if ($('#filterOption2').val() == 'interval') {
                        if ($('#startDate').val() == '') {
                            $('#startDate').val('');
                        }
                        if ($('#endDate').val() == '') {
                            $('#endDate').val('');
                        }
                    }
                    break; 
                default:
                    // Par défaut, si aucune option n'est sélectionnée, utilisez "Cette année"
                    $('#filterOption2').val('currenty');
                    $('#startDate').val(today.substring(0, 4) + '-01-01');
                    $('#endDate').val(today);
                    //
                    // Désactiver les champs de saisie des dates pour "Cette année"
                    $('#startDate').prop('disabled', true);
                    $('#endDate').prop('disabled', true);
                    break;
            }
    }
    // Appeler la fonction lorsqu'il y a un changement dans la sélection
    $('#filterOption2').change(updateDates);
    updateDates();
    

});

  //$('#start').hide();
  //$('#end').hide();


    document.getElementById('hide1').style.display = 'block';
    document.getElementById('hide2').style.display = 'none';

    function cacherDiv() {
        var div = document.getElementById('hide1');
        var div1 = document.getElementById('hide2');
        if (div.style.display === 'none') {
            div.style.display = 'block'; // Si déjà caché, affiche le div
        } else {
            div.style.display = 'none'; // Sinon, cache le div
        }

        if (div1.style.display ==='none') {
            div1.style.display = 'block'; // Si déjà caché, affiche le div
        } else {
            div1.style.display = 'none'; // Sinon, cache le div
        }
    }
    
    
        // Ajoutez un écouteur d'événements pour détecter les changements dans la sélection de l'option
      
  // Assuming you are using jQuery for AJAX


 // $(document).ready(function () {
        // Fonction pour mettre à jour les dates en fonction de l'option sélectionnée
       
   // });

</script>
<script>
    $(function () {

        function updateDatesDepot() {
        
        var filterOption1 = $('#filterOption1').val();
        var today = new Date().toISOString().split('T')[0];
       

        switch (filterOption1) {
            case 'today':
                $('#startDate2').val(today);
                $('#endDate2').val(today);
                $('#startDate2').prop('disabled', true);
                $('#endDate2').prop('disabled', true);
                break;

            case 'week':
               
                var currentDay = new Date(today);
                var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                $('#startDate2').val(firstDayOfWeek.toISOString().split('T')[0]);
                $('#endDate2').val(today);
                $('#startDate2').prop('disabled', true);
                $('#endDate2').prop('disabled', true);
                break;

            case 'month':
                var firstDayOfMonth = today.substring(0, 7) + '-01';
                $('#startDate2').val(firstDayOfMonth);
                $('#endDate2').val(today);
                $('#startDate2').prop('disabled', true);
                $('#endDate2').prop('disabled', true);
                break;

            case 'other':
                $('#startDate2').prop('disabled', false);
                $('#endDate2').prop('disabled', false);

                if ($('#filterOption1').val() == 'other') {
                    if ($('#startDate2').val() == '') {
                        $('#startDate2').val('');
                    }
                    if ($('#endDate2').val() == '') {
                        $('#endDate2').val('');
                    }
                }
                break;

            default:
                $('#filterOption1').val('week');
                var currentDay = new Date(today);
                var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                $('#startDate2').val(firstDayOfWeek.toISOString().split('T')[0]);
                $('#endDate2').val(today);
                $('#startDate2').prop('disabled', true);
                $('#endDate2').prop('disabled', true);
                break;
        }
    }

            // Appeler la fonction lorsqu'il y a un changement dans la sélection
            $('#filterOption1').change(updateDatesDepot);
            updateDatesDepot();  // Appel initial pour définir l'état initial
    });
</script>

<script>
    $(function () {

        function updateDatesTransaction() {
        
        var filterOption3 = $('#filterOption3').val();
        var today = new Date().toISOString().split('T')[0];
       

        switch (filterOption3) {
            case 'today':
                $('#startDate1').val(today);
                $('#endDate1').val(today);
                $('#startDate1').prop('disabled', true);
                $('#endDate1').prop('disabled', true);
                break;

            case 'week':
               
                var currentDay = new Date(today);
                var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                $('#startDate1').val(firstDayOfWeek.toISOString().split('T')[0]);
                $('#endDate1').val(today);
                $('#startDate1').prop('disabled', true);
                $('#endDate1').prop('disabled', true);
                break;

            case 'month':
                var firstDayOfMonth = today.substring(0, 7) + '-01';
                $('#startDate1').val(firstDayOfMonth);
                $('#endDate1').val(today);
                $('#startDate1').prop('disabled', true);
                $('#endDate1').prop('disabled', true);
                break;

            case 'other':
                $('#startDate1').prop('disabled', false);
                $('#endDate1').prop('disabled', false);

                if ($('#filterOption3').val() == 'other') {
                    if ($('#startDate1').val() == '') {
                        $('#startDate1').val('');
                    }
                    if ($('#endDate1').val() == '') {
                        $('#endDate1').val('');
                    }
                }
                break;

            default:
                $('#filterOption3').val('week');
                var currentDay = new Date(today);
                var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                $('#startDate1').val(firstDayOfWeek.toISOString().split('T')[0]);
                $('#endDate1').val(today);
                $('#startDate1').prop('disabled', true);
                $('#endDate1').prop('disabled', true);
                break;
        }
    }

            // Appeler la fonction lorsqu'il y a un changement dans la sélection
            $('#filterOption3').change(updateDatesTransaction);
            updateDatesTransaction();  // Appel initial pour définir l'état initial
    });
</script>

<script>
   
    $(function () {
      
        function updateDatesWallet() {
           
            var filterOption4 = $('#filterOption4').val();
            var today = new Date().toISOString().split('T')[0];

                switch (filterOption4) {
                    
                    case 'all':
                        // Ajustez ces valeurs en fonction de vos besoins
                        $('#startDate4').val('2020-08-01');
                        $('#endDate4').val(today);
                        //
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                    case 'currenty':
                        $('#startDate4').val(today.substring(0, 4) + '-01-01');
                        $('#endDate4').val(today);
                        //
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                    case 'currentm':
                        var firstDayOfMonth = today.substring(0, 7) + '-01';
                        $('#startDate4').val(firstDayOfMonth);
                        $('#endDate4').val(today);
                        //
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                    case 'currentw':
                        var currentDay = new Date(today);
                        var firstDayOfWeek = new Date(currentDay.setDate(currentDay.getDate() - currentDay.getDay()));
                        $('#startDate4').val(firstDayOfWeek.toISOString().split('T')[0]);
                        $('#endDate4').val(today);
                        //
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                    case 'today':
                        $('#startDate4').val(today);
                        $('#endDate4').val(today);
                        //
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                
                    case 'interval':
                        $('#startDate4').prop('disabled', false);
                        $('#endDate4').prop('disabled', false);

                        // Ajoutez ces conditions pour vider les champs seulement si l'option "interval" est sélectionnée et si les champs ne sont pas vides
                        if ($('#filterOption4').val() == 'interval') {
                            if ($('#startDate4').val() == '') {
                                $('#startDate4').val('');
                            }
                            if ($('#endDate4').val() == '') {
                                $('#endDate4').val('');
                            }
                        }
                        break; 
                    default:
                        // Par défaut, si aucune option n'est sélectionnée, utilisez "Cette année"
                        $('#filterOption4').val('currenty');
                        $('#startDate4').val(today.substring(0, 4) + '-01-01');
                        $('#endDate4').val(today);
                        //
                        // Désactiver les champs de saisie des dates pour "Cette année"
                        $('#startDate4').prop('disabled', true);
                        $('#endDate4').prop('disabled', true);
                        break;
                }
            }

                // Appeler la fonction lorsqu'il y a un changement dans la sélection
                $('#filterOption4').change(updateDatesWallet);
                updateDatesWallet();  // Appel initial pour définir l'état initial
        });
</script>

<script>


    $(document).ready(function () {
        $('.btn-danger').on('click', function (event) {
            var button = $(this);
            var modal = $('#exampleModalScrollable');

            // Update form action and method based on button data
            if (button.data('id')) {
                modal.find('#planningForm').attr('action', '<?php echo e(route("comptabilite-update", "")); ?>/' + button.data('id'));
                modal.find('#methodInput').val('PUT');

                // Populate form fields with existing data
                modal.find('[name="iCompanyId"]').val(button.data('company-id')).trigger('change');
                modal.find('[name="iPeriode"]').val(button.data('periode')).trigger('change');
                modal.find('[name="iCommission"]').val(button.data('commission'));
                modal.find('[name="iMoney"]').val(button.data('money'));
                modal.find('[name="iMoneyResponsable"]').val(button.data('moneyresp'));
            } else {
                // Reset form action and method for insert
                modal.find('#planningForm').attr('action', '<?php echo e(route("comptabilite-save")); ?>');
                modal.find('#methodInput').val('POST');

                // Reset form fields
                modal.find('form')[0].reset();
            }
        });
        
        $('.commision').on('click', function (event) {
            var button = $(this);
            var modal = $('#exampleModalScrollable');

            // Update form action and method based on button data
            if (button.data('id')) {
                modal.find('#commissionForm').attr('action', '<?php echo e(route("comptabilite-updatec", "")); ?>/' + button.data('id'));
                modal.find('#methodInput').val('PUT');

                // Populate form fields with existing data
                modal.find('[name="subtotal"]').val(button.data('subtotal')).trigger('change');
                modal.find('[name="companyId"]').val(button.data('company-id'));
                 modal.find('[name="resto"]').val(button.data('company'));
                
                modal.find('[name="commission"]').val(button.data('commission'));
                
            } else {
                // Reset form action and method for insert
                modal.find('#commissionForm').attr('action', '<?php echo e(route("comptabilite-save")); ?>');
                modal.find('#methodInput').val('POST');
                // Reset form fields
                modal.find('form')[0].reset();
            }
        });
    });
</script>
<script>
    $(document).ready(function () {
        $('#companyOption').on('change', function () {
            var selectedOption = $(this).val();
           
            // Make an AJAX request to fetch data
            $.ajax({
                //url: '../getLoadCompanyCommission/' + selectedOption,
                url: '<?php echo e(route("get-data", ["id" => "_id_"])); ?>'.replace('_id_', selectedOption),
                
                type: 'GET',
                success: function (data) {
                   if (data.length > 0 && 'fCommission' in data[0]) {
                        // Populate the input field with the fetched data
                        if(data[0].fCommission ==''){
                            $('#commission').val(data[0].vCommissionPercentage);
                        }else{
                            $('#commission').val(data[0].fCommission);
                        }
                    } else {
                        console.error('Invalid response format or fCommission not found.');
                    }
                },
                error: function (xhr, status, error) {
                    console.error(error);
                }
            });
        });
    });

</script>
<script>
    
     $(document).ready(function() {
        $('#editModalFree').on('show.bs.modal', function (event) {
            
            
            var button = $(event.relatedTarget); 
            var idtrip = button.data('idtrip');
            var idorder = button.data('idorder');
            var drivertrip = button.data('driver');
            var driverorder = button.data('driver-order');
            var livreur = button.data('livreur');
            
            //alert(livreur);
            

            // Pré-remplir les champs du formulaire avec les données récupérées
            var modal = $(this);
            modal.find('.modal-body #orderId').val(idorder);
            modal.find('.modal-body #driverId').val(drivertrip);
            modal.find('.modal-body #driverId0').val(driverorder);
            modal.find('.modal-body #tripId').val(idtrip);
            modal.find('.modal-body #livreur').text(livreur);
   
    
        });
        
    $('#saveChangeFree').click(function() {
        var formData = $('#editFormFree').serialize(); // Sérialiser les données du formulaire
        console.log(formData);
        // Obtenir l'URL de la route de mise à jour
        var updateFreeUrl = "<?php echo e(route('updateFree')); ?>";
        // Envoyer les données modifiées au serveur à l'aide d'une requête AJAX
        $.ajax({
            url: updateFreeUrl,
            type: 'POST',
            data: formData,
            headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // Jeton CSRF
                },
            success: function(response) {
                // Traitement en cas de succès
                console.log(response);
                // Fermer le modal après avoir enregistré les modifications
                $('#editModalFree').modal('hide');
                location.reload();
            },
            error: function(xhr, status, error) {
                // Gestion des erreurs
                console.error(xhr.responseText);
                location.reload();
            }
        });
    });
});
    
</script>

<script>
    $(document).ready(function() {
        $('#editModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); // Bouton qui a déclenché l'événement
            var id = button.data('id'); // Récupérer l'ID de l'utilisateur à modifier
            var name = button.data('name'); // Récupérer le nom de l'entreprise
            var lname = button.data('lname'); // Récupérer la période
            var phone = button.data('phone'); // Récupérer la commission
            var email = button.data('email'); // Récupérer l'email
            var phoneVerified = button.data('phone-verified'); // Récupérer l'état de vérification du numéro de téléphone

            // Pré-remplir les champs du formulaire avec les données récupérées
            var modal = $(this);
            modal.find('.modal-body #userId').val(id);
            modal.find('.modal-body #name').val(name);
            modal.find('.modal-body #lname').val(lname);
            modal.find('.modal-body #phone').val(phone);
            modal.find('.modal-body #email').val(email);
            
            $('#phoneVerified').val(phoneVerified).change();
    
        });
        
    $('#saveChanges').click(function() {
        var formData = $('#editForm').serialize(); // Sérialiser les données du formulaire
    // Obtenir l'URL de la route de mise à jour
        var updateUrl = "<?php echo e(route('update')); ?>";
        // Envoyer les données modifiées au serveur à l'aide d'une requête AJAX
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formData,
            headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // Jeton CSRF
                },
            success: function(response) {
                // Traitement en cas de succès
                console.log(response);
                // Fermer le modal après avoir enregistré les modifications
                $('#editModal').modal('hide');
                location.reload();
            },
            error: function(xhr, status, error) {
                // Gestion des erreurs
                console.error(xhr.responseText);
            }
        });
    });


/*  +==================================== command update ===============================================+   */

    $('#editModalCommand').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); 
            var id = button.data('id'); 
             var driverid = button.data('driverid'); 
            var vorder = button.data('vorder'); 
            var odate = button.data('odate'); 
            var client = button.data('client'); 
            var livreur = button.data('livreur'); 
            var payment = button.data('payment'); 
            var delivery = button.data('delivery'); 
            var montant = button.data('montant'); 
            var wallet = button.data('wallet'); 
            var tmontant = button.data('tmontant'); 
            //var fPackingCharge = button.data('fPackingCharge'); 

            // Pré-remplir les champs du formulaire avec les données récupérées
            var modal = $(this);
            modal.find('.modal-body #orderId').val(id);
            modal.find('.modal-body #vorder').val(vorder);
            modal.find('.modal-body #client').val(client);
            modal.find('.modal-body #livreur').val(driverid).change();
            modal.find('.modal-body #delivery').val(delivery);
            modal.find('.modal-body #cashpay').val(montant);
            modal.find('.modal-body #walletpay').val(wallet);
            modal.find('.modal-body #tmontant').val(tmontant);
            // modal.find('.modal-body #fPackingCharge').val(fPackingCharge);
            
            var gUrl = "<?php echo e(route('support-items')); ?>";
           // Effectuer une requête AJAX pour charger les données restantes
            $.ajax({
                url: gUrl,//'<?php echo e(route("support-items")); ?>',
                type: 'GET', 
                data: { id: id },
                //dataType: 'json', 
                success: function(response) {
                    // Charger les données de retour dans le formulaire
                    $.each(response.items, function(index, item) {
                        
                        var newRow = '<div class="form-group row">' +
                                        '<input type="hidden" id="detailoid_' + index + '" name="detailoid_' +index+ ' " value="' +item.iOrderDeId+ '">'+
                                        '<div class="col-md-6">' +
                                            '<label for="article_' + index + '">Article' + (index+1) + '</label>' +
                                            '<select class="form-control select2bs4" id="item_' + index + '" name="item_' + index + '">' +
                                            '</select>' +
                                        '</div>' +
                                        '<div class="col-md-3">' +
                                            '<label for="qte_' + index + '">&nbsp;</label>' +
                                            '<input type="text" class="form-control" id="qte_' + index + '" name="qte_' + index + '" value="' + item.qty + '">' +
                                        '</div>' +
                                        '<div class="col-md-3">' +
                                            '<label for="price_' + index + '">&nbsp;</label>' +
                                            '<input type="text" class="form-control" id="price_' + index + '" name="price_' + index + '" value="' + item.tprice + '">' +
                                        '</div>' +
                                    '</div>';
                        $('.generer').append(newRow);
                        
                        
                        
                        
                                 // Charger les options de la liste d'articles dans le select correspondant
                    var selectOptions = '';
                    $.each(response.itemlist, function(idx, itm) {
                    var selected = '';
                    if (itm.itemId == item.iMenuItemId) {
                        selected = 'selected';
                    }
                    selectOptions += '<option value="' + itm.itemId + '" ' + selected + '>' + itm.item + '</option>';
   
                    });
                    $('#item_' + index).append(selectOptions);
                        
                    });
                },
                error: function(xhr, status, error) {
                    // Gérer les erreurs
                    //console.error(error);
                    
                    console.log("Erreur lors de la requête AJAX :", xhr.responseText);
                    // Gérer les erreurs
                    console.error(xhr.responseText);
                }
            });
            
    
        });
        
    $('#saveChangeCom').click(function(event) {
        // Empêcher le comportement par défaut du bouton
        event.preventDefault();
        
        // Obtenez l'URL de mise à jour à partir de l'attribut data
        var updateUrlCom = "<?php echo e(route('update-command')); ?>";

        // Récupérez les valeurs des champs de formulaire
        var orderId = $('#orderId').val();
        var vorder = $('#vorder').val();
        var client = $('#client').val();
        var livreur = $('#livreur').val();
        var delivery = $('#delivery').val();
        var cashpay = $('#cashpay').val();
        var walletpay = $('#walletpay').val();
        var tmontant = $('#tmontant').val();
        //var fPackingCharge=$('#fPackingCharge').val();

        // Créez un tableau pour stocker les données générées
        var genererData = [];
        $('.generer').find('.form-group').each(function() {
            var itemIndex = $(this).index();
            var item = {
                detailoid: $('#detailoid_' + itemIndex).val(),
                article: $('#item_' + itemIndex).val(),
                qte: $('#qte_' + itemIndex).val(),
                price: $('#price_' + itemIndex).val()
            };
            genererData.push(item);
        });

        // Créez un objet formData contenant toutes les données du formulaire
        var formData = {
            orderId: orderId,
            vorder: vorder,
            client: client,
            livreur: livreur,
            delivery: delivery,
            cashpay: cashpay,
            walletpay: walletpay,
            tmontant: tmontant,
            //fPackingCharge:fPackingCharge,
            genererData: genererData
        };
        console.log(genererData);
        console.log(formData);

        // Envoyez une requête AJAX pour enregistrer les données
        $.ajax({
            url: updateUrlCom,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Traitez la réponse réussie
                console.log(response);

                // Masquer la fenêtre modale et recharger la page
                $('#editModalCommand').modal('hide');
                location.reload();
            },
            error: function(xhr, status, error) {
                // Traitez la réponse d'erreur
                console.error(xhr.responseText);
            }
        });
    });
 /* +==================================== course update ============================================+ */
 
 
    $('#editModalCourse').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); 
            var id = button.data('id'); 
             var driverid = button.data('driverid'); 
            var vtrip = button.data('vride'); 
            var tdate = button.data('tdate'); 
            var client = button.data('client'); 
            var drivreur = button.data('driver'); 
            var distance = button.data('distance'); 
            var duree = button.data('duree'); 
            var total = button.data('total'); 
            var commission = button.data('commission'); 
            var walletpay = button.data('walletpay'); 
            var cashpay = button.data('cashpay'); 

            // Pré-remplir les champs du formulaire avec les données récupérées
            var modal = $(this);
            modal.find('.modal-body #tripId').val(id);
            modal.find('.modal-body #vtrip').val(vtrip);
            modal.find('.modal-body #client').val(client);
            modal.find('.modal-body #drivreur').val(driverid).change();
            // Sélectionner l'option correspondante dans la liste déroulante
            //modal.find('.modal-body #drivreur option[value="' + driverid + '"]').prop('selected', true);

            
            
            modal.find('.modal-body #distance').val(distance);
            modal.find('.modal-body #duree').val(duree);
            modal.find('.modal-body #cashpay').val(cashpay);
            modal.find('.modal-body #walletpay').val(walletpay);
            modal.find('.modal-body #tmontant').val(total);
            modal.find('.modal-body #commision').val(commission);
            
           
        });
        
        /* +=========+ */
    $('#editModalCourseOrg').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); 
            var idt = button.data('idt'); 
             var driveridt = button.data('driveridt'); 
            var vtrip = button.data('vride'); 
            var tdate = button.data('tdate'); 
            var client = button.data('client'); 
            var drivreur = button.data('driver'); 
            var distancet = button.data('distancet'); 
            var dureet = button.data('dureet'); 
            var totalt = button.data('totalt'); 
            var commissiont = button.data('commissiont'); 
            //var walletpay = button.data('walletpay'); 
            //var cashpay = button.data('cashpay'); 
    alert(idt);
            // Pré-remplir les champs du formulaire avec les données récupérées
            var modal = $(this);
            modal.find('.modal-body #tripIds').val(idt);
            modal.find('.modal-body #vtrip').val(vtrip);
            modal.find('.modal-body #client').val(client);
            modal.find('.modal-body #drivreurt').val(driveridt).change();
            // Sélectionner l'option correspondante dans la liste déroulante
            //modal.find('.modal-body #drivreur option[value="' + driverid + '"]').prop('selected', true);

            
            
            modal.find('.modal-body #distancet').val(distancet);
            modal.find('.modal-body #dureet').val(dureet);
            ///modal.find('.modal-body #cashpay').val(cashpay);
            //modal.find('.modal-body #walletpay').val(walletpay);
            modal.find('.modal-body #tmontantt').val(totalt);
            modal.find('.modal-body #commisiont').val(commissiont);
            
           
        });
        
    /* +============Save Simple=================+ */    
    
    $('#saveChangeCourse').click(function(event) {
        // Empêcher le comportement par défaut du bouton
        event.preventDefault();

        // Obtenez l'URL de mise à jour à partir de l'attribut data
        var updateUrlCourse = "<?php echo e(route('update-course')); ?>";

        // Récupérez les valeurs des champs de formulaire
        var tripId = $('#tripId').val();
        var vtrip = $('#vtrip').val();
        var client = $('#client').val();
        var drivreur = $('#drivreur').val();
        var distance = $('#distance').val();
        var duree  =$('#duree').val();
        var cashpay = $('#cashpay').val();
        var walletpay = $('#walletpay').val();
        var montant = $('#tmontant').val();
        var commission = $('#commision').val();

        // Créez un objet formData contenant toutes les données du formulaire
        var formData = {
            tripId: tripId,
            vtrip: vtrip,
            client: client,
            drivreur: drivreur,
            distance: distance,
            duree : duree,
            cashpay: cashpay,
            walletpay: walletpay,
            montant: montant,
            commission: commission
            //genererData: genererData
        };
        //console.log(genererData);
        //console.log(formData);

        // Envoyez une requête AJAX pour enregistrer les données
        $.ajax({
            url: updateUrlCourse,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Traitez la réponse réussie
                //console.log(response);

                // Masquer la fenêtre modale et recharger la page
                $('#editModalCourse').modal('hide');
                location.reload();
            },
            error: function(xhr, status, error) {
                // Traitez la réponse d'erreur
                console.error(xhr.responseText);
            }
        });
    });
    
    /* +===========Save Organisation=================+ */
    
    $('#saveChangeCourseOrg').click(function(event) {
        // Empêcher le comportement par défaut du bouton
        event.preventDefault();

        // Obtenez l'URL de mise à jour à partir de l'attribut data
        var updateUrlCourse = "<?php echo e(route('update-course')); ?>";

        // Récupérez les valeurs des champs de formulaire
        var tripId = $('#tripIds').val();
        var vtrip = $('#vtrip').val();
        var client = $('#client').val();
        var drivreur = $('#drivreurt').val();
        var distance = $('#distancet').val();
        var duree  =$('#dureet').val();
        var cashpay = 0;    //$('#cashpay').val();
        var walletpay = 0;   //$('#walletpay').val();
        var montant = $('#tmontantt').val();
        var commission = $('#commisiont').val();

        // Créez un objet formData contenant toutes les données du formulaire
        var formData = {
            tripId: tripId,
            vtrip: vtrip,
            client: client,
            drivreur: drivreur,
            distance: distance,
            duree : duree,
            //cashpay: cashpay,
            //walletpay: walletpay,
            montant: montant,
            commission: commission
            //genererData: genererData
        };
        

        // Envoyez une requête AJAX pour enregistrer les données
        $.ajax({
            url: updateUrlCourse,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Traitez la réponse réussie
                //console.log(response);

                // Masquer la fenêtre modale et recharger la page
                $('#editModalCourse').modal('hide');
                location.reload();
            },
            error: function(xhr, status, error) {
                // Traitez la réponse d'erreur
                console.error(xhr.responseText);
            }
        });
    });
    
    /* +==================================== colis update ============================================+ */
 
 
    $('#editModalColis').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); 
            var id = button.data('id'); 
             var livreurid = button.data('livreurid'); 
            var vtrip = button.data('vride'); 
            var tdate = button.data('tdate'); 
            var client = button.data('client'); 
            var livreur = button.data('livreur'); 
            var distance = button.data('distance'); 
            var duree = button.data('duree'); 
            var total = button.data('total'); 
            var commission = button.data('commission'); 
            var walletpay = button.data('walletpay'); 
            var cashpay = button.data('cashpay'); 

            // Pré-remplir les champs du formulaire avec les données récupérées
            var modal = $(this);
            modal.find('.modal-body #tripId').val(id);
            modal.find('.modal-body #vtrip').val(vtrip);
            modal.find('.modal-body #client').val(client);
            modal.find('.modal-body #livreur').val(livreurid).change();
            // Sélectionner l'option correspondante dans la liste déroulante
            //modal.find('.modal-body #drivreur option[value="' + driverid + '"]').prop('selected', true);

            
            
            modal.find('.modal-body #distance').val(distance);
            modal.find('.modal-body #duree').val(duree);
            modal.find('.modal-body #cashpay').val(cashpay);
            modal.find('.modal-body #walletpay').val(walletpay);
            modal.find('.modal-body #tmontant').val(total);
            modal.find('.modal-body #commision').val(commission);
            
           
        });
    
    $('#saveChangeColis').click(function(event) {
        // Empêcher le comportement par défaut du bouton
        event.preventDefault();
        
        // Obtenez l'URL de mise à jour à partir de l'attribut data
        var updateUrlColis = "<?php echo e(route('update-colis')); ?>";

        // Récupérez les valeurs des champs de formulaire
        var tripId = $('#tripId').val();
        var vtrip = $('#vtrip').val();
        var client = $('#client').val();
        var livreur = $('#livreur').val();
        var distance = $('#distance').val();
        var duree  =$('#duree').val();
        var cashpay = $('#cashpay').val();
        var walletpay = $('#walletpay').val();
        var montant = $('#tmontant').val();
        var commission = $('#commision').val();

        // Créez un objet formData contenant toutes les données du formulaire
        var formData = {
            tripId: tripId,
            vtrip: vtrip,
            client: client,
            livreur: livreur,
            distance: distance,
            duree : duree,
            cashpay: cashpay,
            walletpay: walletpay,
            montant: montant,
            commission: commission
            //genererData: genererData
        };
        //console.log(genererData);
        //console.log(formData);

        // Envoyez une requête AJAX pour enregistrer les données
        $.ajax({
            url: updateUrlColis,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Traitez la réponse réussie
                //console.log(response);

                // Masquer la fenêtre modale et recharger la page
                $('#editModalCourse').modal('hide');
                location.reload();
            },
            error: function(xhr, status, error) {
                // Traitez la réponse d'erreur
                console.error(xhr.responseText);
            }
        });
    });
    
    /* +====================le point du livreur ==========================================+ */
    
     $('#fairepoint').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); 
            var id = button.data('id'); 
            var dated = button.data('dated'); 
            var datef = button.data('datef');
            var balance = button.data('balance');
            
            console.log(balance);
            
            if (isNaN(balance)) {
                console.log("La valeur de balance n'est pas un nombre.");
                return;
            }
            
            balance_ajust=20000-balance;
            
            //console.log(balance_ajust);
            
            var livreur = button.data('livreur'); 
            // Pré-remplir les champs du formulaire avec les données récupérées
            var modal = $(this);
            //modal.find('.modal-body #iDriverId').val(id);
            modal.find('.modal-body #iId').val(id);
            modal.find('.modal-body #livreur').val(livreur);
            modal.find('.modal-body #dated').val(dated);
            modal.find('.modal-body #datef').val(datef);
             modal.find('.modal-body #balance').val(balance_ajust);
    });
    
    $('#updateLivreurPoint').click(function(event) {
        event.preventDefault();
        
        var livreurUrlPoint = "<?php echo e(route('livreur-point')); ?>";
        //var iDriverId = $('#iDriverId').val();
        var iId = $('#iId').val();
        var livreur = $('#livreur').val();
        var dated = $('#dated').val();
        var datef = $('#datef').val();
        var balance = $('#balance').val();
        
        var formData = {
            iDriverId: iId,
            livreur: livreur,
            dated: dated,
            datef: datef,
            balance:balance,
        };
        
        console.log(formData);
        
        $.ajax({
            url: livreurUrlPoint,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Traitez la réponse réussie
                console.log(response);
               $('#fairepoint').modal('hide');
               location.reload();
            },
            error: function(xhr, status, error) {
                // Traitez la réponse d'erreur
                console.error(xhr.responseText);
                console.log(0000001212);
               /*$('#fairepoint').modal('hide');
               location.reload();*/
            }
        });
    });
    
    /** +================+=======+ paiement resto+ ==========================+======+**/
    
    $('#paieresto').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); 
            
            var id = button.data('id'); 
            // var ids = button.data('ids'); 
            var dated = button.data('dated'); 
            var datef = button.data('datef');
            var montant = button.data('montant');
            var resto = button.data('resto'); 
             
            var modal = $(this);
            //modal.find('.modal-body #iDriverId').val(id);
            modal.find('.modal-body #iIdC').val(id);
            modal.find('.modal-body #resto').val(resto);
            modal.find('.modal-body #dated').val(dated);
            modal.find('.modal-body #datef').val(datef);
             modal.find('.modal-body #montant').val(montant);
    });
    
    $('#updatePaieResto').click(function(event) {
        event.preventDefault();
        
        var restoPaiement ="<?php echo e(route('store-payment')); ?>";
        //var iDriverId = $('#iDriverId').val();
        var iId = $('#iIdC').val();
        var resto = $('#resto').val();
        var dated = $('#dated').val();
        var datef = $('#datef').val();
        var montant = $('#montant').val();
        
        var formData = {
            iCompanyId: iId,
            resto: resto,
            dated: dated,
            datef: datef,
            montant:montant,
        };
        
        console.log(formData);
        
        $.ajax({
            url: restoPaiement,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Traitez la réponse réussie
                console.log(response);
               $('#paieresto').modal('hide');
               location.reload();
            },
            error: function(xhr, status, error) {
                // Traitez la réponse d'erreur
                console.error(error.responseText);
                //console.log(0000001212);
               /*$('#fairepoint').modal('hide');
               location.reload();*/
            }
        });
    });
    
    
    /** +================+=======+ paiement detail resto+ ==========================+======+**/
    
    $('#paierestodetail').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); 
            
            var id = button.data('id'); 
            // var ids = button.data('ids'); 
            var dated = button.data('dated'); 
            var datef = button.data('datef');
           // var montant = button.data('montant');
            var resto = button.data('resto'); 
            
            var modal = $(this);
            //modal.find('.modal-body #iDriverId').val(id);
            modal.find('.modal-body #iIdC').val(id);
            modal.find('.modal-body #resto').val(resto);
            modal.find('.modal-body #dated').val(dated);
            modal.find('.modal-body #datef').val(datef);
             //modal.find('.modal-body #montant').val(montant);
    });
    /* +===========================================================================+ */
    $('#updatePaieDetailResto').click(function(event) {
        event.preventDefault();
        
        var restoPaiementDetail ="<?php echo e(route('storedetail-payment')); ?>+id";
        //var iDriverId = $('#iDriverId').val();
        var iId = $('#iIdC').val();
        var resto = $('#resto').val();
        var dated = $('#dated').val();
        var datef = $('#datef').val();
        //var montant = $('#montant').val();
        
        var formData = {
            iCompanyId: iId,
            resto: resto,
            dated: dated,
            datef: datef,
            //montant:montant,
        };
        console.log(formData);
        da
        $.ajax({
            url: restoPaiementDetail,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Traitez la réponse réussie
                //console.log(response);
               
              // $('#paierestodetail').modal('hide');
               location.reload();
            },
            error: function(xhr, status, error) {
                // Traitez la réponse d'erreur
                //console.error(error.responseText);
                //console.log(0000001212);
                
               /*$('#fairepoint').modal('hide');*/
               location.reload();
            }
        });
    });
    
    
    /* +==========================Depense=================================+ */
     
    $('#updateDepenseModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); 
            
            var id = button.data('sidex'); 
            var titre = button.data('stitre'); 
            var description = button.data('sdescription');
            var montant = button.data('smontant');
            var driver = button.data('sdriveur'); 
            var drivername = button.data('isdriveur');
            var edate = button.data('sedate');
         
         // Assurez-vous que la date est au format YYYY-MM-DD
        if (edate) {
            var dateObj = new Date(edate);
            var month = ("0" + (dateObj.getMonth() + 1)).slice(-2);
            var day = ("0" + dateObj.getDate()).slice(-2);
            var year = dateObj.getFullYear();
            edate = year + "-" + month + "-" + day;
        }
             
            var modal = $(this);
           
            modal.find('.modal-body #updateId').val(id);
            modal.find('.modal-body #updateTitre').val(titre);
            modal.find('.modal-body #updateDescription').val(description);
            modal.find('.modal-body #updateMontant').val(montant);
             modal.find('.modal-body #updateDriveur').val(driver).change();
            modal.find('.modal-body #updateDate').val(edate);
    });
    
    $('#updateDepense').click(function(event) {
        event.preventDefault();
        
       var depenseUpUrl = "<?php echo e(route('logistique-dupdate')); ?>";
       
        var id = $('updateId').val();
        var titre = $('#updateTitre').val();
        var description = $('#updateDescription').val();
        var montant = $('#updateMontant').val();
        var edate = $('#updateDate').val();
        var driveur = $('#updateDriveur').val();
         
        
        var formData = {
            expenseId: id,
            titre: titre,
            description: description,
            montant: montant,
            edate: edate,
            driveur: driveur,
        };
        
        console.log(formData);
        
        $.ajax({
            url: depenseUpUrl,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Traitez la réponse réussie
                console.log(response);
                
               //$('#paieresto').modal('hide');
               location.reload();
            },
            error: function(xhr, status, error) {
                // Traitez la réponse d'erreur
                console.error(error.responseText);
               
               /*$('#fairepoint').modal('hide');
               location.reload();*/
            }
        });
    });
    


    
    
    
    /* +=================Rafraichir le modal=========================+*/
    
    $('#fairepoint').on('hidden.bs.modal', function () {
        // Recharge la page
        location.reload();
    });
    
    $('#paieresto').on('hidden.bs.modal', function () {
        // Recharge la page
        location.reload();
    });
    
    
    $('#exampleModalScrollable').on('hidden.bs.modal', function () {
        // Recharge la page
        location.reload();
    });
     
    $('#editModal').on('hidden.bs.modal', function () {
        // Recharge la page
        location.reload();
    });
    $('#editModalCommand').on('hidden.bs.modal', function () {
        // Recharge la page
        location.reload();
    });
    $('#editModalColis').on('hiddenbs.modal', function (){
        
         location.reload();
    });

});
</script>

<script>
    $(document).ready(function() {
        $('#saveClient').select2({
            placeholder: "Rechercher un parent...",
            ajax: {
                url: '/get-parents', // Route Laravel pour récupérer les données
                dataType: 'json',
                delay: 250, // Pour optimiser les appels
                processResults: function (data) {
                    return {
                        results: $.map(data, function(item) {
                            return {
                                id: item.iUserId,
                                text: item.name + ' (' + item.vPhone + ')'
                            };
                        })
                    };
                }
            }
        });
    });
</script>    
<script>
    
$(document).ready(function() {
    
    $('#saveDriveSchoolChange').click(function(event) {
        event.preventDefault();
        
        // alert('ok');
        
        var driveschoolUrl = "<?php echo e(route('support-dssave')); ?>";
        
        var montant1 = $('#saveMontant1').val();
        var montant2 = $('#saveMontant2').val();
        var edate = $('#saveDate1').val();
        var driveur = $('#saveDriveur').val();
        var client = $('#saveClient').val();
        var nombre = $('#saveNombre').val();
        var day = $('#saveDay').val();
        var tsadd = $('#savetSaddress').val();
        var tdadd = $('#savetDaddress').val();
        //alert('ok');
        // Create formData object
       var formData = {
            day: day,
            nombre: nombre,
            client: client,
            montant1: montant1,
            montant2: montant2,
            edate: edate,
            driveur: driveur,
            tsaddress:tsadd,
            tdaddress:tdadd
        };

        console.log(formData); // Log formData to check

        // Make AJAX request
        $.ajax({
            url: driveschoolUrl,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Handle success response
                console.log(response);
                location.reload();
            },
            error: function(xhr, status, error) {
                // Handle error response
                console.error(xhr.responseText);
                location.reload();
            }
        });
    });
    
    ///
    
    $('#saveDriveDeactiveChange').click(function(event) {
        event.preventDefault();
        
        // alert('ok');
        
        var drivedeactiveUrl = "<?php echo e(route('support-dsssave')); ?>";
        
        var driveur = $('#saveDriveur').val();
        var raison = $('#saveRaison').val();
 
        //alert('ok');
        // Create formData object
       var formData = {
            raison:raison,
            driveur: driveur,
        };

        console.log(formData); // Log formData to check

        // Make AJAX request
        $.ajax({
            url: drivedeactiveUrl,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Handle success response
                console.log(response);
               location.reload();
            },
            error: function(xhr, status, error) {
                // Handle error response
                console.error(xhr.responseText);
               location.reload();
            }
        });
    });
    
}); 
</script>
<script>
    
    $(document).ready(function() {
/*+======================depense==========================+ */
    $('#saveDepenseChange').click(function(event) {
        event.preventDefault();
        
        var depenseUrl = "<?php echo e(route('logistique-dsave')); ?>";
        
        // Fetch form values
        var titre = $('#saveTitre').val();
        var description = $('#saveDescription').val();
        var montant = $('#saveMontant').val();
        var edate = $('#saveDate').val();
        var driveur = $('#saveDriveur').val();
        
        // Create formData object
        var formData = {
            titre: titre,
            description: description,
            montant: montant,
            edate: edate,
            driveur: driveur,
        };

        console.log(formData); // Log formData to check

        // Make AJAX request
        $.ajax({
            url: depenseUrl,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Handle success response
                console.log(response);
                location.reload();
            },
            error: function(xhr, status, error) {
                // Handle error response
                console.error(xhr.responseText);
                location.reload();
            }
        });
    });
    
}); 
</script>
<script>
    
    $(document).ready(function() {
/*+======================depense==========================+ */
    $('#saveDepenseChangeAll').click(function(event) {
        event.preventDefault();
        
        var depenseUrlCompta = "<?php echo e(route('comptabilite-dsave')); ?>";
        
        // Fetch form values
        var titre = $('#saveTitreAll').val();
        var description = $('#saveDescriptionAll').val();
        var montant = $('#saveMontantAll').val();
        var edate = $('#saveDateAll').val();
        var usertype = $('#saveTypeAll').val();
        var numero = $('#saveNumeroAll').val();
        
        // Create formData object
        var formData = {
            titre: titre,
            description: description,
            montant: montant,
            edate: edate,
            usertype: usertype,
            numero:numero,
        };

        console.log(formData); // Log formData to check

        // Make AJAX request
        $.ajax({
            url: depenseUrlCompta,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Handle success response
                console.log(response);
               location.reload();
            },
            error: function(xhr, status, error) {
                // Handle error response
                console.error(xhr.responseText);
                //location.reload();
            }
        });
    });
   }); 
</script>
<script>
    
    $(document).ready(function() {
/*+======================depense==========================+ */
    $('#saveFactureChangeAll').click(function(event) {
        event.preventDefault();
        
        var factureUrlCompta = "<?php echo e(route('comptabilite-fsave')); ?>";
        
        // Fetch form values
        var service = $('#saveServiceAll').val();
        var numerof = $('#saveNumeroFactAll').val();
        var client  =  $('#saveClientAll').val();
        var numero = $('#saveNumeroAll').val();
        var montant = $('#saveMontantAll').val();
        var edate = $('#saveDateAll').val();
        var status = $('#saveStatusAll').val();
        
        // Create formData object
        var formData = {
            service: service,
            numerof: numerof,
            client:client,
            numero:numero,
            montant: montant,
            edate: edate,
            status:status,
          
        };

        console.log(formData); // Log formData to check

        // Make AJAX request
       $.ajax({
            url: factureUrlCompta,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Handle success response
                console.log(response);
               // alert(response);
               location.reload();
            },
            error: function(xhr, status, error) {
                // Handle error response
                //console.error(xhr.responseText);
                location.reload();
            }
        });
    });
   }); 
</script>
<script>
$(document).ready(function() {
    $('#updateLimiteModal').on('show.bs.modal', function(event) {
       var button = $(event.relatedTarget);
        var iDriverSet = button.data('idriverset');
        var iRayonFixe = button.data('irayonfixe');
        var iAmountValid = button.data('iamountvalid');
        var iTripCountLimit = button.data('itripcountlimit');
        //var iTripCountMax = button.data('itripcountmax');
        //var iAmountOfferFromMaxTrip = button.data('iamountofferfrommaxtrip');
        
        //alert(iDriverSet + " " + iRayonFixe + " " + iAmountValid + " " + iAmountOfferFromMaxTrip + " " + iTripCountMax);
        
        var modal = $(this);
        modal.find('.modal-body #idriversettingid').val(iDriverSet);
        modal.find('.modal-body #rayonlimite').val(iRayonFixe);
        modal.find('.modal-body #montantmini').val(iAmountValid);
        modal.find('.modal-body #coursemini').val(iTripCountLimit);
        //modal.find('.modal-body #coursemaxi').val(iTripCountMax);
        //modal.find('.modal-body #montantrecomp').val(iAmountOfferFromMaxTrip);
    });
    
    $('#updateLimiteModals').on('show.bs.modal', function(event) {
       var button = $(event.relatedTarget);
        var iDriverSete = button.data('idriversete');
     
        var iTripCountMin = button.data('itripcountmin');
        var iTripCountMax = button.data('itripcountmax');
        var iAmountOfferFromMaxTrip = button.data('iamountofferfrommaxtrip');
        
        //alert(iDriverSete + " " + iTripCountMin + " " + iAmountOfferFromMaxTrip + " " + iTripCountMax);
        $('#idriversettingearnid').val(iDriverSete);
        var modal = $(this);
       // modal.find('.modal-body #idriversettingearnid').val(iDriverSete);
        modal.find('.modal-body #courseminis').val(iTripCountMin);
        modal.find('.modal-body #coursemaxis').val(iTripCountMax);
        modal.find('.modal-body #montantrecomps').val(iAmountOfferFromMaxTrip);
    });
/****/
    $('#updateLimiteValid').click(function() {
    event.preventDefault();
   
    
        var formData = $('#UpdateLimiteForm').serialize();
        console.log(formData);
        var updatePUrl = "<?php echo e(route('setting-update')); ?>";
        $.ajax({
            url: updatePUrl,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                console.log(response);
                // Fermer le modal après avoir enregistré les modifications
                $('#updateLimiteModal').modal('hide');
                location.reload();
            },
            error: function(xhr, status, error) {
                console.error(xhr.responseText);
            }
        });
    });
    
    /***/
    $('#updateLimiteValids').click(function() {
    event.preventDefault();
    
    // var a=$('#idriversettingearnid').val();
    //alert(a);
    
    
        var formData = $('#UpdateLimiteForms').serialize();
        
        console.log(formData);
        
        var update2PUrl = "<?php echo e(route('setting-update2')); ?>";
        $.ajax({
            url: update2PUrl,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                console.log(response);
                // Fermer le modal après avoir enregistré les modifications
                //$('#updateLimiteModals').modal('hide');
                location.reload();
            },
            error: function(xhr, status, error) {
                console.error(xhr.responseText);
            }
        });
    });
    //add
    $('#addLimiteValid').click(function() {
    event.preventDefault();
        var formData = $('#addLimiteForm').serialize();
        console.log(formData);
        var add2PUrl = "<?php echo e(route('setting-add')); ?>";
        $.ajax({
            url: add2PUrl,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                console.log(response);
                // Fermer le modal après avoir enregistré les modifications
                $('#updateLimiteModal').modal('hide');
                location.reload();
            },
            error: function(xhr, status, error) {
                console.error(xhr.responseText);
            }
        });
    });
});
</script>

<script>
    $(document).ready(function() {
     
     document.addEventListener('DOMContentLoaded', function () {
        const checkboxes = document.querySelectorAll('.showAlertCheckbox');
    
        checkboxes.forEach(function (checkbox) {
            checkbox.addEventListener('change', function () {
                const checkedCheckboxes = document.querySelectorAll('.showAlertCheckbox:checked');
                const selectedRowsData = [];
    
                checkedCheckboxes.forEach(function (checkedCheckbox) {
                    const row = checkedCheckbox.closest('tr');
                    const rowData = {
                        orderNo: row.querySelector('td:nth-child(1)').textContent,
                        oDate: row.querySelector('td:nth-child(2)').textContent,
                        subTotal: row.querySelector('td:nth-child(3)').textContent,
                        discount: row.querySelector('td:nth-child(4)').textContent,
                        totalCommission: row.querySelector('td:nth-child(5)').textContent,
                        remainingAmount: row.querySelector('td:nth-child(6)').textContent
                    };
                    selectedRowsData.push(rowData);
                });
    
                // Faire ce que vous voulez avec les données des lignes sélectionnées
                console.log(selectedRowsData);
            });
        });
    });
    
});

    function activateOption(id) {
        
        $.ajax({
            url: "<?php echo e(route('setting-activate', ['id' => ':id'])); ?>".replace(':id', id),
            type: 'POST',
            dataType: 'json',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                     location.reload();
                } else {
                    alert('Erreur: ' + response.message+'okay');
                }
            },
            error: function(xhr, status, error) {
                alert('Erreur AJAX: ' + error);
            }
        });
    }

    
    function deactivateOption(id) {
         
          $.ajax({
            url: "<?php echo e(route('setting-deactivate', ['id' => ':id'])); ?>".replace(':id', id),
            type: 'POST',
            dataType: 'json',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                     location.reload();
                } else {
                    alert('Erreur: ' + response.message+'okay');
                }
            },
            error: function(xhr, status, error) {
                alert('Erreur AJAX: ' + error);
            }
        });
      
    }
    /* +====================otion param activate or deactivate =================+ */
    function activateOptionParam(id) {
        
        $.ajax({
            url: "<?php echo e(route('setting-actparam', ['id' => ':id'])); ?>".replace(':id', id),
            type: 'POST',
            dataType: 'json',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                     location.reload();
                } else {
                    alert('Erreur: ' + response.message+'okay');
                }
            },
            error: function(xhr, status, error) {
                //alert('Erreur AJAX: ' + error);
            }
        });
    }

    
    function deactivateOptionParam(id) {
         
          $.ajax({
            url: "<?php echo e(route('setting-deactparam', ['id' => ':id'])); ?>".replace(':id', id),
            type: 'POST',
            dataType: 'json',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                     location.reload();
                } else {
                    alert('Erreur: ' + response.message+'okay');
                }
            },
            error: function(xhr, status, error) {
                //alert('Erreur AJAX: ' + error);
            }
        });
      
    }
    
    
    
    
    function deleteOption(id) {
        if (confirm('Voulez-vous vraiment supprimer cet enregistrement ?')) {
            alert('Supprimer l\'option pour l\'ID : ' + id);
            // Ajouter la logique pour supprimer l'option
        }
    }
</script>
<script>
    $(document).ready(function () {
        
     $('#dateFilter').on('change', function () {
            var selectedValue = $(this).val();
            var today = new Date();
            var startDate, endDate;
        
            if (selectedValue === 'today') {
                startDate = today.toISOString().split('T')[0];
                endDate = startDate;
            } else if (selectedValue === 'yesterday') {
                var yesterday = new Date();
                yesterday.setDate(today.getDate() - 1);
                startDate = yesterday.toISOString().split('T')[0];
                endDate = startDate;
            } else if (selectedValue === 'week') {
                var firstDayOfWeek = new Date();
                firstDayOfWeek.setDate(today.getDate() - today.getDay() + 1); // Monday of this week
                startDate = firstDayOfWeek.toISOString().split('T')[0];
                endDate = today.toISOString().split('T')[0]; // Today
            } else if (selectedValue === 'lastWeek') {
                var firstDayOfLastWeek = new Date();
                firstDayOfLastWeek.setDate(today.getDate() - today.getDay() - 6); // Monday of last week
                var lastDayOfLastWeek = new Date();
                lastDayOfLastWeek.setDate(today.getDate() - today.getDay()); // Sunday of last week
                startDate = firstDayOfLastWeek.toISOString().split('T')[0];
                endDate = lastDayOfLastWeek.toISOString().split('T')[0];
            } else if (selectedValue === 'month') {
                var firstDayOfMonth = new Date(today.getFullYear(), today.getMonth(), 1);
                startDate = firstDayOfMonth.toISOString().split('T')[0];
                endDate = today.toISOString().split('T')[0];
            } else if (selectedValue === 'lastMonth') {
                var firstDayOfLastMonth = new Date(today.getFullYear(), today.getMonth() - 1, 1);
                var lastDayOfLastMonth = new Date(today.getFullYear(), today.getMonth(), 0);
                startDate = firstDayOfLastMonth.toISOString().split('T')[0];
                endDate = lastDayOfLastMonth.toISOString().split('T')[0];
            } else {
                startDate = '';
                endDate = '';
            }
        
            $('#startDate13').val(startDate);
            $('#endDate13').val(endDate);
        });



        
        /* +==============================+ */
        
        $('#myModalMinus').on('show.bs.modal', function(event) {
            
                var button = $(event.relatedTarget);
                var iDrivId = button.data('id');
                var eTypeUser = button.data('etypee');
                
                var modal = $(this);
                modal.find('.modal-body #idrid').val(iDrivId);
                modal.find('.modal-body #etypeuser').val(eTypeUser);
               
        });
        
         $('#myModalPlus').on('show.bs.modal', function(event) {
             
                var button = $(event.relatedTarget);
                var iDriveId = button.data('ide');
                var eTypeeUser = button.data('etypeee');
                
                var modal = $(this);
                modal.find('.modal-body #idride').val(iDriveId);
                modal.find('.modal-body #etypeusere').val(eTypeeUser);
               
        });
        
        $('#myModalPlusRem').on('show.bs.modal', function(event) {
             
                var button = $(event.relatedTarget);
                var iDriveId = button.data('ide');
                var iTripId = button.data('idtri');
                
                /*alert(iDriveId);
                alert(iTripId);*/
                
                var modal = $(this);
                modal.find('.modal-body #idride').val(iDriveId);
                modal.find('.modal-body #itride').val(iTripId);
               
        });
        
        
           // Lorsque le bouton "Sauvegarder" du popup est cliqué
        $('#savePlusRem').on('click', function () {
             event.preventDefault();
            var plusRemUrl = "<?php echo e(route('balance-remboursement')); ?>";
            
            var id = $('#idride').val();
            var idtrip = $('#itride').val();
            
            /*alert(id);
            alert(idtrip);*/
           
             var formData = {
                iDriverId: id,
                iTripId: idtrip
            };
    
            console.log(formData);

            // Make AJAX request
            $.ajax({
                url: plusRemUrl,
                type: 'POST',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    // Handle success response
                    console.log(response);
                    location.reload();
                },
                error: function(xhr, status, error) {
                    // Handle error response
                    console.error(xhr.responseText);
                    location.reload();
                }
            });
        });
        
        
          // Lorsque le bouton "Sauvegarder" du popup est cliqué
        $('#savePlus').on('click', function () {
             event.preventDefault();
            var plusUrl = "<?php echo e(route('balance-additional')); ?>";
            
            var id = $('#idride').val();
            var etypeuser = $('#etypeusere').val();
            var montant = $('#inputField2').val();
            
            
             var formData = {
                iDriverId: id,
                eUserType: etypeuser,
                montant: montant
            };
    
            console.log(formData);

            // Make AJAX request
            $.ajax({
                url: plusUrl,
                type: 'POST',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    // Handle success response
                    console.log(response);
                    location.reload();
                },
                error: function(xhr, status, error) {
                    // Handle error response
                    console.error(xhr.responseText);
                    location.reload();
                }
            });
        });
        
        
         // Lorsque le bouton "Sauvegarder" du popup est cliqué
        $('#saveMinus').on('click', function () {
          
            event.preventDefault();
            var minusUrl = "<?php echo e(route('balance-soustract')); ?>";
            var id = $('#idrid').val();
            var etypeuser = $('#etypeuser').val();
            var montant = $('#inputField1').val();
                
            var formData = {
                iDriverId: id,
                eUserType: etypeuser,
                montant: montant
            };
    
            console.log(formData);

        // Make AJAX request
        $.ajax({
            url: minusUrl,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                // Handle success response
                console.log(response);
                location.reload();
            },
            error: function(xhr, status, error) {
                // Handle error response
                console.error(xhr.responseText);
                location.reload();
            }
        });
    
            
        });
        
        
    });
</script>
<script>
        // Fonction pour recharger la page toutes les 5 minutes vers une URL spécifique
        //setInterval(function(){
            //window.location.href = 'https://livereport.okalm-app.com/support/getAdminCourse'; // Remplacez par l'URL souhaitée
        //}, 300000); // 300000 ms = 5 minutes
    </script>
    <script>
    // Vérifie si l'URL actuelle correspond à la page spécifique
    if (window.location.href === 'https://livereport.okalm-app.com/support/getAdminCourse') {
        // Fonction pour recharger la page toutes les 5 minutes
        setInterval(function(){
            window.location.reload(); // Recharge la même page
        }, 300000); // 300000 ms = 5 minutes
    }
</script>
<script>
$(document).ready(function () {
    $('.open-modal-souscription').on('click', function () {
       
        const title = $(this).data('title');
        const ref = $(this).data('id');
        const amount = $(this).data('amount');
        const operator = $(this).data('operator');
        
        // Affichage
        $('#modalTitleDisplay').val(title);
        $('#modalAmountDisplay').val(amount + ' F');
         $('#modalOperator').val(operator);

        // Champs cachés
        $('#modalRef').val(ref);
        $('#modalAmount').val(amount);
    });
});
</script>


</body>
</html>

<?php /**PATH /home/report/public_html/resources/views/master.blade.php ENDPATH**/ ?>