

<?php $__env->startSection('content'); ?>
 <!-- Content Wrapper. Contains page content -->
 
 <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Liste courses chauffeurs</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Administration</a></li>
              <li class="breadcrumb-item active">Drivers</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<!-- Bouton pour déclencher la fonction de masquage -->
   
    <!-- Main content -->
    <section class="content" id="hide1">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            
             <div class="card">
               <div class="card-header d-flex justify-content-between align-items-center">
                      <h3 class="card-title"> </h3>
                      <button onclick="cacherDiv()" class="btn btn-primary">En carte</button>
                </div>
                <form action="<?php echo e(route('administration-driver')); ?>" method="GET">
                  <div class="card-header">
                    <div class="row">
                    <div class="col-md-3">
                            <label>Filtre:</label>
                            <select class="form-control" name="option2">
                                <option value="all" <?php echo e(old('option2', $option2) == 'all' ? 'selected' : ''); ?>>All</option>
                                <option value="interne" <?php echo e(old('option2', $option2) == 'interne' ? 'selected' : ''); ?>>Interne</option>
                                <option value="externe" <?php echo e(old('option2', $option2) == 'externe' ? 'selected' : ''); ?>>Externe</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate13"  value="<?php echo e(old('startDate', $startDate)); ?>">
                        </div>
                        <div class="col-md-3">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate13" value="<?php echo e(old('endDate', $endDate)); ?>">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
                </form>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Chauffeur</th>
                    <th>Nombre</th>
                    <th>Réalisée</th>
                    <th>Annulée</th>
                    <th>Du chauffeur (Tx annulé)</th>
                    <th>Du client (Tx annulé)</th>
                    <th>Du Admin (Tx annulé)</th>
                    <th>Montant(FCFA)</th>
                     <th>Nb Jours</th>
                    <th>Dernière date</th>
                  </tr>
                  </thead>
                  <tbody>
                  <?php $__currentLoopData = $drivers2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($item->Driver); ?><br/><b><?php echo e($item->vPhone); ?></b></td>
                    <td><?php echo e($item->TotalCourse); ?></td>
                    <td><?php echo e($item->Completed); ?></td>
                    <td> <?php echo e($item->Annulation); ?></td>
                    <td><?php echo e($item->DeDriver); ?></td>
                    <td><?php echo e($item->DeClient); ?></td>
                    <td><?php echo e($item->DeAdmin); ?></td>
                    <td><?php echo e($item->MontantCourse); ?></td>
                    <td><?php echo e($item->WorkDaysCount); ?></td>
                    <td><?php echo e($item->lastdate); ?></td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Chauffeur</th>
                    <th>Nombre</th>
                    <th>Réalisée</th>
                    <th>Annulée</th>
                    <th>Du chauffeur (Tx annulé)</th>
                    <th>Du client (Tx annulé)</th>
                    <th>Du Admin (Tx annulé)</th>
                    <th>Montant(FCFA)</th>
                     <th>Nb Jours</th>
                    <th>Dernière date</th>
                  </tr>
                  </tfoot>
                </table>
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <section class="content" id="hide2">
          
        <div class="card card-solid">

            <div class="card-header d-flex justify-content-between align-items-center">
                <h3 class="card-title"></h3>
                <button onclick="cacherDiv()" class="btn btn-primary">En liste</button>
            </div>
            <form action="<?php echo e(route('administration-driver')); ?>" method="GET">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Option supplémentaire:</label>
                            <select class="form-control" name="additionalOption">
                                <option value="option1">Tous</option>
                                <option value="option2">Periode</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Date de début:</label>
                            <input type="date" class="form-control" name="startDate" id="startDate13"  value="<?php echo e(old('startDate', $startDate)); ?>">
                        </div>
                        <div class="col-md-3">
                            <label>Date de fin:</label>
                            <input type="date" class="form-control" name="endDate" id="endDate13" value="<?php echo e(old('endDate', $endDate)); ?>">
                        </div>
                        <!-- Ajoutez d'autres champs de filtre au besoin -->

                        <!-- Ajoutez le bouton de validation -->
                        <div class="col-md-3">
                            <label>&nbsp;</label>
                            <input type="submit" value="Valider" class="form-control btn btn-primary" id="chercher">
                        </div>
                    </div>
                  </div>
            </form>


            <div class="card-body pb-0">
                <div class="row">
                    
                    <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-12 col-sm-6 col-md-4 d-flex align-items-stretch flex-column">
                        <div class="card bg-light d-flex flex-fill">
                        <div class="card-header text-muted border-bottom-0">
                            Interne
                        </div>
                        <div class="card-body pt-0">
                            <div class="row">
                            <div class="col-7">
                                <h2 class="lead"><b><?php echo e($driver->Driver); ?> </b></h2>
                                <h2 class="lead"><b>Total course: <?php echo e($driver->TotalCourse); ?></b></h2>
                                <p class="text-muted text-sm"><b>Course Terminé: </b> <?php echo e($driver->Completed); ?>(10%)</p>
                                <p class="text-muted text-sm"><b>Course Annulé: </b> <?php echo e($driver->Annulation); ?> (15%)</p>
                                <p class="text-muted text-sm"><b>Par le chaufeur: </b> <?php echo e($driver->DeDriver); ?> (48%)</p>
                                <p class="text-muted text-sm"><b>Par le client: </b> <?php echo e($driver->DeClient); ?> (52%)</p>
                                <p class="text-muted text-sm"><b>Par l'admin: </b> <?php echo e($driver->DeAdmin); ?> (52%)</p>
                                <h2 class="text-muted text-sm"><b>Montant total course : FCFA <?php echo e(number_format($item->MontantCourse , 0, '.', ' ')); ?></b></h2>
                                </br>
                                <ul class="ml-4 mb-0 fa-ul text-muted">
                                <li class="small"><span class="fa-li"><i class="fas fa-lg fa-building"></i></span> Email: <?php echo e($driver->vEmail); ?></li>
                                <li class="small"><span class="fa-li"><i class="fas fa-lg fa-phone"></i></span> Téléphone #: <?php echo e($driver->vPhone); ?></li>
                                </ul>
                            </div>
                            <div class="col-5 text-center">
                                <img src="../../dist/img/user1-128x128.jpg" alt="user-avatar" class="img-circle img-fluid">
                            </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="text-right">
                            <a href="#" class="btn btn-sm btn-primary">
                                <i class="fas fa-user"></i> Voir détails
                            </a>
                            </div>
                        </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="card-footer">
                
                <?php echo $__env->make('layouts.administration.pagination', ['paginator' => $drivers], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
            </div>
        </div>
    </section>
    <!-- /.content -->
  </div>
  <?php $__env->stopSection(); ?>
<?php echo $__env->make('master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/report/public_html/resources/views/layouts/administration/liste_driver.blade.php ENDPATH**/ ?>