

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Liste forfait</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Administration</a></li>
                        <li class="breadcrumb-item active">Recharge</li>
                        <li class="breadcrumb-item active">Forfait</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                        <div class="card">
                        <?php if(session('error')): ?>
                        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
                        <?php endif; ?>
                        <div class="card-body">
                            <table id="example" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Titre</th>
                                        <th>Opérateur</th>
                                        <th>Montant (F)</th>
                                        <th>Description</th>
                                        <th>Jours Bonus</th>
                                        <th>Jours Disponibles</th>
                                        <th>Facteur Bonus</th>
                                        <th>Disponible</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $forfaits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $forfait): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($forfait['title']); ?></td>
                                            <td><?php echo e($forfait['operator']); ?></td>
                                            <td><?php echo e(number_format($forfait['amount'])); ?></td>
                                            <td><?php echo e($forfait['description']); ?></td>
                                            <td><?php echo e(implode(', ', $forfait['bonusDays'])); ?></td>
                                            <td><?php echo e(implode(', ', $forfait['availableDays'])); ?></td>
                                            <td><?php echo e($forfait['bonusFactor']); ?>%</td>
                                            <td>
                                                <?php if($forfait['isAvailable']): ?>
                                                    <span class="badge badge-success">Oui</span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger">Non</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <button type="button"
                                                        class="btn btn-success btn-sm open-modal-souscription"
                                                        data-toggle="modal"
                                                        data-target="#modalSouscription"
                                                        data-id="<?php echo e($forfait['id']); ?>"
                                                        data-title="<?php echo e($forfait['title']); ?>"
                                                        data-amount="<?php echo e($forfait['amount']); ?>"
                                                        data-operator="<?php echo e($forfait['operator']); ?>">
                                                    <i class="fas fa-paper-plane"></i>
                                                </button>
                                            </td>


                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="8" class="text-center">Aucun forfait disponible</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        
                    </div>
                </div>
            </div>
            
          <div class="modal fade" id="modalSouscription" tabindex="-1" role="dialog" aria-labelledby="modalSouscriptionLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <form method="POST" action="<?php echo e(route('subscribe-forfait')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Souscription à un forfait</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Fermer">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        
                        <div class="modal-body">
                            
                            <div class="form-group">
                                <label>Opérateur</label>
                                <input type="text" class="form-control" id="modalOperator" readonly>
                            </div>
                            
                            <div class="form-group">
                                <label>Forfait sélectionné :</label>
                                <input type="text" id="modalTitleDisplay" class="form-control" readonly>
                            </div>
        
                            
                            <div class="form-group">
                                <label>Montant (F CFA) :</label>
                                <input type="text" id="modalAmountDisplay" class="form-control" readonly>
                            </div>
        
                            
                            <div class="form-group">
                                <label>Nom de la campagne :</label>
                                <input type="text" name="campaignName" class="form-control" placeholder="Recharge de mois de juillet" value="" required>
                            </div>
        
                            
                            <div class="form-group">
                                <label for="sentTo">Numéro de téléphone :</label>
                                <input type="text" name="sentTo" id="modalPhone" class="form-control" placeholder="226XXXXXXXX" required>
                            </div>
        
                            
                           
                            <input type="hidden" name="ref" id="modalRef">
                            <input type="hidden" name="amount" id="modalAmount">
                            <input type="hidden" name="countryStringCode" value="BF">
                            <input type="hidden" name="countryNumberCode" value="226">
                        </div>
                        
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                            <button type="submit" class="btn btn-primary">Souscrire</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>


            
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>

<script>
$(document).ready(function () {
    $('.open-modal-souscription').on('click', function () {
        alert('okk');
        const title = $(this).data('title');
        const ref = $(this).data('id');
        const amount = $(this).data('amount');
        const operator = $(this).data('operator');
        
        alert('ok');

        // Affichage
        $('#modalTitleDisplay').val(title);
        $('#modalAmountDisplay').val(amount + ' F');

        // Champs cachés
        $('#modalRef').val(ref);
        $('#modalAmount').val(amount);
    });
});
</script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/report/public_html/resources/views/layouts/administration/liste_forfait.blade.php ENDPATH**/ ?>