

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Liste des balances</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Administration</a></li>
                        <li class="breadcrumb-item active">Portefeuille</li>
                        <li class="breadcrumb-item active">Balance</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <form action="<?php echo e(route('administration-balance')); ?>" method="GET">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-md-2">
                                        <label>Filtre:</label>
                                        <input type="text" class="form-control" name="numero" id="numero" value="<?php echo e(old('numero', $numero)); ?>" placeholder="Saisir numéro pour filtrer">
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Dernière Transaction:</label>
                                        <input type="date" class="form-control" name="soldeDate" id="soldeDate2" value="<?php echo e(old('soldeDate', $soldeDate)); ?>">
                                    </div>
                                    <div class="col-md-1">
                                        <label>Type :</label>
                                        <select class="form-control" name="option33">
                                            <option value="all" <?php echo e(old('option33', $option33) == 'all' ? 'selected' : ''); ?>>All</option>
                                            <option value="user" <?php echo e(old('option33', $option33) == 'user' ? 'selected' : ''); ?>>User</option>
                                            <option value="driver" <?php echo e(old('option33', $option33) == 'driver' ? 'selected' : ''); ?>>Driver</option>
                                            <option value="deliver" <?php echo e(old('option33', $option33) == 'deliver' ? 'selected' : ''); ?>>Livreur</option>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label>Nombre de lignes :</label>
                                        <select class="form-control" name="ligne">
                                            <option value="10" <?php echo e(old('ligne', $ligne) == '10' ? 'selected' : ''); ?>>10</option>
                                            <option value="40" <?php echo e(old('ligne', $ligne) == '40' ? 'selected' : ''); ?>>40</option>
                                            <option value="60" <?php echo e(old('ligne', $ligne) == '60' ? 'selected' : ''); ?>>60</option>
                                            <option value="100" <?php echo e(old('ligne', $ligne) == '100' ? 'selected' : ''); ?>>100</option>
                                        </select>
                                    </div>
                                    <div class="col-md-1">
                                        <label>&nbsp;</label>
                                        <button type="submit" class="btn btn-primary form-control">Filtrer</button>
                                    </div>
                                    <div class="col-md-2">
                                        <label>Solde Total:</label>
                                        <input type="text" class="form-control" value="<?php echo e(number_format($total, 2, ',', ' ')); ?>  XOF" disabled>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="card-body">
                            <table id="example" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Nom</th>
                                        <th>Prénom</th>
                                        <th>Téléphone</th>
                                        <th>Email</th>
                                        <th>Date d'inscription</th>
                                        <th>Type</th>
                                        <th>Balance (XOF)</th>
                                        <th colspan=2></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $balances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $balance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($balance->lastname); ?></td>
                                        <td><?php echo e($balance->name); ?></td>
                                        <td><?php echo e($balance->vPhone); ?></td>
                                        <td><?php echo e($balance->vEmail); ?></td>
                                        <td><?php echo e($balance->vDate); ?></td>
                                        <td><?php echo e($balance->eusertype == 'Rider' ? 'User' : 'Driver'); ?></td>
                                        <td><?php echo e(number_format($balance->balance, 2, ',', ' ')); ?> </td>
                                        <td>
                                            <a href="#" class="btn btn-danger btn-sm open-popup" data-toggle="modal" data-target="#myModalMinus" data-id="<?php echo e($balance->iUserId); ?>" data-etypee="<?php echo e($balance->eusertype); ?>" >
                                                <i class="fas fa-minus"></i> <!-- Icône FontAwesome -->
                                            </a>
                                        </td>
                                        <td>
                                            <a href="#" class="btn btn-success btn-sm open-popuplus" data-toggle="modal" data-target="#myModalPlus" data-ide="<?php echo e($balance->iUserId); ?>" data-etypeee="<?php echo e($balance->eusertype); ?>">
                                                <i class="fas fa-plus"></i> <!-- Icône FontAwesome -->
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="card-footer clearfix">
                            <?php echo e($balances->appends(request()->input())->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal fade" id="myModalMinus" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel">Soustraire le portefeuille</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form id="formPopup">
                                
                                 <input type="hidden" name="iDriverId" id="idrid"> 
                                 <input type="hidden" name="eType" id="etypeuser">
                                <div class="form-group">
                                    <label for="inputField">Montant :</label>
                                    <input type="number" class="form-control" id="inputField1" placeholder="Entrez votre montant ici">
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                            <button type="button" class="btn btn-primary" id="saveMinus">Soustraire</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="myModalPlus" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel">Additionner le portefeuille</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form id="formPopup">
                                <input type="hidden" name="iDriverId" id="idride"> 
                                <input type="hidden" name="eType" id="etypeusere">
                                <div class="form-group">
                                    <label for="inputField">Montant :</label>
                                    <input type="number" class="form-control" id="inputField2" placeholder="Entrez votre montant ici">
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                            <button type="button" class="btn btn-primary" id="savePlus">Additionner</button>
                        </div>
                    </div>
                </div>
            </div>

            
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function () {
        // Lorsque le bouton est cliqué
        $('.open-popup').on('click', function () {
            // Ouvrir le popup
            $('#myModal').modal('show');
        });
        $('.open-popuplus').on('click', function () {
            // Ouvrir le popup
            $('#myModalPlus').modal('show');
        });
        
      
        
       
    });
    
     
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/report/public_html/resources/views/layouts/administration/liste_balance.blade.php ENDPATH**/ ?>